/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMultipart;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.oxm.ByteArrayDataSource;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLMarshaller;

public class XMLBinaryDataHelper {
    protected static XMLBinaryDataHelper binaryDataHelper;
    public Class DATA_HANDLER;
    public Class IMAGE;
    public Class SOURCE;
    public Class MULTIPART;

    public XMLBinaryDataHelper() {
        if (this.DATA_HANDLER == null) {
            this.initializeDataTypes();
        }
    }

    public static XMLBinaryDataHelper getXMLBinaryDataHelper() {
        if (binaryDataHelper == null) {
            XMLBinaryDataHelper.setXMLBinaryDataHelper(new XMLBinaryDataHelper());
        }
        return binaryDataHelper;
    }

    public static void setXMLBinaryDataHelper(XMLBinaryDataHelper xMLBinaryDataHelper) {
        binaryDataHelper = xMLBinaryDataHelper;
    }

    public void initializeDataTypes() {
        this.DATA_HANDLER = DataHandler.class;
        this.IMAGE = Image.class;
        this.SOURCE = Source.class;
        this.MULTIPART = MimeMultipart.class;
    }

    public Object convertObject(Object object, Class clazz, AbstractSession abstractSession) {
        if (clazz == this.DATA_HANDLER) {
            return this.convertObjectToDataHandler(object, abstractSession);
        }
        if (clazz == this.IMAGE) {
            return this.convertObjectToImage(object);
        }
        if (clazz == this.SOURCE) {
            return this.convertObjectToSource(object);
        }
        if (clazz == this.MULTIPART) {
            return this.convertObjectToMultipart(object);
        }
        return abstractSession.getDatasourcePlatform().getConversionManager().convertObject(object, clazz);
    }

    public EncodedData getBytesFromDataHandler(DataHandler dataHandler) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            dataHandler.writeTo((OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new EncodedData(byteArrayOutputStream.toByteArray(), dataHandler.getContentType());
    }

    public EncodedData getBytesForBinaryValue(Object object, XMLMarshaller xMLMarshaller, String string) {
        if (object instanceof DataHandler) {
            return this.getBytesFromDataHandler((DataHandler)object);
        }
        if (object instanceof Image) {
            return this.getBytesFromImage((Image)object, string);
        }
        if (object instanceof Source) {
            return this.getBytesFromSource((Source)object, xMLMarshaller, string);
        }
        if (object instanceof MimeMultipart) {
            return this.getBytesFromMultipart((MimeMultipart)object, xMLMarshaller);
        }
        if (object.getClass() == ClassConstants.APBYTE) {
            return new EncodedData((byte[])object, string);
        }
        if (object.getClass() == ClassConstants.ABYTE) {
            return this.getBytesFromByteObjectArray((Byte[])object, string);
        }
        return new EncodedData(new byte[0], null);
    }

    public EncodedData getBytesFromMultipart(MimeMultipart mimeMultipart, XMLMarshaller xMLMarshaller) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ContentType contentType = new ContentType(mimeMultipart.getContentType());
            String string = contentType.getParameter("boundary");
            byteArrayOutputStream.write(Helper.cr().getBytes());
            byteArrayOutputStream.write(("Content-Type: " + contentType.getBaseType() + "; boundary=\"" + string + "\"\n").getBytes());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            mimeMultipart.writeTo((OutputStream)byteArrayOutputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new EncodedData(byteArrayOutputStream.toByteArray(), mimeMultipart.getContentType());
    }

    public EncodedData getBytesFromSource(Source source, XMLMarshaller xMLMarshaller, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(byteArrayOutputStream);
        xMLMarshaller.getTransformer().transform(source, (Result)streamResult);
        if (string == null) {
            string = "application/xml";
        }
        return new EncodedData(byteArrayOutputStream.toByteArray(), string);
    }

    public EncodedData getBytesFromByteObjectArray(Byte[] byteArray, String string) {
        byte[] byArray = new byte[byteArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = byteArray[i];
        }
        return new EncodedData(byArray, string);
    }

    public EncodedData getBytesFromImage(Image image, String string) {
        if (string == null || string.startsWith("image/*")) {
            string = "image/png";
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersByMIMEType(string);
            if (!iterator.hasNext()) {
                throw XMLMarshalException.noEncoderForMimeType(string);
            }
            ImageWriter imageWriter = iterator.next();
            imageWriter.setOutput(ImageIO.createImageOutputStream(byteArrayOutputStream));
            imageWriter.write(this.convertToBufferedImage(image));
            imageWriter.dispose();
            return new EncodedData(byteArrayOutputStream.toByteArray(), string);
        }
        catch (Exception exception) {
            return new EncodedData(new byte[0], null);
        }
    }

    private BufferedImage convertToBufferedImage(Image image) throws IOException {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        MediaTracker mediaTracker = new MediaTracker(new Component(){});
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.getMessage());
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        return bufferedImage;
    }

    public Object convertObjectToMultipart(Object object) {
        if (object instanceof MimeMultipart) {
            return object;
        }
        if (object instanceof DataHandler) {
            try {
                if (((DataHandler)object).getContent() instanceof MimeMultipart) {
                    MimeMultipart mimeMultipart = (MimeMultipart)((DataHandler)object).getContent();
                    return mimeMultipart;
                }
                return new MimeMultipart(((DataHandler)object).getDataSource());
            }
            catch (Exception exception) {}
        } else {
            if (object instanceof byte[]) {
                try {
                    byte[] byArray = (byte[])object;
                    InputStreamReader inputStreamReader = new InputStreamReader(new ByteArrayInputStream(byArray));
                    int n = 0;
                    while (n != -1) {
                        n = inputStreamReader.read();
                    }
                    return new MimeMultipart((DataSource)new ByteArrayDataSource((byte[])object, "multipart/mixed"));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
            }
            if (object instanceof Byte[]) {
                Byte[] byteArray = (Byte[])object;
                byte[] byArray = new byte[byteArray.length];
                for (int i = 0; i < byteArray.length; ++i) {
                    byArray[i] = byteArray[i];
                }
                try {
                    return new MimeMultipart((DataSource)new ByteArrayDataSource(byArray, "multipart/mixed"));
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
        return null;
    }

    public Object convertObjectToImage(Object object) {
        if (object instanceof Image) {
            return object;
        }
        if (object instanceof DataHandler) {
            try {
                if (((DataHandler)object).getContent() instanceof Image) {
                    Image image = (Image)((DataHandler)object).getContent();
                    return image;
                }
                return ImageIO.read(((DataHandler)object).getInputStream());
            }
            catch (Exception exception) {}
        } else {
            if (object instanceof byte[]) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                try {
                    return ImageIO.read(byteArrayInputStream);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
            }
            if (object instanceof Byte[]) {
                Byte[] byteArray = (Byte[])object;
                byte[] byArray = new byte[byteArray.length];
                for (int i = 0; i < byteArray.length; ++i) {
                    byArray[i] = byteArray[i];
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                try {
                    return ImageIO.read(byteArrayInputStream);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
        return null;
    }

    public String stringFromDataHandler(DataHandler dataHandler, QName qName, AbstractSession abstractSession) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            dataHandler.writeTo((OutputStream)byteArrayOutputStream);
            return (String)((XMLConversionManager)abstractSession.getDatasourcePlatform().getConversionManager()).convertObject(byteArrayOutputStream.toByteArray(), String.class, qName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String stringFromDataHandler(Object object, QName qName, AbstractSession abstractSession) {
        return this.stringFromDataHandler((DataHandler)object, qName, abstractSession);
    }

    public String stringFromImage(Image image, QName qName, AbstractSession abstractSession) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Iterator<ImageWriter> iterator;
            String string = null;
            if (string == null || string.startsWith("image/*")) {
                string = "image/png";
            }
            if (!(iterator = ImageIO.getImageWritersByMIMEType(string)).hasNext()) {
                throw new RuntimeException("no encoder for MIME type " + string);
            }
            ImageWriter imageWriter = iterator.next();
            imageWriter.setOutput(ImageIO.createImageOutputStream(byteArrayOutputStream));
            imageWriter.write(this.convertToBufferedImage(image));
            imageWriter.dispose();
            return ((XMLConversionManager)abstractSession.getDatasourcePlatform().getConversionManager()).buildBase64StringFromBytes(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String stringFromSource(Source source, QName qName, AbstractSession abstractSession) {
        DataHandler dataHandler = new DataHandler((Object)source, "text/xml");
        return this.stringFromDataHandler(dataHandler, qName, abstractSession);
    }

    public String stringFromMultipart(MimeMultipart mimeMultipart, QName qName, AbstractSession abstractSession) {
        DataHandler dataHandler = new DataHandler((Object)mimeMultipart, mimeMultipart.getContentType());
        return this.stringFromDataHandler(dataHandler, qName, abstractSession);
    }

    public DataHandler convertObjectToDataHandler(Object object, AbstractSession abstractSession) {
        byte[] byArray;
        DataHandler dataHandler = null;
        if (object instanceof DataHandler) {
            return (DataHandler)object;
        }
        if (object instanceof byte[]) {
            byArray = (byte[])object;
            dataHandler = new DataHandler((DataSource)new ByteArrayDataSource(byArray, "application/octet-stream"));
        } else if (object instanceof Byte[]) {
            byArray = (byte[])abstractSession.getDatasourcePlatform().getConversionManager().convertObject(object, ClassConstants.APBYTE);
            dataHandler = new DataHandler((DataSource)new ByteArrayDataSource(byArray, "application/octet-stream"));
        }
        if (object instanceof String) {
            byArray = ((XMLConversionManager)abstractSession.getDatasourcePlatform().getConversionManager()).convertSchemaBase64ToByteArray(object);
            dataHandler = new DataHandler((DataSource)new ByteArrayDataSource(byArray, "application/octet-stream"));
        } else if (object instanceof Image) {
            dataHandler = new DataHandler(object, "image/jpeg");
        } else if (object instanceof Source) {
            dataHandler = new DataHandler(object, "text/xml");
        } else if (object instanceof MimeMultipart) {
            dataHandler = new DataHandler(object, ((MimeMultipart)object).getContentType());
        }
        return dataHandler;
    }

    public Object convertObjectToSource(Object object) {
        if (object instanceof Source) {
            return object;
        }
        if (object instanceof DataHandler) {
            try {
                Source source = (Source)((DataHandler)object).getContent();
                return source;
            }
            catch (Exception exception) {}
        } else {
            if (object instanceof byte[]) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                return new StreamSource(byteArrayInputStream);
            }
            if (object instanceof Byte[]) {
                Byte[] byteArray = (Byte[])object;
                byte[] byArray = new byte[byteArray.length];
                for (int i = 0; i < byteArray.length; ++i) {
                    byArray[i] = byteArray[i];
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                return new StreamSource(byteArrayInputStream);
            }
        }
        return null;
    }

    public class EncodedData {
        private byte[] data;
        private String mimeType;

        public EncodedData(byte[] byArray, String string) {
            this.data = byArray;
            this.mimeType = string;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public byte[] getData() {
            return this.data;
        }

        public void setMimeType(String string) {
            this.mimeType = string;
        }

        public void setData(byte[] byArray) {
            this.data = byArray;
        }
    }
}

