/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.net.URI;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.XMLConversionException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.TimeZoneHolder;
import org.eclipse.persistence.internal.oxm.conversion.Base64;
import org.eclipse.persistence.oxm.XMLConstants;

public class XMLConversionManager
extends ConversionManager
implements TimeZoneHolder {
    protected static final String GMT_ID = "GMT";
    protected static final String GMT_SUFFIX = "Z";
    protected static XMLConversionManager defaultXMLManager;
    protected static HashMap defaultXMLTypes;
    protected static HashMap defaultJavaTypes;
    protected boolean timeZoneQualified = false;
    protected TimeZone timeZone;
    protected static int TOTAL_MS_DIGITS;
    protected static int TOTAL_NS_DIGITS;
    protected static long YEAR_ONE_AD_TIME;
    protected DatatypeFactory datatypeFactory;

    protected DatatypeFactory getDatatypeFactory() {
        if (this.datatypeFactory == null) {
            try {
                this.datatypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new RuntimeException(datatypeConfigurationException);
            }
        }
        return this.datatypeFactory;
    }

    public static XMLConversionManager getDefaultXMLManager() {
        if (defaultXMLManager == null) {
            defaultXMLManager = new XMLConversionManager();
        }
        return defaultXMLManager;
    }

    public TimeZone getTimeZone() {
        if (this.timeZone == null) {
            return TimeZone.getDefault();
        }
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public boolean isTimeZoneQualified() {
        return this.timeZoneQualified;
    }

    public void setTimeZoneQualified(boolean bl) {
        this.timeZoneQualified = bl;
    }

    public Object convertObject(Object object, Class clazz) throws ConversionException {
        if (object == null) {
            return super.convertObject(object, clazz);
        }
        if (clazz == XMLConstants.QNAME_CLASS && object != null) {
            return this.convertObjectToQName(object);
        }
        if (clazz == ClassConstants.List_Class && object instanceof String) {
            return this.convertStringToList(object);
        }
        if (clazz == ClassConstants.STRING && object instanceof List) {
            return this.convertListToString(object);
        }
        if (clazz == ClassConstants.CALENDAR) {
            return this.convertObjectToCalendar(object);
        }
        if (clazz == ClassConstants.UTILDATE) {
            return this.convertObjectToUtilDate(object, XMLConstants.DATE_TIME_QNAME);
        }
        if (clazz == ClassConstants.SQLDATE) {
            return this.convertObjectToSQLDate(object, XMLConstants.DATE_QNAME);
        }
        if (clazz == ClassConstants.TIME) {
            return this.convertObjectToSQLTime(object, XMLConstants.TIME_QNAME);
        }
        if (clazz == ClassConstants.TIMESTAMP) {
            return this.convertObjectToTimestamp(object, XMLConstants.DATE_TIME_QNAME);
        }
        if (clazz == URI.class) {
            return this.convertObjectToURI(object);
        }
        if (clazz == ClassConstants.XML_GREGORIAN_CALENDAR) {
            return this.convertObjectToXMLGregorianCalendar(object);
        }
        if (clazz == ClassConstants.DURATION) {
            return this.convertObjectToDuration(object);
        }
        try {
            return super.convertObject(object, clazz);
        }
        catch (ConversionException conversionException) {
            if (object.getClass() == ClassConstants.STRING) {
                return super.convertObject(((String)object).trim(), clazz);
            }
            throw conversionException;
        }
    }

    public Object convertObject(Object object, Class clazz, QName qName) throws ConversionException {
        if (qName == null) {
            return this.convertObject(object, clazz);
        }
        if (object == null) {
            return super.convertObject(object, clazz);
        }
        if (clazz == ClassConstants.CALENDAR || clazz == ClassConstants.GREGORIAN_CALENDAR) {
            return this.convertObjectToCalendar(object, qName);
        }
        if (clazz == ClassConstants.ABYTE) {
            if (qName.getLocalPart().equalsIgnoreCase("hexBinary")) {
                return super.convertObjectToByteObjectArray(object);
            }
            if (qName.getLocalPart().equalsIgnoreCase("base64Binary")) {
                return this.convertSchemaBase64ToByteObjectArray(object);
            }
        } else if (clazz == ClassConstants.APBYTE) {
            if (qName.getLocalPart().equalsIgnoreCase("hexBinary")) {
                return super.convertObjectToByteArray(object);
            }
            if (qName.getLocalPart().equalsIgnoreCase("base64Binary")) {
                return this.convertSchemaBase64ToByteArray(object);
            }
        } else {
            if (clazz == ClassConstants.List_Class && object instanceof String) {
                return this.convertStringToList(object);
            }
            if (clazz == ClassConstants.STRING && object instanceof List) {
                return this.convertListToString(object);
            }
            if (object instanceof byte[]) {
                if (qName.getLocalPart().equalsIgnoreCase("base64Binary")) {
                    return this.buildBase64StringFromBytes((byte[])object);
                }
                return Helper.buildHexStringFromBytes((byte[])object);
            }
            if (object instanceof Byte[]) {
                if (qName.getLocalPart().equalsIgnoreCase("base64Binary")) {
                    return this.buildBase64StringFromObjectBytes((Byte[])object);
                }
                return this.buildHexStringFromObjectBytes((Byte[])object);
            }
            if (clazz == ClassConstants.UTILDATE) {
                return this.convertObjectToUtilDate(object, qName);
            }
            if (clazz == ClassConstants.SQLDATE) {
                return this.convertObjectToSQLDate(object, qName);
            }
            if (clazz == ClassConstants.TIME) {
                return this.convertObjectToSQLTime(object, qName);
            }
            if (clazz == ClassConstants.TIMESTAMP) {
                return this.convertObjectToTimestamp(object, qName);
            }
            if (clazz == XMLConstants.QNAME_CLASS && object != null) {
                return this.convertObjectToQName(object);
            }
            if (clazz == ClassConstants.STRING) {
                return this.convertObjectToString(object, qName);
            }
            if (clazz == URI.class) {
                return this.convertObjectToURI(object);
            }
            if (clazz == ClassConstants.XML_GREGORIAN_CALENDAR) {
                return this.convertObjectToXMLGregorianCalendar(object, qName);
            }
            if (clazz == ClassConstants.DURATION) {
                return this.convertObjectToDuration(object);
            }
            try {
                return super.convertObject(object, clazz);
            }
            catch (ConversionException conversionException) {
                if (object.getClass() == ClassConstants.STRING) {
                    return super.convertObject(((String)object).trim(), clazz);
                }
                throw conversionException;
            }
        }
        throw ConversionException.couldNotBeConverted(object, clazz);
    }

    protected XMLGregorianCalendar convertObjectToXMLGregorianCalendar(Object object, QName qName) throws ConversionException {
        if (object instanceof XMLGregorianCalendar) {
            return (XMLGregorianCalendar)object;
        }
        if (object instanceof String) {
            return this.convertStringToXMLGregorianCalendar((String)object, qName);
        }
        throw ConversionException.couldNotBeConverted(object, ClassConstants.XML_GREGORIAN_CALENDAR);
    }

    protected XMLGregorianCalendar convertObjectToXMLGregorianCalendar(Object object) throws ConversionException {
        if (object instanceof XMLGregorianCalendar) {
            return (XMLGregorianCalendar)object;
        }
        if (object instanceof String) {
            return this.convertStringToXMLGregorianCalendar((String)object);
        }
        throw ConversionException.couldNotBeConverted(object, ClassConstants.XML_GREGORIAN_CALENDAR);
    }

    protected Duration convertObjectToDuration(Object object) throws ConversionException {
        if (object instanceof Duration) {
            return (Duration)object;
        }
        if (object instanceof String) {
            return this.convertStringToDuration((String)object);
        }
        throw ConversionException.couldNotBeConverted(object, ClassConstants.DURATION);
    }

    protected Character convertObjectToChar(Object object) throws ConversionException {
        if (object == null || object.equals("")) {
            return Character.valueOf('\u0000');
        }
        return super.convertObjectToChar(object);
    }

    protected URI convertObjectToURI(Object object) throws ConversionException {
        if (object instanceof String) {
            try {
                return new URI((String)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw ConversionException.couldNotBeConverted(object, URI.class);
    }

    protected QName convertObjectToQName(Object object) throws ConversionException {
        if (object instanceof QName) {
            return (QName)object;
        }
        if (object instanceof String) {
            return this.qnameFromString((String)object);
        }
        throw ConversionException.couldNotBeConverted(object, XMLConstants.QNAME_CLASS);
    }

    protected Calendar convertObjectToCalendar(Object object) throws ConversionException {
        if (object instanceof String) {
            String string = (String)object;
            if (string.lastIndexOf(84) != -1) {
                return this.convertStringToCalendar((String)object, XMLConstants.DATE_TIME_QNAME);
            }
            if (string.lastIndexOf(58) != -1) {
                return this.convertStringToCalendar((String)object, XMLConstants.TIME_QNAME);
            }
            return this.convertStringToCalendar((String)object, XMLConstants.DATE_QNAME);
        }
        return super.convertObjectToCalendar(object);
    }

    protected String convertObjectToString(Object object) throws ConversionException {
        if (object instanceof Calendar) {
            return this.stringFromCalendar((Calendar)object);
        }
        if (object instanceof Character && object.equals(Character.valueOf('\u0000'))) {
            return "";
        }
        if (object instanceof QName) {
            return this.stringFromQName((QName)object);
        }
        if (object instanceof Date) {
            return this.stringFromSQLDate((Date)object);
        }
        if (object instanceof Time) {
            return this.stringFromSQLTime((Time)object);
        }
        if (object instanceof Timestamp) {
            return this.stringFromTimestamp((Timestamp)object);
        }
        if (object instanceof java.util.Date) {
            return this.stringFromDate((java.util.Date)object);
        }
        if (object instanceof XMLGregorianCalendar) {
            return this.stringFromXMLGregorianCalendar((XMLGregorianCalendar)object);
        }
        if (object instanceof Duration) {
            return this.stringFromDuration((Duration)object);
        }
        return super.convertObjectToString(object);
    }

    protected String convertObjectToString(Object object, QName qName) throws ConversionException {
        if (object instanceof Calendar) {
            return this.stringFromCalendar((Calendar)object, qName);
        }
        if (object instanceof QName) {
            return this.stringFromQName((QName)object);
        }
        if (object instanceof Date) {
            return this.stringFromSQLDate((Date)object, qName);
        }
        if (object instanceof Time) {
            return this.stringFromSQLTime((Time)object, qName);
        }
        if (object instanceof Timestamp) {
            return this.stringFromTimestamp((Timestamp)object, qName);
        }
        if (object instanceof java.util.Date) {
            return this.stringFromDate((java.util.Date)object, qName);
        }
        if (object instanceof XMLGregorianCalendar) {
            return this.stringFromXMLGregorianCalendar((XMLGregorianCalendar)object, qName);
        }
        if (object instanceof Duration) {
            return this.stringFromDuration((Duration)object);
        }
        return super.convertObjectToString(object);
    }

    private Calendar convertObjectToCalendar(Object object, QName qName) {
        if (object instanceof String) {
            return this.convertStringToCalendar((String)object, qName);
        }
        return super.convertObjectToCalendar(object);
    }

    public XMLGregorianCalendar convertStringToXMLGregorianCalendar(String string, QName qName) {
        XMLGregorianCalendar xMLGregorianCalendar = null;
        try {
            xMLGregorianCalendar = this.convertStringToXMLGregorianCalendar(string);
        }
        catch (Exception exception) {
            if (XMLConstants.DATE_QNAME.equals(qName)) {
                throw ConversionException.incorrectDateFormat(string);
            }
            if (XMLConstants.TIME_QNAME.equals(qName)) {
                throw ConversionException.incorrectTimeFormat(string);
            }
            if (XMLConstants.G_DAY_QNAME.equals(qName)) {
                throw XMLConversionException.incorrectGDayFormat(string);
            }
            if (XMLConstants.G_MONTH_QNAME.equals(qName)) {
                throw XMLConversionException.incorrectGMonthFormat(string);
            }
            if (XMLConstants.G_MONTH_DAY_QNAME.equals(qName)) {
                throw XMLConversionException.incorrectGMonthDayFormat(string);
            }
            if (XMLConstants.G_YEAR_QNAME.equals(qName)) {
                throw XMLConversionException.incorrectGYearFormat(string);
            }
            if (XMLConstants.G_YEAR_MONTH_QNAME.equals(qName)) {
                throw XMLConversionException.incorrectGYearMonthFormat(string);
            }
            if (XMLConstants.DURATION_QNAME.equals(qName)) {
                throw new IllegalArgumentException();
            }
            throw ConversionException.incorrectDateTimeFormat(string);
        }
        QName qName2 = xMLGregorianCalendar.getXMLSchemaType();
        if (!qName2.equals(qName)) {
            if (XMLConstants.DATE_QNAME.equals(qName)) {
                if (qName2.equals(XMLConstants.DATE_TIME_QNAME)) {
                    xMLGregorianCalendar.setHour(Integer.MIN_VALUE);
                    xMLGregorianCalendar.setMinute(Integer.MIN_VALUE);
                    xMLGregorianCalendar.setSecond(Integer.MIN_VALUE);
                    xMLGregorianCalendar.setMillisecond(Integer.MIN_VALUE);
                    return xMLGregorianCalendar;
                }
                throw ConversionException.incorrectDateFormat(string);
            }
            if (XMLConstants.TIME_QNAME.equals(qName)) {
                throw ConversionException.incorrectTimeFormat(string);
            }
            if (XMLConstants.G_DAY_QNAME.equals(qName)) {
                throw XMLConversionException.incorrectGDayFormat(string);
            }
            if (XMLConstants.G_MONTH_QNAME.equals(qName)) {
                throw XMLConversionException.incorrectGMonthFormat(string);
            }
            if (XMLConstants.G_MONTH_DAY_QNAME.equals(qName)) {
                throw XMLConversionException.incorrectGMonthDayFormat(string);
            }
            if (XMLConstants.G_YEAR_QNAME.equals(qName)) {
                throw XMLConversionException.incorrectGYearFormat(string);
            }
            if (XMLConstants.G_YEAR_MONTH_QNAME.equals(qName)) {
                throw XMLConversionException.incorrectGYearMonthFormat(string);
            }
            if (XMLConstants.DURATION_QNAME.equals(qName)) {
                throw new IllegalArgumentException();
            }
            if (XMLConstants.DATE_TIME_QNAME.equals(qName)) {
                throw ConversionException.incorrectDateTimeFormat(string);
            }
        }
        return xMLGregorianCalendar;
    }

    public XMLGregorianCalendar convertStringToXMLGregorianCalendar(String string) {
        XMLGregorianCalendar xMLGregorianCalendar = null;
        try {
            xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar(string + "--");
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                throw illegalArgumentException;
            }
        }
        return xMLGregorianCalendar;
    }

    public Duration convertStringToDuration(String string) {
        return this.getDatatypeFactory().newDuration(string);
    }

    public Calendar convertStringToCalendar(String string, QName qName) {
        java.util.Date date = this.convertStringToDate(string, qName);
        Calendar calendar = Helper.calendarFromUtilDate(date);
        calendar.setTimeZone(this.getTimeZone());
        return calendar;
    }

    private java.util.Date convertObjectToUtilDate(Object object, QName qName) {
        if (object instanceof String) {
            return this.convertStringToDate((String)object, qName);
        }
        return super.convertObjectToUtilDate(object);
    }

    protected Date convertObjectToSQLDate(Object object, QName qName) {
        if (object instanceof String) {
            java.util.Date date = this.convertStringToDate((String)object, qName);
            return new Date(date.getTime() / 1000L * 1000L);
        }
        return super.convertObjectToDate(object);
    }

    protected Time convertObjectToSQLTime(Object object, QName qName) {
        if (object instanceof String) {
            java.util.Date date = this.convertStringToDate((String)object, qName);
            return new Time(date.getTime() / 1000L * 1000L);
        }
        return super.convertObjectToTime(object);
    }

    protected Timestamp convertStringToTimestamp(String string) {
        return this.convertStringToTimestamp(string, XMLConstants.DATE_TIME_QNAME);
    }

    protected Timestamp convertObjectToTimestamp(Object object, QName qName) {
        if (object instanceof String) {
            return this.convertStringToTimestamp((String)object, qName);
        }
        return super.convertObjectToTimestamp(object);
    }

    public Timestamp convertStringToTimestamp(String string, QName qName) {
        XMLGregorianCalendar xMLGregorianCalendar = null;
        try {
            xMLGregorianCalendar = this.convertStringToXMLGregorianCalendar(string);
        }
        catch (Exception exception) {
            if (XMLConstants.DATE_QNAME.equals(qName)) {
                throw ConversionException.incorrectDateFormat(string);
            }
            if (XMLConstants.TIME_QNAME.equals(qName)) {
                throw XMLConversionException.incorrectTimestampTimeFormat(string);
            }
            if (XMLConstants.G_DAY_QNAME.equals(qName)) {
                throw XMLConversionException.incorrectGDayFormat(string);
            }
            if (XMLConstants.G_MONTH_QNAME.equals(qName)) {
                throw XMLConversionException.incorrectGMonthFormat(string);
            }
            if (XMLConstants.G_MONTH_DAY_QNAME.equals(qName)) {
                throw XMLConversionException.incorrectGMonthDayFormat(string);
            }
            if (XMLConstants.G_YEAR_QNAME.equals(qName)) {
                throw XMLConversionException.incorrectGYearFormat(string);
            }
            if (XMLConstants.G_YEAR_MONTH_QNAME.equals(qName)) {
                throw XMLConversionException.incorrectGYearMonthFormat(string);
            }
            if (XMLConstants.DURATION_QNAME.equals(qName)) {
                throw new IllegalArgumentException();
            }
            throw XMLConversionException.incorrectTimestampDateTimeFormat(string);
        }
        GregorianCalendar gregorianCalendar = xMLGregorianCalendar.toGregorianCalendar();
        gregorianCalendar.setTimeZone(this.getTimeZone());
        QName qName2 = xMLGregorianCalendar.getXMLSchemaType();
        if (!qName2.equals(qName)) {
            if (XMLConstants.DATE_QNAME.equals(qName)) {
                if (qName2.equals(XMLConstants.DATE_TIME_QNAME)) {
                    gregorianCalendar.clear(11);
                    gregorianCalendar.clear(12);
                    gregorianCalendar.clear(13);
                    gregorianCalendar.clear(14);
                    return Helper.timestampFromCalendar(gregorianCalendar);
                }
                throw ConversionException.incorrectDateFormat(string);
            }
            if (XMLConstants.TIME_QNAME.equals(qName)) {
                throw XMLConversionException.incorrectTimestampTimeFormat(string);
            }
            if (XMLConstants.G_DAY_QNAME.equals(qName)) {
                throw XMLConversionException.incorrectGDayFormat(string);
            }
            if (XMLConstants.G_MONTH_QNAME.equals(qName)) {
                throw XMLConversionException.incorrectGMonthFormat(string);
            }
            if (XMLConstants.G_MONTH_DAY_QNAME.equals(qName)) {
                throw XMLConversionException.incorrectGMonthDayFormat(string);
            }
            if (XMLConstants.G_YEAR_QNAME.equals(qName)) {
                throw XMLConversionException.incorrectGYearFormat(string);
            }
            if (XMLConstants.G_YEAR_MONTH_QNAME.equals(qName)) {
                throw XMLConversionException.incorrectGYearMonthFormat(string);
            }
            if (XMLConstants.DURATION_QNAME.equals(qName)) {
                throw new IllegalArgumentException();
            }
            if (XMLConstants.DATE_TIME_QNAME.equals(qName)) {
                throw XMLConversionException.incorrectTimestampDateTimeFormat(string);
            }
        }
        Timestamp timestamp = Helper.timestampFromCalendar(gregorianCalendar);
        int n = string.lastIndexOf(46);
        if (-1 == n) {
            return timestamp;
        }
        int n2 = string.lastIndexOf(GMT_SUFFIX);
        if (-1 == n2) {
            n2 = string.lastIndexOf(45);
            if (n2 < n) {
                n2 = -1;
            }
            if (-1 == n2) {
                n2 = string.lastIndexOf(43);
            }
        }
        String string2 = -1 == n2 ? string.substring(n + 1) : string.substring(n + 1, n2);
        double d = Long.valueOf(string2).doubleValue();
        timestamp.setNanos((int)(d *= Math.pow(10.0, 9 - string2.length())));
        return timestamp;
    }

    public String stringFromCalendar(Calendar calendar, QName qName) {
        Calendar calendar2 = (Calendar)calendar.clone();
        XMLGregorianCalendar xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar();
        if (calendar.isSet(15)) {
            xMLGregorianCalendar.setTimezone(calendar2.get(15) / 60000);
        }
        if (XMLConstants.G_DAY_QNAME.equals(qName)) {
            xMLGregorianCalendar.setDay(calendar2.get(5));
            return xMLGregorianCalendar.toXMLFormat();
        }
        if (XMLConstants.G_MONTH_QNAME.equals(qName)) {
            xMLGregorianCalendar.setMonth(calendar2.get(2) + 1);
            String string = xMLGregorianCalendar.toXMLFormat();
            String string2 = string.substring(0, 4);
            String string3 = "";
            if (string.length() == 4 && string.length() == 6) {
                string3 = "";
            }
            if (string.length() == 5 || string.length() == 10) {
                string3 = string.substring(4);
            }
            if (string.length() == 7 || string.length() == 12) {
                string3 = string.substring(6);
            }
            return string2 + string3;
        }
        if (XMLConstants.G_MONTH_DAY_QNAME.equals(qName)) {
            xMLGregorianCalendar.setMonth(calendar2.get(2) + 1);
            xMLGregorianCalendar.setDay(calendar2.get(5));
            return xMLGregorianCalendar.toXMLFormat();
        }
        if (XMLConstants.G_YEAR_QNAME.equals(qName)) {
            if (calendar2.get(0) == 0) {
                xMLGregorianCalendar.setYear(-calendar2.get(1));
            } else {
                xMLGregorianCalendar.setYear(calendar2.get(1));
            }
            return xMLGregorianCalendar.toXMLFormat();
        }
        if (XMLConstants.G_YEAR_MONTH_QNAME.equals(qName)) {
            if (calendar2.get(0) == 0) {
                xMLGregorianCalendar.setYear(-calendar2.get(1));
            } else {
                xMLGregorianCalendar.setYear(calendar2.get(1));
            }
            xMLGregorianCalendar.setMonth(calendar2.get(2) + 1);
            return xMLGregorianCalendar.toXMLFormat();
        }
        if (XMLConstants.DATE_QNAME.equals(qName)) {
            if (calendar2.get(0) == 0) {
                xMLGregorianCalendar.setYear(-calendar2.get(1));
            } else {
                xMLGregorianCalendar.setYear(calendar2.get(1));
            }
            xMLGregorianCalendar.setMonth(calendar2.get(2) + 1);
            xMLGregorianCalendar.setDay(calendar2.get(5));
            return xMLGregorianCalendar.toXMLFormat();
        }
        if (XMLConstants.TIME_QNAME.equals(qName)) {
            xMLGregorianCalendar.setTime(calendar2.get(11), calendar2.get(12), calendar2.get(13), calendar2.get(14));
            return this.truncateMillis(xMLGregorianCalendar.toXMLFormat());
        }
        if (calendar2.get(0) == 0) {
            xMLGregorianCalendar.setYear(-calendar2.get(1));
        } else {
            xMLGregorianCalendar.setYear(calendar2.get(1));
        }
        xMLGregorianCalendar.setMonth(calendar2.get(2) + 1);
        xMLGregorianCalendar.setDay(calendar2.get(5));
        xMLGregorianCalendar.setTime(calendar2.get(11), calendar2.get(12), calendar2.get(13), calendar2.get(14));
        return this.truncateMillis(xMLGregorianCalendar.toXMLFormat());
    }

    private String truncateMillis(String string) {
        String string2 = string;
        int n = string.indexOf(46);
        if (n > 0) {
            int n2;
            String string3 = string.substring(0, n);
            String string4 = "";
            if (string.length() > n + 4) {
                string4 = string.substring(n + 4, string.length());
            }
            String string5 = string.substring(n + 1, n + 4);
            char[] cArray = new char[string5.length()];
            string5.getChars(0, string5.length(), cArray, 0);
            for (n2 = 2; n2 >= 1 && cArray[n2] == '0'; --n2) {
            }
            string5 = new String(cArray, 0, n2 + 1);
            if (string5.length() > 0) {
                string5 = '.' + string5;
                string2 = string3 + string5 + string4;
            } else {
                string2 = string3 + string4;
            }
        }
        return string2;
    }

    private String stringFromCalendar(Calendar calendar) {
        if (!(calendar.isSet(10) || calendar.isSet(12) || calendar.isSet(13) || calendar.isSet(14))) {
            return this.stringFromCalendar(calendar, XMLConstants.DATE_QNAME);
        }
        if (!(calendar.isSet(1) || calendar.isSet(2) || calendar.isSet(5))) {
            return this.stringFromCalendar(calendar, XMLConstants.TIME_QNAME);
        }
        return this.stringFromDate(calendar.getTime());
    }

    public java.util.Date convertStringToDate(String string, QName qName) {
        XMLGregorianCalendar xMLGregorianCalendar = this.convertStringToXMLGregorianCalendar(string, qName);
        if (qName == null) {
            qName = xMLGregorianCalendar.getXMLSchemaType();
        }
        XMLGregorianCalendar xMLGregorianCalendar2 = this.getDatatypeFactory().newXMLGregorianCalendar();
        xMLGregorianCalendar2.setTimezone(this.getTimeZone().getRawOffset() / 60000);
        GregorianCalendar gregorianCalendar = xMLGregorianCalendar.getTimezone() == Integer.MIN_VALUE ? xMLGregorianCalendar.toGregorianCalendar(this.getTimeZone(), null, null) : xMLGregorianCalendar.toGregorianCalendar();
        gregorianCalendar.setGregorianChange(new java.util.Date(Long.MAX_VALUE));
        java.util.Date date = gregorianCalendar.getTime();
        return date;
    }

    private String stringFromDate(java.util.Date date) {
        XMLGregorianCalendar xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
        gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
        gregorianCalendar.setTime(date);
        if (gregorianCalendar.get(0) == 0) {
            xMLGregorianCalendar.setYear(-gregorianCalendar.get(1));
        } else {
            xMLGregorianCalendar.setYear(gregorianCalendar.get(1));
        }
        xMLGregorianCalendar.setMonth(gregorianCalendar.get(2) + 1);
        xMLGregorianCalendar.setDay(gregorianCalendar.get(5));
        xMLGregorianCalendar.setHour(gregorianCalendar.get(11));
        xMLGregorianCalendar.setMinute(gregorianCalendar.get(12));
        xMLGregorianCalendar.setSecond(gregorianCalendar.get(13));
        String string = xMLGregorianCalendar.toXMLFormat();
        string = this.appendMillis(string, date.getTime());
        string = this.appendTimeZone(string);
        return string;
    }

    public String stringFromDate(java.util.Date date, QName qName) {
        XMLGregorianCalendar xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar();
        if (XMLConstants.DATE_QNAME.equals(qName)) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
            gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            gregorianCalendar.setTime(date);
            xMLGregorianCalendar.setDay(gregorianCalendar.get(5));
            xMLGregorianCalendar.setMonth(gregorianCalendar.get(2) + 1);
            if (gregorianCalendar.get(0) == 0) {
                xMLGregorianCalendar.setYear(-gregorianCalendar.get(1));
            } else {
                xMLGregorianCalendar.setYear(gregorianCalendar.get(1));
            }
            return xMLGregorianCalendar.toXMLFormat();
        }
        if (XMLConstants.TIME_QNAME.equals(qName)) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
            gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            gregorianCalendar.setTime(date);
            xMLGregorianCalendar.setHour(gregorianCalendar.get(11));
            xMLGregorianCalendar.setMinute(gregorianCalendar.get(12));
            xMLGregorianCalendar.setSecond(gregorianCalendar.get(13));
            String string = xMLGregorianCalendar.toXMLFormat();
            string = this.appendMillis(string, date.getTime());
            return this.appendTimeZone(string);
        }
        if (XMLConstants.G_DAY_QNAME.equals(qName)) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
            gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            gregorianCalendar.setTime(date);
            xMLGregorianCalendar.setDay(gregorianCalendar.get(5));
            return xMLGregorianCalendar.toXMLFormat();
        }
        if (XMLConstants.G_MONTH_QNAME.equals(qName)) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
            gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            gregorianCalendar.setTime(date);
            xMLGregorianCalendar.setMonth(gregorianCalendar.get(2) + 1);
            String string = xMLGregorianCalendar.toXMLFormat();
            if (string.length() == 6) {
                string = string.substring(0, 4);
            }
            return string;
        }
        if (XMLConstants.G_MONTH_DAY_QNAME.equals(qName)) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
            gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            gregorianCalendar.setTime(date);
            xMLGregorianCalendar.setMonth(gregorianCalendar.get(2) + 1);
            xMLGregorianCalendar.setDay(gregorianCalendar.get(5));
            return xMLGregorianCalendar.toXMLFormat();
        }
        if (XMLConstants.G_YEAR_QNAME.equals(qName)) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
            gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            gregorianCalendar.setTime(date);
            if (gregorianCalendar.get(0) == 0) {
                xMLGregorianCalendar.setYear(-gregorianCalendar.get(1));
            } else {
                xMLGregorianCalendar.setYear(gregorianCalendar.get(1));
            }
            return xMLGregorianCalendar.toXMLFormat();
        }
        if (XMLConstants.G_YEAR_MONTH_QNAME.equals(qName)) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
            gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            gregorianCalendar.setTime(date);
            if (gregorianCalendar.get(0) == 0) {
                xMLGregorianCalendar.setYear(-gregorianCalendar.get(1));
            } else {
                xMLGregorianCalendar.setYear(gregorianCalendar.get(1));
            }
            xMLGregorianCalendar.setMonth(gregorianCalendar.get(2) + 1);
            return xMLGregorianCalendar.toXMLFormat();
        }
        if (XMLConstants.DURATION_QNAME.equals(qName)) {
            throw new IllegalArgumentException();
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
        gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
        gregorianCalendar.setTime(date);
        xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar(gregorianCalendar);
        if (!this.isTimeZoneQualified()) {
            xMLGregorianCalendar.setTimezone(Integer.MIN_VALUE);
        }
        String string = xMLGregorianCalendar.toXMLFormat();
        return this.truncateMillis(string);
    }

    private String stringFromSQLDate(Date date) {
        XMLGregorianCalendar xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
        gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
        gregorianCalendar.setTime(date);
        if (gregorianCalendar.get(0) == 0) {
            xMLGregorianCalendar.setYear(-gregorianCalendar.get(1));
        } else {
            xMLGregorianCalendar.setYear(gregorianCalendar.get(1));
        }
        xMLGregorianCalendar.setMonth(gregorianCalendar.get(2) + 1);
        xMLGregorianCalendar.setDay(gregorianCalendar.get(5));
        return xMLGregorianCalendar.toXMLFormat();
    }

    private String stringFromSQLDate(Date date, QName qName) {
        if (XMLConstants.DATE_TIME_QNAME.equals(qName)) {
            XMLGregorianCalendar xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
            gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            gregorianCalendar.setTime(date);
            if (gregorianCalendar.get(0) == 0) {
                xMLGregorianCalendar.setYear(-gregorianCalendar.get(1));
            } else {
                xMLGregorianCalendar.setYear(gregorianCalendar.get(1));
            }
            xMLGregorianCalendar.setMonth(gregorianCalendar.get(2) + 1);
            xMLGregorianCalendar.setDay(gregorianCalendar.get(5));
            xMLGregorianCalendar.setHour(gregorianCalendar.get(11));
            xMLGregorianCalendar.setMinute(gregorianCalendar.get(12));
            xMLGregorianCalendar.setSecond(gregorianCalendar.get(13));
            return xMLGregorianCalendar.toXMLFormat();
        }
        if (XMLConstants.TIME_QNAME.equals(qName)) {
            XMLGregorianCalendar xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
            gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            gregorianCalendar.setTime(date);
            xMLGregorianCalendar.setHour(gregorianCalendar.get(11));
            xMLGregorianCalendar.setMinute(gregorianCalendar.get(12));
            xMLGregorianCalendar.setSecond(gregorianCalendar.get(13));
            String string = xMLGregorianCalendar.toXMLFormat();
            return this.appendTimeZone(string);
        }
        if (XMLConstants.G_DAY_QNAME.equals(qName)) {
            XMLGregorianCalendar xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
            gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            gregorianCalendar.setTime(date);
            xMLGregorianCalendar.setDay(gregorianCalendar.get(5));
            return xMLGregorianCalendar.toXMLFormat();
        }
        if (XMLConstants.G_MONTH_QNAME.equals(qName)) {
            XMLGregorianCalendar xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
            gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            gregorianCalendar.setTime(date);
            xMLGregorianCalendar.setMonth(gregorianCalendar.get(2) + 1);
            String string = xMLGregorianCalendar.toXMLFormat();
            if (string.length() == 6) {
                string = string.substring(0, 4);
            }
            return string;
        }
        if (XMLConstants.G_MONTH_DAY_QNAME.equals(qName)) {
            XMLGregorianCalendar xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
            gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            gregorianCalendar.setTime(date);
            xMLGregorianCalendar.setMonth(gregorianCalendar.get(2) + 1);
            xMLGregorianCalendar.setDay(gregorianCalendar.get(5));
            return xMLGregorianCalendar.toXMLFormat();
        }
        if (XMLConstants.G_YEAR_QNAME.equals(qName)) {
            XMLGregorianCalendar xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
            gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            gregorianCalendar.setTime(date);
            if (gregorianCalendar.get(0) == 0) {
                xMLGregorianCalendar.setYear(-gregorianCalendar.get(1));
            } else {
                xMLGregorianCalendar.setYear(gregorianCalendar.get(1));
            }
            return xMLGregorianCalendar.toXMLFormat();
        }
        if (XMLConstants.G_YEAR_MONTH_QNAME.equals(qName)) {
            XMLGregorianCalendar xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
            gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            gregorianCalendar.setTime(date);
            if (gregorianCalendar.get(0) == 0) {
                xMLGregorianCalendar.setYear(-gregorianCalendar.get(1));
            } else {
                xMLGregorianCalendar.setYear(gregorianCalendar.get(1));
            }
            xMLGregorianCalendar.setMonth(gregorianCalendar.get(2) + 1);
            return xMLGregorianCalendar.toXMLFormat();
        }
        if (XMLConstants.DURATION_QNAME.equals(qName)) {
            throw new IllegalArgumentException();
        }
        return this.stringFromSQLDate(date);
    }

    private String stringFromSQLTime(Time time) {
        XMLGregorianCalendar xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
        gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
        gregorianCalendar.setTime(time);
        xMLGregorianCalendar.setHour(gregorianCalendar.get(11));
        xMLGregorianCalendar.setMinute(gregorianCalendar.get(12));
        xMLGregorianCalendar.setSecond(gregorianCalendar.get(13));
        String string = xMLGregorianCalendar.toXMLFormat();
        return this.appendTimeZone(string);
    }

    private String stringFromSQLTime(Time time, QName qName) {
        if (XMLConstants.DATE_TIME_QNAME.equals(qName)) {
            XMLGregorianCalendar xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
            gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            gregorianCalendar.setTime(time);
            if (gregorianCalendar.get(0) == 0) {
                xMLGregorianCalendar.setYear(-gregorianCalendar.get(1));
            } else {
                xMLGregorianCalendar.setYear(gregorianCalendar.get(1));
            }
            xMLGregorianCalendar.setMonth(gregorianCalendar.get(2) + 1);
            xMLGregorianCalendar.setDay(gregorianCalendar.get(5));
            xMLGregorianCalendar.setHour(gregorianCalendar.get(11));
            xMLGregorianCalendar.setMinute(gregorianCalendar.get(12));
            xMLGregorianCalendar.setSecond(gregorianCalendar.get(13));
            String string = xMLGregorianCalendar.toXMLFormat();
            return this.appendTimeZone(string);
        }
        if (XMLConstants.DATE_QNAME.equals(qName)) {
            XMLGregorianCalendar xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
            gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            gregorianCalendar.setTime(time);
            if (gregorianCalendar.get(0) == 0) {
                xMLGregorianCalendar.setYear(-gregorianCalendar.get(1));
            } else {
                xMLGregorianCalendar.setYear(gregorianCalendar.get(1));
            }
            xMLGregorianCalendar.setMonth(gregorianCalendar.get(2) + 1);
            xMLGregorianCalendar.setDay(gregorianCalendar.get(5));
            return xMLGregorianCalendar.toXMLFormat();
        }
        if (XMLConstants.G_DAY_QNAME.equals(qName)) {
            XMLGregorianCalendar xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
            gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            gregorianCalendar.setTime(time);
            xMLGregorianCalendar.setDay(gregorianCalendar.get(5));
            return xMLGregorianCalendar.toXMLFormat();
        }
        if (XMLConstants.G_MONTH_QNAME.equals(qName)) {
            XMLGregorianCalendar xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
            gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            gregorianCalendar.setTime(time);
            xMLGregorianCalendar.setMonth(gregorianCalendar.get(2) + 1);
            String string = xMLGregorianCalendar.toXMLFormat();
            if (string.length() == 6) {
                string = string.substring(0, 4);
            }
            return string;
        }
        if (XMLConstants.G_MONTH_DAY_QNAME.equals(qName)) {
            XMLGregorianCalendar xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
            gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            gregorianCalendar.setTime(time);
            xMLGregorianCalendar.setMonth(gregorianCalendar.get(2) + 1);
            xMLGregorianCalendar.setDay(gregorianCalendar.get(5));
            return xMLGregorianCalendar.toXMLFormat();
        }
        if (XMLConstants.G_YEAR_QNAME.equals(qName)) {
            XMLGregorianCalendar xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
            gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            gregorianCalendar.setTime(time);
            if (gregorianCalendar.get(0) == 0) {
                xMLGregorianCalendar.setYear(-gregorianCalendar.get(1));
            } else {
                xMLGregorianCalendar.setYear(gregorianCalendar.get(1));
            }
            return xMLGregorianCalendar.toXMLFormat();
        }
        if (XMLConstants.G_YEAR_MONTH_QNAME.equals(qName)) {
            XMLGregorianCalendar xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
            gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            gregorianCalendar.setTime(time);
            if (gregorianCalendar.get(0) == 0) {
                xMLGregorianCalendar.setYear(-gregorianCalendar.get(1));
            } else {
                xMLGregorianCalendar.setYear(gregorianCalendar.get(1));
            }
            xMLGregorianCalendar.setMonth(gregorianCalendar.get(2) + 1);
            return xMLGregorianCalendar.toXMLFormat();
        }
        if (XMLConstants.DURATION_QNAME.equals(qName)) {
            throw new IllegalArgumentException();
        }
        return this.stringFromSQLTime(time);
    }

    private String stringFromTimestamp(Timestamp timestamp) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
        gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
        gregorianCalendar.setTime(timestamp);
        XMLGregorianCalendar xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar();
        if (gregorianCalendar.get(0) == 0) {
            xMLGregorianCalendar.setYear(-gregorianCalendar.get(1));
        } else {
            xMLGregorianCalendar.setYear(gregorianCalendar.get(1));
        }
        xMLGregorianCalendar.setMonth(gregorianCalendar.get(2) + 1);
        xMLGregorianCalendar.setDay(gregorianCalendar.get(5));
        xMLGregorianCalendar.setHour(gregorianCalendar.get(11));
        xMLGregorianCalendar.setMinute(gregorianCalendar.get(12));
        xMLGregorianCalendar.setSecond(gregorianCalendar.get(13));
        String string = xMLGregorianCalendar.toXMLFormat();
        string = this.appendNanos(string, timestamp);
        return this.appendTimeZone(string);
    }

    private String stringFromTimestamp(Timestamp timestamp, QName qName) {
        if (XMLConstants.DATE_QNAME.equals(qName)) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
            gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            gregorianCalendar.setTime(timestamp);
            XMLGregorianCalendar xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar();
            if (gregorianCalendar.get(0) == 0) {
                xMLGregorianCalendar.setYear(-gregorianCalendar.get(1));
            } else {
                xMLGregorianCalendar.setYear(gregorianCalendar.get(1));
            }
            xMLGregorianCalendar.setMonth(gregorianCalendar.get(2) + 1);
            xMLGregorianCalendar.setDay(gregorianCalendar.get(5));
            return xMLGregorianCalendar.toXMLFormat();
        }
        if (XMLConstants.TIME_QNAME.equals(qName)) {
            Calendar calendar = Calendar.getInstance(this.getTimeZone());
            calendar.setTimeInMillis(timestamp.getTime());
            XMLGregorianCalendar xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar();
            xMLGregorianCalendar.setHour(calendar.get(11));
            xMLGregorianCalendar.setMinute(calendar.get(12));
            xMLGregorianCalendar.setSecond(calendar.get(13));
            String string = xMLGregorianCalendar.toXMLFormat();
            return this.appendNanos(string, timestamp);
        }
        if (XMLConstants.G_DAY_QNAME.equals(qName)) {
            XMLGregorianCalendar xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
            gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            gregorianCalendar.setTime(timestamp);
            xMLGregorianCalendar.setDay(gregorianCalendar.get(5));
            return xMLGregorianCalendar.toXMLFormat();
        }
        if (XMLConstants.G_MONTH_QNAME.equals(qName)) {
            XMLGregorianCalendar xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
            gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            gregorianCalendar.setTime(timestamp);
            xMLGregorianCalendar.setMonth(gregorianCalendar.get(2) + 1);
            String string = xMLGregorianCalendar.toXMLFormat();
            if (string.length() == 6) {
                string = string.substring(0, 4);
            }
            return string;
        }
        if (XMLConstants.G_MONTH_DAY_QNAME.equals(qName)) {
            XMLGregorianCalendar xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
            gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            gregorianCalendar.setTime(timestamp);
            xMLGregorianCalendar.setMonth(gregorianCalendar.get(2) + 1);
            xMLGregorianCalendar.setDay(gregorianCalendar.get(5));
            return xMLGregorianCalendar.toXMLFormat();
        }
        if (XMLConstants.G_YEAR_QNAME.equals(qName)) {
            XMLGregorianCalendar xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
            gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            gregorianCalendar.setTime(timestamp);
            if (gregorianCalendar.get(0) == 0) {
                xMLGregorianCalendar.setYear(-gregorianCalendar.get(1));
            } else {
                xMLGregorianCalendar.setYear(gregorianCalendar.get(1));
            }
            return xMLGregorianCalendar.toXMLFormat();
        }
        if (XMLConstants.G_YEAR_MONTH_QNAME.equals(qName)) {
            XMLGregorianCalendar xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
            gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            gregorianCalendar.setTime(timestamp);
            if (gregorianCalendar.get(0) == 0) {
                xMLGregorianCalendar.setYear(-gregorianCalendar.get(1));
            } else {
                xMLGregorianCalendar.setYear(gregorianCalendar.get(1));
            }
            xMLGregorianCalendar.setMonth(gregorianCalendar.get(2) + 1);
            return xMLGregorianCalendar.toXMLFormat();
        }
        if (XMLConstants.DURATION_QNAME.equals(qName)) {
            throw new IllegalArgumentException();
        }
        XMLGregorianCalendar xMLGregorianCalendar = this.getDatatypeFactory().newXMLGregorianCalendar();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone());
        gregorianCalendar.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
        gregorianCalendar.setTime(timestamp);
        if (gregorianCalendar.get(0) == 0) {
            xMLGregorianCalendar.setYear(-gregorianCalendar.get(1));
        } else {
            xMLGregorianCalendar.setYear(gregorianCalendar.get(1));
        }
        xMLGregorianCalendar.setMonth(gregorianCalendar.get(2) + 1);
        xMLGregorianCalendar.setDay(gregorianCalendar.get(5));
        xMLGregorianCalendar.setHour(gregorianCalendar.get(11));
        xMLGregorianCalendar.setMinute(gregorianCalendar.get(12));
        xMLGregorianCalendar.setSecond(gregorianCalendar.get(13));
        String string = xMLGregorianCalendar.toXMLFormat();
        string = this.appendNanos(string, timestamp);
        return this.appendTimeZone(string);
    }

    private String stringFromXMLGregorianCalendar(XMLGregorianCalendar xMLGregorianCalendar, QName qName) {
        return this.stringFromCalendar(xMLGregorianCalendar.toGregorianCalendar(), qName);
    }

    private String stringFromXMLGregorianCalendar(XMLGregorianCalendar xMLGregorianCalendar) {
        return xMLGregorianCalendar.toXMLFormat();
    }

    private String stringFromDuration(Duration duration) {
        return duration.toString();
    }

    private String stringFromQName(QName qName) {
        return qName.toString();
    }

    private QName qnameFromString(String string) {
        if (string.indexOf(123) != -1) {
            String string2 = string.substring(string.indexOf(123) + 1, string.indexOf(125));
            String string3 = string.substring(string.indexOf(125) + 1);
            return new QName(string2, string3);
        }
        return new QName(string);
    }

    public byte[] convertSchemaBase64ToByteArray(Object object) throws ConversionException {
        if (!(object instanceof String)) {
            throw ConversionException.couldNotBeConverted(object, ClassConstants.APBYTE);
        }
        byte[] byArray = Base64.base64Decode(((String)object).getBytes());
        return byArray;
    }

    protected Byte[] convertSchemaBase64ToByteObjectArray(Object object) throws ConversionException {
        byte[] byArray = this.convertSchemaBase64ToByteArray(object);
        Byte[] byteArray = new Byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byteArray[i] = new Byte(byArray[i]);
        }
        return byteArray;
    }

    public String buildBase64StringFromBytes(byte[] byArray) {
        byte[] byArray2 = Base64.base64Encode(byArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray2.length; ++i) {
            stringBuffer.append((char)byArray2[i]);
        }
        return stringBuffer.toString();
    }

    public String buildBase64StringFromObjectBytes(Byte[] byteArray) {
        byte[] byArray = new byte[byteArray.length];
        for (int i = 0; i < byteArray.length; ++i) {
            byArray[i] = byteArray[i];
        }
        return this.buildBase64StringFromBytes(byArray);
    }

    protected String buildHexStringFromObjectBytes(Byte[] byteArray) {
        byte[] byArray = new byte[byteArray.length];
        for (int i = 0; i < byteArray.length; ++i) {
            byArray[i] = byteArray[i];
        }
        return Helper.buildHexStringFromBytes(byArray);
    }

    protected List convertStringToList(Object object) throws ConversionException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (object instanceof String) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, " ");
            while (stringTokenizer.hasMoreElements()) {
                String string = stringTokenizer.nextToken();
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    protected String convertListToString(Object object) throws ConversionException {
        String string = new String();
        if (object instanceof List) {
            List list = (List)object;
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                if (!(e instanceof String)) continue;
                if (i > 0) {
                    string = string + " ";
                }
                string = string + e;
            }
        }
        return string;
    }

    private TimeZone convertStringToTimeZone(String string) {
        if (GMT_SUFFIX.equals(string)) {
            return TimeZone.getTimeZone(GMT_ID);
        }
        return TimeZone.getTimeZone(GMT_ID + string);
    }

    public static HashMap getDefaultXMLTypes() {
        if (defaultXMLTypes == null) {
            defaultXMLTypes = XMLConversionManager.buildXMLTypes();
        }
        return defaultXMLTypes;
    }

    public static HashMap getDefaultJavaTypes() {
        if (defaultJavaTypes == null) {
            defaultJavaTypes = XMLConversionManager.buildJavaTypes();
        }
        return defaultJavaTypes;
    }

    private static HashMap buildXMLTypes() {
        HashMap<QName, Class> hashMap = new HashMap<QName, Class>();
        hashMap.put(XMLConstants.BASE_64_BINARY_QNAME, ClassConstants.APBYTE);
        hashMap.put(XMLConstants.BOOLEAN_QNAME, ClassConstants.PBOOLEAN);
        hashMap.put(XMLConstants.BYTE_QNAME, ClassConstants.PBYTE);
        hashMap.put(XMLConstants.DATE_QNAME, ClassConstants.CALENDAR);
        hashMap.put(XMLConstants.DATE_TIME_QNAME, ClassConstants.CALENDAR);
        hashMap.put(XMLConstants.DECIMAL_QNAME, ClassConstants.BIGDECIMAL);
        hashMap.put(XMLConstants.DOUBLE_QNAME, ClassConstants.PDOUBLE);
        hashMap.put(XMLConstants.FLOAT_QNAME, ClassConstants.PFLOAT);
        hashMap.put(XMLConstants.HEX_BINARY_QNAME, ClassConstants.APBYTE);
        hashMap.put(XMLConstants.INT_QNAME, ClassConstants.PINT);
        hashMap.put(XMLConstants.INTEGER_QNAME, ClassConstants.BIGINTEGER);
        hashMap.put(XMLConstants.LONG_QNAME, ClassConstants.PLONG);
        hashMap.put(XMLConstants.QNAME_QNAME, XMLConstants.QNAME_CLASS);
        hashMap.put(XMLConstants.SHORT_QNAME, ClassConstants.PSHORT);
        hashMap.put(XMLConstants.STRING_QNAME, ClassConstants.STRING);
        hashMap.put(XMLConstants.TIME_QNAME, ClassConstants.CALENDAR);
        hashMap.put(XMLConstants.UNSIGNED_BYTE_QNAME, ClassConstants.PSHORT);
        hashMap.put(XMLConstants.UNSIGNED_INT_QNAME, ClassConstants.PLONG);
        hashMap.put(XMLConstants.UNSIGNED_SHORT_QNAME, ClassConstants.PINT);
        hashMap.put(XMLConstants.ANY_SIMPLE_TYPE_QNAME, ClassConstants.STRING);
        return hashMap;
    }

    private static HashMap buildJavaTypes() {
        HashMap<Class, QName> hashMap = new HashMap<Class, QName>();
        hashMap.put(ClassConstants.APBYTE, XMLConstants.HEX_BINARY_QNAME);
        hashMap.put(ClassConstants.BIGDECIMAL, XMLConstants.DECIMAL_QNAME);
        hashMap.put(ClassConstants.BIGINTEGER, XMLConstants.INTEGER_QNAME);
        hashMap.put(ClassConstants.PBOOLEAN, XMLConstants.BOOLEAN_QNAME);
        hashMap.put(ClassConstants.PBYTE, XMLConstants.BYTE_QNAME);
        hashMap.put(ClassConstants.CALENDAR, XMLConstants.DATE_TIME_QNAME);
        hashMap.put(ClassConstants.PDOUBLE, XMLConstants.DOUBLE_QNAME);
        hashMap.put(ClassConstants.PFLOAT, XMLConstants.FLOAT_QNAME);
        hashMap.put(ClassConstants.PINT, XMLConstants.INT_QNAME);
        hashMap.put(ClassConstants.PLONG, XMLConstants.LONG_QNAME);
        hashMap.put(ClassConstants.PSHORT, XMLConstants.SHORT_QNAME);
        hashMap.put(XMLConstants.QNAME_CLASS, XMLConstants.QNAME_QNAME);
        hashMap.put(ClassConstants.STRING, XMLConstants.STRING_QNAME);
        hashMap.put(ClassConstants.ABYTE, XMLConstants.HEX_BINARY_QNAME);
        hashMap.put(ClassConstants.BOOLEAN, XMLConstants.BOOLEAN_QNAME);
        hashMap.put(ClassConstants.BYTE, XMLConstants.BYTE_QNAME);
        hashMap.put(ClassConstants.GREGORIAN_CALENDAR, XMLConstants.DATE_TIME_QNAME);
        hashMap.put(ClassConstants.DOUBLE, XMLConstants.DOUBLE_QNAME);
        hashMap.put(ClassConstants.FLOAT, XMLConstants.FLOAT_QNAME);
        hashMap.put(ClassConstants.INTEGER, XMLConstants.INT_QNAME);
        hashMap.put(ClassConstants.LONG, XMLConstants.LONG_QNAME);
        hashMap.put(ClassConstants.SHORT, XMLConstants.SHORT_QNAME);
        hashMap.put(ClassConstants.UTILDATE, XMLConstants.DATE_TIME_QNAME);
        return hashMap;
    }

    private String appendTimeZone(String string) {
        if (!this.timeZoneQualified) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        int n = this.getTimeZone().getRawOffset() / 60000;
        if (0 == n) {
            stringBuilder.append(GMT_SUFFIX);
            return stringBuilder.toString();
        }
        if (n < 0) {
            stringBuilder.append('-');
            n = Math.abs(n);
        } else {
            stringBuilder.append('+');
        }
        int n2 = n / 60;
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2);
        stringBuilder.append(':');
        int n3 = n % 60;
        if (n3 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3);
        return stringBuilder.toString();
    }

    public Object clone() {
        XMLConversionManager xMLConversionManager = (XMLConversionManager)super.clone();
        return xMLConversionManager;
    }

    private String appendNanos(String string, Timestamp timestamp) {
        StringBuilder stringBuilder = new StringBuilder(string);
        int n = timestamp.getNanos();
        stringBuilder.append(n == 0 ? ".0" : '.' + Helper.buildZeroPrefixAndTruncTrailZeros(n, TOTAL_NS_DIGITS)).toString();
        return stringBuilder.toString();
    }

    private String appendMillis(String string, long l) {
        StringBuilder stringBuilder = new StringBuilder(string);
        int n = (int)(l % 1000L);
        if (n < 0) {
            n += 1000;
        }
        stringBuilder.append(n == 0 ? ".0" : '.' + Helper.buildZeroPrefixAndTruncTrailZeros(n, TOTAL_MS_DIGITS)).toString();
        return stringBuilder.toString();
    }

    static {
        TOTAL_MS_DIGITS = 3;
        TOTAL_NS_DIGITS = 9;
        YEAR_ONE_AD_TIME = -62135769600000L;
    }
}

