/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.oxm.record.DOMReader;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLFragmentReader
extends DOMReader {
    protected NamespaceResolver nsresolver;
    protected List<NamespaceResolver> nsresolverList = new ArrayList<NamespaceResolver>();
    protected Map<Element, NamespaceResolver> tmpresolverMap;

    public XMLFragmentReader(NamespaceResolver namespaceResolver) {
        this.nsresolverList.add(namespaceResolver);
        this.tmpresolverMap = new HashMap<Element, NamespaceResolver>();
    }

    public void parse(Node node) throws SAXException {
        if (node.getNodeType() == 11) {
            this.handleChildNodes(node.getChildNodes());
        } else {
            super.parse(node);
        }
    }

    protected void reportElementEvents(Element element) throws SAXException {
        super.reportElementEvents(element);
        this.cleanupNamespaceResolvers(element);
    }

    protected void endDocument() throws SAXException {
    }

    protected void startDocument() throws SAXException {
    }

    protected void handleXMLNSPrefixedAttribute(Element element, Attr attr) {
        String string = this.resolveNamespacePrefix(element.getPrefix());
        if (string == null || !string.equals(attr.getLocalName())) {
            NamespaceResolver namespaceResolver = this.getTempResolver(element);
            namespaceResolver.put(attr.getLocalName(), attr.getValue());
            if (!this.nsresolverList.contains(namespaceResolver)) {
                this.nsresolverList.add(namespaceResolver);
            }
        }
    }

    protected void handlePrefixedAttribute(Element element) throws SAXException {
        String string = element.getPrefix();
        String string2 = this.resolveNamespacePrefix(string);
        if (string2 == null || !string2.equals(element.getNamespaceURI())) {
            NamespaceResolver namespaceResolver = this.getTempResolver(element);
            namespaceResolver.put(string, element.getNamespaceURI());
            if (!this.nsresolverList.contains(namespaceResolver)) {
                this.nsresolverList.add(namespaceResolver);
            }
            this.getContentHandler().startPrefixMapping(string, element.getNamespaceURI());
        }
    }

    protected void endPrefixMappings(Element element) throws SAXException {
        NamespaceResolver namespaceResolver = this.getTempResolver(element);
        if (namespaceResolver != null) {
            Enumeration enumeration = namespaceResolver.getPrefixes();
            while (enumeration.hasMoreElements()) {
                this.getContentHandler().endPrefixMapping((String)enumeration.nextElement());
            }
        }
    }

    protected NamespaceResolver getTempResolver(Element element) {
        NamespaceResolver namespaceResolver = this.tmpresolverMap.get(element);
        if (namespaceResolver == null) {
            namespaceResolver = new NamespaceResolver();
            this.tmpresolverMap.put(element, namespaceResolver);
        }
        return namespaceResolver;
    }

    protected void cleanupNamespaceResolvers(Element element) {
        NamespaceResolver namespaceResolver = this.tmpresolverMap.get(element);
        if (namespaceResolver != null) {
            this.tmpresolverMap.remove(element);
            this.nsresolverList.remove(namespaceResolver);
        }
    }

    protected String resolveNamespacePrefix(String string) {
        String string2 = null;
        if (string != null) {
            NamespaceResolver namespaceResolver;
            for (int i = this.nsresolverList.size() - 1; i >= 0 && ((string2 = (namespaceResolver = this.nsresolverList.get(i)).resolveNamespacePrefix(string)) == null || string2.equals("")); --i) {
            }
        }
        return string2;
    }

    protected void processParentNamespaces(Element element) throws SAXException {
    }
}

