/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record.deferred;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.oxm.record.deferred.CharactersEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.CommentEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.DocumentLocatorEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.EndCDATAEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.EndDTDEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.EndDocumentEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.EndElementEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.EndEntityEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.EndPrefixMappingEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.IgnorableWhitespaceEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.ProcessingInstructionEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.SAXEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.SkippedEntityEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.StartCDATAEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.StartDTDEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.StartDocumentEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.StartElementEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.StartEntityEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.StartPrefixMappingEvent;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public abstract class DeferredContentHandler
implements ContentHandler,
LexicalHandler {
    private int levelIndex = 0;
    private List<SAXEvent> events = new ArrayList<SAXEvent>();
    private UnmarshalRecord parent;
    private boolean startOccurred;
    private boolean charactersOccurred;

    public DeferredContentHandler(UnmarshalRecord unmarshalRecord) {
        this.parent = unmarshalRecord;
    }

    protected abstract void processEmptyElement() throws SAXException;

    protected abstract void processComplexElement() throws SAXException;

    protected abstract void processSimpleElement() throws SAXException;

    protected void executeEvents(UnmarshalRecord unmarshalRecord) throws SAXException {
        for (int i = 0; i < this.events.size(); ++i) {
            SAXEvent sAXEvent = this.events.get(i);
            sAXEvent.processEvent(unmarshalRecord);
        }
        if (this.parent.getXMLReader().getContentHandler().equals(this)) {
            this.parent.getXMLReader().setContentHandler(unmarshalRecord);
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        StartPrefixMappingEvent startPrefixMappingEvent = new StartPrefixMappingEvent(string, string2);
        this.events.add(startPrefixMappingEvent);
    }

    public void endPrefixMapping(String string) throws SAXException {
        EndPrefixMappingEvent endPrefixMappingEvent = new EndPrefixMappingEvent(string);
        this.events.add(endPrefixMappingEvent);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        ++this.levelIndex;
        AttributeList attributeList = this.buildAttributeList(attributes);
        StartElementEvent startElementEvent = new StartElementEvent(string, string2, string3, attributeList);
        this.events.add(startElementEvent);
        if (this.startOccurred) {
            this.processComplexElement();
            return;
        }
        this.startOccurred = true;
    }

    protected AttributeList buildAttributeList(Attributes attributes) throws SAXException {
        AttributeList attributeList = new AttributeList(attributes.getLength());
        for (int i = 0; i < attributes.getLength(); ++i) {
            attributeList.addAttribute(attributes.getLocalName(i), attributes.getQName(i), attributes.getURI(i), attributes.getType(i), attributes.getValue(i), i);
        }
        return attributeList;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        --this.levelIndex;
        EndElementEvent endElementEvent = new EndElementEvent(string, string2, string3);
        this.events.add(endElementEvent);
        if (this.charactersOccurred) {
            this.processSimpleElement();
        } else if (this.startOccurred) {
            this.processEmptyElement();
        }
        if (this.levelIndex == 0 && this.parent != null) {
            this.parent.getXMLReader().setContentHandler(this.parent);
        }
    }

    public void setDocumentLocator(Locator locator) {
        DocumentLocatorEvent documentLocatorEvent = new DocumentLocatorEvent(locator);
        this.events.add(documentLocatorEvent);
    }

    public void startDocument() throws SAXException {
        StartDocumentEvent startDocumentEvent = new StartDocumentEvent();
        this.events.add(startDocumentEvent);
    }

    public void endDocument() throws SAXException {
        EndDocumentEvent endDocumentEvent = new EndDocumentEvent();
        this.events.add(endDocumentEvent);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.charactersOccurred = true;
        CharactersEvent charactersEvent = new CharactersEvent(cArray, n, n2);
        this.events.add(charactersEvent);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        IgnorableWhitespaceEvent ignorableWhitespaceEvent = new IgnorableWhitespaceEvent(cArray, n, n2);
        this.events.add(ignorableWhitespaceEvent);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        ProcessingInstructionEvent processingInstructionEvent = new ProcessingInstructionEvent(string, string2);
        this.events.add(processingInstructionEvent);
    }

    public void skippedEntity(String string) throws SAXException {
        SkippedEntityEvent skippedEntityEvent = new SkippedEntityEvent(string);
        this.events.add(skippedEntityEvent);
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        StartDTDEvent startDTDEvent = new StartDTDEvent(string, string2, string3);
        this.events.add(startDTDEvent);
    }

    public void endDTD() throws SAXException {
        EndDTDEvent endDTDEvent = new EndDTDEvent();
        this.events.add(endDTDEvent);
    }

    public void startEntity(String string) throws SAXException {
        StartEntityEvent startEntityEvent = new StartEntityEvent(string);
        this.events.add(startEntityEvent);
    }

    public void endEntity(String string) throws SAXException {
        EndEntityEvent endEntityEvent = new EndEntityEvent(string);
        this.events.add(endEntityEvent);
    }

    public void startCDATA() throws SAXException {
        StartCDATAEvent startCDATAEvent = new StartCDATAEvent();
        this.events.add(startCDATAEvent);
    }

    public void endCDATA() throws SAXException {
        EndCDATAEvent endCDATAEvent = new EndCDATAEvent();
        this.events.add(endCDATAEvent);
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        CommentEvent commentEvent = new CommentEvent(cArray, n, n2);
        this.events.add(commentEvent);
    }

    protected UnmarshalRecord getParent() {
        return this.parent;
    }

    protected List getEvents() {
        return this.events;
    }

    public class AttributeList
    implements Attributes {
        private String[] localNames;
        private String[] uris;
        private String[] values;
        private String[] types;
        private ArrayList<String> qNames;

        public AttributeList(int n) {
            this.qNames = new ArrayList(n);
            this.localNames = new String[n];
            this.uris = new String[n];
            this.types = new String[n];
            this.values = new String[n];
        }

        public void addAttribute(String string, String string2, String string3, String string4, String string5, int n) {
            this.qNames.add(n, string2);
            this.localNames[n] = string;
            this.uris[n] = string3;
            this.types[n] = string4;
            this.values[n] = string5;
        }

        public String getQName(int n) {
            return this.qNames.get(n);
        }

        public String getType(String string, String string2) {
            for (int i = 0; i < this.localNames.length; ++i) {
                String string3 = this.localNames[i];
                if (string3 == null || string2 == null || !string2.equals(string3)) continue;
                String string4 = this.uris[i];
                if (string4 == null) {
                    string4 = "";
                }
                if (!string4.equals(string)) continue;
                return this.types[i];
            }
            return null;
        }

        public String getType(int n) {
            return this.types[n];
        }

        public String getType(String string) {
            return this.types[this.getIndex(string)];
        }

        public int getIndex(String string) {
            return this.qNames.indexOf(string);
        }

        public int getIndex(String string, String string2) {
            for (int i = 0; i < this.localNames.length; ++i) {
                String string3 = this.localNames[i];
                if (string3 == null || string2 == null || !string2.equals(string3)) continue;
                String string4 = this.uris[i];
                if (string4 == null) {
                    string4 = "";
                }
                if (!string4.equals(string)) continue;
                return i;
            }
            return -1;
        }

        public int getLength() {
            return this.localNames.length;
        }

        public String getLocalName(int n) {
            return this.localNames[n];
        }

        public String getURI(int n) {
            return this.uris[n];
        }

        public String getValue(int n) {
            return this.values[n];
        }

        public String getValue(String string) {
            return this.values[this.getIndex(string)];
        }

        public String getValue(String string, String string2) {
            for (int i = 0; i < this.localNames.length; ++i) {
                String string3 = this.localNames[i];
                if (string3 == null || string2 == null || !string2.equals(string3)) continue;
                String string4 = this.uris[i];
                if (string4 == null) {
                    string4 = "";
                }
                if (!string4.equals(string)) continue;
                return this.values[i];
            }
            return null;
        }
    }
}

