/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.schema.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.oxm.schema.model.Annotation;
import org.eclipse.persistence.internal.oxm.schema.model.AttributeGroup;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Element;
import org.eclipse.persistence.internal.oxm.schema.model.Group;
import org.eclipse.persistence.internal.oxm.schema.model.Import;
import org.eclipse.persistence.internal.oxm.schema.model.Include;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleType;
import org.eclipse.persistence.oxm.NamespaceResolver;

public class Schema {
    private String name;
    private List imports;
    private List includes;
    private String targetNamespace;
    private String defaultNamespace;
    private boolean elementFormDefault;
    private boolean attributeFormDefault;
    private Map topLevelSimpleTypes;
    private Map topLevelComplexTypes;
    private Map topLevelElements;
    private Map topLevelAttributes;
    private NamespaceResolver namespaceResolver = new NamespaceResolver();
    private Map attributesMap;
    private Map attributeGroups;
    private Map groups;
    private Annotation annotation;

    public Schema() {
        this.imports = new ArrayList();
        this.includes = new ArrayList();
        this.topLevelSimpleTypes = new HashMap();
        this.topLevelComplexTypes = new HashMap();
        this.topLevelElements = new HashMap();
        this.topLevelAttributes = new HashMap();
        this.attributesMap = new HashMap();
        this.attributeGroups = new HashMap();
        this.groups = new HashMap();
    }

    public void setTargetNamespace(String string) {
        this.targetNamespace = string;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setDefaultNamespace(String string) {
        this.defaultNamespace = string;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void setTopLevelSimpleTypes(Map map) {
        this.topLevelSimpleTypes = map;
    }

    public Map getTopLevelSimpleTypes() {
        return this.topLevelSimpleTypes;
    }

    public void addTopLevelSimpleTypes(SimpleType simpleType) {
        this.topLevelSimpleTypes.put(simpleType.getName(), simpleType);
    }

    public void setTopLevelComplexTypes(Map map) {
        this.topLevelComplexTypes = map;
    }

    public Map getTopLevelComplexTypes() {
        return this.topLevelComplexTypes;
    }

    public void addTopLevelComplexTypes(ComplexType complexType) {
        this.topLevelComplexTypes.put(complexType.getName(), complexType);
    }

    public void setTopLevelElements(Map map) {
        this.topLevelElements = map;
    }

    public Map getTopLevelElements() {
        return this.topLevelElements;
    }

    public void addTopLevelElement(Element element) {
        this.topLevelElements.put(element.getName(), element);
    }

    public void setElementFormDefault(boolean bl) {
        this.elementFormDefault = bl;
    }

    public boolean isElementFormDefault() {
        return this.elementFormDefault;
    }

    public void setAttributeFormDefault(boolean bl) {
        this.attributeFormDefault = bl;
    }

    public boolean isAttributeFormDefault() {
        return this.attributeFormDefault;
    }

    public void setTopLevelAttributes(Map map) {
        this.topLevelAttributes = map;
    }

    public Map getTopLevelAttributes() {
        return this.topLevelAttributes;
    }

    public void setNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.namespaceResolver = namespaceResolver;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public void setImports(List list) {
        this.imports = list;
    }

    public List getImports() {
        return this.imports;
    }

    public void setIncludes(List list) {
        this.includes = list;
    }

    public List getIncludes() {
        return this.includes;
    }

    public void setAttributesMap(Map map) {
        this.attributesMap = map;
        for (QName qName : map.keySet()) {
            if (!qName.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) continue;
            String string = (String)map.get(qName);
            String string2 = qName.getLocalPart();
            int n = string2.indexOf(58);
            if (n > -1) {
                string2 = string2.substring(n + 1, string2.length());
            }
            this.namespaceResolver.put(string2, string);
        }
    }

    public Map getAttributesMap() {
        return this.attributesMap;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setAttributeGroups(Map map) {
        this.attributeGroups = map;
    }

    public Map getAttributeGroups() {
        return this.attributeGroups;
    }

    public AttributeGroup getAttributeGroup(String string, String string2) {
        AttributeGroup attributeGroup = null;
        if (string.equals(this.targetNamespace) && (attributeGroup = (AttributeGroup)this.getAttributeGroups().get(string2)) != null) {
            return attributeGroup;
        }
        attributeGroup = this.getAttributeGroupFromReferencedSchemas(string, string2);
        return attributeGroup;
    }

    protected AttributeGroup getAttributeGroupFromReferencedSchemas(String string, String string2) {
        Schema schema;
        AttributeGroup attributeGroup = null;
        Iterator iterator = this.getIncludes().iterator();
        while (iterator.hasNext() && attributeGroup == null) {
            schema = ((Include)iterator.next()).getSchema();
            attributeGroup = schema.getAttributeGroup(string, string2);
        }
        if (attributeGroup == null) {
            iterator = this.getImports().iterator();
            while (iterator.hasNext() && attributeGroup == null) {
                schema = ((Import)iterator.next()).getSchema();
                attributeGroup = schema.getAttributeGroup(string, string2);
            }
        }
        return attributeGroup;
    }

    public void setGroups(Map map) {
        this.groups = map;
    }

    public Map getGroups() {
        return this.groups;
    }

    public Group getGroup(String string, String string2) {
        Group group = null;
        if (string.equals(this.targetNamespace) && (group = (Group)this.getGroups().get(string2)) != null) {
            return group;
        }
        group = this.getGroupFromReferencedSchemas(string, string2);
        return group;
    }

    protected Group getGroupFromReferencedSchemas(String string, String string2) {
        Schema schema;
        Group group = null;
        Iterator iterator = this.getIncludes().iterator();
        while (iterator.hasNext() && group == null) {
            schema = ((Include)iterator.next()).getSchema();
            group = schema.getGroup(string, string2);
        }
        if (group == null) {
            iterator = this.getImports().iterator();
            while (iterator.hasNext() && group == null) {
                schema = ((Import)iterator.next()).getSchema();
                group = schema.getGroup(string, string2);
            }
        }
        return group;
    }
}

