/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.util.IdentityHashMap;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.queries.ExpressionQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryByExamplePolicy;

public class QueryByExampleMechanism
extends ExpressionQueryMechanism {
    protected boolean isParsed = false;
    protected Object exampleObject;
    protected QueryByExamplePolicy queryByExamplePolicy;

    public QueryByExampleMechanism(DatabaseQuery databaseQuery) {
        super(databaseQuery);
    }

    public QueryByExampleMechanism(DatabaseQuery databaseQuery, Expression expression) {
        super(databaseQuery, expression);
    }

    public void buildSelectionCriteria(AbstractSession abstractSession) {
        if (this.isParsed() || this.getExampleObject() == null) {
            return;
        }
        ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)this.getQuery();
        objectLevelReadQuery.checkDescriptor(abstractSession);
        QueryByExamplePolicy queryByExamplePolicy = this.getQueryByExamplePolicy();
        if (queryByExamplePolicy == null) {
            queryByExamplePolicy = new QueryByExamplePolicy();
        }
        if (objectLevelReadQuery.getReferenceClass().isInstance(this.getExampleObject())) {
            Expression expression = objectLevelReadQuery.getDescriptor().getObjectBuilder().buildExpressionFromExample(this.getExampleObject(), queryByExamplePolicy, objectLevelReadQuery.getExpressionBuilder(), new IdentityHashMap(), abstractSession);
            if (this.getSelectionCriteria() != null) {
                this.setSelectionCriteria(this.getSelectionCriteria().and(expression));
            } else {
                this.setSelectionCriteria(expression);
            }
        } else {
            throw QueryException.exampleAndReferenceObjectClassMismatch(this.getExampleObject().getClass(), objectLevelReadQuery.getReferenceClass(), objectLevelReadQuery);
        }
        this.setIsParsed(true);
    }

    public Object getExampleObject() {
        return this.exampleObject;
    }

    public QueryByExamplePolicy getQueryByExamplePolicy() {
        return this.queryByExamplePolicy;
    }

    public boolean isParsed() {
        return this.isParsed;
    }

    public boolean isQueryByExampleMechanism() {
        return true;
    }

    public void setExampleObject(Object object) {
        this.exampleObject = object;
    }

    public void setIsParsed(boolean bl) {
        this.isParsed = bl;
    }

    public void setQueryByExamplePolicy(QueryByExamplePolicy queryByExamplePolicy) {
        this.queryByExamplePolicy = queryByExamplePolicy;
    }
}

