/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.expressions.SQLModifyStatement;
import org.eclipse.persistence.internal.expressions.SQLStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.queries.CallQueryMechanism;
import org.eclipse.persistence.internal.queries.DatabaseQueryMechanism;
import org.eclipse.persistence.queries.DatabaseQuery;

public class StatementQueryMechanism
extends CallQueryMechanism {
    protected SQLStatement sqlStatement;
    protected Vector sqlStatements;

    public StatementQueryMechanism(DatabaseQuery databaseQuery) {
        super(databaseQuery);
    }

    public StatementQueryMechanism(DatabaseQuery databaseQuery, SQLStatement sQLStatement) {
        super(databaseQuery);
        this.sqlStatement = sQLStatement;
    }

    public void clearStatement() {
    }

    public DatabaseQueryMechanism clone(DatabaseQuery databaseQuery) {
        StatementQueryMechanism statementQueryMechanism = (StatementQueryMechanism)super.clone(databaseQuery);
        if (!this.hasMultipleStatements() && this.getSQLStatement() != null) {
            statementQueryMechanism.setSQLStatement((SQLStatement)this.sqlStatement.clone());
        } else {
            Vector vector = this.getSQLStatements();
            if (vector != null) {
                NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(vector.size());
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    ((Vector)nonSynchronizedVector).addElement(((SQLStatement)enumeration.nextElement()).clone());
                }
                statementQueryMechanism.setSQLStatements(nonSynchronizedVector);
            }
        }
        return statementQueryMechanism;
    }

    public Integer deleteObject() throws DatabaseException {
        if (!this.hasMultipleCalls() && this.getCall() == null) {
            this.prepareDeleteObject();
            if (!this.hasMultipleCalls() && this.getCall() == null) {
                return new Integer(1);
            }
        }
        return super.deleteObject();
    }

    public Integer executeNoSelect() throws DatabaseException {
        if (!this.hasMultipleCalls() && this.getCall() == null) {
            this.prepareExecuteNoSelect();
        }
        return super.executeNoSelect();
    }

    public Expression getSelectionCriteria() {
        return this.getSQLStatement().getWhereClause();
    }

    public SQLStatement getSQLStatement() {
        return this.sqlStatement;
    }

    public Vector getSQLStatements() {
        if (this.sqlStatements == null) {
            this.sqlStatements = NonSynchronizedVector.newInstance(3);
        }
        return this.sqlStatements;
    }

    public boolean hasMultipleStatements() {
        return this.sqlStatements != null && !this.sqlStatements.isEmpty();
    }

    public void insertObject() throws DatabaseException {
        if (!this.hasMultipleCalls() && this.getCall() == null) {
            this.prepareInsertObject();
        }
        super.insertObject();
    }

    public void insertObject(boolean bl) {
        if (bl) {
            this.setCalls(null);
            this.trimFieldsForInsert();
            this.prepareInsertObject();
        }
        this.insertObject();
    }

    public void trimFieldsForInsert() {
        this.getDescriptor().getObjectBuilder().trimFieldsForInsert(this.getSession(), this.getModifyRow());
    }

    public boolean isCallQueryMechanism() {
        return false;
    }

    public boolean isStatementQueryMechanism() {
        return true;
    }

    public void prepare() {
        if (!this.hasMultipleStatements() && this.getSQLStatement() == null) {
            throw QueryException.sqlStatementNotSetProperly(this.getQuery());
        }
    }

    public void prepareCursorSelectAllRows() {
        this.setCallFromStatement();
        this.clearStatement();
        super.prepareCursorSelectAllRows();
    }

    public void prepareDeleteAll() {
        this.setCallFromStatement();
        this.clearStatement();
        super.prepareDeleteAll();
    }

    public void prepareDeleteObject() {
        this.setCallFromStatement();
        this.clearStatement();
        super.prepareDeleteObject();
    }

    public void prepareDoesExist(DatabaseField databaseField) {
        this.setCallFromStatement();
        this.clearStatement();
        this.getCall().returnOneRow();
        this.prepareCall();
    }

    public void prepareExecuteNoSelect() {
        this.setCallFromStatement();
        this.clearStatement();
        super.prepareExecuteNoSelect();
    }

    public void prepareExecuteSelect() {
        this.setCallFromStatement();
        this.clearStatement();
        super.prepareExecuteSelect();
    }

    public void prepareInsertObject() {
        if (this.getModifyRow() == null) {
            return;
        }
        if (this.hasMultipleStatements()) {
            Enumeration enumeration = this.getSQLStatements().elements();
            while (enumeration.hasMoreElements()) {
                ((SQLModifyStatement)enumeration.nextElement()).setModifyRow(this.getModifyRow());
            }
        } else if (this.getSQLStatement() != null) {
            ((SQLModifyStatement)this.getSQLStatement()).setModifyRow(this.getModifyRow());
        }
        this.setCallFromStatement();
        this.clearStatement();
        super.prepareInsertObject();
    }

    public void prepareSelectAllRows() {
        this.setCallFromStatement();
        this.clearStatement();
        super.prepareSelectAllRows();
    }

    public void prepareSelectOneRow() {
        this.setCallFromStatement();
        this.clearStatement();
        super.prepareSelectOneRow();
    }

    public void prepareUpdateObject() {
        if (this.getModifyRow() == null) {
            return;
        }
        if (this.hasMultipleStatements()) {
            Enumeration enumeration = this.getSQLStatements().elements();
            while (enumeration.hasMoreElements()) {
                ((SQLModifyStatement)enumeration.nextElement()).setModifyRow(this.getModifyRow());
            }
        } else if (this.getSQLStatement() != null) {
            ((SQLModifyStatement)this.getSQLStatement()).setModifyRow(this.getModifyRow());
        }
        this.setCallFromStatement();
        this.clearStatement();
        super.prepareUpdateObject();
    }

    public void prepareUpdateAll() {
        this.setCallFromStatement();
        this.clearStatement();
        super.prepareUpdateAll();
    }

    protected void setCallFromStatement() {
        this.getSession().startOperationProfile("sql generation", this.getQuery(), Integer.MAX_VALUE);
        if (this.hasMultipleStatements()) {
            Enumeration enumeration = this.getSQLStatements().elements();
            while (enumeration.hasMoreElements()) {
                DatabaseCall databaseCall = null;
                databaseCall = this.getDescriptor() != null ? this.getDescriptor().buildCallFromStatement((SQLStatement)enumeration.nextElement(), this.getSession()) : ((SQLStatement)enumeration.nextElement()).buildCall(this.getSession());
                if (databaseCall == null) continue;
                this.addCall(databaseCall);
            }
        } else {
            DatabaseCall databaseCall = null;
            databaseCall = this.getDescriptor() != null ? this.getDescriptor().buildCallFromStatement(this.getSQLStatement(), this.getSession()) : this.getSQLStatement().buildCall(this.getSession());
            if (databaseCall != null) {
                this.setCall(databaseCall);
            }
        }
        this.getSession().endOperationProfile("sql generation", this.getQuery(), Integer.MAX_VALUE);
    }

    public void setSQLStatement(SQLStatement sQLStatement) {
        this.sqlStatement = sQLStatement;
    }

    protected void setSQLStatements(Vector vector) {
        this.sqlStatements = vector;
    }

    public Integer updateObject() throws DatabaseException {
        if (!this.hasMultipleCalls() && this.getCall() == null) {
            this.prepareUpdateObject();
            if (!this.hasMultipleCalls() && this.getCall() == null) {
                return new Integer(1);
            }
        }
        return super.updateObject();
    }
}

