/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sequencing;

import java.util.Map;
import java.util.Queue;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.persistence.internal.sequencing.SequencingLogInOut;

class PreallocationHandler
implements SequencingLogInOut {
    protected Map<String, Queue> preallocatedSequences;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue getPreallocated(String string) {
        ConcurrentLinkedQueue concurrentLinkedQueue = this.preallocatedSequences.get(string);
        if (concurrentLinkedQueue == null) {
            Map<String, Queue> map = this.preallocatedSequences;
            synchronized (map) {
                concurrentLinkedQueue = this.preallocatedSequences.get(string);
                if (concurrentLinkedQueue == null) {
                    concurrentLinkedQueue = new ConcurrentLinkedQueue();
                    this.preallocatedSequences.put(string, concurrentLinkedQueue);
                }
            }
        }
        return concurrentLinkedQueue;
    }

    public void onConnect() {
        this.initializePreallocated();
    }

    public void onDisconnect() {
        this.preallocatedSequences = null;
    }

    public boolean isConnected() {
        return this.preallocatedSequences != null;
    }

    public void initializePreallocated() {
        this.preallocatedSequences = new ConcurrentHashMap<String, Queue>(20);
    }

    public void initializePreallocated(String string) {
        this.preallocatedSequences.remove(string);
    }

    public void setPreallocated(String string, Vector vector) {
        this.getPreallocated(string).addAll(vector);
    }
}

