/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.internal.helper.DescriptorCompare;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CommitOrderCalculator;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.UpdateObjectQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitManager {
    protected List<Class> commitOrder;
    protected Map<Object, Integer> commitState;
    protected static final Integer PRE = 1;
    protected static final Integer POST = 2;
    protected static final Integer COMPLETE = 3;
    protected Map shallowCommits;
    protected AbstractSession session;
    protected boolean isActive;
    protected Map<DatabaseMapping, List<Object[]>> dataModifications;
    protected List objectsToDelete;
    protected int commitDepth;

    public CommitManager(AbstractSession abstractSession) {
        this.session = abstractSession;
    }

    public void addDataModificationEvent(DatabaseMapping databaseMapping, Object[] objectArray) {
        if (!this.getDataModifications().containsKey(databaseMapping)) {
            this.dataModifications.put(databaseMapping, new ArrayList());
        }
        this.dataModifications.get(databaseMapping).add(objectArray);
    }

    public void addObjectToDelete(Object object) {
        this.getObjectsToDelete().add(object);
    }

    /*
     * WARNING - void declaration
     */
    public void commitAllObjectsWithChangeSet(UnitOfWorkChangeSet unitOfWorkChangeSet) throws RuntimeException, DatabaseException, OptimisticLockException {
        this.reinitialize();
        this.isActive = true;
        this.session.beginTransaction();
        try {
            Iterator iterator;
            if (unitOfWorkChangeSet.getObjectChanges().size() + unitOfWorkChangeSet.getNewObjectChangeSets().size() <= 1) {
                Object object;
                iterator = unitOfWorkChangeSet.getNewObjectChangeSets().keySet().iterator();
                if (iterator.hasNext()) {
                    object = (Class)iterator.next();
                    this.commitNewObjectsForClassWithChangeSet(unitOfWorkChangeSet, (Class)object);
                }
                if ((object = unitOfWorkChangeSet.getObjectChanges().keySet().iterator()).hasNext()) {
                    String object2 = (String)object.next();
                    this.commitChangedObjectsForClassWithChangeSet(unitOfWorkChangeSet, object2);
                }
            } else {
                iterator = this.getCommitOrder();
                int n = iterator.size();
                boolean i = false;
                while (i < n) {
                    Class clazz = (Class)iterator.get((int)i);
                    this.commitAllObjectsForClassWithChangeSet(unitOfWorkChangeSet, clazz);
                    ++i;
                }
            }
            if (this.hasDataModifications()) {
                iterator = this.getDataModifications().keySet().iterator();
                for (List<Object[]> list : this.getDataModifications().values()) {
                    int n = list.size();
                    DatabaseMapping databaseMapping = (DatabaseMapping)iterator.next();
                    for (int i = 0; i < n; ++i) {
                        Object[] objectArray = list.get(i);
                        databaseMapping.performDataModificationEvent(objectArray, this.getSession());
                    }
                }
            }
            if (this.hasObjectsToDelete()) {
                void var4_14;
                iterator = this.getObjectsToDelete();
                int n = iterator.size();
                this.reinitialize();
                boolean bl = false;
                while (var4_14 < n) {
                    this.session.deleteObject(iterator.get((int)var4_14));
                    ++var4_14;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            this.session.rollbackTransaction();
            throw runtimeException;
        }
        finally {
            this.reinitialize();
            this.isActive = false;
        }
        this.session.commitTransaction();
    }

    protected void commitAllObjectsForClassWithChangeSet(UnitOfWorkChangeSet unitOfWorkChangeSet, Class clazz) {
        this.commitChangedObjectsForClassWithChangeSet(unitOfWorkChangeSet, clazz.getName());
        this.commitNewObjectsForClassWithChangeSet(unitOfWorkChangeSet, clazz);
    }

    protected void commitNewObjectsForClassWithChangeSet(UnitOfWorkChangeSet unitOfWorkChangeSet, Class clazz) {
        Map map = (Map)unitOfWorkChangeSet.getNewObjectChangeSets().get(clazz);
        if (map != null) {
            AbstractSession abstractSession = this.getSession();
            ClassDescriptor classDescriptor = abstractSession.getDescriptor(clazz);
            for (ObjectChangeSet objectChangeSet : new ArrayList(map.values())) {
                Object object = objectChangeSet.getUnitOfWorkClone();
                if (!this.isProcessedCommit(object)) {
                    InsertObjectQuery insertObjectQuery = classDescriptor.getQueryManager().getInsertQuery();
                    if (insertObjectQuery == null) {
                        insertObjectQuery = new InsertObjectQuery();
                        insertObjectQuery.setDescriptor(classDescriptor);
                    } else {
                        insertObjectQuery.checkPrepare(abstractSession, insertObjectQuery.getTranslationRow());
                        insertObjectQuery = (InsertObjectQuery)insertObjectQuery.clone();
                    }
                    insertObjectQuery.setIsExecutionClone(true);
                    insertObjectQuery.setObjectChangeSet(objectChangeSet);
                    insertObjectQuery.setObject(object);
                    insertObjectQuery.cascadeOnlyDependentParts();
                    insertObjectQuery.setModifyRow(null);
                    abstractSession.executeQuery(insertObjectQuery);
                }
                unitOfWorkChangeSet.putNewObjectInChangesList(objectChangeSet, abstractSession);
            }
        }
    }

    protected void commitChangedObjectsForClassWithChangeSet(UnitOfWorkChangeSet unitOfWorkChangeSet, String string) {
        Map map = (Map)unitOfWorkChangeSet.getObjectChanges().get(string);
        if (map != null) {
            ClassDescriptor classDescriptor = null;
            AbstractSession abstractSession = this.getSession();
            for (ObjectChangeSet objectChangeSet : map.values()) {
                Object object = objectChangeSet.getUnitOfWorkClone();
                if (classDescriptor == null) {
                    classDescriptor = abstractSession.getDescriptor(object);
                }
                if (this.isProcessedCommit(object)) continue;
                WriteObjectQuery writeObjectQuery = null;
                writeObjectQuery = objectChangeSet.isNew() ? new InsertObjectQuery() : new UpdateObjectQuery();
                writeObjectQuery.setIsExecutionClone(true);
                writeObjectQuery.setDescriptor(classDescriptor);
                writeObjectQuery.setObjectChangeSet(objectChangeSet);
                writeObjectQuery.setObject(object);
                writeObjectQuery.cascadeOnlyDependentParts();
                abstractSession.executeQuery(writeObjectQuery);
            }
        }
    }

    public void deleteAllObjects(List list) throws RuntimeException, DatabaseException, OptimisticLockException {
        this.isActive = true;
        AbstractSession abstractSession = this.getSession();
        abstractSession.beginTransaction();
        try {
            if (list.size() == 1) {
                this.deleteAllObjects(list.get(0).getClass(), list, abstractSession);
            } else {
                List<Class> list2 = this.getCommitOrder();
                for (int i = list2.size() - 1; i >= 0; --i) {
                    Class clazz = list2.get(i);
                    this.deleteAllObjects(clazz, list, abstractSession);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            try {
                abstractSession.rollbackTransaction();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw runtimeException;
        }
        finally {
            this.reinitialize();
            this.isActive = false;
        }
        abstractSession.commitTransaction();
    }

    public void deleteAllObjects(Class clazz, List list, AbstractSession abstractSession) {
        ClassDescriptor classDescriptor = null;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            DeleteObjectQuery deleteObjectQuery;
            Object e = list.get(i);
            if (e.getClass() != clazz) continue;
            if (classDescriptor == null) {
                classDescriptor = abstractSession.getDescriptor(clazz);
            }
            if ((deleteObjectQuery = classDescriptor.getQueryManager().getDeleteQuery()) == null) {
                deleteObjectQuery = new DeleteObjectQuery();
                deleteObjectQuery.setDescriptor(classDescriptor);
            } else {
                deleteObjectQuery.checkPrepare(abstractSession, deleteObjectQuery.getTranslationRow());
                deleteObjectQuery = (DeleteObjectQuery)deleteObjectQuery.clone();
            }
            deleteObjectQuery.setIsExecutionClone(true);
            deleteObjectQuery.setObject(e);
            abstractSession.executeQuery(deleteObjectQuery);
        }
    }

    public List<Class> getCommitOrder() {
        if (this.commitOrder == null) {
            this.commitOrder = new ArrayList<Class>();
        }
        return this.commitOrder;
    }

    protected Map<Object, Integer> getCommitState() {
        if (this.commitState == null) {
            this.commitState = new IdentityHashMap<Object, Integer>();
        }
        return this.commitState;
    }

    protected boolean hasDataModifications() {
        return this.dataModifications != null && !this.dataModifications.isEmpty();
    }

    protected Map<DatabaseMapping, List<Object[]>> getDataModifications() {
        if (this.dataModifications == null) {
            this.dataModifications = new HashMap<DatabaseMapping, List<Object[]>>(16);
        }
        return this.dataModifications;
    }

    protected boolean hasObjectsToDelete() {
        return this.objectsToDelete != null && !this.objectsToDelete.isEmpty();
    }

    protected List getObjectsToDelete() {
        if (this.objectsToDelete == null) {
            this.objectsToDelete = new ArrayList();
        }
        return this.objectsToDelete;
    }

    protected AbstractSession getSession() {
        return this.session;
    }

    protected Map getShallowCommits() {
        if (this.shallowCommits == null) {
            this.shallowCommits = new IdentityHashMap();
        }
        return this.shallowCommits;
    }

    public void initializeCommitOrder() {
        int n;
        Vector vector = Helper.buildVectorFromMapElements(this.getSession().getDescriptors());
        vector = Helper.addAllUniqueToVector(new Vector(vector.size()), vector);
        Object[] objectArray = new Object[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            objectArray[n] = vector.elementAt(n);
        }
        Arrays.sort(objectArray, new DescriptorCompare());
        vector = new Vector(vector.size());
        for (n = 0; n < objectArray.length; ++n) {
            vector.addElement(objectArray[n]);
        }
        CommitOrderCalculator commitOrderCalculator = new CommitOrderCalculator(this.getSession());
        commitOrderCalculator.addNodes(vector);
        commitOrderCalculator.calculateMappingDependencies();
        commitOrderCalculator.orderCommits();
        vector = commitOrderCalculator.getOrderedDescriptors();
        commitOrderCalculator = new CommitOrderCalculator(this.getSession());
        commitOrderCalculator.addNodes(vector);
        commitOrderCalculator.calculateSpecifiedDependencies();
        commitOrderCalculator.orderCommits();
        this.setCommitOrder(commitOrderCalculator.getOrderedClasses());
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isProcessedCommit(Object object) {
        return this.getCommitState().get(object) != null;
    }

    public boolean isCommitCompleted(Object object) {
        return this.getCommitState().get(object) == COMPLETE;
    }

    public boolean isCommitCompletedOrInPost(Object object) {
        Integer n = this.getCommitState().get(object);
        return n == COMPLETE || n == POST;
    }

    public boolean isCommitInPostModify(Object object) {
        return this.getCommitState().get(object) == POST;
    }

    public boolean isCommitInPreModify(Object object) {
        return this.getCommitState().get(object) == PRE;
    }

    public boolean isShallowCommitted(Object object) {
        if (this.shallowCommits == null) {
            return false;
        }
        return this.shallowCommits.containsKey(object);
    }

    public void markCommitCompleted(Object object) {
        --this.commitDepth;
        this.getCommitState().put(object, COMPLETE);
        if (!this.isActive && this.commitDepth == 0) {
            this.reinitialize();
            return;
        }
    }

    public void markPostModifyCommitInProgress(Object object) {
        this.getCommitState().put(object, POST);
    }

    public void markPreModifyCommitInProgress(Object object) {
        ++this.commitDepth;
        this.getCommitState().put(object, PRE);
    }

    public void markShallowCommit(Object object) {
        this.getShallowCommits().put(object, object);
    }

    public void reinitialize() {
        this.commitState = null;
        this.commitDepth = 0;
        this.shallowCommits = null;
        this.objectsToDelete = null;
        this.dataModifications = null;
    }

    public void setCommitOrder(List list) {
        this.commitOrder = list;
    }

    protected void setDataModifications(Map<DatabaseMapping, List<Object[]>> map) {
        this.dataModifications = map;
    }

    public void setIsActive(boolean bl) {
        this.isActive = bl;
    }

    protected void setObjectsToDelete(List list) {
        this.objectsToDelete = list;
    }

    protected void setSession(AbstractSession abstractSession) {
        this.session = abstractSession;
    }

    protected void setShallowCommits(Map map) {
        this.shallowCommits = map;
    }

    public String toString() {
        Object[] objectArray = new Object[]{new Integer(this.commitDepth)};
        return Helper.getShortClassName(this.getClass()) + ToStringLocalization.buildMessage("commit_depth", objectArray);
    }
}

