/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CommitOrderDependencyNode;

public class CommitOrderCalculator {
    protected int currentTime = 0;
    protected Vector nodes = new Vector(1);
    protected Vector orderedDescriptors;
    protected AbstractSession session;

    public CommitOrderCalculator(AbstractSession abstractSession) {
        this.session = abstractSession;
    }

    protected void addNode(ClassDescriptor classDescriptor) {
        this.nodes.addElement(new CommitOrderDependencyNode(this, classDescriptor, this.session));
    }

    public void addNodes(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ClassDescriptor classDescriptor = (ClassDescriptor)enumeration.nextElement();
            this.addNode(classDescriptor);
        }
    }

    public void calculateMappingDependencies() {
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            CommitOrderDependencyNode commitOrderDependencyNode = (CommitOrderDependencyNode)enumeration.nextElement();
            commitOrderDependencyNode.recordMappingDependencies();
        }
    }

    public void calculateSpecifiedDependencies() {
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            CommitOrderDependencyNode commitOrderDependencyNode = (CommitOrderDependencyNode)enumeration.nextElement();
            commitOrderDependencyNode.recordSpecifiedDependencies();
        }
    }

    public void depthFirstSearch() {
        CommitOrderDependencyNode commitOrderDependencyNode;
        Enumeration enumeration = this.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            commitOrderDependencyNode = (CommitOrderDependencyNode)enumeration.nextElement();
            commitOrderDependencyNode.markNotVisited();
            commitOrderDependencyNode.setPredecessor(null);
        }
        this.currentTime = 0;
        enumeration = this.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            commitOrderDependencyNode = (CommitOrderDependencyNode)enumeration.nextElement();
            if (!commitOrderDependencyNode.hasNotBeenVisited()) continue;
            commitOrderDependencyNode.visit();
        }
    }

    private static int doCompare(Object object, Object object2) {
        int n;
        int n2 = ((CommitOrderDependencyNode)object).getFinishingTime();
        if (n2 >= (n = ((CommitOrderDependencyNode)object2).getFinishingTime())) {
            return 1;
        }
        return -1;
    }

    public int getNextTime() {
        int n = this.currentTime++;
        return n;
    }

    public Vector getNodes() {
        return this.nodes;
    }

    public Vector getOrderedClasses() {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(this.getOrderedDescriptors().size());
        Enumeration enumeration = this.getOrderedDescriptors().elements();
        while (enumeration.hasMoreElements()) {
            ((Vector)nonSynchronizedVector).addElement(((ClassDescriptor)enumeration.nextElement()).getJavaClass());
        }
        return nonSynchronizedVector;
    }

    public Vector getOrderedDescriptors() {
        return this.orderedDescriptors;
    }

    public CommitOrderDependencyNode nodeFor(Class clazz) {
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            CommitOrderDependencyNode commitOrderDependencyNode = (CommitOrderDependencyNode)enumeration.nextElement();
            if (commitOrderDependencyNode.getDescriptor().getJavaClass() != clazz) continue;
            return commitOrderDependencyNode;
        }
        return null;
    }

    public CommitOrderDependencyNode nodeFor(ClassDescriptor classDescriptor) {
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            CommitOrderDependencyNode commitOrderDependencyNode = (CommitOrderDependencyNode)enumeration.nextElement();
            if (commitOrderDependencyNode.getDescriptor() != classDescriptor) continue;
            return commitOrderDependencyNode;
        }
        return null;
    }

    public void orderCommits() {
        this.depthFirstSearch();
        Object[] objectArray = new Object[this.nodes.size()];
        this.nodes.copyInto(objectArray);
        CommitOrderCalculator.quicksort(objectArray);
        Vector<ClassDescriptor> vector = new Vector<ClassDescriptor>(this.nodes.size());
        for (int i = 0; i < this.nodes.size(); ++i) {
            CommitOrderDependencyNode commitOrderDependencyNode = (CommitOrderDependencyNode)objectArray[i];
            vector.addElement(commitOrderDependencyNode.getDescriptor());
        }
        this.orderedDescriptors = vector;
    }

    private static void quicksort(Object[] objectArray) {
        CommitOrderCalculator.quicksort(objectArray, 0, objectArray.length - 1);
    }

    private static void quicksort(Object[] objectArray, int n, int n2) {
        if (n >= n2) {
            return;
        }
        CommitOrderCalculator.swap(objectArray, n, (n + n2) / 2);
        int n3 = n;
        for (int i = n + 1; i <= n2; ++i) {
            if (CommitOrderCalculator.doCompare(objectArray[i], objectArray[n]) >= 0) continue;
            CommitOrderCalculator.swap(objectArray, ++n3, i);
        }
        CommitOrderCalculator.swap(objectArray, n, n3);
        CommitOrderCalculator.quicksort(objectArray, n, n3 - 1);
        CommitOrderCalculator.quicksort(objectArray, n3 + 1, n2);
    }

    private static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }
}

