/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitOfWorkChangeSet
implements Serializable,
org.eclipse.persistence.sessions.changesets.UnitOfWorkChangeSet {
    protected transient Hashtable objectChanges;
    protected transient Hashtable newObjectChangeSets;
    protected transient Map cloneToObjectChangeSet;
    protected transient Map objectChangeSetToUOWClone;
    protected Map aggregateList;
    protected Map allChangeSets;
    protected Map deletedObjects;
    protected boolean hasChanges;
    protected boolean hasForcedChanges;
    private boolean isChangeSetFromOutsideUOW = false;
    protected transient AbstractSession session;

    public UnitOfWorkChangeSet() {
        this.setHasChanges(false);
    }

    public UnitOfWorkChangeSet(AbstractSession abstractSession) {
        this.session = abstractSession;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public UnitOfWorkChangeSet(byte[] byArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        this.allChangeSets = (Map)objectInputStream.readObject();
        this.deletedObjects = (Map)objectInputStream.readObject();
    }

    public void addDeletedObjects(Map map, AbstractSession abstractSession) {
        for (Object k : map.keySet()) {
            this.addDeletedObject(k, abstractSession);
        }
    }

    public void addDeletedObject(Object object, AbstractSession abstractSession) {
        ClassDescriptor classDescriptor = abstractSession.getDescriptor(object);
        if (!classDescriptor.isAggregateCollectionDescriptor()) {
            ObjectChangeSet objectChangeSet = classDescriptor.getObjectBuilder().createObjectChangeSet(object, this, false, abstractSession);
            objectChangeSet.setShouldBeDeleted(true);
            this.getDeletedObjects().put(objectChangeSet, objectChangeSet);
        }
    }

    public void addObjectChangeSet(ObjectChangeSet objectChangeSet, AbstractSession abstractSession, boolean bl) {
        if (objectChangeSet != null) {
            if (objectChangeSet.isNew() && bl) {
                this.addNewObjectChangeSet(objectChangeSet, abstractSession);
                this.getAllChangeSets().put(objectChangeSet, objectChangeSet);
            } else {
                boolean bl2 = objectChangeSet.hasChanges();
                if (bl2) {
                    this.setHasChanges(true);
                    this.hasForcedChanges = this.hasForcedChanges || objectChangeSet.hasForcedChanges();
                } else {
                    this.hasForcedChanges = true;
                }
                if (!objectChangeSet.isAggregate()) {
                    if (bl2) {
                        this.getAllChangeSets().put(objectChangeSet, objectChangeSet);
                    }
                    if (objectChangeSet.getCacheKey() != null) {
                        Hashtable<ObjectChangeSet, ObjectChangeSet> hashtable = (Hashtable<ObjectChangeSet, ObjectChangeSet>)this.getObjectChanges().get(objectChangeSet.getClassName());
                        if (hashtable == null) {
                            hashtable = new Hashtable<ObjectChangeSet, ObjectChangeSet>(2);
                            this.getObjectChanges().put(objectChangeSet.getClassName(), hashtable);
                            hashtable.put(objectChangeSet, objectChangeSet);
                        } else {
                            hashtable.put(objectChangeSet, objectChangeSet);
                        }
                    }
                }
            }
        }
    }

    protected void addNewObjectChangeSet(ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        IdentityHashMap<ObjectChangeSet, ObjectChangeSet> identityHashMap = (IdentityHashMap<ObjectChangeSet, ObjectChangeSet>)this.getNewObjectChangeSets().get(objectChangeSet.getClassType(abstractSession));
        if (identityHashMap == null) {
            identityHashMap = new IdentityHashMap<ObjectChangeSet, ObjectChangeSet>();
            this.getNewObjectChangeSets().put(objectChangeSet.getClassType(abstractSession), identityHashMap);
        }
        identityHashMap.put(objectChangeSet, objectChangeSet);
        this.hasChanges = true;
    }

    public ObjectChangeSet findObjectChangeSet(ObjectChangeSet objectChangeSet, UnitOfWorkChangeSet unitOfWorkChangeSet) {
        Hashtable hashtable = (Hashtable)this.getObjectChanges().get(objectChangeSet.getClassName());
        ObjectChangeSet objectChangeSet2 = null;
        if (hashtable != null) {
            objectChangeSet2 = (ObjectChangeSet)hashtable.get(objectChangeSet);
        }
        if (objectChangeSet2 == null) {
            objectChangeSet2 = (ObjectChangeSet)this.getObjectChangeSetForClone(objectChangeSet.getUnitOfWorkClone());
        }
        return objectChangeSet2;
    }

    public ObjectChangeSet findOrIntegrateObjectChangeSet(ObjectChangeSet objectChangeSet, UnitOfWorkChangeSet unitOfWorkChangeSet) {
        if (objectChangeSet == null) {
            return objectChangeSet;
        }
        ObjectChangeSet objectChangeSet2 = this.findObjectChangeSet(objectChangeSet, unitOfWorkChangeSet);
        if (objectChangeSet2 == null) {
            objectChangeSet2 = new ObjectChangeSet(objectChangeSet.getPrimaryKeys(), objectChangeSet.getClassType(), objectChangeSet.getUnitOfWorkClone(), this, objectChangeSet.isNew());
            this.addObjectChangeSetForIdentity(objectChangeSet2, objectChangeSet2.getUnitOfWorkClone());
        }
        return objectChangeSet2;
    }

    public void addObjectChangeSetForIdentity(ObjectChangeSet objectChangeSet, Object object) {
        if (objectChangeSet == null || object == null) {
            return;
        }
        if (objectChangeSet.isAggregate()) {
            this.getAggregateList().put(objectChangeSet, objectChangeSet);
        }
        this.getObjectChangeSetToUOWClone().put(objectChangeSet, object);
        this.getCloneToObjectChangeSet().put(object, objectChangeSet);
    }

    protected Map getAggregateList() {
        if (this.aggregateList == null) {
            this.aggregateList = new IdentityHashMap();
        }
        return this.aggregateList;
    }

    @Override
    public Map getAllChangeSets() {
        if (this.allChangeSets == null) {
            this.allChangeSets = new IdentityHashMap();
        }
        return this.allChangeSets;
    }

    public byte[] getByteArrayRepresentation(AbstractSession abstractSession) throws IOException {
        Serializable serializable2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        IdentityHashMap<Serializable, Serializable> identityHashMap = new IdentityHashMap<Serializable, Serializable>();
        for (Serializable serializable2 : this.getAllChangeSets().values()) {
            Serializable serializable3 = abstractSession.getDescriptor(((ObjectChangeSet)serializable2).getClassType(abstractSession));
            int n = ((ClassDescriptor)serializable3).getCacheSynchronizationType();
            if (((ObjectChangeSet)serializable2).isNew() && n != 3) continue;
            ((ObjectChangeSet)serializable2).setSynchronizationType(n);
            ((ObjectChangeSet)serializable2).prepareChangeRecordsForSynchronization(abstractSession);
            identityHashMap.put(serializable2, serializable2);
        }
        serializable2 = new IdentityHashMap();
        for (Serializable serializable3 : this.getDeletedObjects().keySet()) {
            ClassDescriptor classDescriptor = abstractSession.getDescriptor(((ObjectChangeSet)serializable3).getClassType(abstractSession));
            int n = classDescriptor.getCacheSynchronizationType();
            if (n == 4) continue;
            ((ObjectChangeSet)serializable3).setSynchronizationType(n);
            ((ObjectChangeSet)serializable3).prepareChangeRecordsForSynchronization(abstractSession);
            serializable2.put(serializable3, serializable3);
        }
        if (identityHashMap.isEmpty() && serializable2.isEmpty()) {
            return null;
        }
        objectOutputStream.writeObject(identityHashMap);
        objectOutputStream.writeObject(serializable2);
        return byteArrayOutputStream.toByteArray();
    }

    public Map getCloneToObjectChangeSet() {
        if (this.cloneToObjectChangeSet == null) {
            this.cloneToObjectChangeSet = new IdentityHashMap();
        }
        return this.cloneToObjectChangeSet;
    }

    @Override
    public Map getDeletedObjects() {
        if (this.deletedObjects == null) {
            this.deletedObjects = new IdentityHashMap();
        }
        return this.deletedObjects;
    }

    public Hashtable getObjectChanges() {
        if (this.objectChanges == null) {
            this.objectChanges = new Hashtable(2);
        }
        return this.objectChanges;
    }

    public Set<Class> findUpdatedObjectsClasses() {
        if (this.objectChanges == null || this.objectChanges.isEmpty()) {
            return null;
        }
        HashSet<Class> hashSet = new HashSet<Class>(this.getObjectChanges().size());
        block0: for (Hashtable hashtable : this.getObjectChanges().values()) {
            for (ObjectChangeSet objectChangeSet : hashtable.keySet()) {
                if (objectChangeSet.isNew()) continue;
                hashSet.add(objectChangeSet.getClassType());
                continue block0;
            }
        }
        return hashSet;
    }

    @Override
    public org.eclipse.persistence.sessions.changesets.ObjectChangeSet getObjectChangeSetForClone(Object object) {
        if (object == null || this.getCloneToObjectChangeSet() == null) {
            return null;
        }
        return (org.eclipse.persistence.sessions.changesets.ObjectChangeSet)this.getCloneToObjectChangeSet().get(object);
    }

    protected Map getObjectChangeSetToUOWClone() {
        if (this.objectChangeSetToUOWClone == null) {
            this.objectChangeSetToUOWClone = new IdentityHashMap();
        }
        return this.objectChangeSetToUOWClone;
    }

    @Override
    public Object getUOWCloneForObjectChangeSet(org.eclipse.persistence.sessions.changesets.ObjectChangeSet objectChangeSet) {
        if (objectChangeSet == null || this.getObjectChangeSetToUOWClone() == null) {
            return null;
        }
        return this.getObjectChangeSetToUOWClone().get(objectChangeSet);
    }

    @Override
    public boolean hasChanges() {
        return this.hasChanges || this.hasDeletedObjects();
    }

    public boolean hasDeletedObjects() {
        return this.deletedObjects != null && !this.deletedObjects.isEmpty();
    }

    public void setHasChanges(boolean bl) {
        this.hasChanges = bl;
    }

    public boolean hasForcedChanges() {
        return this.hasForcedChanges;
    }

    public ObjectChangeSet mergeObjectChanges(ObjectChangeSet objectChangeSet, UnitOfWorkChangeSet unitOfWorkChangeSet) {
        ObjectChangeSet objectChangeSet2 = this.findOrIntegrateObjectChangeSet(objectChangeSet, unitOfWorkChangeSet);
        if (objectChangeSet2 != null) {
            objectChangeSet2.mergeObjectChanges(objectChangeSet, this, unitOfWorkChangeSet);
        }
        return objectChangeSet2;
    }

    public void mergeUnitOfWorkChangeSet(UnitOfWorkChangeSet unitOfWorkChangeSet, AbstractSession abstractSession, boolean bl) {
        if (unitOfWorkChangeSet == null) {
            return;
        }
        for (Object object : unitOfWorkChangeSet.getObjectChanges().values()) {
            for (Object object2 : object.values()) {
                object2 = this.mergeObjectChanges((ObjectChangeSet)object2, unitOfWorkChangeSet);
                this.addObjectChangeSet((ObjectChangeSet)object2, abstractSession, !bl);
            }
        }
        if (unitOfWorkChangeSet.hasDeletedObjects()) {
            for (Object object : unitOfWorkChangeSet.getDeletedObjects().values()) {
                Object object2;
                object2 = this.findObjectChangeSet((ObjectChangeSet)object, unitOfWorkChangeSet);
                if (object2 == null) {
                    object2 = object;
                }
                this.getDeletedObjects().put(object2, object2);
            }
        }
    }

    public void putNewObjectInChangesList(ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        if (objectChangeSet.getCacheKey() == null) {
            objectChangeSet.setCacheKey(new CacheKey(abstractSession.getDescriptor(objectChangeSet.getUnitOfWorkClone().getClass()).getObjectBuilder().extractPrimaryKeyFromObject(objectChangeSet.getUnitOfWorkClone(), abstractSession, false)));
        }
        this.addObjectChangeSet(objectChangeSet, abstractSession, false);
        this.removeObjectChangeSetFromNewList(objectChangeSet, abstractSession);
    }

    public void removeObjectChangeSetFromNewList(ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        Map map = (Map)this.getNewObjectChangeSets().get(objectChangeSet.getClassType(abstractSession));
        if (map != null) {
            map.remove(objectChangeSet);
        }
    }

    public void removeObjectChangeSet(ObjectChangeSet objectChangeSet) {
        if (objectChangeSet == null) {
            return;
        }
        Object v = this.getObjectChangeSetToUOWClone().get(objectChangeSet);
        if (objectChangeSet.isAggregate()) {
            this.getAggregateList().remove(objectChangeSet);
        } else {
            Hashtable hashtable = (Hashtable)this.getObjectChanges().get(v.getClass().getName());
            if (hashtable != null) {
                hashtable.remove(objectChangeSet);
            }
        }
        this.getObjectChangeSetToUOWClone().remove(objectChangeSet);
        if (v != null) {
            this.getCloneToObjectChangeSet().remove(v);
        }
        this.getAllChangeSets().remove(objectChangeSet);
    }

    public void setIsChangeSetFromOutsideUOW(boolean bl) {
        this.isChangeSetFromOutsideUOW = bl;
    }

    public boolean isChangeSetFromOutsideUOW() {
        return this.isChangeSetFromOutsideUOW;
    }

    protected void setCloneToObjectChangeSet(Map map) {
        this.cloneToObjectChangeSet = map;
    }

    protected void setObjectChanges(Hashtable hashtable) {
        this.objectChanges = hashtable;
    }

    protected void setObjectChangeSetToUOWClone(Map map) {
        this.objectChangeSetToUOWClone = map;
    }

    public Hashtable getNewObjectChangeSets() {
        if (this.newObjectChangeSets == null) {
            this.newObjectChangeSets = new Hashtable();
        }
        return this.newObjectChangeSets;
    }
}

