/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.factories;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.eis.EISObjectPersistenceXMLProject;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.oxm.OXMObjectPersistenceRuntimeXMLProject;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.sessions.factories.DirectToXMLTypeMappingHelper;
import org.eclipse.persistence.internal.sessions.factories.NamespaceResolvableProject;
import org.eclipse.persistence.internal.sessions.factories.NamespaceResolverWithPrefixes;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventAdapter;

public class MissingDescriptorListener
extends SessionEventAdapter {
    protected static String XML_TYPE_CLASS = "org.eclipse.persistence.mappings.xdb.DirectToXMLTypeMapping";
    protected static String EIS_DESCRIPTOR_CLASS = "org.eclipse.persistence.eis.EISDescriptor";
    protected static String XML_INTERACTION_CLASS = "org.eclipse.persistence.eis.interactions.XMLInteraction";
    protected static String EIS_LOGIN_CLASS = "org.eclipse.persistence.eis.EISLogin";
    protected static String XML_BINARY_MAPPING_CLASS = "org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping";

    public void missingDescriptor(SessionEvent sessionEvent) {
        NamespaceResolverWithPrefixes namespaceResolverWithPrefixes;
        Serializable serializable;
        String string = ((Class)sessionEvent.getResult()).getName();
        DatabaseSession databaseSession = (DatabaseSession)sessionEvent.getSession();
        Project project = databaseSession.getProject();
        String string2 = "";
        if (project instanceof NamespaceResolvableProject) {
            serializable = (NamespaceResolvableProject)project;
            string2 = serializable.getPrimaryNamespaceXPath();
            namespaceResolverWithPrefixes = serializable.getNamespaceResolver();
        } else {
            namespaceResolverWithPrefixes = new NamespaceResolverWithPrefixes();
        }
        DirectToXMLTypeMappingHelper.getInstance().addXDBDescriptors(string, (DatabaseSessionImpl)databaseSession, namespaceResolverWithPrefixes);
        if (string.equals(EIS_DESCRIPTOR_CLASS) || string.equals(XML_INTERACTION_CLASS) || string.equals(EIS_LOGIN_CLASS)) {
            try {
                serializable = null;
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        serializable = (Class)AccessController.doPrivileged(new PrivilegedClassForName(XML_INTERACTION_CLASS));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        if (privilegedActionException.getCause() instanceof ClassNotFoundException) {
                            throw (ClassNotFoundException)privilegedActionException.getCause();
                        }
                        throw (RuntimeException)privilegedActionException.getCause();
                    }
                } else {
                    serializable = PrivilegedAccessHelper.getClassForName(XML_INTERACTION_CLASS);
                }
                databaseSession.getDescriptor(Call.class).getInheritancePolicy().addClassIndicator((Class)serializable, string2 + "xml-interaction");
            }
            catch (Exception exception) {
                throw ValidationException.fatalErrorOccurred(exception);
            }
            databaseSession.addDescriptors(new EISObjectPersistenceXMLProject(namespaceResolverWithPrefixes));
        }
        if (string.equals(XML_BINARY_MAPPING_CLASS)) {
            databaseSession.addDescriptors(new OXMObjectPersistenceRuntimeXMLProject(namespaceResolverWithPrefixes));
        }
    }
}

