/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.logging;

import java.io.Serializable;
import java.util.Date;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class SessionLogEntry
implements Serializable {
    protected Date date = new Date();
    protected transient AbstractSession session;
    protected transient Thread thread = Thread.currentThread();
    protected transient Accessor connection;
    protected String message;
    protected Throwable throwable;
    protected int level;
    protected String nameSpace;
    protected Object[] parameters;
    protected boolean shouldTranslate;

    public SessionLogEntry(AbstractSession abstractSession) {
        this.session = abstractSession;
        this.message = "";
        this.level = 5;
    }

    public SessionLogEntry(AbstractSession abstractSession, Throwable throwable) {
        this(abstractSession);
        this.throwable = throwable;
        this.level = 7;
    }

    public SessionLogEntry(AbstractSession abstractSession, String string) {
        this(abstractSession);
        this.message = string;
    }

    public SessionLogEntry(AbstractSession abstractSession, String string, Accessor accessor) {
        this(abstractSession, string);
        this.connection = accessor;
    }

    public SessionLogEntry(int n, AbstractSession abstractSession, String string, Object[] objectArray, Accessor accessor, boolean bl) {
        this(abstractSession, string, accessor);
        this.level = n;
        this.parameters = objectArray;
        this.shouldTranslate = bl;
    }

    public SessionLogEntry(int n, String string, AbstractSession abstractSession, String string2, Object[] objectArray, Accessor accessor, boolean bl) {
        this(n, abstractSession, string2, objectArray, accessor, bl);
        this.nameSpace = string;
    }

    public SessionLogEntry(AbstractSession abstractSession, int n, String string, Throwable throwable) {
        this(abstractSession, throwable);
        this.level = n;
        this.nameSpace = string;
    }

    public Accessor getConnection() {
        return this.connection;
    }

    public Date getDate() {
        return this.date;
    }

    public Throwable getException() {
        return this.throwable;
    }

    public String getMessage() {
        return this.message;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public Thread getThread() {
        return this.thread;
    }

    public int getLevel() {
        return this.level;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public boolean shouldTranslate() {
        return this.shouldTranslate;
    }

    public boolean hasException() {
        return this.getException() != null;
    }

    public void setConnection(Accessor accessor) {
        this.connection = accessor;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setException(Throwable throwable) {
        this.throwable = throwable;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setSession(AbstractSession abstractSession) {
        this.session = abstractSession;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public void setNameSpace(String string) {
        this.nameSpace = string;
    }

    public void setParameters(Object[] objectArray) {
        this.parameters = objectArray;
    }

    public void setShouldTranslate(boolean bl) {
        this.shouldTranslate = bl;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getMessage() + ")";
    }
}

