/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.descriptors.changetracking.MapChangeEvent;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.descriptors.changetracking.AttributeChangeListener;
import org.eclipse.persistence.internal.descriptors.changetracking.ObjectChangeListener;
import org.eclipse.persistence.internal.expressions.SQLDeleteStatement;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.indirection.TransparentIndirectionPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.DirectMapContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.DeferrableChangeRecord;
import org.eclipse.persistence.internal.sessions.DirectMapChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class DirectMapMapping
extends DirectCollectionMapping {
    protected DatabaseField directKeyField;
    protected Converter keyConverter;
    protected String keyConverterClassName;

    public DirectMapMapping() {
        this.selectionQuery = new DataReadQuery();
        this.containerPolicy = new DirectMapContainerPolicy(ClassConstants.Hashtable_Class);
    }

    public Converter getKeyConverter() {
        return this.keyConverter;
    }

    public void setKeyConverter(Converter converter) {
        this.keyConverter = converter;
    }

    public void setKeyConverterClassName(String string) {
        this.keyConverterClassName = string;
    }

    public void addToCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, UnitOfWorkImpl unitOfWorkImpl) throws DescriptorException {
        DirectMapChangeRecord directMapChangeRecord = (DirectMapChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (directMapChangeRecord == null) {
            directMapChangeRecord = new DirectMapChangeRecord(objectChangeSet);
            directMapChangeRecord.setAttribute(this.getAttributeName());
            directMapChangeRecord.setMapping(this);
            objectChangeSet.addChange(directMapChangeRecord);
        }
        directMapChangeRecord.addAdditionChange(object, object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object buildCloneForPartObject(Object object, Object object2, Object object3, UnitOfWorkImpl unitOfWorkImpl, boolean bl) {
        DirectMapContainerPolicy directMapContainerPolicy = (DirectMapContainerPolicy)this.getContainerPolicy();
        if (object == null) {
            return directMapContainerPolicy.containerInstance(1);
        }
        Object object4 = directMapContainerPolicy.containerInstance(directMapContainerPolicy.sizeFor(object));
        Object object5 = null;
        Object object6 = object;
        synchronized (object6) {
            object5 = directMapContainerPolicy.cloneFor(object);
        }
        object6 = directMapContainerPolicy.iteratorFor(object5);
        while (directMapContainerPolicy.hasNext(object6)) {
            Object object7 = directMapContainerPolicy.next(object6, unitOfWorkImpl);
            Object object8 = this.buildKeyClone(object7, unitOfWorkImpl, bl);
            Object object9 = this.buildElementClone(directMapContainerPolicy.valueFromKey(object7, object5), unitOfWorkImpl, bl);
            directMapContainerPolicy.addInto(object8, object9, object4, unitOfWorkImpl);
        }
        return object4;
    }

    protected Object buildKeyClone(Object object, UnitOfWorkImpl unitOfWorkImpl, boolean bl) {
        Object object2 = object;
        if (this.getKeyConverter() != null && this.getKeyConverter().isMutable()) {
            object2 = this.getKeyConverter().convertDataValueToObjectValue(this.getKeyConverter().convertObjectValueToDataValue(object2, unitOfWorkImpl), unitOfWorkImpl);
        }
        return object2;
    }

    public void calculateDeferredChanges(ChangeRecord changeRecord, AbstractSession abstractSession) {
        DirectMapChangeRecord directMapChangeRecord = (DirectMapChangeRecord)changeRecord;
        this.compareCollectionsForChange(directMapChangeRecord.getOriginalCollection(), directMapChangeRecord.getLatestCollection(), directMapChangeRecord, abstractSession);
    }

    public ChangeRecord compareForChange(Object object, Object object2, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        Object object3;
        Object object4;
        Object object5;
        Object object6 = null;
        Object object7 = null;
        DirectMapContainerPolicy directMapContainerPolicy = (DirectMapContainerPolicy)this.getContainerPolicy();
        object6 = this.getAttributeValueFromObject(object);
        if (object6 != null && !this.getIndirectionPolicy().objectIsInstantiated(object6)) {
            return null;
        }
        Map map = (Map)this.getRealCollectionAttributeValueFromObject(object, abstractSession);
        HashMap hashMap = new HashMap(10);
        HashMap hashMap2 = new HashMap(10);
        if (!objectChangeSet.isNew()) {
            object7 = this.getAttributeValueFromObject(object2);
            if (object7 == null && object6 == null) {
                return null;
            }
            object5 = (Map)this.getRealCollectionAttributeValueFromObject(object2, abstractSession);
            object4 = directMapContainerPolicy.iteratorFor(object5);
            while (directMapContainerPolicy.hasNext(object4)) {
                object3 = directMapContainerPolicy.next(object4, abstractSession);
                hashMap.put(object3, object5.get(object3));
            }
        }
        object5 = directMapContainerPolicy.iteratorFor(map);
        while (directMapContainerPolicy.hasNext(object5)) {
            object4 = directMapContainerPolicy.next(object5, abstractSession);
            object3 = map.get(object4);
            Object v = hashMap.get(object4);
            if (!hashMap.containsKey(object4)) {
                hashMap2.put(object4, map.get(object4));
                continue;
            }
            if (v == null && object3 != null || !v.equals(object3)) {
                hashMap2.put(object4, map.get(object4));
                continue;
            }
            hashMap.remove(object4);
        }
        if (hashMap2.isEmpty() && hashMap.isEmpty() && !objectChangeSet.isNew()) {
            return null;
        }
        object4 = new DirectMapChangeRecord(objectChangeSet);
        ((ChangeRecord)object4).setAttribute(this.getAttributeName());
        ((ChangeRecord)object4).setMapping(this);
        ((DirectMapChangeRecord)object4).addAdditionChange(hashMap2);
        ((DirectMapChangeRecord)object4).addRemoveChange(hashMap);
        return object4;
    }

    public boolean compareObjects(Object object, Object object2, AbstractSession abstractSession) {
        Object object3 = this.getRealCollectionAttributeValueFromObject(object, abstractSession);
        Object object4 = this.getRealCollectionAttributeValueFromObject(object2, abstractSession);
        DirectMapContainerPolicy directMapContainerPolicy = (DirectMapContainerPolicy)this.getContainerPolicy();
        return directMapContainerPolicy.compareContainers(object3, object4);
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        if (this.keyConverter != null) {
            if (this.keyConverter instanceof TypeConversionConverter) {
                ((TypeConversionConverter)this.keyConverter).convertClassNamesToClasses(classLoader);
            } else if (this.keyConverter instanceof ObjectTypeConverter) {
                ((ObjectTypeConverter)this.keyConverter).convertClassNamesToClasses(classLoader);
            }
        }
        if (this.keyConverterClassName != null) {
            Converter converter;
            block13: {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        Class clazz;
                        try {
                            clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.keyConverterClassName, true, classLoader));
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.keyConverterClassName, privilegedActionException.getException());
                        }
                        try {
                            converter = (Converter)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz));
                            break block13;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.keyConverterClassName, privilegedActionException.getException());
                        }
                    }
                    Class clazz = PrivilegedAccessHelper.getClassForName(this.keyConverterClassName, true, classLoader);
                    converter = (Converter)PrivilegedAccessHelper.newInstanceFromClass(clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.keyConverterClassName, classNotFoundException);
                }
                catch (Exception exception) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.keyConverterClassName, exception);
                }
            }
            this.setKeyConverter(converter);
        }
    }

    public DatabaseField getDirectKeyField() {
        return this.directKeyField;
    }

    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        super.initialize(abstractSession);
        this.initializeDirectKeyField(abstractSession);
        this.initializeContainerPolicy(abstractSession);
        if (this.getKeyConverter() != null) {
            this.getKeyConverter().initialize(this, abstractSession);
        }
        if (this.getValueConverter() != null) {
            this.getValueConverter().initialize(this, abstractSession);
        }
    }

    protected void initializeContainerPolicy(AbstractSession abstractSession) {
        ((DirectMapContainerPolicy)this.getContainerPolicy()).setKeyField(this.getDirectKeyField());
        ((DirectMapContainerPolicy)this.getContainerPolicy()).setValueField(this.getDirectField());
        ((DirectMapContainerPolicy)this.getContainerPolicy()).setKeyConverter(this.getKeyConverter());
        ((DirectMapContainerPolicy)this.getContainerPolicy()).setValueConverter(this.getValueConverter());
    }

    protected void initializeDeleteQuery(AbstractSession abstractSession) {
        if (!this.getDeleteQuery().hasSessionName()) {
            this.getDeleteQuery().setSessionName(abstractSession.getName());
        }
        if (this.hasCustomDeleteQuery()) {
            return;
        }
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        Expression expression = ((Expression)expressionBuilder).getField(this.getDirectKeyField()).equal(expressionBuilder.getParameter(this.getDirectKeyField()));
        Expression expression2 = null;
        SQLDeleteStatement sQLDeleteStatement = new SQLDeleteStatement();
        for (int i = 0; i < this.getReferenceKeyFields().size(); ++i) {
            DatabaseField databaseField = this.getReferenceKeyFields().get(i);
            DatabaseField databaseField2 = this.getSourceKeyFields().get(i);
            Expression expression3 = ((Expression)expressionBuilder).getField(databaseField);
            Expression expression4 = expressionBuilder.getParameter(databaseField2);
            Expression expression5 = expression3.equal(expression4);
            expression2 = expression5.and(expression2);
        }
        expression2 = expression2.and(expression);
        sQLDeleteStatement.setWhereClause(expression2);
        sQLDeleteStatement.setTable(this.getReferenceTable());
        this.getDeleteQuery().setSQLStatement(sQLDeleteStatement);
    }

    protected void initializeDirectKeyField(AbstractSession abstractSession) throws DescriptorException {
        if (this.getDirectKeyField() == null) {
            throw DescriptorException.directFieldNameNotSet(this);
        }
        this.getDirectKeyField().setTable(this.getReferenceTable());
        this.getDirectKeyField().setIndex(1);
    }

    protected void initializeInsertQuery(AbstractSession abstractSession) {
        super.initializeInsertQuery(abstractSession);
        this.getInsertQuery().getModifyRow().put(this.getDirectKeyField(), (Object)null);
    }

    protected void initializeSelectionStatement(AbstractSession abstractSession) {
        SQLSelectStatement sQLSelectStatement = new SQLSelectStatement();
        sQLSelectStatement.addTable(this.getReferenceTable());
        sQLSelectStatement.addField((DatabaseField)this.getDirectField().clone());
        sQLSelectStatement.addField((DatabaseField)this.getDirectKeyField().clone());
        sQLSelectStatement.setWhereClause(this.getSelectionCriteria());
        sQLSelectStatement.normalize(abstractSession, null);
        this.getSelectionQuery().setSQLStatement(sQLSelectStatement);
    }

    public boolean isDirectMapMapping() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeChangesIntoObject(Object object, ChangeRecord changeRecord, Object object2, MergeManager mergeManager) {
        DirectMapContainerPolicy directMapContainerPolicy = (DirectMapContainerPolicy)this.getContainerPolicy();
        Map map = null;
        AbstractSession abstractSession = mergeManager.getSession();
        HashMap hashMap = ((DirectMapChangeRecord)changeRecord).getAddObjects();
        HashMap hashMap2 = ((DirectMapChangeRecord)changeRecord).getRemoveObjects();
        map = this.isAttributeValueInstantiated(object) && !changeRecord.getOwner().isNew() ? (Map)this.getRealCollectionAttributeValueFromObject(object, abstractSession) : (Map)directMapContainerPolicy.containerInstance(hashMap.size());
        if (!this.isAttributeValueInstantiated(object)) {
            if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                return;
            }
            Object object3 = this.getRealCollectionAttributeValueFromObject(object2, abstractSession);
            Object object4 = directMapContainerPolicy.iteratorFor(object3);
            while (directMapContainerPolicy.hasNext(object4)) {
                Object object5 = directMapContainerPolicy.next(object4, abstractSession);
                directMapContainerPolicy.addInto(object5, ((Map)object3).get(object5), map, abstractSession);
            }
        } else {
            Object object6 = map;
            if (map instanceof IndirectCollection) {
                object6 = ((IndirectCollection)((Object)map)).getDelegateObject();
            }
            Map map2 = object6;
            synchronized (map2) {
                for (Object k : hashMap2.keySet()) {
                    directMapContainerPolicy.removeFrom(k, null, map, abstractSession);
                }
                for (Object k : hashMap.keySet()) {
                    Object v = hashMap.get(k);
                    if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                        if (directMapContainerPolicy.contains(v, map, abstractSession)) continue;
                        directMapContainerPolicy.addInto(k, v, map, abstractSession);
                        continue;
                    }
                    directMapContainerPolicy.addInto(k, v, map, abstractSession);
                }
            }
        }
        this.setRealAttributeValueInObject(object, map);
    }

    public void mergeIntoObject(Object object, boolean bl, Object object2, MergeManager mergeManager) {
        Object object3;
        Object object4;
        if (bl && mergeManager.shouldMergeWorkingCopyIntoOriginal() && !this.isAttributeValueInstantiated(object2)) {
            this.setAttributeValueInObject(object, this.getIndirectionPolicy().getOriginalIndirectionObject(this.getAttributeValueFromObject(object2), mergeManager.getSession()));
            return;
        }
        if (!this.shouldMergeCascadeReference(mergeManager)) {
            return;
        }
        if (mergeManager.shouldRefreshRemoteObject() && this.usesIndirection()) {
            this.mergeRemoteValueHolder(object, object2, mergeManager);
            return;
        }
        if (mergeManager.shouldMergeOriginalIntoWorkingCopy() ? !this.isAttributeValueInstantiated(object) : !this.isAttributeValueInstantiated(object2)) {
            return;
        }
        Map map = (Map)this.getRealCollectionAttributeValueFromObject(object2, mergeManager.getSession());
        DirectMapContainerPolicy directMapContainerPolicy = (DirectMapContainerPolicy)this.getContainerPolicy();
        Object object5 = this.getRealCollectionAttributeValueFromObject(object, mergeManager.getSession());
        Object object6 = directMapContainerPolicy.containerInstance(directMapContainerPolicy.sizeFor(map));
        boolean bl2 = false;
        if (this.getDescriptor().getObjectChangePolicy().isObjectChangeTrackingPolicy() && object instanceof ChangeTracker && ((ChangeTracker)object)._persistence_getPropertyChangeListener() != null) {
            bl2 = true;
            object4 = directMapContainerPolicy.iteratorFor(object5);
            while (directMapContainerPolicy.hasNext(object4)) {
                object3 = directMapContainerPolicy.next(object4, mergeManager.getSession());
                ((ObjectChangeListener)((ChangeTracker)object)._persistence_getPropertyChangeListener()).internalPropertyChange(new MapChangeEvent(object, this.getAttributeName(), object5, object3, ((Map)object5).get(object3), CollectionChangeEvent.REMOVE));
            }
            if (object6 instanceof ChangeTracker) {
                ((ChangeTracker)object6)._persistence_setPropertyChangeListener(((ChangeTracker)object)._persistence_getPropertyChangeListener());
            }
            if (object5 instanceof ChangeTracker) {
                ((ChangeTracker)object5)._persistence_setPropertyChangeListener(null);
            }
        }
        object5 = object6;
        object4 = directMapContainerPolicy.iteratorFor(map);
        while (directMapContainerPolicy.hasNext(object4)) {
            object3 = directMapContainerPolicy.next(object4, mergeManager.getSession());
            if (bl2) {
                ((ObjectChangeListener)((ChangeTracker)object)._persistence_getPropertyChangeListener()).internalPropertyChange(new MapChangeEvent(object, this.getAttributeName(), object5, object3, map.get(object3), CollectionChangeEvent.ADD));
            }
            directMapContainerPolicy.addInto(object3, map.get(object3), object5, mergeManager.getSession());
        }
        if (bl2 && this.getDescriptor().getObjectChangePolicy().isAttributeChangeTrackingPolicy() && (object4 = ((AttributeChangeListener)((ChangeTracker)object)._persistence_getPropertyChangeListener()).getObjectChangeSet()) != null && (object3 = (DirectMapChangeRecord)((ObjectChangeSet)object4).getChangesForAttributeNamed(this.getAttributeName())) != null) {
            if (!((DeferrableChangeRecord)object3).isDeferred()) {
                if (!((DirectMapChangeRecord)object3).hasChanges()) {
                    ((ObjectChangeSet)object4).removeChange(this.getAttributeName());
                }
            } else {
                ((DeferrableChangeRecord)object3).setLatestCollection(object5);
            }
        }
        this.setRealAttributeValueInObject(object, object5);
    }

    public void postInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException {
        Object[] objectArray;
        Object object;
        Object object2;
        DatabaseRecord databaseRecord = new DatabaseRecord();
        if (this.isReadOnly()) {
            return;
        }
        Object object3 = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        DirectMapContainerPolicy directMapContainerPolicy = (DirectMapContainerPolicy)this.getContainerPolicy();
        if (directMapContainerPolicy.isEmpty(object3)) {
            return;
        }
        this.prepareTranslationRow(writeObjectQuery.getTranslationRow(), writeObjectQuery.getObject(), writeObjectQuery.getSession());
        for (int i = 0; i < this.getReferenceKeyFields().size(); ++i) {
            object2 = this.getReferenceKeyFields().get(i);
            object = this.getSourceKeyFields().get(i);
            objectArray = writeObjectQuery.getTranslationRow().get((DatabaseField)object);
            databaseRecord.put((DatabaseField)object2, (Object)objectArray);
        }
        Object object4 = directMapContainerPolicy.iteratorFor(object3);
        while (directMapContainerPolicy.hasNext(object4)) {
            object2 = directMapContainerPolicy.next(object4, writeObjectQuery.getSession());
            object = directMapContainerPolicy.valueFromKey(object2, object3);
            if (this.getKeyConverter() != null) {
                object2 = this.getKeyConverter().convertObjectValueToDataValue(object2, writeObjectQuery.getSession());
            }
            if (this.getValueConverter() != null) {
                object = this.getValueConverter().convertObjectValueToDataValue(object, writeObjectQuery.getSession());
            }
            databaseRecord.put(this.getDirectKeyField(), object2);
            databaseRecord.put(this.getDirectField(), object);
            if (writeObjectQuery.shouldCascadeOnlyDependentParts()) {
                objectArray = new Object[]{"insert", this.getInsertQuery(), databaseRecord.clone()};
                writeObjectQuery.getSession().getCommitManager().addDataModificationEvent(this, objectArray);
                continue;
            }
            writeObjectQuery.getSession().executeQuery((DatabaseQuery)this.getInsertQuery(), databaseRecord);
        }
    }

    protected void postUpdateWithChangeSet(WriteObjectQuery writeObjectQuery) throws DatabaseException {
        Object[] objectArray;
        Cloneable cloneable;
        ObjectChangeSet objectChangeSet = writeObjectQuery.getObjectChangeSet();
        DirectMapChangeRecord directMapChangeRecord = (DirectMapChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (directMapChangeRecord == null) {
            return;
        }
        for (int i = 0; i < this.getReferenceKeyFields().size(); ++i) {
            Object object = this.getReferenceKeyFields().get(i);
            cloneable = this.getSourceKeyFields().get(i);
            objectArray = writeObjectQuery.getTranslationRow().get((DatabaseField)cloneable);
            writeObjectQuery.getTranslationRow().put((DatabaseField)object, (Object)objectArray);
        }
        for (Object object : directMapChangeRecord.getRemoveObjects().keySet()) {
            cloneable = (AbstractRecord)writeObjectQuery.getTranslationRow().clone();
            if (this.getKeyConverter() != null) {
                object = this.getKeyConverter().convertObjectValueToDataValue(object, writeObjectQuery.getSession());
            }
            ((AbstractRecord)cloneable).add(this.getDirectKeyField(), object);
            objectArray = new Object[]{"delete", this.getDeleteQuery(), cloneable};
            writeObjectQuery.getSession().getCommitManager().addDataModificationEvent(this, objectArray);
        }
        for (Object object : directMapChangeRecord.getAddObjects().keySet()) {
            cloneable = (AbstractRecord)writeObjectQuery.getTranslationRow().clone();
            objectArray = directMapChangeRecord.getAddObjects().get(object);
            if (this.getKeyConverter() != null) {
                object = this.getKeyConverter().convertObjectValueToDataValue(object, writeObjectQuery.getSession());
            }
            if (this.getValueConverter() != null) {
                objectArray = this.getValueConverter().convertObjectValueToDataValue(objectArray, writeObjectQuery.getSession());
            }
            ((AbstractRecord)cloneable).add(this.getDirectKeyField(), object);
            ((AbstractRecord)cloneable).add(this.getDirectField(), objectArray);
            Object[] objectArray2 = new Object[]{"insert", this.getInsertQuery(), cloneable};
            writeObjectQuery.getSession().getCommitManager().addDataModificationEvent(this, objectArray2);
        }
    }

    public void removeFromCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, UnitOfWorkImpl unitOfWorkImpl) throws DescriptorException {
        DirectMapChangeRecord directMapChangeRecord = (DirectMapChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (directMapChangeRecord == null) {
            directMapChangeRecord = new DirectMapChangeRecord(objectChangeSet);
            directMapChangeRecord.setAttribute(this.getAttributeName());
            directMapChangeRecord.setMapping(this);
            objectChangeSet.addChange(directMapChangeRecord);
        }
        directMapChangeRecord.addRemoveChange(object, object2);
    }

    public void setDirectKeyField(DatabaseField databaseField) {
        this.directKeyField = databaseField;
    }

    public void setDirectKeyFieldClassification(Class clazz) {
        this.getDirectKeyField().setType(clazz);
    }

    public void setDirectKeyFieldName(String string) {
        this.setDirectKeyField(new DatabaseField(string));
    }

    public void updateChangeRecord(Object object, Object object2, Object object3, ObjectChangeSet objectChangeSet, UnitOfWorkImpl unitOfWorkImpl) throws DescriptorException {
        DirectMapChangeRecord directMapChangeRecord = (DirectMapChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (directMapChangeRecord == null) {
            directMapChangeRecord = new DirectMapChangeRecord(objectChangeSet);
            directMapChangeRecord.setAttribute(this.getAttributeName());
            directMapChangeRecord.setMapping(this);
            objectChangeSet.addChange(directMapChangeRecord);
        }
        if (directMapChangeRecord.getOriginalCollection() == null) {
            directMapChangeRecord.setOriginalCollection(object3);
        }
        directMapChangeRecord.setLatestCollection(object2);
        directMapChangeRecord.setIsDeferred(true);
        objectChangeSet.deferredDetectionRequiredOn(this.getAttributeName());
    }

    public void useMapClass(Class clazz) {
        if (!Helper.classImplementsInterface(clazz, ClassConstants.Map_Class)) {
            throw DescriptorException.illegalContainerClass(clazz);
        }
        DirectMapContainerPolicy directMapContainerPolicy = new DirectMapContainerPolicy(clazz);
        this.setContainerPolicy(directMapContainerPolicy);
    }

    public void useTransparentMap() {
        this.setIndirectionPolicy(new TransparentIndirectionPolicy());
        this.useMapClass(ClassConstants.IndirectMap_Class);
    }

    public void setKeyClass(Class clazz) {
        TypeConversionConverter typeConversionConverter = new TypeConversionConverter(this);
        typeConversionConverter.setObjectClass(clazz);
        this.setKeyConverter(typeConversionConverter);
    }

    public Class getKeyClass() {
        if (!(this.getKeyConverter() instanceof TypeConversionConverter)) {
            return null;
        }
        return ((TypeConversionConverter)this.getKeyConverter()).getObjectClass();
    }

    public void setValueClass(Class clazz) {
        TypeConversionConverter typeConversionConverter = new TypeConversionConverter(this);
        typeConversionConverter.setObjectClass(clazz);
        this.setValueConverter(typeConversionConverter);
    }

    public void simpleAddToCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        DirectMapChangeRecord directMapChangeRecord = (DirectMapChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (directMapChangeRecord == null) {
            directMapChangeRecord = new DirectMapChangeRecord(objectChangeSet);
            directMapChangeRecord.setAttribute(this.getAttributeName());
            directMapChangeRecord.setMapping(this);
            directMapChangeRecord.getAddObjects().put(object, object2);
            objectChangeSet.addChange(directMapChangeRecord);
        } else if (directMapChangeRecord.getRemoveObjects().containsKey(object)) {
            directMapChangeRecord.getRemoveObjects().remove(object);
        } else {
            directMapChangeRecord.getAddObjects().put(object, object2);
        }
    }

    public void simpleRemoveFromCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        DirectMapChangeRecord directMapChangeRecord = (DirectMapChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (directMapChangeRecord == null) {
            directMapChangeRecord = new DirectMapChangeRecord(objectChangeSet);
            directMapChangeRecord.setAttribute(this.getAttributeName());
            directMapChangeRecord.setMapping(this);
            directMapChangeRecord.getRemoveObjects().put(object, object2);
            objectChangeSet.addChange(directMapChangeRecord);
        } else if (directMapChangeRecord.getAddObjects().containsKey(object)) {
            directMapChangeRecord.getAddObjects().remove(object);
        } else {
            directMapChangeRecord.getRemoveObjects().put(object, object2);
        }
    }

    public Class getValueClass() {
        if (!(this.getValueConverter() instanceof TypeConversionConverter)) {
            return null;
        }
        return ((TypeConversionConverter)this.getValueConverter()).getObjectClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object extractResultFromBatchQuery(DatabaseQuery databaseQuery, AbstractRecord abstractRecord, AbstractSession abstractSession, AbstractRecord abstractRecord2) {
        Hashtable hashtable = null;
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        DatabaseQuery databaseQuery2 = databaseQuery;
        synchronized (databaseQuery2) {
            hashtable = (Hashtable)databaseQuery.getProperty("batched objects");
            containerPolicy = this.getContainerPolicy();
            if (hashtable == null) {
                Vector vector = (Vector)abstractSession.executeQuery(databaseQuery, abstractRecord2);
                hashtable = new Hashtable();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    AbstractRecord abstractRecord3 = (AbstractRecord)enumeration.nextElement();
                    Object object = abstractRecord3.get(this.getDirectKeyField());
                    Object object2 = abstractRecord3.get(this.getDirectField());
                    CacheKey cacheKey = new CacheKey(this.extractKeyFromReferenceRow(abstractRecord3, abstractSession));
                    Object object3 = hashtable.get(cacheKey);
                    if (object3 == null) {
                        object3 = containerPolicy.containerInstance();
                        hashtable.put(cacheKey, object3);
                    }
                    if (this.getKeyConverter() != null) {
                        object = this.getKeyConverter().convertDataValueToObjectValue(object, databaseQuery.getSession());
                    }
                    if (this.getValueConverter() != null) {
                        object2 = this.getValueConverter().convertDataValueToObjectValue(object2, databaseQuery.getSession());
                    }
                    containerPolicy.addInto(object, object2, object3, databaseQuery.getSession());
                }
                databaseQuery.setProperty("batched objects", hashtable);
            }
        }
        databaseQuery2 = hashtable.get(new CacheKey(this.extractPrimaryKeyFromRow(abstractRecord, abstractSession)));
        if (databaseQuery2 == null) {
            return containerPolicy.containerInstance();
        }
        return databaseQuery2;
    }

    protected Object valueFromRowInternalWithJoin(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) throws DatabaseException {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object = containerPolicy.containerInstance();
        ObjectBuilder objectBuilder = this.getDescriptor().getObjectBuilder();
        Vector vector = objectBuilder.extractPrimaryKeyFromRow(abstractRecord, abstractSession);
        CacheKey cacheKey = new CacheKey(vector);
        List list = joinedAttributeManager.getDataResultsByPrimaryKey().get(cacheKey);
        HashSet<Object> hashSet = new HashSet<Object>();
        Converter converter = this.getKeyConverter();
        Converter converter2 = this.getValueConverter();
        for (int i = 0; i < list.size(); ++i) {
            AbstractRecord abstractRecord2;
            AbstractRecord abstractRecord3 = abstractRecord2 = (AbstractRecord)list.get(i);
            Object object2 = (abstractRecord3 = this.trimRowForJoin(abstractRecord3, joinedAttributeManager, abstractSession)).get(this.getDirectKeyField());
            if (object2 == null) {
                return this.getIndirectionPolicy().valueFromRow(object);
            }
            if (hashSet.contains(object2)) continue;
            hashSet.add(object2);
            if (converter != null) {
                object2 = converter.convertDataValueToObjectValue(object2, abstractSession);
            }
            Object object3 = abstractRecord3.get(this.getDirectField());
            if (converter2 != null) {
                object3 = converter2.convertDataValueToObjectValue(object3, abstractSession);
            }
            containerPolicy.addInto(object2, object3, object, abstractSession);
        }
        return this.getIndirectionPolicy().valueFromRow(object);
    }
}

