/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.ObjectReferenceChangeRecord;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.RelationalMapping;
import org.eclipse.persistence.mappings.TypedAssociation;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.mappings.querykeys.DirectQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReadQuery;

public class VariableOneToOneMapping
extends ObjectReferenceMapping
implements RelationalMapping {
    protected DatabaseField typeField;
    protected Map sourceToTargetQueryKeyNames;
    protected Map typeIndicatorTranslation;
    protected Map typeIndicatorNameTranslation;

    public VariableOneToOneMapping() {
        this.selectionQuery = new ReadObjectQuery();
        this.sourceToTargetQueryKeyNames = new HashMap(2);
        this.typeIndicatorTranslation = new HashMap(5);
        this.typeIndicatorNameTranslation = new HashMap(5);
        this.foreignKeyFields = NonSynchronizedVector.newInstance(1);
        this.isForeignKeyRelationship = false;
    }

    public boolean isRelationalMapping() {
        return true;
    }

    public void addClassIndicator(Class clazz, Object object) {
        if (object == null) {
            object = Helper.getNullWrapper();
        }
        this.getTypeIndicatorTranslation().put(clazz, object);
        this.getTypeIndicatorTranslation().put(object, clazz);
    }

    public void addClassNameIndicator(String string, Object object) {
        if (object == null) {
            object = Helper.getNullWrapper();
        }
        this.getTypeIndicatorNameTranslation().put(string, object);
    }

    public void addForeignQueryKeyName(DatabaseField databaseField, String string) {
        this.getSourceToTargetQueryKeyNames().put(databaseField, string);
        this.getForeignKeyFields().addElement(databaseField);
        this.setIsForeignKeyRelationship(true);
    }

    public void addForeignQueryKeyName(String string, String string2) {
        this.addForeignQueryKeyName(new DatabaseField(string), string2);
    }

    public void addTargetForeignQueryKeyName(String string, String string2) {
        DatabaseField databaseField = new DatabaseField(string2);
        this.getSourceToTargetQueryKeyNames().put(databaseField, string);
    }

    protected Object batchedValueFromRow(AbstractRecord abstractRecord, ReadAllQuery readAllQuery) {
        throw QueryException.batchReadingNotSupported(this, readAllQuery);
    }

    public Object clone() {
        VariableOneToOneMapping variableOneToOneMapping = (VariableOneToOneMapping)super.clone();
        HashMap<DatabaseField, DatabaseField> hashMap = new HashMap<DatabaseField, DatabaseField>(this.getSourceToTargetQueryKeyNames().size());
        HashMap hashMap2 = new HashMap(this.getSourceToTargetQueryKeyNames().size());
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(this.getForeignKeyFields().size());
        if (this.getTypeField() != null) {
            variableOneToOneMapping.setTypeField((DatabaseField)this.getTypeField().clone());
        }
        for (DatabaseField databaseField : this.getSourceToTargetQueryKeyNames().keySet()) {
            DatabaseField databaseField2 = (DatabaseField)databaseField.clone();
            hashMap.put(databaseField, databaseField2);
            hashMap2.put(databaseField2, this.getSourceToTargetQueryKeyNames().get(databaseField));
        }
        Enumeration<DatabaseField> enumeration = this.getForeignKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField;
            databaseField = (DatabaseField)enumeration.nextElement();
            ((Vector)nonSynchronizedVector).addElement(hashMap.get(databaseField));
        }
        variableOneToOneMapping.setSourceToTargetQueryKeyFields(hashMap2);
        variableOneToOneMapping.setForeignKeyFields(nonSynchronizedVector);
        variableOneToOneMapping.setTypeIndicatorTranslation(new HashMap(this.getTypeIndicatorTranslation()));
        return variableOneToOneMapping;
    }

    protected Vector collectFields() {
        DatabaseField databaseField = this.getTypeField();
        if (databaseField != null) {
            Vector vector = (Vector)this.getForeignKeyFields().clone();
            vector.addElement(databaseField);
            return vector;
        }
        return this.getForeignKeyFields();
    }

    protected boolean compareObjectsWithoutPrivateOwned(Object object, Object object2, AbstractSession abstractSession) {
        Object object3 = this.getRealAttributeValueFromObject(object, abstractSession);
        Object object4 = this.getRealAttributeValueFromObject(object2, abstractSession);
        if (object3 == null && object4 == null) {
            return true;
        }
        if (object3 == null || object4 == null) {
            return false;
        }
        if (object3.getClass() != object4.getClass()) {
            return false;
        }
        Iterator iterator = this.getSourceToTargetQueryKeyNames().values().iterator();
        ClassDescriptor classDescriptor = abstractSession.getDescriptor(object3.getClass());
        ClassDescriptor classDescriptor2 = abstractSession.getDescriptor(object4.getClass());
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            DatabaseField databaseField = classDescriptor.getObjectBuilder().getFieldForQueryKeyName(string);
            Object object5 = classDescriptor.getObjectBuilder().extractValueFromObjectForField(object3, databaseField, abstractSession);
            DatabaseField databaseField2 = classDescriptor2.getObjectBuilder().getFieldForQueryKeyName(string);
            Object object6 = classDescriptor2.getObjectBuilder().extractValueFromObjectForField(object4, databaseField2, abstractSession);
            if (object5 == null && object6 == null) continue;
            if (object5 == null || object6 == null) {
                return false;
            }
            if (object5.equals(object6)) continue;
            return false;
        }
        return true;
    }

    public Vector getClassIndicatorAssociations() {
        Vector<TypedAssociation> vector = new Vector<TypedAssociation>();
        Iterator iterator = this.getTypeIndicatorNameTranslation().keySet().iterator();
        Iterator iterator2 = this.getTypeIndicatorNameTranslation().values().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof Class) {
                object = ((Class)object).getName();
            }
            Object v = iterator2.next();
            vector.addElement(new TypedAssociation(object, v));
        }
        return vector;
    }

    public ClassDescriptor getDescriptorForTarget(Object object, AbstractSession abstractSession) {
        return abstractSession.getDescriptor(object);
    }

    public Class getFieldClassification(DatabaseField databaseField) {
        if (this.getTypeField() != null && databaseField.equals(this.getTypeField())) {
            return this.getTypeField().getType();
        }
        String string = (String)this.getSourceToTargetQueryKeyNames().get(databaseField);
        if (string == null) {
            return null;
        }
        Iterator iterator = this.getReferenceDescriptor().getInterfacePolicy().getChildDescriptors().iterator();
        if (iterator.hasNext()) {
            ClassDescriptor classDescriptor = (ClassDescriptor)iterator.next();
            DatabaseMapping databaseMapping = classDescriptor.getObjectBuilder().getMappingForAttributeName(string);
            if (databaseMapping != null && databaseMapping.isDirectToFieldMapping()) {
                return ((AbstractDirectMapping)databaseMapping).getAttributeClassification();
            }
            QueryKey queryKey = classDescriptor.getQueryKeyNamed(string);
            if (queryKey != null && queryKey.isDirectQueryKey()) {
                return classDescriptor.getObjectBuilder().getFieldClassification(((DirectQueryKey)queryKey).getField());
            }
        }
        return null;
    }

    public Vector getForeignKeyFieldNames() {
        Vector<String> vector = new Vector<String>(this.getForeignKeyFields().size());
        Enumeration<DatabaseField> enumeration = this.getForeignKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement().getQualifiedName());
        }
        return vector;
    }

    protected Object getImplementorForType(Object object, AbstractSession abstractSession) {
        if (object == null) {
            return this.getTypeIndicatorTranslation().get(Helper.getNullWrapper());
        }
        try {
            object = abstractSession.getDatasourcePlatform().convertObject(object, this.getTypeField().getType());
        }
        catch (ConversionException conversionException) {
            throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
        }
        return this.getTypeIndicatorTranslation().get(object);
    }

    public Vector getSourceToTargetQueryKeyFieldAssociations() {
        Vector<Association> vector = new Vector<Association>(this.getSourceToTargetQueryKeyNames().size());
        Iterator iterator = this.getSourceToTargetQueryKeyNames().keySet().iterator();
        Iterator iterator2 = this.getSourceToTargetQueryKeyNames().values().iterator();
        while (iterator.hasNext()) {
            String string = ((DatabaseField)iterator.next()).getQualifiedName();
            Object v = iterator2.next();
            vector.addElement(new Association(string, v));
        }
        return vector;
    }

    public Map getSourceToTargetQueryKeyNames() {
        return this.sourceToTargetQueryKeyNames;
    }

    public DatabaseField getTypeField() {
        return this.typeField;
    }

    public String getTypeFieldName() {
        if (this.getTypeField() == null) {
            return null;
        }
        return this.getTypeField().getQualifiedName();
    }

    protected Object getTypeForImplementor(Class clazz) {
        Object v = this.getTypeIndicatorTranslation().get(clazz);
        if (v == Helper.getNullWrapper()) {
            v = null;
        }
        return v;
    }

    public Map getTypeIndicatorTranslation() {
        if (this.typeIndicatorTranslation.isEmpty() && !this.typeIndicatorNameTranslation.isEmpty()) {
            Iterator iterator = this.typeIndicatorNameTranslation.keySet().iterator();
            Iterator iterator2 = this.typeIndicatorNameTranslation.values().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                Object v = iterator2.next();
                Class clazz = (Class)ConversionManager.getDefaultManager().convertObject(k, ClassConstants.CLASS);
                this.typeIndicatorTranslation.put(clazz, v);
                this.typeIndicatorTranslation.put(v, clazz);
            }
        }
        return this.typeIndicatorTranslation;
    }

    public Map getTypeIndicatorNameTranslation() {
        if (this.typeIndicatorNameTranslation.isEmpty() && !this.typeIndicatorTranslation.isEmpty()) {
            Iterator iterator = this.typeIndicatorTranslation.keySet().iterator();
            Iterator iterator2 = this.typeIndicatorTranslation.values().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                Object v = iterator2.next();
                if (!(k instanceof Class)) continue;
                String string = ((Class)k).getName();
                this.typeIndicatorNameTranslation.put(string, v);
            }
        }
        return this.typeIndicatorNameTranslation;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        Iterator iterator = this.getTypeIndicatorNameTranslation().entrySet().iterator();
        this.typeIndicatorTranslation = new HashMap();
        while (iterator.hasNext()) {
            Class clazz;
            Object v;
            block6: {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                v = entry.getValue();
                clazz = null;
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(string, true, classLoader));
                            break block6;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(string, privilegedActionException.getException());
                        }
                    }
                    clazz = PrivilegedAccessHelper.getClassForName(string, true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(string, classNotFoundException);
                }
            }
            this.addClassIndicator(clazz, v);
        }
    }

    public void initialize(AbstractSession abstractSession) {
        super.initialize(abstractSession);
        this.initializeForeignKeys(abstractSession);
        this.setFields(this.collectFields());
        if (this.getTypeField() != null) {
            this.setTypeField(this.getDescriptor().buildField(this.getTypeField()));
        }
        if (this.shouldInitializeSelectionCriteria()) {
            this.initializeSelectionCriteria(abstractSession);
        }
    }

    protected void initializeForeignKeys(AbstractSession abstractSession) {
        HashMap hashMap = new HashMap(this.getSourceToTargetQueryKeyNames().size());
        for (Map.Entry entry : this.getSourceToTargetQueryKeyNames().entrySet()) {
            DatabaseField databaseField = this.getDescriptor().buildField((DatabaseField)entry.getKey());
            hashMap.put(databaseField, entry.getValue());
        }
        this.sourceToTargetQueryKeyNames = hashMap;
    }

    public void initializeSelectionCriteria(AbstractSession abstractSession) {
        Expression expression = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        for (DatabaseField databaseField : this.getSourceToTargetQueryKeyNames().keySet()) {
            String string = (String)this.getSourceToTargetQueryKeyNames().get(databaseField);
            Expression expression2 = expressionBuilder.getParameter(databaseField).equal(expressionBuilder.get(string));
            if (expression == null) {
                expression = expression2;
                continue;
            }
            expression = expression2.and(expression);
        }
        this.setSelectionCriteria(expression);
    }

    public boolean isVariableOneToOneMapping() {
        return true;
    }

    protected boolean cacheKeysAreEqual(CacheKey cacheKey, CacheKey cacheKey2) {
        return cacheKey.equals(cacheKey2) && cacheKey2.getClass().equals(cacheKey.getClass());
    }

    protected Vector getPrimaryKeyForObject(Object object, AbstractSession abstractSession) {
        return abstractSession.keyFromObject(object);
    }

    public void preInitialize(AbstractSession abstractSession) throws DescriptorException {
        super.preInitialize(abstractSession);
        if (this.getTypeIndicatorTranslation().isEmpty()) {
            return;
        }
        Class<?> clazz = null;
        Iterator iterator = this.getTypeIndicatorTranslation().values().iterator();
        while (iterator.hasNext() && clazz == null) {
            Object v = iterator.next();
            if (v == Helper.getNullWrapper() || v instanceof Class) continue;
            clazz = v.getClass();
        }
        this.getTypeField().setType(clazz);
    }

    public void rehashFieldDependancies(AbstractSession abstractSession) {
        this.setSourceToTargetQueryKeyFields(Helper.rehashMap(this.getSourceToTargetQueryKeyNames()));
    }

    public void setClassIndicatorAssociations(Vector vector) {
        this.setTypeIndicatorNameTranslation(new HashMap(vector.size() + 1));
        this.setTypeIndicatorTranslation(new HashMap(vector.size() * 2 + 1));
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Association association = (Association)enumeration.nextElement();
            Object object = association.getKey();
            if (object instanceof Class) {
                this.addClassIndicator((Class)association.getKey(), association.getValue());
                continue;
            }
            this.addClassNameIndicator((String)association.getKey(), association.getValue());
        }
    }

    public void setForeignKeyFieldNames(Vector vector) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Vector)nonSynchronizedVector).addElement(new DatabaseField((String)enumeration.nextElement()));
        }
        this.setForeignKeyFields(nonSynchronizedVector);
        if (!((Vector)nonSynchronizedVector).isEmpty()) {
            this.setIsForeignKeyRelationship(true);
        }
    }

    public void setForeignQueryKeyName(String string, String string2) {
        this.addForeignQueryKeyName(string, string2);
    }

    public void setSourceToTargetQueryKeyFieldAssociations(Vector vector) {
        this.setSourceToTargetQueryKeyFields(new HashMap(vector.size() + 1));
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Association association = (Association)enumeration.nextElement();
            DatabaseField databaseField = new DatabaseField((String)association.getKey());
            String string = (String)association.getValue();
            this.getSourceToTargetQueryKeyNames().put(databaseField, string);
        }
    }

    protected void setSourceToTargetQueryKeyFields(Map map) {
        this.sourceToTargetQueryKeyNames = map;
    }

    public void setTypeField(DatabaseField databaseField) {
        this.typeField = databaseField;
    }

    public void setTypeFieldName(String string) {
        this.setTypeField(new DatabaseField(string));
    }

    protected void setTypeIndicatorTranslation(Map map) {
        this.typeIndicatorTranslation = map;
    }

    protected void setTypeIndicatorNameTranslation(Map map) {
        this.typeIndicatorNameTranslation = map;
    }

    public Object valueFromObject(Object object, DatabaseField databaseField, AbstractSession abstractSession) {
        AbstractRecord abstractRecord = this.getIndirectionPolicy().extractReferenceRow(this.getAttributeValueFromObject(object));
        if (abstractRecord != null) {
            Object object2 = abstractRecord.get(databaseField);
            try {
                object2 = abstractSession.getDatasourcePlatform().convertObject(object2, this.getFieldClassification(databaseField));
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
            }
            return object2;
        }
        Object object3 = this.getRealAttributeValueFromObject(object, abstractSession);
        String string = (String)this.getSourceToTargetQueryKeyNames().get(databaseField);
        ClassDescriptor classDescriptor = abstractSession.getDescriptor(object3.getClass());
        DatabaseField databaseField2 = classDescriptor.getObjectBuilder().getTargetFieldForQueryKeyName(string);
        if (databaseField2 == null) {
            return null;
        }
        return classDescriptor.getObjectBuilder().extractValueFromObjectForField(object3, databaseField2, abstractSession);
    }

    public Object valueFromRow(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) throws DatabaseException {
        Cloneable cloneable;
        Object object = this.getFields().elements();
        while (object.hasMoreElements()) {
            cloneable = object.nextElement();
            if (abstractRecord.get((DatabaseField)cloneable) != null) continue;
            return this.getIndirectionPolicy().nullValueFromRow();
        }
        if (this.getTypeField() != null) {
            if (objectBuildingQuery.isReadAllQuery() && (((ReadAllQuery)objectBuildingQuery).isAttributeBatchRead(this.getDescriptor(), this.getAttributeName()) || this.shouldUseBatchReading())) {
                return this.batchedValueFromRow(abstractRecord, (ReadAllQuery)objectBuildingQuery);
            }
            if (abstractRecord.get(this.getTypeField()) == null) {
                return this.getIndirectionPolicy().nullValueFromRow();
            }
            object = (Class)this.getImplementorForType(abstractRecord.get(this.getTypeField()), abstractSession);
            cloneable = (ReadObjectQuery)this.getSelectionQuery().clone();
            ((ObjectLevelReadQuery)cloneable).setReferenceClass((Class)object);
            ((ObjectLevelReadQuery)cloneable).setSelectionCriteria(this.getSelectionCriteria());
            ((ObjectLevelReadQuery)cloneable).setDescriptor(null);
            if (objectBuildingQuery.isObjectLevelReadQuery() && (objectBuildingQuery.shouldCascadeAllParts() || objectBuildingQuery.shouldCascadePrivateParts() && this.isPrivateOwned() || objectBuildingQuery.shouldCascadeByMapping() && this.cascadeRefresh)) {
                ((ObjectLevelReadQuery)cloneable).setShouldRefreshIdentityMapResult(objectBuildingQuery.shouldRefreshIdentityMapResult());
                ((DatabaseQuery)cloneable).setCascadePolicy(objectBuildingQuery.getCascadePolicy());
                ((DatabaseQuery)cloneable).setShouldMaintainCache(objectBuildingQuery.shouldMaintainCache());
                if (((ObjectLevelReadQuery)objectBuildingQuery).hasAsOfClause()) {
                    ((ObjectLevelReadQuery)cloneable).setAsOfClause(((ObjectLevelReadQuery)objectBuildingQuery).getAsOfClause());
                }
                ((ReadQuery)cloneable).setQueryId(objectBuildingQuery.getQueryId());
            }
            return this.getIndirectionPolicy().valueFromQuery((ReadQuery)cloneable, abstractRecord, abstractSession);
        }
        return super.valueFromRow(abstractRecord, joinedAttributeManager, objectBuildingQuery, abstractSession);
    }

    protected void writeFromNullObjectIntoRow(AbstractRecord abstractRecord) {
        if (this.isReadOnly()) {
            return;
        }
        if (this.isForeignKeyRelationship()) {
            Enumeration<DatabaseField> enumeration = this.getForeignKeyFields().elements();
            while (enumeration.hasMoreElements()) {
                abstractRecord.put(enumeration.nextElement(), (Object)null);
            }
        }
        if (this.getTypeField() != null) {
            abstractRecord.put(this.getTypeField(), (Object)null);
        }
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isReadOnly()) {
            return;
        }
        Object object2 = this.getRealAttributeValueFromObject(object, abstractSession);
        if (object2 == null) {
            this.writeFromNullObjectIntoRow(abstractRecord);
        } else {
            if (this.isForeignKeyRelationship()) {
                Enumeration<DatabaseField> enumeration = this.getForeignKeyFields().elements();
                ClassDescriptor classDescriptor = abstractSession.getDescriptor(object2.getClass());
                while (enumeration.hasMoreElements()) {
                    DatabaseField databaseField = enumeration.nextElement();
                    String string = (String)this.getSourceToTargetQueryKeyNames().get(databaseField);
                    DatabaseField databaseField2 = classDescriptor.getObjectBuilder().getFieldForQueryKeyName(string);
                    if (databaseField2 == null) {
                        throw DescriptorException.variableOneToOneMappingIsNotDefinedProperly(this, classDescriptor, string);
                    }
                    Object object3 = classDescriptor.getObjectBuilder().extractValueFromObjectForField(object2, databaseField2, abstractSession);
                    abstractRecord.put(databaseField, object3);
                }
            }
            if (this.getTypeField() != null) {
                abstractRecord.put(this.getTypeField(), this.getTypeForImplementor(object2.getClass()));
            }
        }
    }

    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isReadOnly()) {
            return;
        }
        ObjectChangeSet objectChangeSet = (ObjectChangeSet)((ObjectReferenceChangeRecord)changeRecord).getNewValue();
        if (objectChangeSet == null) {
            this.writeFromNullObjectIntoRow(abstractRecord);
        } else {
            Object object = objectChangeSet.getUnitOfWorkClone();
            if (this.isForeignKeyRelationship()) {
                Enumeration<DatabaseField> enumeration = this.getForeignKeyFields().elements();
                ClassDescriptor classDescriptor = abstractSession.getDescriptor(object.getClass());
                while (enumeration.hasMoreElements()) {
                    DatabaseField databaseField = enumeration.nextElement();
                    String string = (String)this.getSourceToTargetQueryKeyNames().get(databaseField);
                    DatabaseField databaseField2 = classDescriptor.getObjectBuilder().getFieldForQueryKeyName(string);
                    if (databaseField2 == null) {
                        throw DescriptorException.variableOneToOneMappingIsNotDefinedProperly(this, classDescriptor, string);
                    }
                    Object object2 = classDescriptor.getObjectBuilder().extractValueFromObjectForField(object, databaseField2, abstractSession);
                    abstractRecord.put(databaseField, object2);
                }
            }
            if (this.getTypeField() != null) {
                abstractRecord.put(this.getTypeField(), this.getTypeForImplementor(object.getClass()));
            }
        }
    }

    public void writeFromObjectIntoRowForShallowInsert(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        this.writeFromNullObjectIntoRow(abstractRecord);
    }

    public void writeFromObjectIntoRowForShallowInsertWithChangeRecord(ChangeRecord changeRecord, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        this.writeFromNullObjectIntoRow(abstractRecord);
    }

    public void writeFromObjectIntoRowForWhereClause(ObjectLevelModifyQuery objectLevelModifyQuery, AbstractRecord abstractRecord) {
        if (this.isReadOnly()) {
            return;
        }
        Object object = objectLevelModifyQuery.isDeleteObjectQuery() ? objectLevelModifyQuery.getObject() : objectLevelModifyQuery.getBackupClone();
        Object object2 = this.getRealAttributeValueFromObject(object, objectLevelModifyQuery.getSession());
        if (object2 == null) {
            this.writeFromNullObjectIntoRow(abstractRecord);
        } else {
            if (this.isForeignKeyRelationship()) {
                Enumeration<DatabaseField> enumeration = this.getForeignKeyFields().elements();
                ClassDescriptor classDescriptor = objectLevelModifyQuery.getSession().getDescriptor(object2.getClass());
                while (enumeration.hasMoreElements()) {
                    DatabaseField databaseField = enumeration.nextElement();
                    String string = (String)this.getSourceToTargetQueryKeyNames().get(databaseField);
                    DatabaseField databaseField2 = classDescriptor.getObjectBuilder().getFieldForQueryKeyName(string);
                    if (databaseField2 == null) {
                        throw DescriptorException.variableOneToOneMappingIsNotDefinedProperly(this, classDescriptor, string);
                    }
                    Object object3 = classDescriptor.getObjectBuilder().extractValueFromObjectForField(object2, databaseField2, objectLevelModifyQuery.getSession());
                    abstractRecord.put(databaseField, object3);
                }
            }
            if (this.getTypeField() != null) {
                abstractRecord.put(this.getTypeField(), this.getTypeForImplementor(object2.getClass()));
            }
        }
    }

    public void writeInsertFieldsIntoRow(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        this.writeFromNullObjectIntoRow(abstractRecord);
    }
}

