/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.foundation;

import java.math.BigDecimal;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.DirectToFieldChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;
import org.eclipse.persistence.mappings.foundation.MapKeyMapping;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryByExamplePolicy;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.ObjectCopyingPolicy;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.remote.DistributedSession;
import org.eclipse.persistence.sessions.remote.RemoteSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDirectMapping
extends DatabaseMapping
implements MapKeyMapping {
    protected DatabaseField field;
    protected transient Class attributeClassification;
    protected transient String attributeClassificationName;
    protected transient Class attributeObjectClassification;
    protected Converter converter;
    protected String converterClassName;
    protected transient Object nullValue;
    protected Boolean isMutable;

    public AbstractDirectMapping() {
        this.setWeight(WEIGHT_1);
    }

    public Converter getConverter() {
        return this.converter;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public void setConverterClassName(String string) {
        this.converterClassName = string;
    }

    public boolean isMutable() {
        if (this.isMutable == null) {
            return false;
        }
        return this.isMutable;
    }

    public void setIsMutable(boolean bl) {
        this.isMutable = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public void buildBackupClone(Object object, Object object2, UnitOfWorkImpl unitOfWorkImpl) {
        this.buildClone(object, object2, unitOfWorkImpl);
    }

    @Override
    public void buildClone(Object object, Object object2, UnitOfWorkImpl unitOfWorkImpl) {
        this.buildCloneValue(object, object2, unitOfWorkImpl);
    }

    public void buildCloneValue(Object object, Object object2, AbstractSession abstractSession) {
        Object object3 = this.getAttributeValueFromObject(object);
        if (this.isMutable() && object3 != null) {
            if (object3 instanceof byte[]) {
                int n = ((byte[])object3).length;
                byte[] byArray = new byte[n];
                System.arraycopy(object3, 0, byArray, 0, n);
                object3 = byArray;
            } else {
                object3 = object3 instanceof Date ? ((Date)object3).clone() : (object3 instanceof Calendar ? ((Calendar)object3).clone() : this.getAttributeValue(this.getFieldValue(object3, abstractSession), abstractSession));
            }
        }
        this.setAttributeValueInObject(object2, object3);
    }

    @Override
    public void buildCopy(Object object, Object object2, ObjectCopyingPolicy objectCopyingPolicy) {
        this.buildCloneValue(object2, object, objectCopyingPolicy.getSession());
    }

    @Override
    public Expression buildExpression(Object object, QueryByExamplePolicy queryByExamplePolicy, Expression expression, Map map, AbstractSession abstractSession) {
        String string = this.getAttributeName();
        Object object2 = this.getAttributeValueFromObject(object);
        if (!queryByExamplePolicy.shouldIncludeInQuery(object.getClass(), string, object2)) {
            return null;
        }
        Expression expression2 = expression.get(string);
        expression2 = object2 == null ? queryByExamplePolicy.completeExpressionForNull(expression2) : queryByExamplePolicy.completeExpression(expression2, object2, object2.getClass());
        return expression2;
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
    }

    @Override
    public Object clone() {
        AbstractDirectMapping abstractDirectMapping = (AbstractDirectMapping)super.clone();
        abstractDirectMapping.setField((DatabaseField)this.getField().clone());
        return abstractDirectMapping;
    }

    @Override
    protected Vector<DatabaseField> collectFields() {
        Vector<DatabaseField> vector = new Vector<DatabaseField>(1);
        vector.addElement(this.getField());
        return vector;
    }

    @Override
    public ChangeRecord compareForChange(Object object, Object object2, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        if (objectChangeSet.isNew() || !this.compareObjects(object2, object, abstractSession)) {
            return this.buildChangeRecord(object, objectChangeSet, abstractSession);
        }
        return null;
    }

    @Override
    public ChangeRecord buildChangeRecord(Object object, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        return this.internalBuildChangeRecord(this.getAttributeValueFromObject(object), objectChangeSet);
    }

    public ChangeRecord internalBuildChangeRecord(Object object, ObjectChangeSet objectChangeSet) {
        DirectToFieldChangeRecord directToFieldChangeRecord = new DirectToFieldChangeRecord(objectChangeSet);
        directToFieldChangeRecord.setAttribute(this.getAttributeName());
        directToFieldChangeRecord.setMapping(this);
        directToFieldChangeRecord.setNewValue(object);
        return directToFieldChangeRecord;
    }

    @Override
    public boolean compareObjects(Object object, Object object2, AbstractSession abstractSession) {
        Object object3 = this.getAttributeValueFromObject(object);
        Object object4 = this.getAttributeValueFromObject(object2);
        return this.compareObjectValues(object3, object4, abstractSession);
    }

    protected boolean compareObjectValues(Object object, Object object2, AbstractSession abstractSession) {
        if (object == object2) {
            return true;
        }
        if ((object = this.getFieldValue(object, abstractSession)) == (object2 = this.getFieldValue(object2, abstractSession))) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        boolean bl = object.equals(object2);
        if (bl) {
            return true;
        }
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = object2.getClass();
        if (clazz == ClassConstants.APBYTE && clazz2 == ClassConstants.APBYTE) {
            return Helper.compareByteArrays((byte[])object, (byte[])object2);
        }
        if (clazz == ClassConstants.APCHAR && clazz2 == ClassConstants.APCHAR) {
            return Helper.compareCharArrays((char[])object, (char[])object2);
        }
        if (clazz.isArray() && clazz2.isArray()) {
            return Helper.compareArrays((Object[])object, (Object[])object2);
        }
        if (object instanceof BigDecimal && object2 instanceof BigDecimal) {
            return Helper.compareBigDecimals((BigDecimal)object, (BigDecimal)object2);
        }
        return false;
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        if (this.converter != null) {
            if (this.converter instanceof TypeConversionConverter) {
                ((TypeConversionConverter)this.converter).convertClassNamesToClasses(classLoader);
            } else if (this.converter instanceof ObjectTypeConverter) {
                ((ObjectTypeConverter)this.converter).convertClassNamesToClasses(classLoader);
            }
        }
        if (this.converterClassName != null) {
            Converter converter;
            block13: {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        Class clazz;
                        try {
                            clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.converterClassName, true, classLoader));
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.converterClassName, privilegedActionException.getException());
                        }
                        try {
                            converter = (Converter)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz));
                            break block13;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.converterClassName, privilegedActionException.getException());
                        }
                    }
                    Class clazz = PrivilegedAccessHelper.getClassForName(this.converterClassName, true, classLoader);
                    converter = (Converter)PrivilegedAccessHelper.newInstanceFromClass(clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.converterClassName, classNotFoundException);
                }
                catch (Exception exception) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.converterClassName, exception);
                }
            }
            this.setConverter(converter);
        }
    }

    @Override
    public void fixObjectReferences(Object object, Map map, Map map2, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
    }

    @Override
    public Class getAttributeClassification() {
        return this.attributeClassification;
    }

    public String getAttributeClassificationName() {
        if (this.attributeClassificationName == null && this.attributeClassification != null) {
            this.attributeClassificationName = this.attributeClassification.getName();
        }
        return this.attributeClassificationName;
    }

    public Object getAttributeValue(Object object, Session session) {
        Object object2 = object;
        if (object == null && this.nullValue != null) {
            return this.nullValue;
        }
        if (this.converter != null) {
            object2 = this.converter.convertDataValueToObjectValue(object2, session);
        } else if (object2 == null || object2.getClass() != this.attributeObjectClassification) {
            try {
                object2 = session.getDatasourcePlatform().convertObject(object2, this.attributeClassification);
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
            }
        }
        if (object2 == null) {
            object2 = this.nullValue;
        }
        return object2;
    }

    @Override
    public DatabaseField getField() {
        return this.field;
    }

    @Override
    public boolean isAbstractDirectMapping() {
        return true;
    }

    @Override
    public Class getFieldClassification(DatabaseField databaseField) {
        if (databaseField.type != null) {
            return databaseField.type;
        }
        if (this.converter != null) {
            return null;
        }
        return Helper.getObjectClass(this.attributeClassification);
    }

    public Class getFieldClassification() {
        if (this.getField() == null) {
            return null;
        }
        return this.getField().getType();
    }

    public void setFieldClassification(Class clazz) {
        this.getField().setType(clazz);
    }

    public void setFieldType(int n) {
        this.getField().setSqlType(n);
    }

    public String getFieldName() {
        return this.getField().getQualifiedName();
    }

    public Object getFieldValue(Object object, AbstractSession abstractSession) {
        Object object2 = object;
        if (this.nullValue != null && this.nullValue.equals(object2)) {
            return null;
        }
        if (this.converter != null) {
            object2 = this.converter.convertObjectValueToDataValue(object2, abstractSession);
        }
        Class clazz = this.getFieldClassification(this.field);
        if (object2 == null || clazz != object2.getClass()) {
            try {
                object2 = abstractSession.getPlatform(this.descriptor.getJavaClass()).convertObject(object2, clazz);
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.descriptor, conversionException);
            }
        }
        return object2;
    }

    public Object getNullValue() {
        return this.nullValue;
    }

    @Override
    public Integer getWeight() {
        return this.weight;
    }

    @Override
    public void remoteInitialization(DistributedSession distributedSession) {
        if (!this.isRemotelyInitialized()) {
            super.remoteInitialization(distributedSession);
            if (this.attributeClassification == null) {
                this.attributeClassification = this.getAttributeAccessor().getAttributeClass();
            }
            this.attributeObjectClassification = Helper.getObjectClass(this.attributeClassification);
        }
    }

    @Override
    public void preInitialize(AbstractSession abstractSession) throws DescriptorException {
        super.preInitialize(abstractSession);
        if (this.attributeClassification == null) {
            this.attributeClassification = this.getAttributeAccessor().getAttributeClass();
        }
        this.attributeObjectClassification = Helper.getObjectClass(this.attributeClassification);
        if (this.isMutable == null) {
            if (this.getConverter() != null) {
                this.setIsMutable(this.getConverter().isMutable());
            } else {
                this.setIsMutable(false);
            }
            if (ClassConstants.UTILDATE.isAssignableFrom(this.getAttributeClassification()) || ClassConstants.CALENDAR.isAssignableFrom(this.getAttributeClassification())) {
                this.setIsMutable(abstractSession.getProject().getDefaultTemporalMutable());
            }
        }
    }

    public boolean hasConverter() {
        return this.getConverter() != null;
    }

    @Override
    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        super.initialize(abstractSession);
        if (this.getField() == null) {
            abstractSession.getIntegrityChecker().handleError(DescriptorException.fieldNameNotSetInMapping(this));
        }
        this.setField(this.getDescriptor().buildField(this.getField()));
        this.setFields(this.collectFields());
        if (this.getConverter() != null) {
            this.getConverter().initialize(this, abstractSession);
        }
        if (this.getField().getSqlType() == 2002) {
            this.getDescriptor().setIsNativeConnectionRequired(true);
        }
    }

    @Override
    public boolean isDirectToFieldMapping() {
        return true;
    }

    @Override
    public void iterate(DescriptorIterator descriptorIterator) {
        if (descriptorIterator.shouldIterateOnPrimitives()) {
            descriptorIterator.iteratePrimitiveForMapping(this.getAttributeValueFromObject(descriptorIterator.getVisitedParent()), this);
        }
    }

    @Override
    public void mergeChangesIntoObject(Object object, ChangeRecord changeRecord, Object object2, MergeManager mergeManager) {
        this.setAttributeValueInObject(object, ((DirectToFieldChangeRecord)changeRecord).getNewValue());
    }

    @Override
    public void mergeIntoObject(Object object, boolean bl, Object object2, MergeManager mergeManager) {
        if ((mergeManager.shouldMergeCloneIntoWorkingCopy() || mergeManager.shouldMergeCloneWithReferencesIntoWorkingCopy()) && this.descriptor.getObjectChangePolicy().isObjectChangeTrackingPolicy()) {
            Object object3;
            Object object4 = this.getAttributeValueFromObject(object2);
            if (!this.compareObjectValues(object4, object3 = this.getAttributeValueFromObject(object), mergeManager.getSession())) {
                this.setAttributeValueInObject(object, object4);
                this.descriptor.getObjectChangePolicy().raiseInternalPropertyChangeEvent(object, this.getAttributeName(), object3, object4);
            }
        } else {
            this.setAttributeValueInObject(object, this.getAttributeValueFromObject(object2));
        }
    }

    public void setAttributeClassification(Class clazz) {
        this.attributeClassification = clazz;
    }

    public void setAttributeClassificationName(String string) {
        this.attributeClassificationName = string;
    }

    public void setField(DatabaseField databaseField) {
        this.field = databaseField;
    }

    public void setNullValue(Object object) {
        this.nullValue = object;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[" + this.getAttributeName() + "-->" + this.getField() + "]";
    }

    @Override
    public void updateChangeRecord(Object object, Object object2, Object object3, ObjectChangeSet objectChangeSet, UnitOfWorkImpl unitOfWorkImpl) {
        DirectToFieldChangeRecord directToFieldChangeRecord = (DirectToFieldChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (directToFieldChangeRecord == null) {
            objectChangeSet.addChange(this.internalBuildChangeRecord(object2, objectChangeSet));
        } else {
            directToFieldChangeRecord.setNewValue(object2);
        }
    }

    @Override
    public boolean isChangeTrackingSupported(Project project) {
        return !this.isMutable();
    }

    @Override
    public boolean isCloningRequired() {
        return this.isMutable() || this.getDescriptor().getCopyPolicy().buildsNewInstance();
    }

    @Override
    public void validateBeforeInitialization(AbstractSession abstractSession) throws DescriptorException {
        if (this.getFieldName() == null || this.getFieldName().length() == 0) {
            abstractSession.getIntegrityChecker().handleError(DescriptorException.noFieldNameForMapping(this));
        }
    }

    @Override
    public Object valueFromObject(Object object, DatabaseField databaseField, AbstractSession abstractSession) throws DescriptorException {
        return this.getFieldValue(this.getAttributeValueFromObject(object), abstractSession);
    }

    @Override
    public void buildCloneFromRow(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, Object object, ObjectBuildingQuery objectBuildingQuery, UnitOfWorkImpl unitOfWorkImpl, AbstractSession abstractSession) {
        Object object2 = this.valueFromRow(abstractRecord, joinedAttributeManager, objectBuildingQuery, abstractSession);
        this.setAttributeValueInObject(object, object2);
    }

    @Override
    public void buildShallowOriginalFromRow(AbstractRecord abstractRecord, Object object, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) {
        this.readFromRowIntoObject(abstractRecord, null, object, objectBuildingQuery, abstractSession);
    }

    @Override
    public Object valueFromRow(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) {
        Object object = abstractRecord.get(this.field);
        Object object2 = this.getAttributeValue(object, abstractSession);
        return object2;
    }

    public Object valueFromResultSet(ResultSet resultSet, ObjectLevelReadQuery objectLevelReadQuery, AbstractSession abstractSession, DatabaseAccessor databaseAccessor, ResultSetMetaData resultSetMetaData, int n, DatabasePlatform databasePlatform) throws DatabaseException {
        return databaseAccessor.getObject(resultSet, this.field, resultSetMetaData, n, databasePlatform, true, abstractSession);
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isReadOnly) {
            return;
        }
        Object object2 = this.getAttributeValueFromObject(object);
        Object object3 = this.getFieldValue(object2, abstractSession);
        this.writeValueIntoRow(abstractRecord, this.field, object3);
    }

    protected abstract void writeValueIntoRow(AbstractRecord var1, DatabaseField var2, Object var3);

    @Override
    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isReadOnly) {
            return;
        }
        if (this.isPrimaryKeyMapping && !changeRecord.getOwner().isNew()) {
            throw ValidationException.primaryKeyUpdateDisallowed(changeRecord.getOwner().getClassName(), changeRecord.getAttribute());
        }
        Object object = ((DirectToFieldChangeRecord)changeRecord).getNewValue();
        Object object2 = this.getFieldValue(object, abstractSession);
        abstractRecord.add(this.field, object2);
    }

    @Override
    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery writeObjectQuery, AbstractRecord abstractRecord) {
        if (writeObjectQuery.getSession().isUnitOfWork() && this.compareObjects(writeObjectQuery.getBackupClone(), writeObjectQuery.getObject(), writeObjectQuery.getSession())) {
            return;
        }
        super.writeFromObjectIntoRowForUpdate(writeObjectQuery, abstractRecord);
    }

    @Override
    public void writeInsertFieldsIntoRow(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isReadOnly()) {
            return;
        }
        abstractRecord.add(this.getField(), null);
    }
}

