/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.transformers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetMethodParameterTypes;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.mappings.transformers.FieldTransformer;
import org.eclipse.persistence.sessions.Session;

public class MethodBasedFieldTransformer
implements FieldTransformer {
    protected transient Method fieldTransformationMethod;
    protected String methodName;
    protected AbstractTransformationMapping mapping;

    public MethodBasedFieldTransformer(String string) {
        this.methodName = string;
    }

    public void initialize(AbstractTransformationMapping abstractTransformationMapping) {
        this.mapping = abstractTransformationMapping;
        try {
            this.fieldTransformationMethod = Helper.getDeclaredMethod(abstractTransformationMapping.getDescriptor().getJavaClass(), this.methodName, new Class[0]);
        }
        catch (Exception exception) {
            try {
                Class[] classArray = new Class[]{ClassConstants.PublicInterfaceSession_Class};
                this.fieldTransformationMethod = Helper.getDeclaredMethod(abstractTransformationMapping.getDescriptor().getJavaClass(), this.methodName, classArray);
            }
            catch (Exception exception2) {
                try {
                    Class[] classArray = new Class[]{ClassConstants.SessionsSession_Class};
                    this.fieldTransformationMethod = Helper.getDeclaredMethod(abstractTransformationMapping.getDescriptor().getJavaClass(), this.methodName, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw DescriptorException.noSuchMethodWhileConvertingToMethod(this.methodName, abstractTransformationMapping, noSuchMethodException);
                }
                catch (SecurityException securityException) {
                    throw DescriptorException.securityWhileConvertingToMethod(this.methodName, abstractTransformationMapping, securityException);
                }
            }
        }
    }

    public Object buildFieldValue(Object object, String string, Session session) {
        Class[] classArray = null;
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                classArray = (Class[])AccessController.doPrivileged(new PrivilegedGetMethodParameterTypes(this.fieldTransformationMethod));
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (RuntimeException)privilegedActionException.getCause();
            }
        } else {
            classArray = PrivilegedAccessHelper.getMethodParameterTypes(this.fieldTransformationMethod);
        }
        Object[] objectArray = new Object[classArray.length];
        if (objectArray.length == 1) {
            objectArray[0] = session;
        }
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedMethodInvoker(this.fieldTransformationMethod, object, objectArray));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (privilegedActionException.getCause() instanceof IllegalAccessException) {
                        throw (IllegalAccessException)privilegedActionException.getCause();
                    }
                    if (privilegedActionException.getCause() instanceof InvocationTargetException) {
                        throw (InvocationTargetException)privilegedActionException.getCause();
                    }
                    throw (RuntimeException)privilegedActionException.getCause();
                }
            }
            return PrivilegedAccessHelper.invokeMethod(this.fieldTransformationMethod, object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DescriptorException.illegalAccessWhileInvokingFieldToMethod(this.fieldTransformationMethod.getName(), this.mapping, illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DescriptorException.illegalArgumentWhileInvokingFieldToMethod(this.fieldTransformationMethod.getName(), this.mapping, illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DescriptorException.targetInvocationWhileInvokingFieldToMethod(this.fieldTransformationMethod.getName(), this.mapping, invocationTargetException);
        }
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String string) {
        this.methodName = string;
    }
}

