/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.helper.InvalidObject;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.CursoredStreamPolicy;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;
import org.eclipse.persistence.queries.ValueReadQuery;

public class DataReadQuery
extends ReadQuery {
    protected ContainerPolicy containerPolicy;
    protected int resultType;
    public static final int MAP = 0;
    public static final int ARRAY = 1;
    public static final int VALUE = 2;
    public static final int ATTRIBUTE = 3;
    public static final int AUTO = 4;

    public DataReadQuery() {
        this.shouldMaintainCache = false;
        this.resultType = 0;
        this.setContainerPolicy(ContainerPolicy.buildDefaultPolicy());
    }

    public DataReadQuery(String string) {
        this();
        this.setSQLString(string);
    }

    public DataReadQuery(Call call) {
        this();
        this.setCall(call);
    }

    public void cacheResult(Object object) {
        this.setTemporaryCachedQueryResults(object);
    }

    public Object clone() {
        DataReadQuery dataReadQuery = (DataReadQuery)super.clone();
        dataReadQuery.setContainerPolicy(this.getContainerPolicy().clone(dataReadQuery));
        return dataReadQuery;
    }

    public Object execute(AbstractSession abstractSession, AbstractRecord abstractRecord) throws DatabaseException {
        if (this.shouldCacheQueryResults()) {
            if (this.getContainerPolicy().overridesRead()) {
                throw QueryException.cannotCacheCursorResultsOnQuery(this);
            }
            if (this.isPrepared()) {
                Object object = this.getQueryResults(abstractSession, abstractRecord, true);
                if (object == InvalidObject.instance) {
                    return null;
                }
                if (object != null) {
                    return object;
                }
            }
        }
        return super.execute(abstractSession, abstractRecord);
    }

    public Object executeDatabaseQuery() throws DatabaseException {
        if (this.getContainerPolicy().overridesRead()) {
            return this.getContainerPolicy().execute();
        }
        return this.executeNonCursor();
    }

    public Converter getValueConverter() {
        return null;
    }

    public Object buildObject(AbstractRecord abstractRecord) {
        if (this.resultType == 4) {
            Vector vector = abstractRecord.getValues();
            if (vector.size() == 1) {
                return abstractRecord.getValues().get(0);
            }
            return abstractRecord.getValues().toArray();
        }
        if (this.resultType == 1) {
            return abstractRecord.getValues().toArray();
        }
        if (this.resultType == 3) {
            Object object = abstractRecord.get(abstractRecord.getFields().get(0));
            if (this.getValueConverter() != null) {
                object = this.getValueConverter().convertDataValueToObjectValue(object, this.session);
            }
            return object;
        }
        return abstractRecord;
    }

    protected Object executeNonCursor() throws DatabaseException {
        Object object;
        block2: {
            Vector vector;
            block3: {
                block1: {
                    vector = this.getQueryMechanism().executeSelect();
                    object = null;
                    if (this.resultType != 0) break block1;
                    object = this.getContainerPolicy().buildContainerFromVector(vector, this.session);
                    break block2;
                }
                if (this.resultType != 2) break block3;
                if (vector.isEmpty()) break block2;
                AbstractRecord abstractRecord = (AbstractRecord)vector.get(0);
                object = abstractRecord.get(abstractRecord.getFields().get(0));
                if (this.getValueConverter() == null) break block2;
                object = this.getValueConverter().convertDataValueToObjectValue(object, this.session);
                break block2;
            }
            int n = vector.size();
            ContainerPolicy containerPolicy = this.getContainerPolicy();
            object = containerPolicy.containerInstance(n);
            for (int i = 0; i < n; ++i) {
                Object object2 = this.buildObject((AbstractRecord)vector.get(i));
                containerPolicy.addInto(object2, object, this.session);
            }
        }
        this.cacheResult(object);
        return object;
    }

    public ContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    public boolean isDataReadQuery() {
        return true;
    }

    protected void prepare() {
        super.prepare();
        this.getContainerPolicy().prepare(this, this.getSession());
        if (this.getContainerPolicy().overridesRead()) {
            return;
        }
        this.getQueryMechanism().prepareExecuteSelect();
    }

    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        this.getContainerPolicy().prepareForExecution();
    }

    public Object remoteExecute() {
        if (this.getContainerPolicy().overridesRead()) {
            return this.getContainerPolicy().remoteExecute();
        }
        return super.remoteExecute();
    }

    public void setContainerPolicy(ContainerPolicy containerPolicy) {
        if (containerPolicy == null) {
            return;
        }
        this.containerPolicy = containerPolicy;
    }

    public void useCollectionClass(Class clazz) {
        this.setContainerPolicy(ContainerPolicy.buildPolicyFor(clazz));
    }

    public void useCursoredStream() {
        this.useCursoredStream(10, 5);
    }

    public int getResultType() {
        return this.resultType;
    }

    public void setResultType(int n) {
        this.resultType = n;
    }

    public void setResultType(String string) {
        if ("Map".equals(string)) {
            this.resultType = 0;
        } else if ("Array".equals(string)) {
            this.resultType = 1;
        } else if ("Value".equals(string)) {
            this.resultType = 2;
        } else if ("Attribute".equals(string)) {
            this.resultType = 3;
        }
    }

    public void useCursoredStream(int n, int n2) {
        this.setContainerPolicy(new CursoredStreamPolicy(this, n, n2));
    }

    public void useCursoredStream(int n, int n2, ValueReadQuery valueReadQuery) {
        this.setContainerPolicy(new CursoredStreamPolicy(this, n, n2, valueReadQuery));
    }

    public void useScrollableCursor() {
        this.useScrollableCursor(10);
    }

    public void useScrollableCursor(int n) {
        this.setContainerPolicy(new ScrollableCursorPolicy(this, n));
    }

    public void useScrollableCursor(ScrollableCursorPolicy scrollableCursorPolicy) {
        scrollableCursorPolicy.setQuery(this);
        this.setContainerPolicy(scrollableCursorPolicy);
    }
}

