/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.QueryStringCall;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;

public class SQLCall
extends DatabaseCall
implements QueryStringCall {
    protected boolean hasCustomSQLArguments = false;

    public SQLCall() {
    }

    public SQLCall(String string) {
        this();
        this.setSQLString(string);
    }

    protected void afterTranslateCustomQuery(Vector vector, Vector vector2) {
        for (int i = 0; i < this.getParameters().size(); ++i) {
            DatabaseField databaseField;
            Integer n = (Integer)this.getParameterTypes().elementAt(i);
            Object e = this.getParameters().elementAt(i);
            if (n == MODIFY || n == OUT || n == OUT_CURSOR || n == IN && e instanceof DatabaseField) {
                databaseField = this.afterTranslateCustomQueryUpdateParameter((DatabaseField)e, i, n, vector, vector2);
                if (databaseField == null) continue;
                this.getParameters().setElementAt(databaseField, i);
                continue;
            }
            if (n == INOUT) {
                databaseField = this.afterTranslateCustomQueryUpdateParameter((DatabaseField)((Object[])e)[1], i, n, vector, vector2);
                if (databaseField == null) continue;
                if (((Object[])e)[0] instanceof DatabaseField) {
                    if (((Object[])e)[0] != ((Object[])e)[1]) {
                        DatabaseField databaseField2 = (DatabaseField)databaseField.clone();
                        databaseField2.setName(((DatabaseField)((Object[])e)[0]).getName());
                        ((Object[])e)[0] = databaseField2;
                    } else {
                        ((Object[])e)[0] = databaseField;
                    }
                }
                ((Object[])e)[1] = databaseField;
                continue;
            }
            if (n != IN || !(e instanceof DatabaseField) || (databaseField = this.afterTranslateCustomQueryUpdateParameter((DatabaseField)e, i, n, vector, vector2)) == null) continue;
            this.getParameters().setElementAt(databaseField, i);
        }
    }

    protected DatabaseField afterTranslateCustomQueryUpdateParameter(DatabaseField databaseField, int n, Integer n2, Vector vector, Vector vector2) {
        for (int i = 0; i < vector.size(); ++i) {
            DatabaseField databaseField2 = (DatabaseField)vector.elementAt(i);
            if (!databaseField.equals(databaseField2)) continue;
            Integer n3 = (Integer)vector2.elementAt(i);
            if (n3 == null) {
                return databaseField2;
            }
            if (n3 != OUT_CURSOR) break;
            if (n2 == OUT) {
                this.getParameterTypes().setElementAt(OUT_CURSOR, n);
                return databaseField2;
            }
            throw ValidationException.cannotSetCursorForParameterTypeOtherThanOut(databaseField.getName(), this.toString());
        }
        return null;
    }

    public boolean hasCustomSQLArguments() {
        return this.hasCustomSQLArguments;
    }

    public boolean isSQLCall() {
        return true;
    }

    public boolean isQueryStringCall() {
        return true;
    }

    protected void prepareInternal(AbstractSession abstractSession) {
        if (this.hasCustomSQLArguments()) {
            Vector vector = null;
            Vector vector2 = null;
            if (this.getParameters().size() > 0) {
                vector = this.getParameters();
                this.setParameters(NonSynchronizedVector.newInstance());
                vector2 = this.getParameterTypes();
                this.setParameterTypes(NonSynchronizedVector.newInstance());
            }
            this.translateCustomQuery();
            if (vector != null) {
                this.afterTranslateCustomQuery(vector, vector2);
            }
        }
        super.prepareInternal(abstractSession);
    }

    public void setHasCustomSQLArguments(boolean bl) {
        this.hasCustomSQLArguments = bl;
    }

    public void setCustomSQLArgumentType(String string, Class clazz) {
        DatabaseField databaseField = new DatabaseField(string);
        databaseField.setType(clazz);
        this.getParameters().add(databaseField);
        this.getParameterTypes().add(null);
    }

    public void setCustomSQLArgumentType(String string, int n) {
        DatabaseField databaseField = new DatabaseField(string);
        databaseField.setSqlType(n);
        this.getParameters().add(databaseField);
        this.getParameterTypes().add(null);
    }

    public void setCustomSQLArgumentType(String string, int n, String string2) {
        ObjectRelationalDatabaseField objectRelationalDatabaseField = new ObjectRelationalDatabaseField(string);
        objectRelationalDatabaseField.setSqlType(n);
        objectRelationalDatabaseField.setSqlTypeName(string2);
        this.getParameters().add(objectRelationalDatabaseField);
        this.getParameterTypes().add(null);
    }

    public void setCustomSQLArgumentType(String string, int n, String string2, Class clazz) {
        ObjectRelationalDatabaseField objectRelationalDatabaseField = new ObjectRelationalDatabaseField(string);
        objectRelationalDatabaseField.setSqlType(n);
        objectRelationalDatabaseField.setSqlTypeName(string2);
        objectRelationalDatabaseField.setType(clazz);
        this.getParameters().add(objectRelationalDatabaseField);
        this.getParameterTypes().add(null);
    }

    public void setCustomSQLArgumentType(String string, int n, String string2, DatabaseField databaseField) {
        ObjectRelationalDatabaseField objectRelationalDatabaseField = new ObjectRelationalDatabaseField(string);
        objectRelationalDatabaseField.setSqlType(n);
        objectRelationalDatabaseField.setSqlTypeName(string2);
        objectRelationalDatabaseField.setNestedTypeField(databaseField);
        this.getParameters().add(objectRelationalDatabaseField);
        this.getParameterTypes().add(null);
    }

    public void setCustomSQLArgumentType(String string, int n, String string2, Class clazz, DatabaseField databaseField) {
        ObjectRelationalDatabaseField objectRelationalDatabaseField = new ObjectRelationalDatabaseField(string);
        objectRelationalDatabaseField.setSqlType(n);
        objectRelationalDatabaseField.setSqlTypeName(string2);
        objectRelationalDatabaseField.setType(clazz);
        objectRelationalDatabaseField.setNestedTypeField(databaseField);
        this.getParameters().add(objectRelationalDatabaseField);
        this.getParameterTypes().add(null);
    }

    public void setSQLString(String string) {
        this.setSQLStringInternal(string);
    }

    public void appendTranslationParameter(Writer writer, ParameterExpression parameterExpression, DatabasePlatform databasePlatform) throws IOException {
        try {
            databasePlatform.writeParameterMarker(writer, parameterExpression);
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        this.getParameters().addElement(parameterExpression);
        this.getParameterTypes().addElement(TRANSLATION);
    }

    public void useCustomSQLCursorOutputAsResultSet(String string) {
        DatabaseField databaseField = new DatabaseField(string);
        this.getParameters().add(databaseField);
        this.getParameterTypes().add(OUT_CURSOR);
        this.setIsCursorOutputProcedure(true);
    }
}

