/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.queries.CursorPolicy;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.eclipse.persistence.sessions.remote.DistributedSession;

public class ScrollableCursorPolicy
extends CursorPolicy {
    protected int resultSetType;
    protected int resultSetConcurrency;
    public static final int FETCH_FORWARD = 1000;
    public static final int FETCH_REVERSE = 1001;
    public static final int FETCH_UNKNOWN = 1002;
    public static final int TYPE_FORWARD_ONLY = 1003;
    public static final int TYPE_SCROLL_INSENSITIVE = 1004;
    public static final int TYPE_SCROLL_SENSITIVE = 1005;
    public static final int CONCUR_READ_ONLY = 1007;
    public static final int CONCUR_UPDATABLE = 1008;

    public ScrollableCursorPolicy() {
        this.setResultSetType(1004);
        this.setResultSetConcurrency(1008);
    }

    public ScrollableCursorPolicy(ReadQuery readQuery, int n) {
        super(readQuery, n);
        this.setResultSetType(1004);
        this.setResultSetConcurrency(1008);
    }

    public Object execute() {
        DatabaseCall databaseCall = this.getQuery().getQueryMechanism().cursorSelectAllRows();
        ScrollableCursor scrollableCursor = new ScrollableCursor(databaseCall, this);
        return scrollableCursor;
    }

    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public int getResultSetType() {
        return this.resultSetType;
    }

    public boolean isScrollableCursorPolicy() {
        return true;
    }

    public Object remoteExecute() {
        return ((DistributedSession)this.getQuery().getSession()).cursorSelectObjects(this);
    }

    public void setResultSetConcurrency(int n) {
        this.resultSetConcurrency = n;
    }

    public void setResultSetType(int n) {
        this.resultSetType = n;
    }
}

