/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions;

import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.Connector;
import org.eclipse.persistence.sessions.Session;

public class DefaultConnector
implements Connector {
    protected String driverClassName;
    protected String driverURLHeader;
    protected String databaseURL;
    protected Class driverClass;
    protected Driver driver;
    private boolean connectDirectly = false;

    public DefaultConnector() {
    }

    public DefaultConnector(String string, String string2, String string3) {
        this.initialize(string, string2, string3);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            throw new InternalError("Clone failed");
        }
    }

    public Connection connect(Properties properties, Session session) throws DatabaseException {
        SQLException sQLException;
        block12: {
            String string;
            if (this.driverClassName != null && this.driverClass == null) {
                this.loadDriverClass(session);
            }
            if ((string = this.getConnectionString()) == null || string.trim().equals("")) {
                throw DatabaseException.unableToAcquireConnectionFromDriverException(this.driverClassName, null, string);
            }
            sQLException = null;
            if (this.shouldUseDriverManager(properties, session)) {
                try {
                    return DriverManager.getConnection(this.getConnectionString(), properties);
                }
                catch (SQLException sQLException2) {
                    sQLException = sQLException2;
                    if (session == null) break block12;
                    ((AbstractSession)session).logThrowable(2, "connection", sQLException2);
                }
            }
        }
        if (this.driverClass == null) {
            throw DatabaseException.sqlException(sQLException, (AbstractSession)session, true);
        }
        boolean bl = false;
        try {
            Connection connection = this.directConnect(properties);
            if (null == connection) {
                if (null != sQLException) {
                    bl = true;
                    throw DatabaseException.unableToAcquireConnectionFromDriverException(sQLException, this.getDriverClassName(), properties.getProperty("user"), this.getDatabaseURL());
                }
                throw DatabaseException.unableToAcquireConnectionFromDriverException(this.getDriverClassName(), this.driverClass.getCanonicalName(), this.getDatabaseURL());
            }
            if (null != sQLException) {
                this.connectDirectly = true;
            }
            return connection;
        }
        catch (DatabaseException databaseException) {
            if (sQLException != null && !bl) {
                throw DatabaseException.sqlException(sQLException, (AbstractSession)session, true);
            }
            throw databaseException;
        }
    }

    public boolean shouldUseDriverManager(Properties properties, Session session) {
        return !this.connectDirectly && (session == null || session.getServerPlatform().shouldUseDriverManager());
    }

    protected Connection directConnect(Properties properties) throws DatabaseException {
        if (this.driver == null) {
            this.instantiateDriver();
        }
        try {
            return this.driver.connect(this.getConnectionString(), properties);
        }
        catch (SQLException sQLException) {
            this.clearDriverClassAndDriver();
            throw DatabaseException.sqlException(sQLException, true);
        }
    }

    public String getConnectionString() {
        if (this.getDriverURLHeader() == null) {
            return this.getDatabaseURL();
        }
        if (this.getDatabaseURL() == null) {
            return this.getDriverURLHeader();
        }
        return this.getDriverURLHeader() + this.getDatabaseURL();
    }

    public String getConnectionDetails() {
        return this.getConnectionString();
    }

    public String getDatabaseURL() {
        return this.databaseURL;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getDriverURLHeader() {
        return this.driverURLHeader;
    }

    protected void initialize(String string, String string2, String string3) {
        this.setDriverClassName(string);
        this.setDriverURLHeader(string2);
        this.setDatabaseURL(string3);
    }

    protected void loadDriverClass(Session session) throws DatabaseException {
        block9: {
            try {
                if (session != null) {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            this.driverClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getDriverClassName(), true, session.getPlatform().getConversionManager().getLoader()));
                            break block9;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw DatabaseException.configurationErrorClassNotFound(this.getDriverClassName());
                        }
                    }
                    this.driverClass = PrivilegedAccessHelper.getClassForName(this.getDriverClassName(), true, session.getPlatform().getConversionManager().getLoader());
                    break block9;
                }
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        this.driverClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getDriverClassName(), true, ConversionManager.getDefaultManager().getLoader()));
                        break block9;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw DatabaseException.configurationErrorClassNotFound(this.getDriverClassName());
                    }
                }
                this.driverClass = PrivilegedAccessHelper.getClassForName(this.getDriverClassName(), true, ConversionManager.getDefaultManager().getLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.clearDriverClassAndDriver();
                throw DatabaseException.configurationErrorClassNotFound(this.getDriverClassName());
            }
        }
    }

    public void setDatabaseURL(String string) {
        this.databaseURL = string;
    }

    public void setDriverClassName(String string) {
        this.driverClassName = string;
        this.clearDriverClassAndDriver();
    }

    public void setDriverURLHeader(String string) {
        this.driverURLHeader = string;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getConnectionString() + ")";
    }

    public void toString(PrintWriter printWriter) {
        printWriter.println(ToStringLocalization.buildMessage("datasource_URL", null) + "=> \"" + this.getConnectionString() + "\"");
    }

    protected void instantiateDriver() throws DatabaseException {
        block8: {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        this.driver = (Driver)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(this.driverClass));
                        break block8;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        if (privilegedActionException.getCause() instanceof IllegalAccessException) {
                            throw (IllegalAccessException)privilegedActionException.getCause();
                        }
                        if (privilegedActionException.getCause() instanceof InstantiationException) {
                            throw (InstantiationException)privilegedActionException.getCause();
                        }
                        throw (RuntimeException)privilegedActionException.getCause();
                    }
                }
                this.driver = (Driver)PrivilegedAccessHelper.newInstanceFromClass(this.driverClass);
            }
            catch (InstantiationException instantiationException) {
                this.clearDriverClassAndDriver();
                throw DatabaseException.configurationErrorNewInstanceInstantiationException(instantiationException, this.driverClass);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.clearDriverClassAndDriver();
                throw DatabaseException.configurationErrorNewInstanceIllegalAccessException(illegalAccessException, this.driverClass);
            }
        }
    }

    public void clearDriverClassAndDriver() {
        this.driverClass = null;
        this.driver = null;
    }
}

