/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.coordination.rmi;

import java.io.IOException;
import java.net.InetAddress;
import java.rmi.Naming;
import java.rmi.NoSuchObjectException;
import java.rmi.server.UnicastRemoteObject;
import javax.naming.Context;
import javax.rmi.PortableRemoteObject;
import org.eclipse.persistence.exceptions.RemoteCommandManagerException;
import org.eclipse.persistence.internal.sessions.coordination.RemoteConnection;
import org.eclipse.persistence.internal.sessions.coordination.rmi.RMIRemoteCommandConnection;
import org.eclipse.persistence.internal.sessions.coordination.rmi.RMIRemoteCommandConnectionImpl;
import org.eclipse.persistence.internal.sessions.coordination.rmi.RMIRemoteConnection;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;
import org.eclipse.persistence.sessions.coordination.ServiceId;
import org.eclipse.persistence.sessions.coordination.TransportManager;

public class RMITransportManager
extends TransportManager {
    public boolean isRMIOverIIOP;

    public RMITransportManager(RemoteCommandManager remoteCommandManager) {
        this.rcm = remoteCommandManager;
        this.initialize();
    }

    public RemoteConnection createConnection(ServiceId serviceId) {
        RemoteConnection remoteConnection = null;
        if (this.namingServiceType == 1) {
            remoteConnection = this.createConnectionFromRegistry(serviceId.getId(), serviceId.getURL());
        } else if (this.namingServiceType == 0) {
            remoteConnection = this.createConnectionFromJNDI(serviceId.getId(), serviceId.getURL());
        }
        if (remoteConnection != null) {
            remoteConnection.setServiceId(serviceId);
        }
        return remoteConnection;
    }

    protected RemoteConnection createConnectionFromJNDI(String string, String string2) {
        Object[] objectArray = new Object[]{string, string2};
        this.rcm.logDebug("looking_up_remote_conn_in_jndi", objectArray);
        try {
            Context context = this.getRemoteHostContext(string2);
            if (this.isRMIOverIIOP()) {
                return new RMIRemoteConnection((RMIRemoteCommandConnection)PortableRemoteObject.narrow((Object)context.lookup(string), RMIRemoteCommandConnection.class));
            }
            return new RMIRemoteConnection((RMIRemoteCommandConnection)context.lookup(string));
        }
        catch (Exception exception) {
            try {
                this.rcm.handleException(RemoteCommandManagerException.errorLookingUpRemoteConnection(string, string2, exception));
            }
            catch (Exception exception2) {
                this.rcm.logDebug("unable_to_look_up_remote_conn_in_jndi", objectArray);
            }
            return null;
        }
    }

    protected RemoteConnection createConnectionFromRegistry(String string, String string2) {
        String string3 = this.formatURLforRegistry(string2, string);
        Object[] objectArray = new Object[]{string3};
        this.rcm.logDebug("looking_up_remote_conn_in_registry", objectArray);
        try {
            return new RMIRemoteConnection((RMIRemoteCommandConnection)Naming.lookup(string3));
        }
        catch (Exception exception) {
            try {
                this.rcm.handleException(RemoteCommandManagerException.errorLookingUpRemoteConnection(string, string2, exception));
            }
            catch (Exception exception2) {
                this.rcm.logDebug("unable_to_look_up_remote_conn_in_registry", objectArray);
            }
            return null;
        }
    }

    public void createLocalConnection() {
        if (this.namingServiceType == 1) {
            this.createLocalConnectionInRegistry();
        } else if (this.namingServiceType == 0) {
            this.createLocalConnectionInJNDI();
        }
        if (this.localConnection != null) {
            this.localConnection.setServiceId(this.rcm.getServiceId());
        }
    }

    protected void createLocalConnectionInJNDI() {
        try {
            RMIRemoteCommandConnection rMIRemoteCommandConnection = this.isRMIOverIIOP() ? new org.eclipse.persistence.internal.sessions.coordination.rmi.iiop.RMIRemoteCommandConnectionImpl(this.rcm) : new RMIRemoteCommandConnectionImpl(this.rcm);
            Object[] objectArray = new Object[]{this.rcm.getServiceId().getId()};
            this.rcm.logDebug("register_local_connection_in_jndi", objectArray);
            this.getLocalHostContext().rebind(this.rcm.getServiceId().getId(), (Object)rMIRemoteCommandConnection);
            this.localConnection = new RMIRemoteConnection(rMIRemoteCommandConnection);
        }
        catch (Exception exception) {
            this.rcm.handleException(RemoteCommandManagerException.errorBindingConnection(this.rcm.getServiceId().toString(), exception));
        }
    }

    protected RemoteConnection createLocalConnectionInRegistry() {
        String string = this.formatURLforRegistry(this.rcm.getServiceId().getURL(), this.rcm.getServiceId().getId());
        try {
            RMIRemoteCommandConnectionImpl rMIRemoteCommandConnectionImpl = new RMIRemoteCommandConnectionImpl(this.rcm);
            Object[] objectArray = new Object[]{string};
            this.rcm.logDebug("register_local_connection_in_registry", objectArray);
            Naming.rebind(string, rMIRemoteCommandConnectionImpl);
            this.localConnection = new RMIRemoteConnection(rMIRemoteCommandConnectionImpl);
        }
        catch (Exception exception) {
            this.rcm.handleException(RemoteCommandManagerException.errorBindingConnection(string, exception));
        }
        return this.localConnection;
    }

    public Context getLocalHostContext() {
        return this.getContext(this.getLocalContextProperties());
    }

    private String formatURLforRegistry(String string, String string2) {
        if (string == null) {
            return null;
        }
        String string3 = string;
        if (string3 != null && (string3.endsWith("/") || string3.endsWith("\\"))) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        return string3 + "/" + string2;
    }

    public String getDefaultLocalUrl() {
        try {
            String string = InetAddress.getLocalHost().getHostName();
            if (this.isRMIOverIIOP()) {
                return "corbaname::" + string + ":" + "5555#";
            }
            return "ormi://" + string + ":" + "23791";
        }
        catch (IOException iOException) {
            throw RemoteCommandManagerException.errorGettingHostName(iOException);
        }
    }

    public void initialize() {
        super.initialize();
        if (this.rcm.getServiceId().getURL() == null) {
            this.rcm.getServiceId().setURL(this.getDefaultLocalUrl());
        }
        this.namingServiceType = 0;
    }

    public void removeLocalConnection() {
        String string = null;
        try {
            RMIRemoteCommandConnection rMIRemoteCommandConnection;
            if (this.namingServiceType == 1) {
                string = this.formatURLforRegistry(this.rcm.getServiceId().getURL(), this.rcm.getServiceId().getId());
                Naming.unbind(string);
            } else if (this.namingServiceType == 0) {
                string = this.rcm.getServiceId().getId();
                this.getLocalHostContext().unbind(string);
            } else {
                return;
            }
            if (this.getConnectionToLocalHost() != null && (rMIRemoteCommandConnection = ((RMIRemoteConnection)this.getConnectionToLocalHost()).getConnection()) != null) {
                try {
                    UnicastRemoteObject.unexportObject(rMIRemoteCommandConnection, true);
                }
                catch (NoSuchObjectException noSuchObjectException) {}
            }
        }
        catch (Exception exception) {
            this.rcm.handleException(RemoteCommandManagerException.errorUnbindingLocalConnection(string, exception));
        }
        this.localConnection = null;
    }

    public boolean isRMIOverIIOP() {
        return this.isRMIOverIIOP;
    }

    public void setIsRMIOverIIOP(boolean bl) {
        this.isRMIOverIIOP = bl;
    }
}

