/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.remote.corba.sun;

import java.rmi.server.ObjID;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.sessions.remote.RemoteCommand;
import org.eclipse.persistence.internal.sessions.remote.RemoteConnection;
import org.eclipse.persistence.internal.sessions.remote.RemoteCursoredStream;
import org.eclipse.persistence.internal.sessions.remote.RemoteScrollableCursor;
import org.eclipse.persistence.internal.sessions.remote.RemoteUnitOfWork;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.internal.sessions.remote.Transporter;
import org.eclipse.persistence.queries.CursoredStreamPolicy;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.remote.DistributedSession;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.sessions.remote.corba.sun.CORBARemoteSessionController;

public class CORBAConnection
extends RemoteConnection {
    CORBARemoteSessionController remoteSessionController;

    public CORBAConnection(CORBARemoteSessionController cORBARemoteSessionController) {
        this.remoteSessionController = cORBARemoteSessionController;
    }

    public void processCommand(RemoteCommand remoteCommand) {
        Transporter transporter = new Transporter();
        transporter.setObject(remoteCommand);
        transporter = this.getRemoteSessionController().processCommand(transporter);
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
    }

    public void beginTransaction() {
        Transporter transporter = this.getRemoteSessionController().beginTransaction();
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
    }

    public RemoteUnitOfWork commitRootUnitOfWork(RemoteUnitOfWork remoteUnitOfWork) {
        Transporter transporter = this.getRemoteSessionController().commitRootUnitOfWork(new Transporter(remoteUnitOfWork));
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (RemoteUnitOfWork)transporter.getObject();
    }

    public void commitTransaction() {
        Transporter transporter = this.getRemoteSessionController().commitTransaction();
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
    }

    public Session createRemoteSession() {
        return new RemoteSession(this);
    }

    public void cursoredStreamClose(ObjID objID) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().cursoredStreamClose(new Transporter(objID));
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
    }

    public Vector cursoredStreamNextPage(RemoteCursoredStream remoteCursoredStream, ReadQuery readQuery, RemoteSession remoteSession, int n) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().cursoredStreamNextPage(new Transporter(remoteCursoredStream.getID()), n);
        if (transporter == null) {
            return null;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        Vector<Object> vector = (Vector<Object>)transporter.getObject();
        if (vector == null) {
            this.cursoredStreamClose(remoteCursoredStream.getID());
            return null;
        }
        Vector<Object> vector2 = vector;
        if (readQuery.isReadAllQuery() && !readQuery.isReportQuery()) {
            vector2 = new Vector<Object>(vector.size());
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object object = remoteSession.getObjectCorrespondingTo(enumeration.nextElement(), transporter.getObjectDescriptors(), new IdentityHashMap(), (ObjectLevelReadQuery)readQuery);
                vector2.addElement(object);
            }
        }
        return vector2;
    }

    public int cursoredStreamSize(ObjID objID) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().cursoredStreamSize(new Transporter(objID));
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Integer)transporter.getObject();
    }

    public RemoteCursoredStream cursorSelectObjects(CursoredStreamPolicy cursoredStreamPolicy, DistributedSession distributedSession) {
        Transporter transporter = this.getRemoteSessionController().cursorSelectObjects(new Transporter(cursoredStreamPolicy));
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        RemoteCursoredStream remoteCursoredStream = (RemoteCursoredStream)transporter.getObject();
        remoteCursoredStream.setSession(distributedSession);
        remoteCursoredStream.setPolicy(cursoredStreamPolicy);
        if (cursoredStreamPolicy.getQuery().isReadAllQuery() && !cursoredStreamPolicy.getQuery().isReportQuery()) {
            this.fixObjectReferences(transporter, (ObjectLevelReadQuery)cursoredStreamPolicy.getQuery(), (RemoteSession)distributedSession);
        }
        return remoteCursoredStream;
    }

    public RemoteScrollableCursor cursorSelectObjects(ScrollableCursorPolicy scrollableCursorPolicy, DistributedSession distributedSession) {
        Transporter transporter = this.getRemoteSessionController().cursorSelectObjects(new Transporter(scrollableCursorPolicy));
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        RemoteScrollableCursor remoteScrollableCursor = (RemoteScrollableCursor)transporter.getObject();
        remoteScrollableCursor.setSession(distributedSession);
        remoteScrollableCursor.setPolicy(scrollableCursorPolicy);
        return remoteScrollableCursor;
    }

    public void fixObjectReferences(Transporter transporter, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
        RemoteCursoredStream remoteCursoredStream = (RemoteCursoredStream)transporter.getObject();
        Vector vector = remoteCursoredStream.getObjectCollection();
        if (objectLevelReadQuery.isReadAllQuery() && !objectLevelReadQuery.isReportQuery()) {
            Vector<Object> vector2 = new Vector<Object>(vector.size());
            IdentityHashMap identityHashMap = new IdentityHashMap(vector.size() + 1);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                vector2.addElement(remoteSession.getObjectCorrespondingTo(e, transporter.getObjectDescriptors(), identityHashMap, objectLevelReadQuery));
            }
            remoteCursoredStream.setObjectCollection(vector2);
        }
    }

    public ClassDescriptor getDescriptor(Class clazz) {
        Transporter transporter = this.getRemoteSessionController().getDescriptor(new Transporter(clazz));
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (ClassDescriptor)transporter.getObject();
    }

    public Vector getDefaultReadOnlyClasses() {
        Transporter transporter = this.getRemoteSessionController().getDefaultReadOnlyClasses();
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Vector)transporter.getObject();
    }

    public Login getLogin() {
        Transporter transporter = this.getRemoteSessionController().getLogin();
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Login)transporter.getObject();
    }

    public CORBARemoteSessionController getRemoteSessionController() {
        return this.remoteSessionController;
    }

    public Object getSequenceNumberNamed(Object object) {
        Transporter transporter = this.getRemoteSessionController().getSequenceNumberNamed(new Transporter(object));
        Object object2 = transporter.getObject();
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return object2;
    }

    public void initializeIdentityMapsOnServerSession() {
        Transporter transporter = this.getRemoteSessionController().initializeIdentityMapsOnServerSession();
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
    }

    public Transporter instantiateRemoteValueHolderOnServer(RemoteValueHolder remoteValueHolder) {
        Transporter transporter = this.getRemoteSessionController().instantiateRemoteValueHolderOnServer(new Transporter(remoteValueHolder));
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return transporter;
    }

    public Transporter remoteExecute(DatabaseQuery databaseQuery) {
        Transporter transporter = this.getRemoteSessionController().executeQuery(new Transporter(databaseQuery));
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return transporter;
    }

    public Transporter remoteExecuteNamedQuery(String string, Class clazz, Vector vector) {
        Transporter transporter = this.getRemoteSessionController().executeNamedQuery(new Transporter(string), new Transporter(clazz), new Transporter(vector));
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return transporter;
    }

    public void rollbackTransaction() {
        Transporter transporter = this.getRemoteSessionController().rollbackTransaction();
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
    }

    public boolean scrollableCursorAbsolute(ObjID objID, int n) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().scrollableCursorAbsolute(new Transporter(objID), n);
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public void scrollableCursorAfterLast(ObjID objID) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().scrollableCursorAfterLast(new Transporter(objID));
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
    }

    public void scrollableCursorBeforeFirst(ObjID objID) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().scrollableCursorBeforeFirst(new Transporter(objID));
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
    }

    public void scrollableCursorClose(ObjID objID) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().scrollableCursorClose(new Transporter(objID));
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
    }

    public int scrollableCursorCurrentIndex(ObjID objID) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().scrollableCursorAfterLast(new Transporter(objID));
        if (transporter == null) {
            return -1;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Integer)transporter.getObject();
    }

    public boolean scrollableCursorFirst(ObjID objID) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().scrollableCursorFirst(new Transporter(objID));
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public boolean scrollableCursorIsAfterLast(ObjID objID) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().scrollableCursorIsAfterLast(new Transporter(objID));
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public boolean scrollableCursorIsBeforeFirst(ObjID objID) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().scrollableCursorIsBeforeFirst(new Transporter(objID));
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public boolean scrollableCursorIsFirst(ObjID objID) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().scrollableCursorIsFirst(new Transporter(objID));
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public boolean scrollableCursorIsLast(ObjID objID) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().scrollableCursorIsLast(new Transporter(objID));
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public boolean scrollableCursorLast(ObjID objID) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().scrollableCursorLast(new Transporter(objID));
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public Object scrollableCursorNextObject(ObjID objID, ReadQuery readQuery, RemoteSession remoteSession) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().scrollableCursorNextObject(new Transporter(objID));
        if (transporter == null) {
            return null;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        Object object = transporter.getObject();
        if (object == null) {
            return null;
        }
        if (readQuery.isReadAllQuery() && !readQuery.isReportQuery()) {
            object = remoteSession.getObjectCorrespondingTo(object, transporter.getObjectDescriptors(), new IdentityHashMap(), (ObjectLevelReadQuery)readQuery);
        }
        return object;
    }

    public Object scrollableCursorPreviousObject(ObjID objID, ReadQuery readQuery, RemoteSession remoteSession) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().scrollableCursorPreviousObject(new Transporter(objID));
        if (transporter == null) {
            return null;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        Object object = transporter.getObject();
        if (object == null) {
            return null;
        }
        if (readQuery.isReadAllQuery() && !readQuery.isReportQuery()) {
            object = remoteSession.getObjectCorrespondingTo(object, transporter.getObjectDescriptors(), new IdentityHashMap(), (ObjectLevelReadQuery)readQuery);
        }
        return object;
    }

    public boolean scrollableCursorRelative(ObjID objID, int n) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().scrollableCursorRelative(new Transporter(objID), n);
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public int scrollableCursorSize(ObjID objID) {
        Transporter transporter = null;
        transporter = this.getRemoteSessionController().scrollableCursorSize(new Transporter(objID));
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Integer)transporter.getObject();
    }

    public void setRemoteSessionController(CORBARemoteSessionController cORBARemoteSessionController) {
        this.remoteSessionController = cORBARemoteSessionController;
    }
}

