/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class PackageRenamer {
    int numberOfTotalFile = 0;
    int numberOfChangedFile = 0;
    boolean specifyLogFile = false;
    PrintWriter outLog = null;
    String logFileString = null;
    File logFile;
    File sourceRootDirFile;
    File destinationRootDir;
    String sourceProperties;
    Properties properties = null;
    String propertiesFileName;
    boolean VERBOSE = true;
    protected static final String SYSTEM_OUT = "System.out";
    BufferedReader reader = null;
    String[] UNSUPPORTED_EXTENSIONS = new String[]{"jar", "zip", "ear", "war", "dll", "class", "exe"};
    int BUFSIZ = 4096;
    String CR = System.getProperty("line.separator");

    public PackageRenamer() {
        this(PackageRenamer.getDefaultPropertiesFileName());
    }

    public PackageRenamer(String string) {
        System.out.println("");
        System.out.println("TopLink Package Renamer");
        System.out.println("-----------------------");
        System.out.println(this.bannerText());
        this.sourceRootDirFile = this.existingDirectoryFromPrompt();
        System.out.println("");
        this.destinationRootDir = this.promptForDestinationDirectory();
        System.out.println("");
        this.propertiesFileName = string;
        this.outLog = this.streamForNonExistentFilePrompt();
        this.properties = this.readChangesFile(string);
    }

    public PackageRenamer(String[] stringArray) {
        this.propertiesFileName = stringArray[0];
        this.sourceRootDirFile = this.buildAndCheckExistingDirFile(stringArray[1]);
        this.destinationRootDir = this.buildAndCheckDestinationFile(stringArray[2]);
        this.outLog = stringArray.length == 4 ? this.buildAndCheckLogWriter(stringArray[3]) : this.buildAndCheckLogWriter(SYSTEM_OUT);
        this.properties = this.readChangesFile(stringArray[0]);
        this.logln(this.bannerText());
    }

    protected String bannerText() {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append(this.CR);
        stringBuffer.append("NOTE: The package renamer is meant to be run on plain text files. ");
        stringBuffer.append(this.CR);
        stringBuffer.append("A rename will NOT be done on binary files.");
        stringBuffer.append(this.CR);
        return stringBuffer.toString();
    }

    public void binaryCopy(File file, File file2) throws FileNotFoundException, IOException {
        int n;
        byte[] byArray = new byte[this.BUFSIZ];
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        while ((n = fileInputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        fileOutputStream.close();
    }

    protected boolean bufferContainsNullChar(byte[] byArray, int n) {
        for (int i = 0; i < n; ++i) {
            if (byArray[i] != 0) continue;
            return true;
        }
        return false;
    }

    public File buildAndCheckDestinationFile(String string) {
        if (string == null) {
            throw new PackageRenamerException("Invalid destination directory entered.");
        }
        File file = new File(string);
        if (file.exists() && file.listFiles().length != 0) {
            throw new PackageRenamerException("Output Directory:" + this.CR + "  '" + string + "'" + this.CR + "exists and is not empty.");
        }
        if (!file.isAbsolute()) {
            throw new PackageRenamerException("A relative destination directory was entered:" + this.CR + "  '" + string + "'" + this.CR + "The directory must be absolute.");
        }
        if (PackageRenamer.directoryIsSubdirectory(this.sourceRootDirFile, file)) {
            throw new PackageRenamerException("Invalid destination directory entered:" + this.CR + "  '" + string + "'" + this.CR + "It cannot be a sub-directory of the source directory.");
        }
        return file;
    }

    public File buildAndCheckExistingDirFile(String string) {
        if (string == null) {
            throw new PackageRenamerException("Invalid source directory entered.");
        }
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            throw new PackageRenamerException("Input Directory:" + this.CR + "  '" + string + "'" + this.CR + "does not exist or is not a directory.");
        }
        if (!file.isAbsolute()) {
            throw new PackageRenamerException("A relative source directory was entered:" + this.CR + "  '" + string + "'" + this.CR + "The directory must be absolute.");
        }
        return file;
    }

    public PrintWriter buildAndCheckLogWriter(String string) {
        if (string == null) {
            throw new PackageRenamerException("Invalid log file name entered.");
        }
        try {
            if (string.equals(SYSTEM_OUT)) {
                return new PrintWriter(System.out);
            }
            File file = new File(string);
            if (file.exists()) {
                throw new PackageRenamerException("Specified log file cannot be created:" + this.CR + "  '" + string + "'");
            }
            FileWriter fileWriter = new FileWriter(string);
            return new PrintWriter(fileWriter);
        }
        catch (IOException iOException) {
            throw new PackageRenamerException("Unhandled IOException occurred while configuring log file: '" + string + "', " + iOException.getMessage());
        }
    }

    protected void cleanup() {
        if (this.outLog != null) {
            this.outLog.close();
        }
    }

    public void createDestinationDirectory(File file) {
        if (!file.exists()) {
            if (!file.mkdirs()) {
                throw new PackageRenamerException("Error while creating directory:" + this.CR + "  '" + file.toString() + "'");
            }
        } else {
            throw new PackageRenamerException("Error directory: '" + file.toString() + "' already exists but shouldn't.");
        }
    }

    public static boolean directoryIsSubdirectory(File file, File file2) {
        if (file2 == null) {
            return false;
        }
        if (file.equals(file2)) {
            return true;
        }
        return PackageRenamer.directoryIsSubdirectory(file, file2.getParentFile());
    }

    public File existingDirectoryFromPrompt() {
        System.out.print("Enter the path of the directory which contains the files to rename:" + this.CR + "> ");
        String string = null;
        try {
            string = this.getReader().readLine();
        }
        catch (IOException iOException) {
            throw new PackageRenamerException("Error while reading the source directory: " + iOException.getMessage());
        }
        return this.buildAndCheckExistingDirFile(string);
    }

    public static String getDefaultPropertiesFileName() {
        String string = System.getProperty("user.dir");
        return string + File.separator + "packageRename.properties";
    }

    public synchronized BufferedReader getReader() {
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader(System.in));
        }
        return this.reader;
    }

    public boolean isExtensionSupported(String string) {
        return true;
    }

    public void logln(String string) {
        this.outLog.println(string);
        this.outLog.flush();
    }

    public static void main(String[] stringArray) {
        PackageRenamer packageRenamer = null;
        try {
            if (stringArray.length == 0) {
                packageRenamer = new PackageRenamer();
                packageRenamer.run();
            } else if (stringArray.length == 1) {
                packageRenamer = new PackageRenamer(stringArray[0]);
                packageRenamer.run();
            } else if (stringArray.length == 3 || stringArray.length == 4) {
                packageRenamer = new PackageRenamer(stringArray);
                packageRenamer.run();
            } else {
                PackageRenamer.usage();
                System.exit(-1);
            }
        }
        catch (PackageRenamerException packageRenamerException) {
            PackageRenamer.usage();
            System.err.println("**************************************************************************");
            System.err.println("Error during package rename. PACKAGE RENAME FAILED.");
            System.err.println(packageRenamerException.getMessage());
            System.err.println("**************************************************************************");
            System.exit(-1);
        }
        catch (Throwable throwable) {
            System.err.println("Unhandled exception was thrown during rename:");
            throwable.printStackTrace();
            System.exit(-1);
        }
        packageRenamer.logln("");
        packageRenamer.logln("PACKAGE RENAME WAS SUCCESSFUL");
        packageRenamer.cleanup();
    }

    public String parseFileExtension(File file) {
        int n = file.getName().lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return file.getName().substring(n + 1);
    }

    protected File promptForDestinationDirectory() {
        System.out.print("Enter the path of the directory to which files are to be copied:" + this.CR + "> ");
        String string = null;
        try {
            string = this.getReader().readLine();
        }
        catch (IOException iOException) {
            throw new PackageRenamerException("Error while reading the destination directory specified: " + iOException.getMessage());
        }
        return this.buildAndCheckDestinationFile(string);
    }

    public Properties readChangesFile(String string) {
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PackageRenamerException("Properties file was not found:" + this.CR + "  '" + string + "'");
        }
        catch (IOException iOException) {
            throw new PackageRenamerException("IO error occurred while reading the properties file:'" + string + "'" + iOException.getMessage());
        }
        this.logln("Using properties file: " + string);
        return properties;
    }

    public void run() {
        this.logln("LOG MESSAGES FROM packageRenamer");
        this.logln("" + new Date());
        this.logln("");
        this.logln("INPUT: -----------------> " + this.sourceRootDirFile.toString());
        this.logln("OUTPUT: ----------------> " + this.destinationRootDir.toString());
        this.logln("");
        this.logln("Verifying root output directory...");
        if (!this.destinationRootDir.exists()) {
            this.logln("");
            this.logln("Creating root output directory...");
            this.createDestinationDirectory(this.destinationRootDir);
            this.logln("");
        }
        this.logln("Verifying root output directory...DONE");
        this.logln("");
        this.logln("List of changed file(s): ");
        this.logln("");
        this.traverseSourceDirectory(this.sourceRootDirFile);
        this.logln("");
        this.logln("Total Changed File(s): ------> " + this.numberOfChangedFile);
        this.logln("Total File(s):         ------> " + this.numberOfTotalFile);
        this.logln("");
    }

    protected PrintWriter streamForNonExistentFilePrompt() {
        System.out.print("Enter the absolute path of the log file [Hit Enter for SYSTEM.OUT]:" + this.CR + "> ");
        String string = null;
        try {
            string = this.getReader().readLine();
        }
        catch (IOException iOException) {
            throw new PackageRenamerException("Error while reading the name of the log file: " + iOException.getMessage());
        }
        if (string != null && string.length() == 0) {
            return this.buildAndCheckLogWriter(SYSTEM_OUT);
        }
        return this.buildAndCheckLogWriter(string);
    }

    public void runSearchAndReplacePackageName(File file) {
        Object object;
        int n;
        StringBuffer stringBuffer;
        Object object2;
        Object object3;
        String string = (String)System.getProperties().get("line.separator");
        String string2 = "";
        String string3 = file.toString();
        String string4 = file.toString().substring(this.sourceRootDirFile.toString().length() + 1);
        string4 = this.returnNewFileNameIfRequired(string4);
        String string5 = this.destinationRootDir.toString() + File.separator + string4;
        try {
            object3 = new FileInputStream(new File(string3));
            object2 = new byte[this.BUFSIZ];
            stringBuffer = new StringBuffer((int)new File(string3).length());
            n = 0;
            while ((n = ((FileInputStream)object3).read((byte[])object2)) != -1) {
                if (this.bufferContainsNullChar((byte[])object2, n)) {
                    ((FileInputStream)object3).close();
                    this.binaryCopy(file, new File(string5));
                    return;
                }
                String string6 = new String((byte[])object2, 0, n);
                stringBuffer.append(string6);
            }
            ((FileInputStream)object3).close();
            string2 = new String(stringBuffer);
        }
        catch (IOException iOException) {
            throw new PackageRenamerException("Unexpected exception was thrown during file manipulation." + iOException.getMessage());
        }
        object3 = new Vector();
        object2 = this.properties.keys();
        while (object2.hasMoreElements()) {
            ((Vector)object3).addElement(object2.nextElement());
        }
        object2 = new String[((Vector)object3).size()];
        ((Vector)object3).copyInto((Object[])object2);
        stringBuffer = null;
        Arrays.sort((Object[])object2);
        n = 0;
        int n2 = ((Object)object2).length;
        Object object4 = this.properties.keys();
        while (object4.hasMoreElements()) {
            object = (String)object4.nextElement();
            Object object5 = object2[n2 - 1];
            String string7 = (String)this.properties.get(object5);
            --n2;
            int n3 = string2.indexOf((String)object5);
            if (n3 != -1 && n == 0) {
                n = 1;
                this.logln(this.numberOfChangedFile + 1 + ". " + string5);
                ++this.numberOfChangedFile;
            }
            string2 = PackageRenamer.replace(string2, (String)object5, string7);
        }
        try {
            object4 = new FileWriter(string5);
            object = new PrintWriter((Writer)object4);
            ((PrintWriter)object).print(string2);
            ((PrintWriter)object).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PackageRenamerException("Could not find file to write:" + this.CR + "  '" + string5 + "'" + this.CR + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new PackageRenamerException("Unexpected exception was thrown while writing the file: '" + string5 + "', " + iOException.getMessage());
        }
    }

    public static String replace(String string, String string2, String string3) {
        int n;
        int n2 = string3.length();
        int n3 = n = string.indexOf(string2);
        while (n > -1) {
            String string4 = string.substring(0, n);
            String string5 = string.substring(n + string2.length(), string.length());
            string = string4 + string3 + string5;
            n3 = n + n2;
            n = string.indexOf(string2, n3);
        }
        return string;
    }

    public String returnNewFileNameIfRequired(String string) {
        Enumeration<Object> enumeration = this.properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string.indexOf(string2) == -1) continue;
            string = PackageRenamer.replace(string, string2, (String)this.properties.get(string2));
        }
        return string;
    }

    public void traverseSourceDirectory(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            String string;
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                string = file2.toString();
                String string2 = this.destinationRootDir.toString() + string.substring(this.sourceRootDirFile.toString().length(), string.length());
                this.createDestinationDirectory(new File(string2));
                this.traverseSourceDirectory(file2);
                continue;
            }
            ++this.numberOfTotalFile;
            string = this.parseFileExtension(file2);
            if (!this.isExtensionSupported(string)) continue;
            this.runSearchAndReplacePackageName(file2);
        }
    }

    public static void usage() {
        System.out.println("");
        System.out.println("TopLink Package Renamer");
        System.out.println("-----------------------");
        System.out.println("");
        System.out.println("The package  renamer should  be run  once on user source code, configuration");
        System.out.println("files,  and   Mapping  Workbench  project  files  that  have  references  to");
        System.out.println("pre-Oracle 9iAS TopLink 9.0.3  API  packages.  The package renamer  works on");
        System.out.println("plain text files and should NOT be run on binary files such as JAR files.");
        System.out.println("");
        System.out.println("The package renamer supports two command line usages. A call which specifies");
        System.out.println("all the required arguments, and  a  call which takes only one parameter.  In");
        System.out.println("this last case, the user is prompted for the missing arguments.");
        System.out.println("");
        System.out.println("Usage:");
        System.out.println("");
        System.out.println("java org.eclipse.persistence.tools.PackageRenamer <properties-file>");
        System.out.println("");
        System.out.println("OR");
        System.out.println("");
        System.out.println("java org.eclipse.persistence.tools.PackageRenamer <properties-file> <source-root-directory> <destination-root-directory> [ <log-file> ]");
        System.out.println("");
        System.out.println("where:");
        System.out.println("\t<properties-file> - File containing  a list of  old and new package");
        System.out.println("\tnames.");
        System.out.println("");
        System.out.println("\t<source-root-directory> - Absolute path name of the directory which");
        System.out.println("\tcontains all the file to be converted.  The <source-root-directory>");
        System.out.println("\twill be searched recursively for files  to convert.  This directory");
        System.out.println("\tshould contain only the plain text files to be converted.");
        System.out.println("");
        System.out.println("\t<destination-root-directory> - Absolute path name of  the directory");
        System.out.println("\twhere the converted directory  structure will be copied.  All files");
        System.out.println("\twill be copied to  the new directory structure whether changes were");
        System.out.println("\tmade or not. This directory must either not exist or be empty.");
        System.out.println("");
        System.out.println("\t<log-file> - The logging  of  the  renaming process will be written");
        System.out.println("\tto the <log-file>.  If no  <log-file>  is  specified  then  logging");
        System.out.println("\twill be written to standard output.");
        System.out.println("");
    }

    public class PackageRenamerException
    extends RuntimeException {
        public PackageRenamerException(String string) {
            super(string);
        }
    }
}

