/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.eis.EISDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.descriptors.FieldTransformation;
import org.eclipse.persistence.internal.descriptors.MethodBasedFieldTransformation;
import org.eclipse.persistence.internal.descriptors.TransformerBasedFieldTransformation;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.mappings.AggregateCollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.TransformationMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.SerializedObjectConverter;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.sequencing.DefaultSequence;
import org.eclipse.persistence.sequencing.NativeSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.ForeignKeyConstraint;
import org.eclipse.persistence.tools.schemaframework.TableCreator;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;
import org.eclipse.persistence.tools.schemaframework.UniqueKeyConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTableGenerator {
    Project project = null;
    private DatabasePlatform databasePlatform;
    private Map<String, TableDefinition> tableMap = null;
    private Map<DatabaseField, FieldDefinition> fieldMap = null;
    private Map<DatabaseField, DatabaseField> databaseFields;
    protected boolean generateFKConstraints = true;

    public DefaultTableGenerator(Project project) {
        this.project = project;
        if (project.getDatasourceLogin().getDatasourcePlatform() instanceof DatabasePlatform) {
            this.databasePlatform = (DatabasePlatform)project.getDatasourceLogin().getDatasourcePlatform();
        }
        this.tableMap = new HashMap<String, TableDefinition>();
        this.fieldMap = new HashMap<DatabaseField, FieldDefinition>();
        this.databaseFields = new HashMap<DatabaseField, DatabaseField>();
    }

    public DefaultTableGenerator(Project project, boolean bl) {
        this(project);
        this.generateFKConstraints = bl;
    }

    public TableCreator generateDefaultTableCreator() {
        TableCreator tableCreator = new TableCreator();
        for (ClassDescriptor classDescriptor : this.project.getDescriptors().values()) {
            if (classDescriptor instanceof XMLDescriptor || classDescriptor instanceof EISDescriptor || classDescriptor instanceof ObjectRelationalDataTypeDescriptor) {
                AbstractSessionLog.getLog().log(6, "relational_descriptor_support_only", null, true);
                return tableCreator;
            }
            if (classDescriptor.isAggregateDescriptor()) continue;
            this.initTableSchema(classDescriptor);
        }
        for (ClassDescriptor classDescriptor : this.project.getOrderedDescriptors()) {
            if (classDescriptor.isAggregateDescriptor()) continue;
            this.postInitTableSchema(classDescriptor);
        }
        tableCreator.addTableDefinitions(this.tableMap.values());
        return tableCreator;
    }

    public TableCreator generateFilteredDefaultTableCreator(AbstractSession abstractSession) throws DatabaseException {
        TableCreator tableCreator = this.generateDefaultTableCreator();
        try {
            Connection connection = null;
            if (abstractSession.isServerSession()) {
                connection = ((ServerSession)abstractSession).getDefaultConnectionPool().acquireConnection().getConnection();
            } else if (abstractSession.isDatabaseSession()) {
                connection = ((DatabaseSessionImpl)abstractSession).getAccessor().getConnection();
            }
            if (connection == null) {
                return tableCreator;
            }
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(null, databaseMetaData.getUserName(), null, new String[]{"TABLE"});
            ArrayList<String> arrayList = new ArrayList<String>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString("TABLE_NAME"));
            }
            resultSet.close();
            ArrayList<TableDefinition> arrayList2 = new ArrayList<TableDefinition>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (TableDefinition tableDefinition : tableCreator.getTableDefinitions()) {
                if (!arrayList.contains(tableDefinition.getFullName())) continue;
                arrayList2.add(tableDefinition);
                arrayList3.add(tableDefinition.getFullName());
            }
            if (!arrayList3.isEmpty()) {
                abstractSession.getSessionLog().log(1, "skip_create_existing_tables", arrayList3);
                tableCreator.getTableDefinitions().removeAll(arrayList2);
            }
        }
        catch (SQLException sQLException) {
            throw DatabaseException.errorRetrieveDbMetadataThroughJDBCConnection();
        }
        return tableCreator;
    }

    protected void initTableSchema(ClassDescriptor classDescriptor) {
        TableDefinition tableDefinition = null;
        DatabaseTable databaseTable2 = null;
        for (DatabaseTable databaseTable2 : classDescriptor.getTables()) {
            tableDefinition = this.getTableDefFromDBTable(databaseTable2);
        }
        Iterator<DatabaseField> iterator = classDescriptor.getFields().iterator();
        DatabaseField databaseField = null;
        while (iterator.hasNext()) {
            databaseField = iterator.next();
            boolean bl = false;
            bl = classDescriptor.getPrimaryKeyFields().contains(databaseField);
            Map<DatabaseField, DatabaseField> map = classDescriptor.getAdditionalTablePrimaryKeyFields().get(databaseField.getTable());
            if (map != null) {
                bl = bl || map.containsValue(databaseField);
            }
            FieldDefinition fieldDefinition = this.getFieldDefFromDBField(databaseField, bl);
            if (bl) {
                String string = classDescriptor.getSequenceNumberName();
                DatabaseLogin databaseLogin = this.project.getLogin();
                Sequence sequence = databaseLogin.getSequence(string);
                if (sequence instanceof DefaultSequence) {
                    sequence = databaseLogin.getDefaultSequence();
                }
                boolean bl2 = sequence instanceof NativeSequence && sequence.shouldAcquireValueAfterInsert();
                fieldDefinition.setIsIdentity(bl2);
            }
            if ((tableDefinition = this.tableMap.get(databaseField.getTableName())).getFields().contains(fieldDefinition)) continue;
            tableDefinition.addField(fieldDefinition);
        }
    }

    private void postInitTableSchema(ClassDescriptor classDescriptor) {
        for (DatabaseMapping databaseMapping : classDescriptor.getMappings()) {
            if (classDescriptor.isChildDescriptor() && classDescriptor.getInheritancePolicy().getParentDescriptor().getMappingForAttributeName(databaseMapping.getAttributeName()) != null) continue;
            if (databaseMapping.isManyToManyMapping()) {
                this.buildRelationTableDefinition((ManyToManyMapping)databaseMapping);
                continue;
            }
            if (databaseMapping.isDirectCollectionMapping()) {
                this.buildDirectCollectionTableDefinition((DirectCollectionMapping)databaseMapping, classDescriptor);
                continue;
            }
            if (databaseMapping.isDirectToFieldMapping()) {
                Converter converter = ((DirectToFieldMapping)databaseMapping).getConverter();
                if (converter == null) continue;
                if (converter instanceof TypeConversionConverter) {
                    this.resetFieldTypeForLOB((DirectToFieldMapping)databaseMapping);
                }
                if (!(converter instanceof SerializedObjectConverter)) continue;
                this.getFieldDefFromDBField(databaseMapping.getField(), false).setType(Byte[].class);
                continue;
            }
            if (databaseMapping.isAggregateCollectionMapping()) {
                this.addForeignkeyFieldToAggregateTargetTable((AggregateCollectionMapping)databaseMapping);
                continue;
            }
            if (databaseMapping.isForeignReferenceMapping()) {
                if (databaseMapping.isOneToOneMapping()) {
                    this.addForeignKeyFieldToSourceTargetTable((OneToOneMapping)databaseMapping);
                    continue;
                }
                if (!databaseMapping.isOneToManyMapping()) continue;
                this.addForeignKeyFieldToSourceTargetTable((OneToManyMapping)databaseMapping);
                continue;
            }
            if (!databaseMapping.isTransformationMapping()) continue;
            this.resetTransformedFieldType((TransformationMapping)databaseMapping);
        }
        this.processAdditionalTablePkFields(classDescriptor);
    }

    private void buildRelationTableDefinition(ManyToManyMapping manyToManyMapping) {
        TableDefinition tableDefinition = this.getTableDefFromDBTable(manyToManyMapping.getRelationTable());
        Vector<DatabaseField> vector = manyToManyMapping.getSourceRelationKeyFields();
        Vector<DatabaseField> vector2 = manyToManyMapping.getSourceKeyFields();
        this.buildRelationTableFields(tableDefinition, vector, vector2);
        Vector<DatabaseField> vector3 = manyToManyMapping.getTargetRelationKeyFields();
        Vector<DatabaseField> vector4 = manyToManyMapping.getTargetKeyFields();
        this.buildRelationTableFields(tableDefinition, vector3, vector4);
    }

    private void buildRelationTableFields(TableDefinition tableDefinition, Vector vector, Vector vector2) {
        assert (vector.size() > 0 && vector.size() == vector2.size());
        DatabaseField databaseField = null;
        DatabaseField databaseField2 = null;
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        for (int i = 0; i < vector.size(); ++i) {
            databaseField = (DatabaseField)vector.get(i);
            databaseField2 = (DatabaseField)vector2.get(i);
            vector3.add(databaseField.getName());
            vector4.add(databaseField2.getName());
            databaseField = this.resolveDatabaseField(databaseField, databaseField2);
            this.setFieldToRelationTable(databaseField, tableDefinition);
        }
        DatabaseTable databaseTable = databaseField2.getTable();
        TableDefinition tableDefinition2 = this.getTableDefFromDBTable(databaseTable);
        this.addForeignKeyConstraint(tableDefinition, tableDefinition2, vector3, vector4);
    }

    private void buildDirectCollectionTableDefinition(DirectCollectionMapping directCollectionMapping, ClassDescriptor classDescriptor) {
        TableDefinition tableDefinition = this.getTableDefFromDBTable(directCollectionMapping.getReferenceTable());
        DatabaseField databaseField = null;
        Vector<DatabaseField> vector = directCollectionMapping.getReferenceKeyFields();
        for (int i = 0; i < vector.size(); ++i) {
            databaseField = this.resolveDatabaseField(vector.get(i), directCollectionMapping.getSourceKeyFields().get(i));
            tableDefinition.addField(this.getDirectCollectionReferenceKeyFieldDefFromDBField(databaseField));
        }
        tableDefinition.addField(this.getFieldDefFromDBField(directCollectionMapping.getDirectField(), false));
        if (directCollectionMapping.isDirectMapMapping()) {
            databaseField = ((DirectMapMapping)directCollectionMapping).getDirectKeyField();
            tableDefinition.addField(this.getFieldDefFromDBField(databaseField, false));
        }
    }

    private void resetFieldTypeForLOB(DirectToFieldMapping directToFieldMapping) {
        if (directToFieldMapping.getFieldClassification().getName().equals("java.sql.Blob")) {
            this.getFieldDefFromDBField(directToFieldMapping.getField(), false).setType(Byte[].class);
        } else if (directToFieldMapping.getFieldClassification().getName().equals("java.sql.Clob")) {
            this.getFieldDefFromDBField(directToFieldMapping.getField(), false).setType(Character[].class);
        }
    }

    private void resetTransformedFieldType(TransformationMapping transformationMapping) {
        for (FieldTransformation fieldTransformation : transformationMapping.getFieldTransformations()) {
            Object object;
            FieldTransformation fieldTransformation2;
            if (fieldTransformation instanceof MethodBasedFieldTransformation) {
                fieldTransformation2 = (MethodBasedFieldTransformation)fieldTransformation;
                try {
                    object = Helper.getDeclaredMethod(transformationMapping.getDescriptor().getJavaClass(), ((MethodBasedFieldTransformation)fieldTransformation2).getMethodName(), null).getReturnType();
                    this.getFieldDefFromDBField(fieldTransformation2.getField(), false).setType((Class)object);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                continue;
            }
            fieldTransformation2 = (TransformerBasedFieldTransformation)fieldTransformation;
            object = "buildFieldValue";
            Class[] classArray = new Class[]{Object.class, String.class, Session.class};
            try {
                Class<?> clazz = Helper.getDeclaredMethod(((TransformerBasedFieldTransformation)fieldTransformation2).getTransformerClass(), (String)object, classArray).getReturnType();
                if (clazz.equals(Object.class)) {
                    throw ValidationException.missingFieldTypeForDDLGenerationOfClassTransformation(transformationMapping.getDescriptor(), transformationMapping.getAttributeName(), (String)object);
                }
                this.getFieldDefFromDBField(fieldTransformation2.getField(), false).setType(clazz);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw ValidationException.missingTransformerMethodForDDLGenerationOfClassTransformation(transformationMapping.getDescriptor(), transformationMapping.getAttributeName(), (String)object);
            }
        }
    }

    private void addForeignkeyFieldToAggregateTargetTable(AggregateCollectionMapping aggregateCollectionMapping) {
        for (DatabaseField databaseField : aggregateCollectionMapping.getTargetForeignKeyFields()) {
            TableDefinition tableDefinition = this.getTableDefFromDBTable(databaseField.getTable());
            tableDefinition.addField(this.getFieldDefFromDBField(databaseField, false));
        }
    }

    private void addForeignKeyFieldToSourceTargetTable(OneToOneMapping oneToOneMapping) {
        if (!oneToOneMapping.isForeignKeyRelationship()) {
            return;
        }
        this.addForeignMappingFkConstraint(oneToOneMapping.getSourceToTargetKeyFields());
    }

    private void addForeignKeyFieldToSourceTargetTable(OneToManyMapping oneToManyMapping) {
        this.addForeignMappingFkConstraint(oneToManyMapping.getTargetForeignKeysToSourceKeys());
    }

    private void addForeignMappingFkConstraint(Map<DatabaseField, DatabaseField> map) {
        if (map.size() == 0) {
            return;
        }
        Vector<DatabaseField> vector = new Vector<DatabaseField>();
        Vector<DatabaseField> vector2 = new Vector<DatabaseField>();
        for (DatabaseField databaseField : map.keySet()) {
            vector.add(databaseField);
            vector2.add(map.get(databaseField));
        }
        this.addJoinColumnsFkConstraint(vector, vector2);
    }

    private TableDefinition getTableDefFromDBTable(DatabaseTable databaseTable) {
        TableDefinition tableDefinition = this.tableMap.get(databaseTable.getName());
        if (tableDefinition == null) {
            tableDefinition = new TableDefinition();
            tableDefinition.setName(databaseTable.getName());
            tableDefinition.setQualifier(databaseTable.getTableQualifier());
            this.addUniqueKeyConstraints(tableDefinition, databaseTable.getUniqueConstraints());
            this.tableMap.put(databaseTable.getName(), tableDefinition);
        }
        return tableDefinition;
    }

    private DatabaseField resolveDatabaseField(DatabaseField databaseField, DatabaseField databaseField2) {
        DatabaseField databaseField3 = new DatabaseField();
        DatabaseField databaseField4 = this.databaseFields.get(databaseField2);
        databaseField3.setName(databaseField.getName());
        databaseField3.setTable(databaseField.getTable());
        if (databaseField4 != null) {
            databaseField3.setType(databaseField4.getType());
            databaseField3.setScale(databaseField4.getScale());
            databaseField3.setLength(databaseField4.getLength());
            databaseField3.setPrecision(databaseField4.getPrecision());
        }
        databaseField3.setUnique(databaseField.isUnique());
        databaseField3.setNullable(databaseField.isNullable());
        databaseField3.setUpdatable(databaseField.isUpdatable());
        databaseField3.setInsertable(databaseField.isInsertable());
        String string = databaseField.getColumnDefinition();
        if (string == null || string.trim().equals("")) {
            if (databaseField4 != null) {
                databaseField3.setColumnDefinition(databaseField4.getColumnDefinition());
            }
        } else {
            databaseField3.setColumnDefinition(string);
        }
        return databaseField3;
    }

    private FieldDefinition getFieldDefFromDBField(DatabaseField databaseField, boolean bl) {
        FieldDefinition fieldDefinition = this.fieldMap.get(databaseField);
        if (fieldDefinition == null) {
            fieldDefinition = new FieldDefinition();
            fieldDefinition.setName(databaseField.getName());
            if (databaseField.getColumnDefinition() != null && databaseField.getColumnDefinition().length() > 0) {
                fieldDefinition.setTypeDefinition(databaseField.getColumnDefinition());
            } else {
                Class clazz = databaseField.getType();
                if (clazz != null) {
                    if (clazz.equals(ClassConstants.STRING) || clazz.equals(ClassConstants.APCHAR) || clazz.equals(ClassConstants.ACHAR)) {
                        fieldDefinition.setSize(databaseField.getLength());
                    } else if (databaseField.getPrecision() > 0) {
                        fieldDefinition.setSize(databaseField.getPrecision());
                        fieldDefinition.setSubSize(databaseField.getScale());
                    }
                }
                if (clazz == null || !clazz.isPrimitive() && this.databasePlatform.getFieldTypeDefinition(clazz) == null) {
                    AbstractSessionLog.getLog().log(1, "field_type_set_to_java_lang_string", databaseField.getQualifiedName(), clazz);
                    fieldDefinition.setType(ClassConstants.STRING);
                } else {
                    fieldDefinition.setType(ConversionManager.getObjectClass(clazz));
                }
                fieldDefinition.setShouldAllowNull(databaseField.isNullable());
                fieldDefinition.setUnique(databaseField.isUnique());
            }
            fieldDefinition.setIsPrimaryKey(bl);
            this.fieldMap.put(databaseField, fieldDefinition);
            this.databaseFields.put(databaseField, databaseField);
        }
        return fieldDefinition;
    }

    private FieldDefinition getDirectCollectionReferenceKeyFieldDefFromDBField(DatabaseField databaseField) {
        FieldDefinition fieldDefinition = (FieldDefinition)this.getFieldDefFromDBField(databaseField, true).clone();
        fieldDefinition.setIsPrimaryKey(false);
        return fieldDefinition;
    }

    private void setFieldToRelationTable(DatabaseField databaseField, TableDefinition tableDefinition) {
        FieldDefinition fieldDefinition = this.getFieldDefFromDBField(databaseField, false);
        if (!tableDefinition.getFields().contains(fieldDefinition)) {
            tableDefinition.addField(this.getFieldDefFromDBField(databaseField, false));
            fieldDefinition.setIsPrimaryKey(true);
        }
    }

    private void processAdditionalTablePkFields(ClassDescriptor classDescriptor) {
        if (!classDescriptor.hasMultipleTables()) {
            return;
        }
        DatabaseTable databaseTable2 = null;
        for (DatabaseTable databaseTable2 : classDescriptor.getTables()) {
            Map<DatabaseField, DatabaseField> map = classDescriptor.getAdditionalTablePrimaryKeyFields().get(databaseTable2);
            if (null == map || map.size() <= 0) continue;
            Vector<DatabaseField> vector = new Vector<DatabaseField>();
            Vector<DatabaseField> vector2 = new Vector<DatabaseField>();
            for (DatabaseField databaseField : map.keySet()) {
                vector2.add(databaseField);
                vector.add(map.get(databaseField));
            }
            this.addJoinColumnsFkConstraint(vector, vector2);
        }
    }

    private void addJoinColumnsFkConstraint(List<DatabaseField> list, List<DatabaseField> list2) {
        Cloneable cloneable;
        assert (list.size() == list2.size());
        if (list.size() == 0) {
            return;
        }
        DatabaseField databaseField = null;
        DatabaseField databaseField2 = null;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        DatabaseTable databaseTable = list.get(0).getTable();
        TableDefinition tableDefinition = this.getTableDefFromDBTable(databaseTable);
        for (int i = 0; i < list.size(); ++i) {
            databaseField = list.get(i);
            databaseField2 = list2.get(i);
            vector.add(databaseField.getName());
            vector2.add(databaseField2.getName());
            cloneable = this.fieldMap.get(databaseField);
            FieldDefinition fieldDefinition = this.fieldMap.get(databaseField2);
            if (fieldDefinition == null) continue;
            if (cloneable == null) {
                cloneable = this.getFieldDefFromDBField(databaseField, false);
                if (!tableDefinition.getFields().contains(cloneable)) {
                    tableDefinition.addField((FieldDefinition)cloneable);
                }
            }
            ((FieldDefinition)cloneable).setType(fieldDefinition.getType());
            ((FieldDefinition)cloneable).setSize(fieldDefinition.getSize());
            ((FieldDefinition)cloneable).setSubSize(fieldDefinition.getSubSize());
        }
        DatabaseTable databaseTable2 = databaseField2.getTable();
        cloneable = this.getTableDefFromDBTable(databaseTable2);
        this.addForeignKeyConstraint(tableDefinition, (TableDefinition)cloneable, vector, vector2);
    }

    private void addForeignKeyConstraint(TableDefinition tableDefinition, TableDefinition tableDefinition2, Vector<String> vector, Vector<String> vector2) {
        if (!this.generateFKConstraints) {
            return;
        }
        assert (vector.size() > 0 && vector.size() == vector2.size());
        Vector<String> vector3 = vector;
        Object object = vector2;
        if (vector.size() > 1) {
            Object object2;
            boolean bl = false;
            boolean bl2 = false;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = 0; i < vector.size(); ++i) {
                object2 = vector2.get(i);
                if (hashMap.containsKey(object2)) {
                    bl2 = true;
                    break;
                }
                hashMap.put((String)object2, vector.get(i));
            }
            Vector<String> vector4 = new Vector<String>(vector.size());
            object2 = new Vector(vector2.size());
            if (!bl2) {
                bl = true;
                for (String object3 : tableDefinition2.getPrimaryKeyFieldNames()) {
                    String string = (String)hashMap.get(object3);
                    if (string == null) {
                        bl = false;
                        break;
                    }
                    vector4.add(string);
                    ((Vector)object2).add(object3);
                }
            }
            if (!bl2 && !bl) {
                for (UniqueKeyConstraint uniqueKeyConstraint : tableDefinition2.getUniqueKeys()) {
                    vector4.setSize(0);
                    ((Vector)object2).setSize(0);
                    bl = true;
                    for (String string : uniqueKeyConstraint.getSourceFields()) {
                        String string2 = (String)hashMap.get(string);
                        if (string2 == null) {
                            bl = false;
                            break;
                        }
                        vector4.add(string2);
                        ((Vector)object2).add(string);
                    }
                    if (!bl) continue;
                    break;
                }
            }
            if (bl) {
                vector3 = vector4;
                object = object2;
            }
        }
        ForeignKeyConstraint foreignKeyConstraint = tableDefinition.buildForeignKeyConstraint(vector3, (Vector)object, tableDefinition2, this.databasePlatform);
        tableDefinition.addForeignKeyConstraint(foreignKeyConstraint);
    }

    private void addUniqueKeyConstraints(TableDefinition tableDefinition, Vector<List<String>> vector) {
        int n = 0;
        for (List<String> list : vector) {
            if (list == null) continue;
            UniqueKeyConstraint uniqueKeyConstraint = tableDefinition.buildUniqueKeyConstraint(list, n++, this.databasePlatform);
            tableDefinition.addUniqueKeyConstraint(uniqueKeyConstraint);
        }
    }
}

