/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.transaction;

import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.eclipse.persistence.exceptions.TransactionException;
import org.eclipse.persistence.transaction.AbstractSynchronizationListener;
import org.eclipse.persistence.transaction.AbstractTransactionController;
import org.eclipse.persistence.transaction.JTASynchronizationListener;

public class JTATransactionController
extends AbstractTransactionController {
    protected TransactionManager transactionManager;
    static String[] codes = new String[]{"STATUS_ACTIVE", "MARKED_ROLLBACK", "PREPARED", "COMMITTED", "ROLLEDBACK", "UNKNOWN", "NO_TRANSACTION", "PREPARING", "COMMITTING", "ROLLING_BACK"};

    public JTATransactionController() {
        this.listenerFactory = new JTASynchronizationListener();
        try {
            this.transactionManager = this.acquireTransactionManager();
        }
        catch (Exception exception) {
            throw TransactionException.errorObtainingTransactionManager(exception);
        }
    }

    protected void registerSynchronization_impl(AbstractSynchronizationListener abstractSynchronizationListener, Object object) throws Exception {
        ((Transaction)object).registerSynchronization((Synchronization)abstractSynchronizationListener);
    }

    protected Object getTransaction_impl() throws Exception {
        return this.getTransactionManager().getTransaction();
    }

    protected Object getTransactionKey_impl(Object object) throws Exception {
        return object;
    }

    protected Object getTransactionStatus_impl() throws Exception {
        return new Integer(this.getTransactionManager().getStatus());
    }

    protected void beginTransaction_impl() throws Exception {
        this.getTransactionManager().begin();
    }

    protected void commitTransaction_impl() throws Exception {
        this.getTransactionManager().commit();
    }

    protected void rollbackTransaction_impl() throws Exception {
        this.getTransactionManager().rollback();
    }

    protected void markTransactionForRollback_impl() throws Exception {
        this.getTransactionManager().setRollbackOnly();
    }

    protected boolean canBeginTransaction_impl(Object object) {
        return this.getIntStatus(object) == 6;
    }

    protected boolean canCommitTransaction_impl(Object object) {
        return this.getIntStatus(object) == 0;
    }

    protected boolean canRollbackTransaction_impl(Object object) {
        return this.getIntStatus(object) == 0;
    }

    protected boolean canIssueSQLToDatabase_impl(Object object) {
        int n = this.getIntStatus(object);
        return n == 0 || n == 7;
    }

    protected boolean canMergeUnitOfWork_impl(Object object) {
        return this.getIntStatus(object) == 3;
    }

    public boolean isRolledBack_impl(Object object) {
        return this.getIntStatus(object) == 4;
    }

    protected TransactionManager acquireTransactionManager() throws Exception {
        return null;
    }

    protected int getIntStatus(Object object) {
        return (Integer)object;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    protected String statusToString_impl(Object object) {
        int n = this.getIntStatus(object);
        return codes[n];
    }
}

