/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.annotations.Converter;
import org.eclipse.persistence.annotations.ObjectTypeConverter;
import org.eclipse.persistence.annotations.StructConverter;
import org.eclipse.persistence.annotations.TypeConverter;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.PropertyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnsMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.ConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.ObjectTypeConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.StructConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.TypeConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.TableMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetadataAccessor
extends ORMetadata {
    private boolean m_isProcessed = false;
    private String m_access;
    private List<ConverterMetadata> m_converters = new ArrayList<ConverterMetadata>();
    private List<ObjectTypeConverterMetadata> m_objectTypeConverters = new ArrayList<ObjectTypeConverterMetadata>();
    private List<StructConverterMetadata> m_structConverters = new ArrayList<StructConverterMetadata>();
    private List<TypeConverterMetadata> m_typeConverters = new ArrayList<TypeConverterMetadata>();
    private List<PropertyMetadata> m_properties = new ArrayList<PropertyMetadata>();
    private MetadataDescriptor m_descriptor;
    private MetadataDescriptor m_owningDescriptor;
    private MetadataProject m_project;
    private String m_name;

    public MetadataAccessor(String string) {
        super(string);
    }

    public MetadataAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, MetadataDescriptor metadataDescriptor, MetadataProject metadataProject) {
        super(annotation, metadataAccessibleObject);
        this.m_project = metadataProject;
        this.m_descriptor = metadataDescriptor;
        this.initAccess();
    }

    public String getAccess() {
        return this.m_access;
    }

    @Override
    public MetadataAnnotatedElement getAccessibleObject() {
        return (MetadataAnnotatedElement)super.getAccessibleObject();
    }

    public String getAccessibleObjectName() {
        return this.getAccessibleObject().getName();
    }

    public AnnotatedElement getAnnotatedElement() {
        return this.getAccessibleObject().getAnnotatedElement();
    }

    public String getAnnotatedElementName() {
        return this.getAnnotatedElement().toString();
    }

    protected <T extends Annotation> T getAnnotation(Class clazz) {
        return this.getAnnotation(clazz.getName());
    }

    protected <T extends Annotation> T getAnnotation(String string) {
        return this.getAccessibleObject().getAnnotation(string, this.m_descriptor);
    }

    public String getAttributeName() {
        return this.getAccessibleObject().getAttributeName();
    }

    public List<ConverterMetadata> getConverters() {
        return this.m_converters;
    }

    public MetadataDescriptor getDescriptor() {
        return this.m_descriptor;
    }

    @Override
    public String getIdentifier() {
        return this.getName();
    }

    public Class getJavaClass() {
        return this.m_descriptor.getJavaClass();
    }

    protected String getJavaClassName() {
        return this.getJavaClass().getName();
    }

    public MetadataLogger getLogger() {
        return this.m_project.getLogger();
    }

    public String getName() {
        return this.m_name;
    }

    protected String getName(DatabaseField databaseField, String string, String string2) {
        return this.getName(databaseField.getName(), string, string2);
    }

    protected String getName(String string, String string2, String string3) {
        return org.eclipse.persistence.internal.jpa.metadata.MetadataHelper.getName(string, string2, string3, this.getLogger(), this.getAnnotatedElement().toString());
    }

    public List<ObjectTypeConverterMetadata> getObjectTypeConverters() {
        return this.m_objectTypeConverters;
    }

    public MetadataDescriptor getOwningDescriptor() {
        if (this.m_owningDescriptor == null) {
            return this.getDescriptor();
        }
        return this.m_owningDescriptor;
    }

    public MetadataProject getProject() {
        return this.m_project;
    }

    public List<PropertyMetadata> getProperties() {
        return this.m_properties;
    }

    public List<StructConverterMetadata> getStructConverters() {
        return this.m_structConverters;
    }

    public List<TypeConverterMetadata> getTypeConverters() {
        return this.m_typeConverters;
    }

    protected String getUpperCaseAttributeName() {
        return this.getAttributeName().toUpperCase();
    }

    protected String getUpperCaseShortJavaClassName() {
        return Helper.getShortClassName((String)this.getJavaClassName()).toUpperCase();
    }

    protected Integer getValue(Integer n, Integer n2) {
        return org.eclipse.persistence.internal.jpa.metadata.MetadataHelper.getValue(n, n2);
    }

    protected String getValue(String string, String string2) {
        return org.eclipse.persistence.internal.jpa.metadata.MetadataHelper.getValue(string, string2);
    }

    public boolean hasAccess() {
        return this.m_access != null;
    }

    public boolean hasPropertyAccess() {
        return this.hasAccess() && this.m_access.equals("PROPERTY");
    }

    public void initAccess() {
        Object t;
        if (this.m_access == null && (t = this.getAnnotation("javax.persistence.Access")) != null) {
            this.setAccess(((Enum)MetadataHelper.invokeMethod("value", t)).name());
        }
    }

    public void initXMLAccessor(MetadataDescriptor metadataDescriptor, MetadataProject metadataProject) {
        this.m_project = metadataProject;
        this.m_descriptor = metadataDescriptor;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.initXMLObjects(this.m_converters, metadataAccessibleObject);
        this.initXMLObjects(this.m_objectTypeConverters, metadataAccessibleObject);
        this.initXMLObjects(this.m_structConverters, metadataAccessibleObject);
        this.initXMLObjects(this.m_typeConverters, metadataAccessibleObject);
        this.initXMLObjects(this.m_properties, metadataAccessibleObject);
    }

    protected boolean isAnnotationPresent(Class<? extends Annotation> clazz) {
        return this.getAccessibleObject().isAnnotationPresent(clazz, this.m_descriptor);
    }

    public boolean isProcessed() {
        return this.m_isProcessed;
    }

    @Override
    public void merge(ORMetadata oRMetadata) {
        MetadataAccessor metadataAccessor = (MetadataAccessor)oRMetadata;
        this.m_access = (String)this.mergeSimpleObjects(this.m_access, metadataAccessor.getAccess(), metadataAccessor.getAccessibleObject(), "@access");
        this.m_converters = this.mergeORObjectLists(this.m_converters, metadataAccessor.getConverters());
        this.m_objectTypeConverters = this.mergeORObjectLists(this.m_objectTypeConverters, metadataAccessor.getObjectTypeConverters());
        this.m_structConverters = this.mergeORObjectLists(this.m_structConverters, metadataAccessor.getStructConverters());
        this.m_typeConverters = this.mergeORObjectLists(this.m_typeConverters, metadataAccessor.getTypeConverters());
        this.m_properties = this.mergeORObjectLists(this.m_properties, metadataAccessor.getProperties());
    }

    public abstract void process();

    public void processConverters() {
        this.processCustomConverters();
        this.processObjectTypeConverters();
        this.processTypeConverters();
        this.processStructConverter();
    }

    protected void processCustomConverters() {
        for (ConverterMetadata converterMetadata : this.m_converters) {
            this.m_project.addConverter(converterMetadata);
        }
        Iterator<ConverterMetadata> iterator = this.getAnnotation(Converter.class);
        if (iterator != null) {
            this.m_project.addConverter(new ConverterMetadata((Annotation)((Object)iterator), this.getAccessibleObject()));
        }
    }

    protected void processObjectTypeConverters() {
        for (ObjectTypeConverterMetadata objectTypeConverterMetadata : this.m_objectTypeConverters) {
            this.m_project.addConverter(objectTypeConverterMetadata);
        }
        Iterator<ObjectTypeConverterMetadata> iterator = this.getAnnotation(ObjectTypeConverter.class);
        if (iterator != null) {
            this.m_project.addConverter(new ObjectTypeConverterMetadata((Annotation)((Object)iterator), this.getAccessibleObject()));
        }
    }

    protected List<PrimaryKeyJoinColumnMetadata> processPrimaryKeyJoinColumns(PrimaryKeyJoinColumnsMetadata primaryKeyJoinColumnsMetadata) {
        List<PrimaryKeyJoinColumnMetadata> list = primaryKeyJoinColumnsMetadata.values(this.m_descriptor);
        if (this.m_descriptor.hasCompositePrimaryKey()) {
            if (list.size() != this.m_descriptor.getPrimaryKeyFields().size()) {
                throw ValidationException.incompletePrimaryKeyJoinColumnsSpecified((Object)this.getAnnotatedElement());
            }
            for (PrimaryKeyJoinColumnMetadata primaryKeyJoinColumnMetadata : list) {
                if (!primaryKeyJoinColumnMetadata.isPrimaryKeyFieldNotSpecified() && !primaryKeyJoinColumnMetadata.isForeignKeyFieldNotSpecified()) continue;
                throw ValidationException.incompletePrimaryKeyJoinColumnsSpecified((Object)this.getAnnotatedElement());
            }
        } else if (list.size() > 1) {
            throw ValidationException.excessivePrimaryKeyJoinColumnsSpecified((Object)this.getAnnotatedElement());
        }
        return list;
    }

    protected void processStructConverter() {
        for (StructConverterMetadata structConverterMetadata : this.m_structConverters) {
            this.m_project.addConverter(structConverterMetadata);
        }
        Iterator<StructConverterMetadata> iterator = this.getAnnotation(StructConverter.class);
        if (iterator != null) {
            this.m_project.addConverter(new StructConverterMetadata((Annotation)((Object)iterator), this.getAccessibleObject()));
        }
    }

    protected void processTable(TableMetadata tableMetadata, String string) {
        this.getProject().processTable(tableMetadata, string, this.m_descriptor.getDefaultCatalog(), this.m_descriptor.getDefaultSchema());
    }

    protected void processTypeConverters() {
        for (TypeConverterMetadata typeConverterMetadata : this.m_typeConverters) {
            this.m_project.addConverter(typeConverterMetadata);
        }
        Iterator<TypeConverterMetadata> iterator = this.getAnnotation(TypeConverter.class);
        if (iterator != null) {
            this.m_project.addConverter(new TypeConverterMetadata((Annotation)((Object)iterator), this.getAccessibleObject()));
        }
    }

    public void setAccess(String string) {
        this.m_access = string;
    }

    public void setConverters(List<ConverterMetadata> list) {
        this.m_converters = list;
    }

    public void setDescriptor(MetadataDescriptor metadataDescriptor) {
        this.m_descriptor = metadataDescriptor;
    }

    public void setIsProcessed() {
        this.m_isProcessed = true;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public void setObjectTypeConverters(List<ObjectTypeConverterMetadata> list) {
        this.m_objectTypeConverters = list;
    }

    public void setOwningDescriptor(MetadataDescriptor metadataDescriptor) {
        this.m_owningDescriptor = metadataDescriptor;
    }

    public void setProperties(List<PropertyMetadata> list) {
        this.m_properties = list;
    }

    public void setStructConverters(List<StructConverterMetadata> list) {
        this.m_structConverters = list;
    }

    public void setTypeConverters(List<TypeConverterMetadata> list) {
        this.m_typeConverters = list;
    }
}

