/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.CollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.UnidirectionalOneToManyMapping;

public class OneToManyAccessor
extends CollectionAccessor {
    public OneToManyAccessor() {
        super("<one-to-many>");
    }

    public OneToManyAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor);
    }

    protected String getLoggingContext() {
        return "metadata_default_one_to_many_reference_class";
    }

    public boolean isOneToMany() {
        return true;
    }

    public void process() {
        super.process();
        if (this.getMappedBy() == null || this.getMappedBy().equals("")) {
            if (!this.getJoinColumns().isEmpty()) {
                UnidirectionalOneToManyMapping unidirectionalOneToManyMapping = new UnidirectionalOneToManyMapping();
                this.process((CollectionMapping)unidirectionalOneToManyMapping);
                this.processUnidirectionalOneToManyTargetForeignKeyRelationship(unidirectionalOneToManyMapping);
                this.processProperties((DatabaseMapping)unidirectionalOneToManyMapping);
                this.getDescriptor().addMapping((DatabaseMapping)unidirectionalOneToManyMapping);
            } else {
                ManyToManyMapping manyToManyMapping = new ManyToManyMapping();
                this.process((CollectionMapping)manyToManyMapping);
                this.processJoinTable(manyToManyMapping);
                this.processProperties((DatabaseMapping)manyToManyMapping);
                this.getDescriptor().addMapping((DatabaseMapping)manyToManyMapping);
            }
        } else {
            OneToManyMapping oneToManyMapping = new OneToManyMapping();
            this.process((CollectionMapping)oneToManyMapping);
            OneToOneMapping oneToOneMapping = null;
            if (!this.getOwningMapping(this.getMappedBy()).isOneToOneMapping()) {
                throw ValidationException.invalidMapping((Class)this.getJavaClass(), (Class)this.getReferenceClass());
            }
            oneToOneMapping = (OneToOneMapping)this.getOwningMapping(this.getMappedBy());
            Map map = oneToOneMapping.getSourceToTargetKeyFields();
            for (DatabaseField databaseField : map.keySet()) {
                DatabaseField databaseField2 = (DatabaseField)map.get(databaseField);
                if (this.getDescriptor().usesTablePerClassInheritanceStrategy() && !databaseField2.getTable().equals(this.getDescriptor().getPrimaryTable())) {
                    databaseField2 = (DatabaseField)databaseField2.clone();
                    databaseField2.setTable(this.getDescriptor().getPrimaryTable());
                }
                oneToManyMapping.addTargetForeignKeyField(databaseField, databaseField2);
            }
            this.processProperties((DatabaseMapping)oneToManyMapping);
            this.getDescriptor().addMapping((DatabaseMapping)oneToManyMapping);
        }
    }
}

