/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.locking;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.annotations.OptimisticLockingType;
import org.eclipse.persistence.descriptors.AllFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.ChangedFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.SelectedFieldsLockingPolicy;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.locking.MetadataHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimisticLockingMetadata
extends ORMetadata {
    private Boolean m_cascade;
    private List<ColumnMetadata> m_selectedColumns = new ArrayList<ColumnMetadata>();
    private Enum m_type;

    public OptimisticLockingMetadata() {
        super("<optimistic-locking>");
    }

    public OptimisticLockingMetadata(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject) {
        super(annotation, metadataAccessibleObject);
        this.m_type = (Enum)MetadataHelper.invokeMethod("type", annotation);
        this.m_cascade = (Boolean)MetadataHelper.invokeMethod("cascade", annotation);
        for (Annotation annotation2 : (Annotation[])MetadataHelper.invokeMethod("selectedColumns", annotation)) {
            this.m_selectedColumns.add(new ColumnMetadata(annotation2, metadataAccessibleObject));
        }
    }

    public Boolean getCascade() {
        return this.m_cascade;
    }

    public List<ColumnMetadata> getSelectedColumns() {
        return this.m_selectedColumns;
    }

    public Enum getType() {
        return this.m_type;
    }

    public boolean hasSelectedColumns() {
        return !this.m_selectedColumns.isEmpty();
    }

    public void process(MetadataDescriptor metadataDescriptor) {
        if (this.m_type == null || this.m_type.name().equals(OptimisticLockingType.VERSION_COLUMN.name())) {
            metadataDescriptor.setUsesCascadedOptimisticLocking(this.m_cascade != null && this.m_cascade != false);
        } else if (this.m_type.name().equals(OptimisticLockingType.ALL_COLUMNS.name())) {
            metadataDescriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)new AllFieldsLockingPolicy());
        } else if (this.m_type.name().equals(OptimisticLockingType.CHANGED_COLUMNS.name())) {
            metadataDescriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)new ChangedFieldsLockingPolicy());
        } else if (this.m_type.name().equals(OptimisticLockingType.SELECTED_COLUMNS.name())) {
            if (this.m_selectedColumns.isEmpty()) {
                throw ValidationException.optimisticLockingSelectedColumnNamesNotSpecified((Class)metadataDescriptor.getJavaClass());
            }
            SelectedFieldsLockingPolicy selectedFieldsLockingPolicy = new SelectedFieldsLockingPolicy();
            for (ColumnMetadata columnMetadata : this.m_selectedColumns) {
                if (columnMetadata.getName().equals("")) {
                    throw ValidationException.optimisticLockingSelectedColumnNamesNotSpecified((Class)metadataDescriptor.getJavaClass());
                }
                selectedFieldsLockingPolicy.addLockFieldName(columnMetadata.getName());
            }
            metadataDescriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)selectedFieldsLockingPolicy);
        }
    }

    public void setCascade(Boolean bl) {
        this.m_cascade = bl;
    }

    public void setSelectedColumns(List<ColumnMetadata> list) {
        this.m_selectedColumns = list;
    }

    public void setType(Enum enum_) {
        this.m_type = enum_;
    }
}

