/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappingsMappingProject;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.sessions.Project;
import org.xml.sax.SAXException;

public class XMLEntityMappingsReader {
    public static final String ORM_1_0_XSD = "org/eclipse/persistence/jpa/orm_1_0.xsd";
    public static final String ORM_1_0_NAMESPACE = "http://java.sun.com/xml/ns/persistence/orm";
    public static final String ECLIPSELINK_ORM_XSD_VERSION = "1.1";
    public static final String ECLIPSELINK_ORM_XSD_NAME = "eclipselink_orm_1_1.xsd";
    public static final String ECLIPSELINK_ORM_XSD = "xsd/eclipselink_orm_1_1.xsd";
    public static final String ECLIPSELINK_ORM_NAMESPACE = "http://www.eclipse.org/eclipselink/xsds/persistence/orm";
    private static XMLContext m_orm1_0Project;
    private static XMLContext m_eclipseLinkOrmProject;

    protected static XMLEntityMappings read(URL uRL, Reader reader, Reader reader2, ClassLoader classLoader, Properties properties) {
        XMLEntityMappings xMLEntityMappings;
        boolean bl = XMLEntityMappingsReader.isORMSchemaValidationPerformed(properties);
        if (m_orm1_0Project == null) {
            m_orm1_0Project = new XMLContext((Project)new XMLEntityMappingsMappingProject(ORM_1_0_NAMESPACE, ORM_1_0_XSD));
            m_eclipseLinkOrmProject = new XMLContext((Project)new XMLEntityMappingsMappingProject(ECLIPSELINK_ORM_NAMESPACE, ECLIPSELINK_ORM_XSD));
        }
        try {
            XMLUnmarshaller xMLUnmarshaller = m_orm1_0Project.createUnmarshaller();
            XMLEntityMappingsReader.useLocalSchemaForUnmarshaller(xMLUnmarshaller, ORM_1_0_XSD, bl);
            xMLEntityMappings = (XMLEntityMappings)xMLUnmarshaller.unmarshal(reader);
        }
        catch (Exception exception) {
            try {
                XMLUnmarshaller xMLUnmarshaller = m_eclipseLinkOrmProject.createUnmarshaller();
                XMLEntityMappingsReader.useLocalSchemaForUnmarshaller(xMLUnmarshaller, ECLIPSELINK_ORM_XSD, bl);
                xMLEntityMappings = (XMLEntityMappings)xMLUnmarshaller.unmarshal(reader2);
            }
            catch (Exception exception2) {
                throw ValidationException.errorParsingMappingFile((URL)uRL, (Exception)exception2);
            }
        }
        return xMLEntityMappings;
    }

    private static InputStreamReader getInputStreamReader(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setUseCaches(false);
        return new InputStreamReader(uRLConnection.getInputStream(), "UTF-8");
    }

    public static XMLEntityMappings read(URL uRL, ClassLoader classLoader) throws IOException {
        return XMLEntityMappingsReader.read(uRL, classLoader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLEntityMappings read(URL uRL, ClassLoader classLoader, Properties properties) throws IOException {
        InputStreamReader inputStreamReader = null;
        InputStreamReader inputStreamReader2 = null;
        try {
            try {
                inputStreamReader = XMLEntityMappingsReader.getInputStreamReader(uRL);
                inputStreamReader2 = XMLEntityMappingsReader.getInputStreamReader(uRL);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw ValidationException.fatalErrorOccurred((Exception)unsupportedEncodingException);
            }
            XMLEntityMappings xMLEntityMappings = XMLEntityMappingsReader.read(uRL, inputStreamReader, inputStreamReader2, classLoader, properties);
            xMLEntityMappings.setMappingFile(uRL);
            XMLEntityMappings xMLEntityMappings2 = xMLEntityMappings;
            return xMLEntityMappings2;
        }
        finally {
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (inputStreamReader2 != null) {
                    inputStreamReader2.close();
                }
            }
            catch (IOException iOException) {
                throw ValidationException.fileError((IOException)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void useLocalSchemaForUnmarshaller(XMLUnmarshaller xMLUnmarshaller, String string, boolean bl) throws IOException, SAXException {
        URL uRL = XMLEntityMappingsReader.class.getClassLoader().getResource(string);
        InputStream inputStream = uRL.openStream();
        StreamSource streamSource = new StreamSource(uRL.openStream());
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(streamSource);
        try {
            if (bl) {
                xMLUnmarshaller.setSchema(schema);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            if (bl) {
                xMLUnmarshaller.setValidationMode(3);
            } else {
                xMLUnmarshaller.setValidationMode(0);
            }
        }
        finally {
            inputStream.close();
        }
    }

    private static boolean isORMSchemaValidationPerformed(Properties properties) {
        String string = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.orm.validate.schema", properties, "false");
        return null != string && string.equalsIgnoreCase("true");
    }
}

