/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.ValueStore;

public class DefaultValueStore
implements ValueStore {
    private Map openContentValues;
    private Object[] typePropertyValues;
    private boolean[] typePropertiesIsSetStatus;
    private DataObject dataObject;

    public Object getDeclaredProperty(int n) {
        if (this.typePropertyValues != null) {
            return this.typePropertyValues[n];
        }
        return null;
    }

    public Object getOpenContentProperty(Property property) {
        return this.getOpenContentValues().get(property);
    }

    public void setDeclaredProperty(int n, Object object) {
        this.getTypePropertyValues()[n] = object;
        this.getTypePropertiesIsSetStatus()[n] = true;
    }

    public void setOpenContentProperty(Property property, Object object) {
        this.getOpenContentValues().put(property, object);
    }

    public boolean isSetDeclaredProperty(int n) {
        return this.getTypePropertiesIsSetStatus()[n];
    }

    public boolean isSetOpenContentProperty(Property property) {
        return this.getOpenContentValues().containsKey(property);
    }

    public void unsetDeclaredProperty(int n) {
        SDOProperty sDOProperty = ((SDODataObject)this.dataObject).getInstanceProperty(n);
        if (!sDOProperty.isMany()) {
            this.getTypePropertyValues()[n] = null;
        }
        this.getTypePropertiesIsSetStatus()[n] = false;
    }

    public void unsetOpenContentProperty(Property property) {
        this.getOpenContentValues().remove(property);
    }

    public void initialize(DataObject dataObject) {
        this.dataObject = dataObject;
        this.setTypePropertiesIsSetStatus(new boolean[dataObject.getType().getProperties().size()]);
        this.setTypePropertyValues(new Object[dataObject.getType().getProperties().size()]);
    }

    public void setTypePropertyValues(Object[] objectArray) {
        this.typePropertyValues = objectArray;
    }

    public void setTypePropertiesIsSetStatus(boolean[] blArray) {
        this.typePropertiesIsSetStatus = blArray;
    }

    public Object[] getTypePropertyValues() {
        return this.typePropertyValues;
    }

    public boolean[] getTypePropertiesIsSetStatus() {
        return this.typePropertiesIsSetStatus;
    }

    public void setOpenContentValues(Map map) {
        this.openContentValues = map;
    }

    public Map getOpenContentValues() {
        if (this.openContentValues == null) {
            this.openContentValues = new HashMap();
        }
        return this.openContentValues;
    }

    public void setManyProperty(Property property, Object object) {
    }

    public ValueStore copy() {
        DefaultValueStore defaultValueStore = new DefaultValueStore();
        defaultValueStore.dataObject = this.dataObject;
        boolean[] blArray = this.getTypePropertiesIsSetStatus();
        boolean[] blArray2 = new boolean[blArray.length];
        System.arraycopy(blArray, 0, blArray2, 0, blArray.length);
        Object[] objectArray = this.getTypePropertyValues();
        Object[] objectArray2 = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        defaultValueStore.setTypePropertiesIsSetStatus(blArray2);
        defaultValueStore.setTypePropertyValues(objectArray2);
        HashMap hashMap = new HashMap();
        hashMap.putAll(this.getOpenContentValues());
        defaultValueStore.setOpenContentValues(hashMap);
        return defaultValueStore;
    }

    public boolean equals(Object object) {
        Object object2;
        DefaultValueStore defaultValueStore;
        try {
            defaultValueStore = (DefaultValueStore)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (defaultValueStore.dataObject != this.dataObject) {
            return false;
        }
        if (defaultValueStore.getTypePropertyValues().length != this.getTypePropertyValues().length || defaultValueStore.getTypePropertiesIsSetStatus().length != this.getTypePropertiesIsSetStatus().length) {
            return false;
        }
        for (int i = 0; i < defaultValueStore.getTypePropertyValues().length; ++i) {
            if (defaultValueStore.isSetDeclaredProperty(i) != this.isSetDeclaredProperty(i)) {
                return false;
            }
            Object object3 = defaultValueStore.getDeclaredProperty(i);
            object2 = this.getDeclaredProperty(i);
            if (!(object3 == null ? object2 != null : !object3.equals(object2))) continue;
            return false;
        }
        if (defaultValueStore.getOpenContentValues().size() != this.getOpenContentValues().size()) {
            return false;
        }
        for (Object object3 : defaultValueStore.getOpenContentValues().keySet()) {
            object2 = defaultValueStore.getOpenContentProperty((Property)object3);
            Object object4 = this.getOpenContentProperty((Property)object3);
            if (!(object2 == null ? object4 != null : !object2.equals(object4))) continue;
            return false;
        }
        return true;
    }
}

