/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.helper.HelperContext;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;

public class DynamicClassWriter {
    private Class parentClass;
    private String className;
    private SDOType type;
    private HelperContext aHelperContext;

    public DynamicClassWriter(String string, SDOType sDOType, HelperContext helperContext) {
        this.aHelperContext = helperContext;
        this.parentClass = SDODataObject.class;
        this.className = string;
        this.type = sDOType;
        this.initializeParentClass();
    }

    private void initializeParentClass() {
        if (this.type.isSubType()) {
            SDOType sDOType = (SDOType)this.type.getBaseTypes().get(0);
            String string = sDOType.getInstanceClassName() + "Impl";
            try {
                this.parentClass = ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getLoader().loadClass(string, sDOType);
            }
            catch (Exception exception) {
                this.parentClass = null;
            }
            if (this.parentClass == null) {
                this.parentClass = SDODataObject.class;
            }
        } else {
            this.parentClass = SDODataObject.class;
        }
    }

    public Class getParentClass() {
        return this.parentClass;
    }

    public String getClassName() {
        return this.className;
    }

    public byte[] createClass() {
        ClassWriter classWriter = new ClassWriter(false);
        classWriter.visit(49, 33, this.className.replace('.', '/'), Type.getType((Class)this.parentClass).getInternalName(), null, null);
        this.addConstructors(classWriter);
        this.addWriteReplace(classWriter);
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    private void addConstructors(ClassWriter classWriter) {
        CodeVisitor codeVisitor = classWriter.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), new String[]{Type.getInternalName(Serializable.class)}, null);
        codeVisitor.visitVarInsn(25, 0);
        codeVisitor.visitMethodInsn(183, Type.getType((Class)this.parentClass).getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]));
        codeVisitor.visitInsn(177);
        codeVisitor.visitMaxs(1, 1);
    }

    private void addWriteReplace(ClassWriter classWriter) {
        Method method;
        try {
            method = this.parentClass.getDeclaredMethod("writeReplace", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return;
        }
        CodeVisitor codeVisitor = classWriter.visitMethod(4, method.getName(), Type.getMethodDescriptor((Method)method), new String[]{Type.getInternalName(ObjectStreamException.class)}, null);
        codeVisitor.visitVarInsn(25, 0);
        codeVisitor.visitMethodInsn(183, Type.getInternalName((Class)this.parentClass), method.getName(), Type.getMethodDescriptor((Method)method));
        codeVisitor.visitInsn(176);
        codeVisitor.visitMaxs(1, 1);
    }
}

