/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.sessions.Session;

public class InstanceClassConverter
implements Converter {
    private Class customClass;

    public Object convertObjectValueToDataValue(Object object, Session session) {
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    public Object convertDataValueToObjectValue(Object object, Session session) {
        if (object != null) {
            Class[] classArray = new Class[]{String.class};
            Constructor constructor = null;
            try {
                constructor = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Constructor)AccessController.doPrivileged(new PrivilegedGetDeclaredConstructorFor(this.customClass, classArray, true)) : PrivilegedAccessHelper.getDeclaredConstructorFor((Class)this.customClass, (Class[])classArray, (boolean)true);
                Object[] objectArray = new Object[]{object.toString()};
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    return AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, objectArray));
                }
                return PrivilegedAccessHelper.invokeConstructor((Constructor)constructor, (Object[])objectArray);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw SDOException.noConstructorWithString((Exception)privilegedActionException, (String)this.customClass.getName());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw SDOException.noConstructorWithString((Exception)noSuchMethodException, (String)this.customClass.getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw SDOException.noConstructorWithString((Exception)illegalAccessException, (String)this.customClass.getName());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw SDOException.noConstructorWithString((Exception)invocationTargetException, (String)this.customClass.getName());
            }
            catch (InstantiationException instantiationException) {
                throw SDOException.noConstructorWithString((Exception)instantiationException, (String)this.customClass.getName());
            }
        }
        return null;
    }

    public boolean isMutable() {
        return true;
    }

    public void initialize(DatabaseMapping databaseMapping, Session session) {
    }

    public void setCustomClass(Class clazz) {
        this.customClass = clazz;
    }

    public Class getCustomClass() {
        return this.customClass;
    }
}

