/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.helper.HelperContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.DynamicClassWriter;

public class SDOClassLoader
extends ClassLoader {
    private ClassLoader delegateLoader;
    private Map generatedClasses;
    private HelperContext aHelperContext;

    public SDOClassLoader(ClassLoader classLoader, HelperContext helperContext) {
        this.aHelperContext = helperContext;
        this.delegateLoader = classLoader;
        this.generatedClasses = new HashMap();
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        clazz = (Class<?>)this.generatedClasses.get(string);
        if (clazz != null) {
            return clazz;
        }
        try {
            clazz = this.delegateLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw noClassDefFoundError;
        }
        return clazz;
    }

    public Class loadClass(String string, SDOType sDOType) throws ClassNotFoundException {
        Class clazz;
        block5: {
            clazz = null;
            clazz = (Class)this.generatedClasses.get(string);
            if (clazz != null) {
                return clazz;
            }
            try {
                clazz = this.delegateLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = this.createGeneric(string, sDOType);
                if (clazz == null) {
                    throw classNotFoundException;
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                clazz = this.createGeneric(string, sDOType);
                if (clazz != null) break block5;
                throw noClassDefFoundError;
            }
        }
        return clazz;
    }

    public Class createGeneric(String string, SDOType sDOType) {
        Class<?> clazz = (Class<?>)this.generatedClasses.get(string);
        if (clazz != null) {
            return clazz;
        }
        if (string == null) {
            return null;
        }
        DynamicClassWriter dynamicClassWriter = new DynamicClassWriter(string, sDOType, this.aHelperContext);
        byte[] byArray = dynamicClassWriter.createClass();
        clazz = this.defineClass(string, byArray, 0, byArray.length);
        this.generatedClasses.put(string, clazz);
        return clazz;
    }

    public void setDelegateLoader(ClassLoader classLoader) {
        this.delegateLoader = classLoader;
    }

    public ClassLoader getDelegateLoader() {
        return this.delegateLoader;
    }

    public URL getResource(String string) {
        return this.delegateLoader.getResource(string);
    }

    public InputStream getResourceAsStream(String string) {
        return this.delegateLoader.getResourceAsStream(string);
    }

    public Enumeration getResources(String string) throws IOException {
        return this.delegateLoader.getResources(string);
    }
}

