/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;

public class SDOMethodAttributeAccessor
extends MethodAttributeAccessor {
    protected Class attributeClass;
    protected SDOProperty property;

    public SDOMethodAttributeAccessor(Property property) {
        this.setProperty(property);
    }

    public SDOMethodAttributeAccessor(Property property, Class clazz) {
        this.setProperty(property);
        this.attributeClass = clazz;
    }

    public Class getAttributeClass() {
        if (this.attributeClass != null) {
            return this.attributeClass;
        }
        return Object.class;
    }

    public Object getAttributeValueFromObject(Object object) throws DescriptorException {
        boolean bl = ((DataObject)object).isSet(this.getProperty());
        if (!bl) {
            return null;
        }
        return ((DataObject)object).get(this.getProperty());
    }

    public void initializeAttributes(Class clazz) throws DescriptorException {
        if (this.getAttributeName() == null) {
            throw DescriptorException.attributeNameNotSpecified();
        }
    }

    public boolean isMethodAttributeAccessor() {
        return true;
    }

    public void setAttributeValueInObject(Object object, Object object2) throws DescriptorException {
        ((SDODataObject)object).setInternal(this.property, object2, false);
    }

    public void setProperty(Property property) {
        this.property = (SDOProperty)property;
    }

    public Property getProperty() {
        return this.property;
    }

    public Class getGetMethodReturnType() {
        return this.attributeClass;
    }

    public Class getSetMethodParameterType() {
        return this.attributeClass;
    }
}

