/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.delegates;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.XMLDocument;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.WeakHashMap;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.XMLMarshalListener;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshalListener;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.record.ContentHandlerRecord;
import org.eclipse.persistence.oxm.record.FormattedWriterRecord;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.NodeRecord;
import org.eclipse.persistence.oxm.record.WriterRecord;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.SDOXMLDocument;
import org.eclipse.persistence.sdo.helper.SDOClassLoader;
import org.eclipse.persistence.sdo.helper.SDOMarshalListener;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.SDOUnmappedContentHandler;
import org.eclipse.persistence.sdo.helper.SDOUnmarshalListener;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.eclipse.persistence.sdo.types.SDOPropertyType;
import org.eclipse.persistence.sdo.types.SDOTypeType;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.xml.sax.InputSource;

public class SDOXMLHelperDelegate
implements SDOXMLHelper {
    private SDOClassLoader loader;
    private XMLContext xmlContext;
    private Map<Thread, XMLMarshaller> xmlMarshallerMap;
    private Map<Thread, XMLUnmarshaller> xmlUnmarshallerMap;
    private Project topLinkProject;
    private HelperContext aHelperContext;

    public SDOXMLHelperDelegate(HelperContext helperContext) {
        this(helperContext, Thread.currentThread().getContextClassLoader());
    }

    public SDOXMLHelperDelegate(HelperContext helperContext, ClassLoader classLoader) {
        this.aHelperContext = helperContext;
        this.loader = new SDOClassLoader(classLoader, helperContext);
        this.xmlMarshallerMap = new WeakHashMap<Thread, XMLMarshaller>();
        this.xmlUnmarshallerMap = new WeakHashMap<Thread, XMLUnmarshaller>();
    }

    public void setTimeZone(TimeZone timeZone) {
        this.getXmlConversionManager().setTimeZone(timeZone);
    }

    public void setTimeZoneQualified(boolean bl) {
        this.getXmlConversionManager().setTimeZoneQualified(bl);
    }

    public XMLDocument load(String string) {
        StringReader stringReader = new StringReader(string);
        try {
            return this.load(stringReader, null, null);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public XMLDocument load(InputStream inputStream) throws IOException {
        return this.load(inputStream, null, null);
    }

    public XMLDocument load(InputStream inputStream, String string, Object object) throws IOException {
        InputSource inputSource = new InputSource(inputStream);
        return this.load(inputSource, string, object);
    }

    public XMLDocument load(InputSource inputSource, String string, Object object) throws IOException {
        SDOType sDOType;
        Object object2;
        Object object3;
        block17: {
            XMLUnmarshaller xMLUnmarshaller = this.getXmlUnmarshaller();
            object3 = null;
            if (object == null) {
                try {
                    object3 = xMLUnmarshaller.unmarshal(inputSource);
                }
                catch (XMLMarshalException xMLMarshalException) {
                    this.handleXMLMarshalException(xMLMarshalException);
                }
            } else {
                try {
                    object2 = (DataObject)object;
                    try {
                        sDOType = (SDOType)object2.get("type");
                        try {
                            if (sDOType != null) {
                                object3 = xMLUnmarshaller.unmarshal(inputSource, sDOType.getImplClass());
                                break block17;
                            }
                            object3 = xMLUnmarshaller.unmarshal(inputSource);
                        }
                        catch (XMLMarshalException xMLMarshalException) {
                            this.handleXMLMarshalException(xMLMarshalException);
                        }
                    }
                    catch (ClassCastException classCastException) {
                        throw SDOException.typePropertyMustBeAType((Exception)classCastException);
                    }
                }
                catch (ClassCastException classCastException) {
                    throw SDOException.optionsMustBeADataObject((Exception)classCastException, (String)"org.eclipse.persistence.sdo", (String)"LoadOptions");
                }
            }
        }
        if (object3 instanceof XMLRoot) {
            object2 = (XMLRoot)object3;
            sDOType = this.createDocument((DataObject)((XMLRoot)object3).getObject(), ((XMLRoot)object3).getNamespaceURI(), ((XMLRoot)object3).getLocalName());
            if (object2.getEncoding() != null) {
                sDOType.setEncoding(object2.getEncoding());
            }
            if (object2.getXMLVersion() != null) {
                sDOType.setXMLVersion(object2.getXMLVersion());
            }
            sDOType.setSchemaLocation(object2.getSchemaLocation());
            sDOType.setNoNamespaceSchemaLocation(object2.getNoNamespaceSchemaLocation());
            return sDOType;
        }
        if (object3 instanceof DataObject) {
            object2 = ((SDOType)((DataObject)object3).getType()).getXmlDescriptor().getDefaultRootElement();
            if (object2 == null) {
                object2 = ((SDOType)((DataObject)object3).getType()).getXsdLocalName();
            }
            return this.createDocument((DataObject)object3, ((DataObject)object3).getType().getURI(), (String)object2);
        }
        if (object3 instanceof XMLDocument) {
            return (XMLDocument)object3;
        }
        return null;
    }

    public XMLDocument load(Reader reader, String string, Object object) throws IOException {
        InputSource inputSource = new InputSource(reader);
        return this.load(inputSource, string, object);
    }

    public XMLDocument load(Source source, String string, Object object) throws IOException {
        Object object2;
        DataObject dataObject;
        Object object3;
        block17: {
            XMLUnmarshaller xMLUnmarshaller = this.getXmlUnmarshaller();
            object3 = null;
            if (object == null) {
                try {
                    object3 = xMLUnmarshaller.unmarshal(source);
                }
                catch (XMLMarshalException xMLMarshalException) {
                    this.handleXMLMarshalException(xMLMarshalException);
                }
            } else {
                try {
                    dataObject = (DataObject)object;
                    try {
                        object2 = (SDOType)dataObject.get("type");
                        try {
                            if (object2 != null) {
                                object3 = xMLUnmarshaller.unmarshal(source, ((SDOType)object2).getImplClass());
                                break block17;
                            }
                            object3 = xMLUnmarshaller.unmarshal(source);
                        }
                        catch (XMLMarshalException xMLMarshalException) {
                            this.handleXMLMarshalException(xMLMarshalException);
                        }
                    }
                    catch (ClassCastException classCastException) {
                        throw SDOException.typePropertyMustBeAType((Exception)classCastException);
                    }
                }
                catch (ClassCastException classCastException) {
                    throw SDOException.optionsMustBeADataObject((Exception)classCastException, (String)"org.eclipse.persistence.sdo", (String)"LoadOptions");
                }
            }
        }
        if (object3 instanceof XMLRoot) {
            dataObject = (XMLRoot)object3;
            object2 = this.createDocument((DataObject)((XMLRoot)object3).getObject(), ((XMLRoot)object3).getNamespaceURI(), ((XMLRoot)object3).getLocalName());
            if (dataObject.getEncoding() != null) {
                object2.setEncoding(dataObject.getEncoding());
            }
            if (dataObject.getXMLVersion() != null) {
                object2.setXMLVersion(dataObject.getXMLVersion());
            }
            object2.setSchemaLocation(dataObject.getSchemaLocation());
            object2.setNoNamespaceSchemaLocation(dataObject.getNoNamespaceSchemaLocation());
            return object2;
        }
        if (object3 instanceof DataObject) {
            dataObject = (DataObject)object3;
            object2 = ((SDOType)((DataObject)object3).getType()).getXmlDescriptor().getDefaultRootElement();
            if (object2 == null) {
                object2 = ((SDOType)((DataObject)object3).getType()).getXsdLocalName();
            }
            return this.createDocument(dataObject, dataObject.getType().getURI(), (String)object2);
        }
        if (object3 instanceof XMLDocument) {
            return (XMLDocument)object3;
        }
        return null;
    }

    public String save(DataObject dataObject, String string, String string2) {
        try {
            StringWriter stringWriter = new StringWriter();
            this.save(dataObject, string, string2, stringWriter);
            return stringWriter.toString();
        }
        catch (XMLMarshalException xMLMarshalException) {
            throw SDOException.xmlMarshalExceptionOccurred((XMLMarshalException)xMLMarshalException, (String)string, (String)string2);
        }
    }

    public void save(DataObject dataObject, String string, String string2, OutputStream outputStream) throws XMLMarshalException, IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.getXmlMarshaller().getEncoding());
        this.save(dataObject, string, string2, outputStreamWriter);
    }

    public void save(XMLDocument xMLDocument, OutputStream outputStream, Object object) throws IOException {
        String string = this.getXmlMarshaller().getEncoding();
        if (xMLDocument.getEncoding() != null) {
            string = xMLDocument.getEncoding();
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
        this.save(xMLDocument, outputStreamWriter, object);
    }

    public void save(XMLDocument xMLDocument, Writer writer, Object object) throws IOException {
        XMLMarshaller xMLMarshaller = this.getXmlMarshaller();
        xMLMarshaller.setFragment(!xMLDocument.isXMLDeclaration());
        xMLMarshaller.setEncoding(xMLDocument.getEncoding());
        xMLMarshaller.setSchemaLocation(xMLDocument.getSchemaLocation());
        xMLMarshaller.setNoNamespaceSchemaLocation(xMLDocument.getNoNamespaceSchemaLocation());
        Object object2 = xMLMarshaller.isFormattedOutput() ? new FormattedWriterRecord() : new WriterRecord();
        object2.setWriter(writer);
        object2.setMarshaller(xMLMarshaller);
        ((SDOMarshalListener)xMLMarshaller.getMarshalListener()).setMarshalledObject(xMLDocument.getRootObject());
        ((SDOMarshalListener)xMLMarshaller.getMarshalListener()).setMarshalledObjectRootQName(new QName(xMLDocument.getRootElementURI(), xMLDocument.getRootElementName()));
        ((SDOMarshalListener)xMLMarshaller.getMarshalListener()).setRootMarshalReocrd((MarshalRecord)object2);
        xMLMarshaller.marshal((Object)xMLDocument, (MarshalRecord)object2);
        writer.flush();
    }

    public void save(XMLDocument xMLDocument, Result result, Object object) throws IOException {
        if (result instanceof StreamResult) {
            StreamResult streamResult = (StreamResult)result;
            Writer writer = streamResult.getWriter();
            if (null == writer) {
                this.save(xMLDocument, streamResult.getOutputStream(), object);
            } else {
                this.save(xMLDocument, writer, object);
            }
        } else {
            XMLMarshaller xMLMarshaller = this.getXmlMarshaller();
            xMLMarshaller.setFragment(!xMLDocument.isXMLDeclaration());
            xMLMarshaller.setEncoding(xMLDocument.getEncoding());
            xMLMarshaller.setSchemaLocation(xMLDocument.getSchemaLocation());
            xMLMarshaller.setNoNamespaceSchemaLocation(xMLDocument.getNoNamespaceSchemaLocation());
            ((SDOMarshalListener)xMLMarshaller.getMarshalListener()).setMarshalledObject(xMLDocument.getRootObject());
            ((SDOMarshalListener)xMLMarshaller.getMarshalListener()).setMarshalledObjectRootQName(new QName(xMLDocument.getRootElementURI(), xMLDocument.getRootElementName()));
            if (result instanceof SAXResult) {
                ContentHandlerRecord contentHandlerRecord = new ContentHandlerRecord();
                contentHandlerRecord.setContentHandler(((SAXResult)result).getHandler());
                contentHandlerRecord.setMarshaller(xMLMarshaller);
                ((SDOMarshalListener)xMLMarshaller.getMarshalListener()).setRootMarshalReocrd((MarshalRecord)contentHandlerRecord);
                xMLMarshaller.marshal((Object)xMLDocument, (MarshalRecord)contentHandlerRecord);
            } else if (result instanceof DOMResult) {
                NodeRecord nodeRecord = new NodeRecord();
                nodeRecord.setDOM(((DOMResult)result).getNode());
                nodeRecord.setMarshaller(xMLMarshaller);
                ((SDOMarshalListener)xMLMarshaller.getMarshalListener()).setRootMarshalReocrd((MarshalRecord)nodeRecord);
                xMLMarshaller.marshal((Object)xMLDocument, (MarshalRecord)nodeRecord);
            } else {
                StringWriter stringWriter = new StringWriter();
                this.save(xMLDocument, stringWriter, object);
                String string = stringWriter.toString();
                StreamSource streamSource = new StreamSource(new StringReader(string));
                xMLMarshaller.getTransformer().transform((Source)streamSource, result);
            }
        }
    }

    public XMLDocument createDocument(DataObject dataObject, String string, String string2) {
        Property property;
        SDOXMLDocument sDOXMLDocument = new SDOXMLDocument();
        sDOXMLDocument.setRootObject(dataObject);
        sDOXMLDocument.setRootElementURI(string);
        if (string2 != null) {
            sDOXMLDocument.setRootElementName(string2);
        }
        if (null != (property = this.getHelperContext().getXSDHelper().getGlobalProperty(string, string2, true))) {
            sDOXMLDocument.setSchemaType(((SDOType)property.getType()).getXsdType());
        }
        sDOXMLDocument.setEncoding("UTF-8");
        sDOXMLDocument.setXMLVersion("1.0");
        return sDOXMLDocument;
    }

    private void save(DataObject dataObject, String string, String string2, Writer writer) throws XMLMarshalException {
        SDOXMLDocument sDOXMLDocument = (SDOXMLDocument)this.createDocument(dataObject, string, string2);
        XMLMarshaller xMLMarshaller = this.getXmlMarshaller();
        xMLMarshaller.setFragment(!sDOXMLDocument.isXMLDeclaration());
        Object object = xMLMarshaller.isFormattedOutput() ? new FormattedWriterRecord() : new WriterRecord();
        object.setWriter(writer);
        object.setMarshaller(xMLMarshaller);
        ((SDOMarshalListener)xMLMarshaller.getMarshalListener()).setMarshalledObject(dataObject);
        ((SDOMarshalListener)xMLMarshaller.getMarshalListener()).setMarshalledObjectRootQName(new QName(string, string2));
        ((SDOMarshalListener)xMLMarshaller.getMarshalListener()).setRootMarshalReocrd((MarshalRecord)object);
        xMLMarshaller.marshal((Object)sDOXMLDocument, (MarshalRecord)object);
        try {
            writer.flush();
        }
        catch (IOException iOException) {
            throw XMLMarshalException.marshalException((Exception)iOException);
        }
    }

    public void setLoader(SDOClassLoader sDOClassLoader) {
        this.loader = sDOClassLoader;
        this.getXmlConversionManager().setLoader((ClassLoader)this.loader);
    }

    public SDOClassLoader getLoader() {
        return this.loader;
    }

    public void setXmlContext(XMLContext xMLContext) {
        this.xmlContext = xMLContext;
    }

    public synchronized XMLContext getXmlContext() {
        if (this.xmlContext == null) {
            this.xmlContext = new XMLContext(this.getTopLinkProject());
            XMLConversionManager xMLConversionManager = this.getXmlConversionManager();
            xMLConversionManager.setLoader((ClassLoader)this.loader);
            xMLConversionManager.setTimeZone(TimeZone.getTimeZone("GMT"));
            xMLConversionManager.setTimeZoneQualified(true);
        }
        return this.xmlContext;
    }

    public void initializeDescriptor(XMLDescriptor xMLDescriptor) {
        AbstractSession abstractSession = (AbstractSession)this.getXmlContext().getSession(0);
        xMLDescriptor.preInitialize(abstractSession);
        xMLDescriptor.initialize(abstractSession);
        xMLDescriptor.postInitialize(abstractSession);
        xMLDescriptor.getObjectBuilder().initializePrimaryKey(abstractSession);
        this.getXmlContext().storeXMLDescriptorByQName(xMLDescriptor);
    }

    public void addDescriptors(List list) {
        XMLDescriptor xMLDescriptor;
        SDOType sDOType;
        int n;
        for (n = 0; n < list.size(); ++n) {
            sDOType = (SDOType)list.get(n);
            if (sDOType.isDataType() || !sDOType.isFinalized()) continue;
            xMLDescriptor = sDOType.getXmlDescriptor();
            this.getTopLinkProject().addDescriptor((ClassDescriptor)xMLDescriptor);
        }
        for (n = 0; n < list.size(); ++n) {
            sDOType = (SDOType)list.get(n);
            if (sDOType.isDataType() || !sDOType.isFinalized()) continue;
            xMLDescriptor = sDOType.getXmlDescriptor();
            this.initializeDescriptor(xMLDescriptor);
        }
    }

    public void setTopLinkProject(Project project) {
        this.topLinkProject = project;
        this.xmlContext = null;
        this.xmlMarshallerMap.clear();
        this.xmlUnmarshallerMap.clear();
    }

    public Project getTopLinkProject() {
        if (this.topLinkProject == null) {
            this.topLinkProject = new Project();
            XMLLogin xMLLogin = new XMLLogin();
            xMLLogin.setEqualNamespaceResolvers(false);
            this.topLinkProject.setDatasourceLogin((Login)xMLLogin);
            NamespaceResolver namespaceResolver = new NamespaceResolver();
            SDOTypeHelper sDOTypeHelper = (SDOTypeHelper)this.aHelperContext.getTypeHelper();
            String string = sDOTypeHelper.getPrefix("commonj.sdo");
            namespaceResolver.put(string, "commonj.sdo");
            SDOType sDOType = (SDOType)sDOTypeHelper.getType("commonj.sdo", "ChangeSummaryType");
            sDOType.getXmlDescriptor().setNamespaceResolver(namespaceResolver);
            this.topLinkProject.addDescriptor((ClassDescriptor)sDOType.getXmlDescriptor());
            SDOType sDOType2 = (SDOType)this.aHelperContext.getTypeHelper().getType("org.eclipse.persistence.sdo", "OpenSequencedType");
            this.topLinkProject.addDescriptor((ClassDescriptor)sDOType2.getXmlDescriptor());
            SDOTypeType sDOTypeType = (SDOTypeType)this.aHelperContext.getTypeHelper().getType("commonj.sdo", "Type");
            if (!sDOTypeType.isInitialized()) {
                sDOTypeType.initializeMappings();
            }
            this.topLinkProject.addDescriptor((ClassDescriptor)sDOTypeType.getXmlDescriptor());
            SDOPropertyType sDOPropertyType = (SDOPropertyType)this.aHelperContext.getTypeHelper().getType("commonj.sdo", "Property");
            if (!sDOPropertyType.isInitialized()) {
                sDOPropertyType.initializeMappings();
            }
            this.topLinkProject.addDescriptor((ClassDescriptor)sDOPropertyType.getXmlDescriptor());
            ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).addWrappersToProject(this.topLinkProject);
        }
        return this.topLinkProject;
    }

    public void setXmlMarshaller(XMLMarshaller xMLMarshaller) {
        this.xmlMarshallerMap.put(Thread.currentThread(), xMLMarshaller);
    }

    public XMLMarshaller getXmlMarshaller() {
        XMLMarshaller xMLMarshaller = this.xmlMarshallerMap.get(Thread.currentThread());
        if (xMLMarshaller == null) {
            xMLMarshaller = this.getXmlContext().createMarshaller();
            xMLMarshaller.setMarshalListener((XMLMarshalListener)new SDOMarshalListener(xMLMarshaller, (SDOTypeHelper)this.aHelperContext.getTypeHelper()));
            this.xmlMarshallerMap.put(Thread.currentThread(), xMLMarshaller);
        }
        XMLContext xMLContext = this.getXmlContext();
        if (xMLMarshaller.getXMLContext() != xMLContext) {
            xMLMarshaller.setXMLContext(xMLContext);
        }
        return xMLMarshaller;
    }

    public void setXmlUnmarshaller(XMLUnmarshaller xMLUnmarshaller) {
        this.xmlUnmarshallerMap.put(Thread.currentThread(), xMLUnmarshaller);
    }

    public XMLUnmarshaller getXmlUnmarshaller() {
        XMLUnmarshaller xMLUnmarshaller = this.xmlUnmarshallerMap.get(Thread.currentThread());
        if (xMLUnmarshaller == null) {
            xMLUnmarshaller = this.getXmlContext().createUnmarshaller();
            xMLUnmarshaller.getProperties().put("sdoHelperContext", this.aHelperContext);
            xMLUnmarshaller.setUnmappedContentHandlerClass(SDOUnmappedContentHandler.class);
            xMLUnmarshaller.setUnmarshalListener((XMLUnmarshalListener)new SDOUnmarshalListener(this.aHelperContext));
            xMLUnmarshaller.setResultAlwaysXMLRoot(true);
            this.xmlUnmarshallerMap.put(Thread.currentThread(), xMLUnmarshaller);
        }
        XMLContext xMLContext = this.getXmlContext();
        if (xMLUnmarshaller.getXMLContext() != xMLContext) {
            xMLUnmarshaller.setXMLContext(xMLContext);
        }
        return xMLUnmarshaller;
    }

    public void reset() {
        this.setTopLinkProject(null);
        this.setXmlContext(null);
        this.xmlMarshallerMap.clear();
        this.xmlUnmarshallerMap.clear();
        this.setLoader(new SDOClassLoader(this.getClass().getClassLoader(), this.aHelperContext));
    }

    public HelperContext getHelperContext() {
        return this.aHelperContext;
    }

    public void setHelperContext(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }

    private void handleXMLMarshalException(XMLMarshalException xMLMarshalException) {
        if (xMLMarshalException.getErrorCode() == 25008 || xMLMarshalException.getErrorCode() == 25007) {
            throw SDOException.globalPropertyNotFound();
        }
        throw xMLMarshalException;
    }

    public XMLConversionManager getXmlConversionManager() {
        return (XMLConversionManager)this.getXmlContext().getSession(0).getDatasourceLogin().getDatasourcePlatform().getConversionManager();
    }
}

