/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.jaxb;

import commonj.sdo.DataObject;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.XMLDocument;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.jaxb.JAXBUnmarshaller;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.sdo.helper.delegates.SDOXMLHelperDelegate;
import org.eclipse.persistence.sdo.helper.jaxb.JAXBHelperContext;
import org.xml.sax.InputSource;

public class JAXBXMLHelper
extends SDOXMLHelperDelegate {
    public JAXBXMLHelper(HelperContext helperContext) {
        super(helperContext);
    }

    public JAXBXMLHelper(HelperContext helperContext, ClassLoader classLoader) {
        super(helperContext, classLoader);
    }

    public JAXBHelperContext getHelperContext() {
        return (JAXBHelperContext)super.getHelperContext();
    }

    public XMLDocument load(InputSource inputSource, String string, Object object) throws IOException {
        if (null == inputSource) {
            return super.load(inputSource, string, object);
        }
        try {
            XMLRoot xMLRoot = (XMLRoot)this.createXMLUnmarshaller().unmarshal(inputSource);
            return this.wrap(xMLRoot);
        }
        catch (XMLMarshalException xMLMarshalException) {
            return this.handleLoadException(xMLMarshalException);
        }
    }

    public XMLDocument load(InputStream inputStream, String string, Object object) throws IOException {
        if (null == inputStream) {
            return super.load(inputStream, string, object);
        }
        return this.load(inputStream);
    }

    public XMLDocument load(InputStream inputStream) throws IOException {
        if (null == inputStream) {
            return super.load(inputStream);
        }
        try {
            XMLRoot xMLRoot = (XMLRoot)this.createXMLUnmarshaller().unmarshal(inputStream);
            return this.wrap(xMLRoot);
        }
        catch (XMLMarshalException xMLMarshalException) {
            return this.handleLoadException(xMLMarshalException);
        }
    }

    public XMLDocument load(Reader reader, String string, Object object) throws IOException {
        if (null == reader) {
            return super.load(reader, string, object);
        }
        try {
            XMLRoot xMLRoot = (XMLRoot)this.createXMLUnmarshaller().unmarshal(reader);
            return this.wrap(xMLRoot);
        }
        catch (XMLMarshalException xMLMarshalException) {
            return this.handleLoadException(xMLMarshalException);
        }
    }

    public XMLDocument load(Source source, String string, Object object) throws IOException {
        if (null == source) {
            return super.load(source, string, object);
        }
        try {
            XMLRoot xMLRoot = (XMLRoot)this.createXMLUnmarshaller().unmarshal(source);
            return this.wrap(xMLRoot);
        }
        catch (XMLMarshalException xMLMarshalException) {
            return this.handleLoadException(xMLMarshalException);
        }
    }

    public XMLDocument load(String string) {
        if (null == string) {
            return super.load(string);
        }
        try {
            StringReader stringReader = new StringReader(string);
            return this.load(stringReader, null, null);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private XMLUnmarshaller createXMLUnmarshaller() {
        try {
            JAXBUnmarshaller jAXBUnmarshaller = (JAXBUnmarshaller)this.getHelperContext().getJAXBContext().createUnmarshaller();
            XMLUnmarshaller xMLUnmarshaller = jAXBUnmarshaller.getXMLUnmarshaller();
            xMLUnmarshaller.setResultAlwaysXMLRoot(true);
            return xMLUnmarshaller;
        }
        catch (JAXBException jAXBException) {
            throw SDOException.sdoJaxbErrorCreatingJAXBUnmarshaller((Exception)((Object)jAXBException));
        }
    }

    private XMLDocument wrap(XMLRoot xMLRoot) {
        DataObject dataObject = this.getHelperContext().wrap(xMLRoot.getObject());
        XMLDocument xMLDocument = this.getHelperContext().getXMLHelper().createDocument(dataObject, xMLRoot.getNamespaceURI(), xMLRoot.getLocalName());
        xMLDocument.setEncoding(xMLRoot.getEncoding());
        xMLDocument.setXMLVersion(xMLRoot.getXMLVersion());
        xMLDocument.setSchemaLocation(xMLRoot.getSchemaLocation());
        xMLDocument.setNoNamespaceSchemaLocation(xMLRoot.getNoNamespaceSchemaLocation());
        return xMLDocument;
    }

    private XMLDocument handleLoadException(XMLMarshalException xMLMarshalException) throws IOException {
        if (xMLMarshalException.getCause() instanceof IOException) {
            throw (IOException)xMLMarshalException.getCause();
        }
        throw xMLMarshalException;
    }
}

