/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeCollectionMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.sessions.remote.RemoteSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLChoiceCollectionMapping
extends DatabaseMapping
implements XMLMapping {
    private Map<XMLField, Class> fieldToClassMappings = new HashMap<XMLField, Class>();
    private Map<Class, XMLField> classToFieldMappings;
    private Map<XMLField, XMLMapping> choiceElementMappings;
    private Map<String, String> fieldToClassNameMappings = new HashMap<String, String>();
    private ContainerPolicy containerPolicy;

    public XMLChoiceCollectionMapping() {
        this.classToFieldMappings = new HashMap<Class, XMLField>();
        this.choiceElementMappings = new HashMap<XMLField, XMLMapping>();
        this.containerPolicy = ContainerPolicy.buildPolicyFor(ClassConstants.Vector_class);
    }

    @Override
    public void buildBackupClone(Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        throw DescriptorException.invalidMappingOperation(this, "buildBackupClone");
    }

    @Override
    public void buildClone(Object original, Object clone, UnitOfWorkImpl unitOfWork) {
        throw DescriptorException.invalidMappingOperation(this, "buildClone");
    }

    @Override
    public void buildCloneFromRow(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object clone, ObjectBuildingQuery sourceQuery, UnitOfWorkImpl unitOfWork, AbstractSession executionSession) {
        throw DescriptorException.invalidMappingOperation(this, "buildCloneFromRow");
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    @Override
    public ChangeRecord compareForChange(Object clone, Object backup, ObjectChangeSet owner, AbstractSession session) {
        throw DescriptorException.invalidMappingOperation(this, "compareForChange");
    }

    @Override
    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        throw DescriptorException.invalidMappingOperation(this, "compareObjects");
    }

    @Override
    public void fixObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, RemoteSession session) {
        throw DescriptorException.invalidMappingOperation(this, "fixObjectReferences");
    }

    @Override
    public void iterate(DescriptorIterator iterator) {
        throw DescriptorException.invalidMappingOperation(this, "iterate");
    }

    @Override
    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager) {
        throw DescriptorException.invalidMappingOperation(this, "mergeChangesIntoObject");
    }

    @Override
    public void mergeIntoObject(Object target, boolean isTargetUninitialized, Object source, MergeManager mergeManager) {
        throw DescriptorException.invalidMappingOperation(this, "mergeIntoObject");
    }

    @Override
    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        return null;
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session) throws DescriptorException {
    }

    @Override
    public void writeSingleValue(Object value, Object parent, XMLRecord row, AbstractSession session) {
    }

    @Override
    public boolean isXMLMapping() {
        return true;
    }

    @Override
    public Vector<DatabaseField> getFields() {
        return this.collectFields();
    }

    @Override
    protected Vector<DatabaseField> collectFields() {
        Vector<DatabaseField> fields = new Vector<DatabaseField>(this.getFieldToClassMappings().keySet());
        return fields;
    }

    public void addChoiceElement(String xpath, Class elementType) {
        XMLField field = new XMLField(xpath);
        this.getFieldToClassMappings().put(field, elementType);
        if (this.classToFieldMappings.get(elementType) == null) {
            this.classToFieldMappings.put(elementType, field);
        }
    }

    public void addChoiceElement(String xpath, String elementTypeName) {
        this.fieldToClassNameMappings.put(xpath, elementTypeName);
    }

    public Map<XMLField, Class> getFieldToClassMappings() {
        return this.fieldToClassMappings;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (this.fieldToClassMappings.size() == 0) {
            this.convertClassNamesToClasses(((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).getLoader());
        }
        for (XMLField next : this.getFieldToClassMappings().keySet()) {
            DatabaseMapping xmlMapping;
            if (next.getLastXPathFragment().nameIsText()) {
                xmlMapping = new XMLCompositeDirectCollectionMapping();
                xmlMapping.setAttributeName(this.getAttributeName());
                xmlMapping.setAttributeAccessor(this.getAttributeAccessor());
                ((AbstractCompositeDirectCollectionMapping)xmlMapping).setAttributeElementClass(this.getFieldToClassMappings().get(next));
                ((AbstractCompositeDirectCollectionMapping)xmlMapping).setField(next);
                xmlMapping.setDescriptor(this.getDescriptor());
                ((AbstractCompositeDirectCollectionMapping)xmlMapping).setContainerPolicy(this.getContainerPolicy());
                this.choiceElementMappings.put(next, (XMLMapping)((Object)xmlMapping));
                ((XMLCompositeDirectCollectionMapping)xmlMapping).initialize(session);
                continue;
            }
            xmlMapping = new XMLCompositeCollectionMapping();
            xmlMapping.setAttributeName(this.getAttributeName());
            xmlMapping.setAttributeAccessor(this.getAttributeAccessor());
            ((AggregateMapping)xmlMapping).setReferenceClass(this.getFieldToClassMappings().get(next));
            ((AbstractCompositeCollectionMapping)xmlMapping).setField(next);
            xmlMapping.setDescriptor(this.getDescriptor());
            ((AbstractCompositeCollectionMapping)xmlMapping).setContainerPolicy(this.getContainerPolicy());
            this.choiceElementMappings.put(next, (XMLMapping)((Object)xmlMapping));
            ((XMLCompositeCollectionMapping)xmlMapping).initialize(session);
        }
    }

    public Map<Class, XMLField> getClassToFieldMappings() {
        return this.classToFieldMappings;
    }

    public Map<XMLField, XMLMapping> getChoiceElementMappings() {
        return this.choiceElementMappings;
    }

    @Override
    public ContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    public void setContainerPolicy(ContainerPolicy cp) {
        this.containerPolicy = cp;
    }

    public void useCollectionClass(Class concreteContainerClass) {
        this.setContainerPolicy(ContainerPolicy.buildPolicyFor(concreteContainerClass));
    }

    public void useCollectionClassName(String concreteContainerClassName) {
        this.setContainerPolicy(new CollectionContainerPolicy(concreteContainerClassName));
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        for (String xpath : this.fieldToClassNameMappings.keySet()) {
            Class elementType;
            block6: {
                String className = this.fieldToClassNameMappings.get(xpath);
                elementType = null;
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            elementType = (Class)AccessController.doPrivileged(new PrivilegedClassForName(className, true, classLoader));
                            break block6;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(className, exception.getException());
                        }
                    }
                    elementType = PrivilegedAccessHelper.getClassForName(className, true, classLoader);
                }
                catch (ClassNotFoundException exc) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(className, exc);
                }
            }
            this.addChoiceElement(xpath, elementType);
        }
    }
}

