/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.antlr.runtime;

import org.eclipse.persistence.internal.libraries.antlr.runtime.BaseRecognizer;
import org.eclipse.persistence.internal.libraries.antlr.runtime.CharStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.CommonToken;
import org.eclipse.persistence.internal.libraries.antlr.runtime.EarlyExitException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.MismatchedNotSetException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.MismatchedRangeException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.MismatchedSetException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.MismatchedTokenException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.NoViableAltException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.RecognitionException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.Token;
import org.eclipse.persistence.internal.libraries.antlr.runtime.TokenSource;

public abstract class Lexer
extends BaseRecognizer
implements TokenSource {
    protected CharStream input;
    protected Token token;
    protected int tokenStartCharIndex = -1;
    protected int tokenStartLine;
    protected int tokenStartCharPositionInLine;
    protected int channel;
    protected int type;
    protected String text;

    public Lexer() {
    }

    public Lexer(CharStream input) {
        this.input = input;
    }

    public void reset() {
        super.reset();
        this.token = null;
        this.type = 0;
        this.channel = 0;
        this.tokenStartCharIndex = -1;
        this.tokenStartCharPositionInLine = -1;
        this.tokenStartLine = -1;
        this.text = null;
        if (this.input != null) {
            this.input.seek(0);
        }
    }

    public Token nextToken() {
        while (true) {
            this.token = null;
            this.channel = 0;
            this.tokenStartCharIndex = this.input.index();
            this.tokenStartCharPositionInLine = this.input.getCharPositionInLine();
            this.tokenStartLine = this.input.getLine();
            this.text = null;
            if (this.input.LA(1) == -1) {
                return Token.EOF_TOKEN;
            }
            try {
                this.mTokens();
                if (this.token == null) {
                    this.emit();
                } else if (this.token == Token.SKIP_TOKEN) continue;
                return this.token;
            }
            catch (RecognitionException re) {
                this.reportError(re);
                this.recover(re);
                continue;
            }
            break;
        }
    }

    public void skip() {
        this.token = Token.SKIP_TOKEN;
    }

    public abstract void mTokens() throws RecognitionException;

    public void setCharStream(CharStream input) {
        this.input = null;
        this.reset();
        this.input = input;
    }

    public void emit(Token token) {
        this.token = token;
    }

    public Token emit() {
        CommonToken t = new CommonToken(this.input, this.type, this.channel, this.tokenStartCharIndex, this.getCharIndex() - 1);
        t.setLine(this.tokenStartLine);
        t.setText(this.text);
        t.setCharPositionInLine(this.tokenStartCharPositionInLine);
        this.emit(t);
        return t;
    }

    public void match(String s) throws MismatchedTokenException {
        for (int i = 0; i < s.length(); ++i) {
            if (this.input.LA(1) != s.charAt(i)) {
                if (this.backtracking > 0) {
                    this.failed = true;
                    return;
                }
                MismatchedTokenException mte = new MismatchedTokenException(s.charAt(i), this.input);
                this.recover(mte);
                throw mte;
            }
            this.input.consume();
            this.failed = false;
        }
    }

    public void matchAny() {
        this.input.consume();
    }

    public void match(int c) throws MismatchedTokenException {
        if (this.input.LA(1) != c) {
            if (this.backtracking > 0) {
                this.failed = true;
                return;
            }
            MismatchedTokenException mte = new MismatchedTokenException(c, this.input);
            this.recover(mte);
            throw mte;
        }
        this.input.consume();
        this.failed = false;
    }

    public void matchRange(int a, int b) throws MismatchedRangeException {
        if (this.input.LA(1) < a || this.input.LA(1) > b) {
            if (this.backtracking > 0) {
                this.failed = true;
                return;
            }
            MismatchedRangeException mre = new MismatchedRangeException(a, b, this.input);
            this.recover(mre);
            throw mre;
        }
        this.input.consume();
        this.failed = false;
    }

    public int getLine() {
        return this.input.getLine();
    }

    public int getCharPositionInLine() {
        return this.input.getCharPositionInLine();
    }

    public int getCharIndex() {
        return this.input.index();
    }

    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        return this.input.substring(this.tokenStartCharIndex, this.getCharIndex() - 1);
    }

    public void setText(String text) {
        this.text = text;
    }

    public void reportError(RecognitionException e) {
        this.displayRecognitionError(this.getTokenNames(), e);
    }

    public String getErrorMessage(RecognitionException e, String[] tokenNames) {
        String msg = null;
        if (e instanceof MismatchedTokenException) {
            MismatchedTokenException mte = (MismatchedTokenException)e;
            msg = "mismatched character " + this.getCharErrorDisplay(e.c) + " expecting " + this.getCharErrorDisplay(mte.expecting);
        } else if (e instanceof NoViableAltException) {
            NoViableAltException nvae = (NoViableAltException)e;
            msg = "no viable alternative at character " + this.getCharErrorDisplay(e.c);
        } else if (e instanceof EarlyExitException) {
            EarlyExitException eee = (EarlyExitException)e;
            msg = "required (...)+ loop did not match anything at character " + this.getCharErrorDisplay(e.c);
        } else if (e instanceof MismatchedSetException) {
            MismatchedSetException mse = (MismatchedSetException)e;
            msg = "mismatched character " + this.getCharErrorDisplay(e.c) + " expecting set " + mse.expecting;
        } else if (e instanceof MismatchedNotSetException) {
            MismatchedNotSetException mse = (MismatchedNotSetException)e;
            msg = "mismatched character " + this.getCharErrorDisplay(e.c) + " expecting set " + mse.expecting;
        } else if (e instanceof MismatchedRangeException) {
            MismatchedRangeException mre = (MismatchedRangeException)e;
            msg = "mismatched character " + this.getCharErrorDisplay(e.c) + " expecting set " + this.getCharErrorDisplay(mre.a) + ".." + this.getCharErrorDisplay(mre.b);
        } else {
            msg = super.getErrorMessage(e, tokenNames);
        }
        return msg;
    }

    public String getCharErrorDisplay(int c) {
        String s = String.valueOf((char)c);
        switch (c) {
            case -1: {
                s = "<EOF>";
                break;
            }
            case 10: {
                s = "\\n";
                break;
            }
            case 9: {
                s = "\\t";
                break;
            }
            case 13: {
                s = "\\r";
            }
        }
        return "'" + s + "'";
    }

    public void recover(RecognitionException re) {
        this.input.consume();
    }

    public void traceIn(String ruleName, int ruleIndex) {
        String inputSymbol = (char)this.input.LT(1) + " line=" + this.getLine() + ":" + this.getCharPositionInLine();
        super.traceIn(ruleName, ruleIndex, inputSymbol);
    }

    public void traceOut(String ruleName, int ruleIndex) {
        String inputSymbol = (char)this.input.LT(1) + " line=" + this.getLine() + ":" + this.getCharPositionInLine();
        super.traceOut(ruleName, ruleIndex, inputSymbol);
    }
}

