/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.antlr.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.libraries.antlr.runtime.CommonTokenStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.Token;
import org.eclipse.persistence.internal.libraries.antlr.runtime.TokenSource;

public class TokenRewriteStream
extends CommonTokenStream {
    public static final String DEFAULT_PROGRAM_NAME = "default";
    public static final int PROGRAM_INIT_SIZE = 100;
    public static final int MIN_TOKEN_INDEX = 0;
    protected Map programs = null;
    protected Map lastRewriteTokenIndexes = null;

    public TokenRewriteStream() {
        this.init();
    }

    protected void init() {
        this.programs = new HashMap();
        this.programs.put(DEFAULT_PROGRAM_NAME, new ArrayList(100));
        this.lastRewriteTokenIndexes = new HashMap();
    }

    public TokenRewriteStream(TokenSource tokenSource) {
        super(tokenSource);
        this.init();
    }

    public TokenRewriteStream(TokenSource tokenSource, int channel) {
        super(tokenSource, channel);
        this.init();
    }

    public void rollback(int instructionIndex) {
        this.rollback(DEFAULT_PROGRAM_NAME, instructionIndex);
    }

    public void rollback(String programName, int instructionIndex) {
        List is = (List)this.programs.get(programName);
        if (is != null) {
            this.programs.put(programName, is.subList(0, instructionIndex));
        }
    }

    public void deleteProgram() {
        this.deleteProgram(DEFAULT_PROGRAM_NAME);
    }

    public void deleteProgram(String programName) {
        this.rollback(programName, 0);
    }

    protected void addToSortedRewriteList(RewriteOperation op) {
        this.addToSortedRewriteList(DEFAULT_PROGRAM_NAME, op);
    }

    protected void addToSortedRewriteList(String programName, RewriteOperation op) {
        Comparator comparator;
        List rewrites = this.getProgram(programName);
        int pos = Collections.binarySearch(rewrites, op, comparator = new Comparator(){

            public int compare(Object o, Object o1) {
                RewriteOperation a = (RewriteOperation)o;
                RewriteOperation b = (RewriteOperation)o1;
                if (a.index < b.index) {
                    return -1;
                }
                if (a.index > b.index) {
                    return 1;
                }
                return 0;
            }
        });
        if (pos >= 0) {
            while (pos >= 0) {
                RewriteOperation prevOp = (RewriteOperation)rewrites.get(pos);
                if (prevOp.index < op.index) break;
                --pos;
            }
            ++pos;
            if (op instanceof ReplaceOp) {
                int i;
                boolean replaced = false;
                for (i = pos; i < rewrites.size(); ++i) {
                    RewriteOperation prevOp = (RewriteOperation)rewrites.get(pos);
                    if (prevOp.index != op.index) break;
                    if (!(prevOp instanceof ReplaceOp)) continue;
                    rewrites.set(pos, op);
                    replaced = true;
                    break;
                }
                if (!replaced) {
                    rewrites.add(i, op);
                }
            } else {
                rewrites.add(pos, op);
            }
        } else {
            rewrites.add(-pos - 1, op);
        }
    }

    public void insertAfter(Token t, Object text) {
        this.insertAfter(DEFAULT_PROGRAM_NAME, t, text);
    }

    public void insertAfter(int index, Object text) {
        this.insertAfter(DEFAULT_PROGRAM_NAME, index, text);
    }

    public void insertAfter(String programName, Token t, Object text) {
        this.insertAfter(programName, t.getTokenIndex(), text);
    }

    public void insertAfter(String programName, int index, Object text) {
        this.insertBefore(programName, index + 1, text);
    }

    public void insertBefore(Token t, Object text) {
        this.insertBefore(DEFAULT_PROGRAM_NAME, t, text);
    }

    public void insertBefore(int index, Object text) {
        this.insertBefore(DEFAULT_PROGRAM_NAME, index, text);
    }

    public void insertBefore(String programName, Token t, Object text) {
        this.insertBefore(programName, t.getTokenIndex(), text);
    }

    public void insertBefore(String programName, int index, Object text) {
        this.addToSortedRewriteList(programName, new InsertBeforeOp(index, text));
    }

    public void replace(int index, Object text) {
        this.replace(DEFAULT_PROGRAM_NAME, index, index, text);
    }

    public void replace(int from, int to, Object text) {
        this.replace(DEFAULT_PROGRAM_NAME, from, to, text);
    }

    public void replace(Token indexT, Object text) {
        this.replace(DEFAULT_PROGRAM_NAME, indexT, indexT, text);
    }

    public void replace(Token from, Token to, Object text) {
        this.replace(DEFAULT_PROGRAM_NAME, from, to, text);
    }

    public void replace(String programName, int from, int to, Object text) {
        if (from > to || from < 0 || to < 0) {
            return;
        }
        this.addToSortedRewriteList(programName, new ReplaceOp(from, to, text));
    }

    public void replace(String programName, Token from, Token to, Object text) {
        this.replace(programName, from.getTokenIndex(), to.getTokenIndex(), text);
    }

    public void delete(int index) {
        this.delete(DEFAULT_PROGRAM_NAME, index, index);
    }

    public void delete(int from, int to) {
        this.delete(DEFAULT_PROGRAM_NAME, from, to);
    }

    public void delete(Token indexT) {
        this.delete(DEFAULT_PROGRAM_NAME, indexT, indexT);
    }

    public void delete(Token from, Token to) {
        this.delete(DEFAULT_PROGRAM_NAME, from, to);
    }

    public void delete(String programName, int from, int to) {
        this.replace(programName, from, to, null);
    }

    public void delete(String programName, Token from, Token to) {
        this.replace(programName, from, to, null);
    }

    public int getLastRewriteTokenIndex() {
        return this.getLastRewriteTokenIndex(DEFAULT_PROGRAM_NAME);
    }

    protected int getLastRewriteTokenIndex(String programName) {
        Integer I = (Integer)this.lastRewriteTokenIndexes.get(programName);
        if (I == null) {
            return -1;
        }
        return I;
    }

    protected void setLastRewriteTokenIndex(String programName, int i) {
        this.lastRewriteTokenIndexes.put(programName, new Integer(i));
    }

    protected List getProgram(String name) {
        List is = (List)this.programs.get(name);
        if (is == null) {
            is = this.initializeProgram(name);
        }
        return is;
    }

    private List initializeProgram(String name) {
        ArrayList is = new ArrayList(100);
        this.programs.put(name, is);
        return is;
    }

    public String toOriginalString() {
        return this.toOriginalString(0, this.size() - 1);
    }

    public String toOriginalString(int start, int end) {
        StringBuffer buf = new StringBuffer();
        for (int i = start; i >= 0 && i <= end && i < this.tokens.size(); ++i) {
            buf.append(this.get(i).getText());
        }
        return buf.toString();
    }

    public String toString() {
        return this.toString(0, this.size() - 1);
    }

    public String toString(String programName) {
        return this.toString(programName, 0, this.size() - 1);
    }

    public String toString(int start, int end) {
        return this.toString(DEFAULT_PROGRAM_NAME, start, end);
    }

    public String toString(String programName, int start, int end) {
        List rewrites = (List)this.programs.get(programName);
        if (rewrites == null || rewrites.size() == 0) {
            return this.toOriginalString(start, end);
        }
        StringBuffer buf = new StringBuffer();
        int rewriteOpIndex = 0;
        int tokenCursor = start;
        while (tokenCursor >= 0 && tokenCursor <= end && tokenCursor < this.tokens.size()) {
            if (rewriteOpIndex < rewrites.size()) {
                RewriteOperation op = (RewriteOperation)rewrites.get(rewriteOpIndex);
                while (op.index < tokenCursor && rewriteOpIndex < rewrites.size()) {
                    if (++rewriteOpIndex >= rewrites.size()) continue;
                    op = (RewriteOperation)rewrites.get(rewriteOpIndex);
                }
                while (tokenCursor == op.index && rewriteOpIndex < rewrites.size()) {
                    tokenCursor = op.execute(buf);
                    if (++rewriteOpIndex >= rewrites.size()) continue;
                    op = (RewriteOperation)rewrites.get(rewriteOpIndex);
                }
            }
            if (tokenCursor > end) continue;
            buf.append(this.get(tokenCursor).getText());
            ++tokenCursor;
        }
        for (int opi = rewriteOpIndex; opi < rewrites.size(); ++opi) {
            RewriteOperation op = (RewriteOperation)rewrites.get(opi);
            if (op.index < this.size()) continue;
            op.execute(buf);
        }
        return buf.toString();
    }

    public String toDebugString() {
        return this.toDebugString(0, this.size() - 1);
    }

    public String toDebugString(int start, int end) {
        StringBuffer buf = new StringBuffer();
        for (int i = start; i >= 0 && i <= end && i < this.tokens.size(); ++i) {
            buf.append(this.get(i));
        }
        return buf.toString();
    }

    static class DeleteOp
    extends ReplaceOp {
        public DeleteOp(int from, int to) {
            super(from, to, null);
        }
    }

    static class ReplaceOp
    extends RewriteOperation {
        protected int lastIndex;

        public ReplaceOp(int from, int to, Object text) {
            super(from, text);
            this.lastIndex = to;
        }

        public int execute(StringBuffer buf) {
            if (this.text != null) {
                buf.append(this.text);
            }
            return this.lastIndex + 1;
        }
    }

    static class InsertBeforeOp
    extends RewriteOperation {
        public InsertBeforeOp(int index, Object text) {
            super(index, text);
        }

        public int execute(StringBuffer buf) {
            buf.append(this.text);
            return this.index;
        }
    }

    static class RewriteOperation {
        protected int index;
        protected Object text;

        protected RewriteOperation(int index, Object text) {
            this.index = index;
            this.text = text;
        }

        public int execute(StringBuffer buf) {
            return this.index;
        }

        public String toString() {
            String opName = this.getClass().getName();
            int $index = opName.indexOf(36);
            opName = opName.substring($index + 1, opName.length());
            return opName + "@" + this.index + '\"' + this.text + '\"';
        }
    }
}

