/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.lang.reflect.Modifier;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeObjectMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.XMLNillableMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.NullPolicy;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.w3c.dom.Element;

public class XMLCompositeObjectMapping
extends AbstractCompositeObjectMapping
implements XMLMapping,
XMLNillableMapping {
    private static final String EMPTY_STRING = "";
    AbstractNullPolicy nullPolicy = new NullPolicy();

    public void initialize(AbstractSession session) throws DescriptorException {
        if (this.getReferenceClass() == null && this.getReferenceClassName() != null) {
            this.setReferenceClass(session.getDatasourcePlatform().getConversionManager().convertClassNameToClass(this.getReferenceClassName()));
        }
        if (this.getReferenceClass() != null) {
            super.initialize(session);
        } else {
            if (this.getField() == null) {
                throw DescriptorException.fieldNameNotSetInMapping(this);
            }
            this.setField(this.getDescriptor().buildField(this.getField()));
            this.setFields(this.collectFields());
            if (this.hasConverter()) {
                this.getConverter().initialize(this, session);
            }
        }
    }

    public void setNullPolicy(AbstractNullPolicy aNullPolicy) {
        this.nullPolicy = aNullPolicy;
    }

    public AbstractNullPolicy getNullPolicy() {
        return this.nullPolicy;
    }

    public boolean isXMLMapping() {
        return true;
    }

    public String getXPath() {
        return this.getField().getName();
    }

    public void setXPath(String xpathString) {
        this.setField(new XMLField(xpathString));
    }

    protected Object buildCompositeRow(Object attributeValue, AbstractSession session, AbstractRecord databaseRow) {
        ClassDescriptor classDesc = this.getReferenceDescriptor(attributeValue, session);
        XMLObjectBuilder objectBuilder = (XMLObjectBuilder)classDesc.getObjectBuilder();
        XMLField xmlFld = (XMLField)this.getField();
        if (xmlFld.hasLastXPathFragment() && xmlFld.getLastXPathFragment().hasLeafElementType()) {
            XMLRecord xmlRec = (XMLRecord)databaseRow;
            xmlRec.setLeafElementType(xmlFld.getLastXPathFragment().getLeafElementType());
        }
        XMLRecord parent = (XMLRecord)databaseRow;
        boolean addXsiType = this.shouldAddXsiType((XMLRecord)databaseRow, classDesc);
        XMLRecord child = (XMLRecord)objectBuilder.createRecordFor(attributeValue, (XMLField)this.getField(), parent, this);
        child.setNamespaceResolver(parent.getNamespaceResolver());
        objectBuilder.buildIntoNestedRow(child, attributeValue, session, addXsiType);
        return child;
    }

    protected Object buildCompositeObject(ObjectBuilder objectBuilder, AbstractRecord nestedRow, ObjectBuildingQuery query, JoinedAttributeManager joinManager) {
        return objectBuilder.buildObject(query, nestedRow, joinManager);
    }

    public Object readFromRowIntoObject(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object targetObject, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        Object fieldValue = databaseRow.getIndicatingNoEntry(this.getField());
        if (null == fieldValue || fieldValue instanceof String) {
            if (!this.getNullPolicy().getIsSetPerformedForAbsentNode()) {
                return null;
            }
            this.setAttributeValueInObject(targetObject, null);
            return null;
        }
        XMLRecord nestedRow = (XMLRecord)this.getDescriptor().buildNestedRowFromFieldValue(fieldValue);
        if (this.getNullPolicy().valueIsNull((Element)nestedRow.getDOM())) {
            this.setAttributeValueInObject(targetObject, null);
            return null;
        }
        Object attributeValue = this.valueFromRow(fieldValue, nestedRow, joinManager, sourceQuery, executionSession);
        this.setAttributeValueInObject(targetObject, attributeValue);
        return attributeValue;
    }

    public Object valueFromRow(Object fieldValue, XMLRecord nestedRow, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        ClassDescriptor aDescriptor = this.getReferenceDescriptor((DOMRecord)nestedRow);
        if (aDescriptor.hasInheritance()) {
            QName leafElementType;
            Class classValue = aDescriptor.getInheritancePolicy().classFromRow(nestedRow, executionSession);
            if (classValue == null && (leafElementType = ((XMLField)this.getField()).getLeafElementType()) != null) {
                Object indicator = aDescriptor.getInheritancePolicy().getClassIndicatorMapping().get(leafElementType);
                if (indicator == null) {
                    throw DescriptorException.missingClassForIndicatorFieldValue(leafElementType, aDescriptor.getInheritancePolicy().getDescriptor());
                }
                classValue = (Class)indicator;
            }
            if (classValue != null) {
                aDescriptor = this.getReferenceDescriptor(classValue, executionSession);
            } else if (Modifier.isAbstract(aDescriptor.getJavaClass().getModifiers())) {
                throw DescriptorException.missingClassIndicatorField(nestedRow, aDescriptor.getInheritancePolicy().getDescriptor());
            }
        }
        ObjectBuilder objectBuilder = aDescriptor.getObjectBuilder();
        Object toReturn = this.buildCompositeObject(objectBuilder, nestedRow, sourceQuery, joinManager);
        if (this.getConverter() != null) {
            toReturn = this.getConverter() instanceof XMLConverter ? ((XMLConverter)this.getConverter()).convertDataValueToObjectValue(toReturn, executionSession, nestedRow.getUnmarshaller()) : this.getConverter().convertDataValueToObjectValue(toReturn, executionSession);
        }
        return toReturn;
    }

    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        Object fieldValue = row.get(this.getField());
        if (fieldValue == null || fieldValue instanceof String) {
            return null;
        }
        XMLRecord nestedRow = (XMLRecord)this.getDescriptor().buildNestedRowFromFieldValue(fieldValue);
        if (this.getNullPolicy().valueIsNull((Element)nestedRow.getDOM())) {
            return null;
        }
        return this.valueFromRow(fieldValue, nestedRow, joinManager, sourceQuery, executionSession);
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord databaseRow, AbstractSession session) throws DescriptorException {
        if (this.isReadOnly()) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(object);
        this.writeSingleValue(attributeValue, object, (XMLRecord)databaseRow, session);
    }

    public void writeSingleValue(Object value, Object parent, XMLRecord record, AbstractSession session) {
        Object attributeValue = value;
        if (this.getConverter() != null) {
            attributeValue = this.getConverter() instanceof XMLConverter ? ((XMLConverter)this.getConverter()).convertObjectValueToDataValue(attributeValue, session, record.getMarshaller()) : this.getConverter().convertObjectValueToDataValue(attributeValue, session);
        }
        if (((XMLField)this.getField()).isSelfField()) {
            XMLObjectBuilder objectBuilder = (XMLObjectBuilder)this.getReferenceDescriptor(attributeValue.getClass(), session).getObjectBuilder();
            objectBuilder.buildIntoNestedRow(record, attributeValue, session);
        } else {
            Object fieldValue = null;
            if (attributeValue != null) {
                fieldValue = this.buildCompositeRow(attributeValue, session, record);
            } else if (this.getNullPolicy().compositeObjectMarshal(record, parent, (XMLField)this.getField())) {
                return;
            }
            record.put(this.getField(), fieldValue);
        }
    }

    public void configureNestedRow(AbstractRecord parent, AbstractRecord child) {
        XMLRecord parentRecord = (XMLRecord)parent;
        XMLRecord childRecord = (XMLRecord)child;
        childRecord.setUnmarshaller(parentRecord.getUnmarshaller());
        childRecord.setOwningObject(parentRecord.getCurrentObject());
    }

    public ClassDescriptor getReferenceDescriptor(DOMRecord xmlRecord) {
        ClassDescriptor returnDescriptor = this.referenceDescriptor;
        if (returnDescriptor == null) {
            String type = ((Element)xmlRecord.getDOM()).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (null != type && !type.equals(EMPTY_STRING)) {
                XPathFragment typeFragment = new XPathFragment(type);
                String namespaceURI = xmlRecord.resolveNamespacePrefix(typeFragment.getPrefix());
                typeFragment.setNamespaceURI(namespaceURI);
                returnDescriptor = xmlRecord.getUnmarshaller().getXMLContext().getDescriptorByGlobalType(typeFragment);
            } else {
                QName leafType = ((XMLField)this.getField()).getLastXPathFragment().getLeafElementType();
                if (leafType != null) {
                    XPathFragment frag = new XPathFragment();
                    String xpath = leafType.getLocalPart();
                    String uri = leafType.getNamespaceURI();
                    if (uri != null && !uri.equals(EMPTY_STRING)) {
                        frag.setNamespaceURI(uri);
                        String prefix = ((XMLDescriptor)this.getDescriptor()).getNonNullNamespaceResolver().resolveNamespaceURI(uri);
                        if (prefix != null && !prefix.equals(EMPTY_STRING)) {
                            xpath = prefix + ":" + xpath;
                        }
                    }
                    frag.setXPath(xpath);
                    returnDescriptor = xmlRecord.getUnmarshaller().getXMLContext().getDescriptorByGlobalType(frag);
                }
            }
        }
        if (returnDescriptor == null) {
            throw XMLMarshalException.noDescriptorFound(this);
        }
        return returnDescriptor;
    }

    protected ClassDescriptor getReferenceDescriptor(Class theClass, AbstractSession session) {
        if (this.getReferenceDescriptor() != null && this.getReferenceDescriptor().getJavaClass().equals(theClass)) {
            return this.getReferenceDescriptor();
        }
        ClassDescriptor subDescriptor = session.getDescriptor(theClass);
        if (subDescriptor == null) {
            throw DescriptorException.noSubClassMatch(theClass, this);
        }
        return subDescriptor;
    }

    public boolean shouldAddXsiType(XMLRecord record, ClassDescriptor aDescriptor) {
        XMLDescriptor xmlDescriptor = (XMLDescriptor)aDescriptor;
        if (this.getReferenceDescriptor() == null && xmlDescriptor.getSchemaReference() != null) {
            XMLField indicatorField;
            if (aDescriptor.hasInheritance() && (indicatorField = (XMLField)aDescriptor.getInheritancePolicy().getClassIndicatorField()).getLastXPathFragment().getNamespaceURI() != null && indicatorField.getLastXPathFragment().getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema-instance") && indicatorField.getLastXPathFragment().getLocalName().equals("type")) {
                return false;
            }
            XMLSchemaReference xmlRef = xmlDescriptor.getSchemaReference();
            if (xmlRef.getType() == 1 && xmlRef.isGlobalDefinition()) {
                QName ctxQName = xmlRef.getSchemaContextAsQName(xmlDescriptor.getNamespaceResolver());
                QName leafType = ((XMLField)this.getField()).getLeafElementType();
                if (leafType == null || !ctxQName.equals(record.getLeafElementType())) {
                    return true;
                }
            }
        }
        return false;
    }
}

