/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.tree.analysis;

import java.util.ArrayList;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.libraries.asm.tree.AbstractInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.IincInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.MethodInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.MultiANewArrayInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.VarInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.AnalyzerException;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.Interpreter;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.Value;

public class Frame {
    private Value[] locals;
    private Value[] stack;
    private int top;

    public Frame(int nLocals, int nStack) {
        this.locals = new Value[nLocals];
        this.stack = new Value[nStack];
    }

    public Frame(Frame src) {
        this(src.locals.length, src.stack.length);
        this.init(src);
    }

    public Frame init(Frame src) {
        System.arraycopy(src.locals, 0, this.locals, 0, this.locals.length);
        System.arraycopy(src.stack, 0, this.stack, 0, src.top);
        this.top = src.top;
        return this;
    }

    public int getLocals() {
        return this.locals.length;
    }

    public Value getLocal(int i) throws AnalyzerException {
        if (i >= this.locals.length) {
            throw new AnalyzerException("Trying to access an inexistant local variable");
        }
        return this.locals[i];
    }

    public void setLocal(int i, Value value) throws AnalyzerException {
        if (i >= this.locals.length) {
            throw new AnalyzerException("Trying to access an inexistant local variable");
        }
        this.locals[i] = value;
    }

    public int getStackSize() {
        return this.top;
    }

    public Value getStack(int i) throws AnalyzerException {
        if (i >= this.top) {
            throw new AnalyzerException("Trying to access an inexistant stack element");
        }
        return this.stack[i];
    }

    public void clearStack() {
        this.top = 0;
    }

    public Value pop() throws AnalyzerException {
        if (this.top == 0) {
            throw new AnalyzerException("Cannot pop operand off an empty stack.");
        }
        return this.stack[--this.top];
    }

    public void push(Value value) throws AnalyzerException {
        if (this.top >= this.stack.length) {
            throw new AnalyzerException("Insufficient maximum stack size.");
        }
        this.stack[this.top++] = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(AbstractInsnNode insn, Interpreter interpreter) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 0: {
                return;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                this.push(interpreter.newOperation(insn));
                return;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.push(interpreter.copyOperation(insn, this.getLocal(((VarInsnNode)insn).var)));
                return;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                Value value2 = this.pop();
                Value value1 = this.pop();
                this.push(interpreter.binaryOperation(insn, value1, value2));
                return;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                Value value1 = interpreter.copyOperation(insn, this.pop());
                int var = ((VarInsnNode)insn).var;
                this.setLocal(var, value1);
                if (value1.getSize() == 2) {
                    this.setLocal(var + 1, interpreter.newValue(null));
                }
                if (var <= 0 || this.getLocal(var - 1).getSize() != 2) return;
                this.setLocal(var - 1, interpreter.newValue(null));
                return;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                Value value3 = this.pop();
                Value value2 = this.pop();
                Value value1 = this.pop();
                interpreter.ternaryOperation(insn, value1, value2, value3);
                return;
            }
            case 87: {
                if (this.pop().getSize() != 2) return;
                throw new AnalyzerException("Illegal use of POP");
            }
            case 88: {
                if (this.pop().getSize() != 1 || this.pop().getSize() == 1) return;
                throw new AnalyzerException("Illegal use of POP2");
            }
            case 89: {
                Value value1 = this.pop();
                if (value1.getSize() != 1) {
                    throw new AnalyzerException("Illegal use of DUP");
                }
                this.push(interpreter.copyOperation(insn, value1));
                this.push(interpreter.copyOperation(insn, value1));
                return;
            }
            case 90: {
                Value value1 = this.pop();
                Value value2 = this.pop();
                if (value1.getSize() != 1 || value2.getSize() != 1) {
                    throw new AnalyzerException("Illegal use of DUP_X1");
                }
                this.push(interpreter.copyOperation(insn, value1));
                this.push(interpreter.copyOperation(insn, value2));
                this.push(interpreter.copyOperation(insn, value1));
                return;
            }
            case 91: {
                Value value1 = this.pop();
                if (value1.getSize() != 1) throw new AnalyzerException("Illegal use of DUP_X2");
                Value value2 = this.pop();
                if (value2.getSize() == 1) {
                    Value value3 = this.pop();
                    if (value3.getSize() != 1) throw new AnalyzerException("Illegal use of DUP_X2");
                    this.push(interpreter.copyOperation(insn, value1));
                    this.push(interpreter.copyOperation(insn, value3));
                    this.push(interpreter.copyOperation(insn, value2));
                    this.push(interpreter.copyOperation(insn, value1));
                    return;
                }
                this.push(interpreter.copyOperation(insn, value1));
                this.push(interpreter.copyOperation(insn, value2));
                this.push(interpreter.copyOperation(insn, value1));
                return;
            }
            case 92: {
                Value value1 = this.pop();
                if (value1.getSize() == 1) {
                    Value value2 = this.pop();
                    if (value2.getSize() != 1) throw new AnalyzerException("Illegal use of DUP2");
                    this.push(interpreter.copyOperation(insn, value2));
                    this.push(interpreter.copyOperation(insn, value1));
                    this.push(interpreter.copyOperation(insn, value2));
                    this.push(interpreter.copyOperation(insn, value1));
                    return;
                }
                this.push(interpreter.copyOperation(insn, value1));
                this.push(interpreter.copyOperation(insn, value1));
                return;
            }
            case 93: {
                Value value1 = this.pop();
                if (value1.getSize() == 1) {
                    Value value3;
                    Value value2 = this.pop();
                    if (value2.getSize() != 1 || (value3 = this.pop()).getSize() != 1) throw new AnalyzerException("Illegal use of DUP2_X1");
                    this.push(interpreter.copyOperation(insn, value2));
                    this.push(interpreter.copyOperation(insn, value1));
                    this.push(interpreter.copyOperation(insn, value3));
                    this.push(interpreter.copyOperation(insn, value2));
                    this.push(interpreter.copyOperation(insn, value1));
                    return;
                }
                Value value2 = this.pop();
                if (value2.getSize() != 1) throw new AnalyzerException("Illegal use of DUP2_X1");
                this.push(interpreter.copyOperation(insn, value1));
                this.push(interpreter.copyOperation(insn, value2));
                this.push(interpreter.copyOperation(insn, value1));
                return;
            }
            case 94: {
                Value value1 = this.pop();
                if (value1.getSize() == 1) {
                    Value value2 = this.pop();
                    if (value2.getSize() != 1) throw new AnalyzerException("Illegal use of DUP2_X2");
                    Value value3 = this.pop();
                    if (value3.getSize() == 1) {
                        Value value4 = this.pop();
                        if (value4.getSize() != 1) throw new AnalyzerException("Illegal use of DUP2_X2");
                        this.push(interpreter.copyOperation(insn, value2));
                        this.push(interpreter.copyOperation(insn, value1));
                        this.push(interpreter.copyOperation(insn, value4));
                        this.push(interpreter.copyOperation(insn, value3));
                        this.push(interpreter.copyOperation(insn, value2));
                        this.push(interpreter.copyOperation(insn, value1));
                        return;
                    }
                    this.push(interpreter.copyOperation(insn, value2));
                    this.push(interpreter.copyOperation(insn, value1));
                    this.push(interpreter.copyOperation(insn, value3));
                    this.push(interpreter.copyOperation(insn, value2));
                    this.push(interpreter.copyOperation(insn, value1));
                    return;
                }
                Value value2 = this.pop();
                if (value2.getSize() == 1) {
                    Value value3 = this.pop();
                    if (value3.getSize() != 1) throw new AnalyzerException("Illegal use of DUP2_X2");
                    this.push(interpreter.copyOperation(insn, value1));
                    this.push(interpreter.copyOperation(insn, value3));
                    this.push(interpreter.copyOperation(insn, value2));
                    this.push(interpreter.copyOperation(insn, value1));
                    return;
                }
                this.push(interpreter.copyOperation(insn, value1));
                this.push(interpreter.copyOperation(insn, value2));
                this.push(interpreter.copyOperation(insn, value1));
                return;
            }
            case 95: {
                Value value2 = this.pop();
                Value value1 = this.pop();
                if (value1.getSize() != 1 || value2.getSize() != 1) {
                    throw new AnalyzerException("Illegal use of SWAP");
                }
                this.push(interpreter.copyOperation(insn, value2));
                this.push(interpreter.copyOperation(insn, value1));
                return;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                Value value2 = this.pop();
                Value value1 = this.pop();
                this.push(interpreter.binaryOperation(insn, value1, value2));
                return;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                this.push(interpreter.unaryOperation(insn, this.pop()));
                return;
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                Value value2 = this.pop();
                Value value1 = this.pop();
                this.push(interpreter.binaryOperation(insn, value1, value2));
                return;
            }
            case 132: {
                int var = ((IincInsnNode)insn).var;
                this.setLocal(var, interpreter.unaryOperation(insn, this.getLocal(var)));
                return;
            }
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: {
                this.push(interpreter.unaryOperation(insn, this.pop()));
                return;
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                Value value2 = this.pop();
                Value value1 = this.pop();
                this.push(interpreter.binaryOperation(insn, value1, value2));
                return;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                interpreter.unaryOperation(insn, this.pop());
                return;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                Value value2 = this.pop();
                Value value1 = this.pop();
                interpreter.binaryOperation(insn, value1, value2);
                return;
            }
            case 167: {
                return;
            }
            case 168: {
                this.push(interpreter.newOperation(insn));
                return;
            }
            case 169: {
                return;
            }
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                interpreter.unaryOperation(insn, this.pop());
                return;
            }
            case 177: {
                return;
            }
            case 178: {
                this.push(interpreter.newOperation(insn));
                return;
            }
            case 179: {
                interpreter.unaryOperation(insn, this.pop());
                return;
            }
            case 180: {
                this.push(interpreter.unaryOperation(insn, this.pop()));
                return;
            }
            case 181: {
                Value value2 = this.pop();
                Value value1 = this.pop();
                interpreter.binaryOperation(insn, value1, value2);
                return;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                ArrayList<Value> values = new ArrayList<Value>();
                String desc = ((MethodInsnNode)insn).desc;
                for (int i = Type.getArgumentTypes(desc).length; i > 0; --i) {
                    values.add(0, this.pop());
                }
                if (insn.getOpcode() != 184) {
                    values.add(0, this.pop());
                }
                if (Type.getReturnType(desc) == Type.VOID_TYPE) {
                    interpreter.naryOperation(insn, values);
                    return;
                }
                this.push(interpreter.naryOperation(insn, values));
                return;
            }
            case 187: {
                this.push(interpreter.newOperation(insn));
                return;
            }
            case 188: 
            case 189: 
            case 190: {
                this.push(interpreter.unaryOperation(insn, this.pop()));
                return;
            }
            case 191: {
                interpreter.unaryOperation(insn, this.pop());
                return;
            }
            case 192: 
            case 193: {
                this.push(interpreter.unaryOperation(insn, this.pop()));
                return;
            }
            case 194: 
            case 195: {
                interpreter.unaryOperation(insn, this.pop());
                return;
            }
            case 197: {
                ArrayList<Value> values = new ArrayList<Value>();
                for (int i = ((MultiANewArrayInsnNode)insn).dims; i > 0; --i) {
                    values.add(0, this.pop());
                }
                this.push(interpreter.naryOperation(insn, values));
                return;
            }
            case 198: 
            case 199: {
                interpreter.unaryOperation(insn, this.pop());
                return;
            }
            default: {
                throw new RuntimeException("Illegal opcode");
            }
        }
    }

    public boolean merge(Frame frame, Interpreter interpreter) throws AnalyzerException {
        Value v;
        int i;
        if (this.top != frame.top) {
            throw new AnalyzerException("Incompatible stack heights");
        }
        boolean changes = false;
        for (i = 0; i < this.locals.length; ++i) {
            v = interpreter.merge(this.locals[i], frame.locals[i]);
            if (v == this.locals[i]) continue;
            this.locals[i] = v;
            changes |= true;
        }
        for (i = 0; i < this.top; ++i) {
            v = interpreter.merge(this.stack[i], frame.stack[i]);
            if (v == this.stack[i]) continue;
            this.stack[i] = v;
            changes |= true;
        }
        return changes;
    }

    public boolean merge(Frame frame, boolean[] access) {
        boolean changes = false;
        for (int i = 0; i < this.locals.length; ++i) {
            if (access[i] || this.locals[i].equals(frame.locals[i])) continue;
            this.locals[i] = frame.locals[i];
            changes = true;
        }
        return changes;
    }

    public String toString() {
        int i;
        StringBuffer b = new StringBuffer();
        for (i = 0; i < this.locals.length; ++i) {
            b.append(this.locals[i]);
        }
        b.append(' ');
        for (i = 0; i < this.top; ++i) {
            b.append(this.stack[i].toString());
        }
        return b.toString();
    }
}

