/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.attrs;

import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ByteVector;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.Label;

public class SourceDebugExtensionAttribute
extends Attribute {
    public String debugExtension;

    public SourceDebugExtensionAttribute() {
        super("SourceDebugExtension");
    }

    public SourceDebugExtensionAttribute(String debugExtension) {
        this();
        this.debugExtension = debugExtension;
    }

    protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
        return new SourceDebugExtensionAttribute(this.readUTF8(cr, off, len));
    }

    protected ByteVector write(ClassWriter cw, byte[] code, int len, int maxStack, int maxLocals) {
        byte[] b = this.putUTF8(this.debugExtension);
        return new ByteVector().putByteArray(b, 0, b.length);
    }

    private String readUTF8(ClassReader cr, int index, int utfLen) {
        int endIndex = index + utfLen;
        byte[] b = cr.b;
        char[] buf = new char[utfLen];
        int strLen = 0;
        block4: while (index < endIndex) {
            byte d;
            int c = b[index++] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    buf[strLen++] = (char)c;
                    continue block4;
                }
                case 12: 
                case 13: {
                    d = b[index++];
                    buf[strLen++] = (char)((c & 0x1F) << 6 | d & 0x3F);
                    continue block4;
                }
            }
            d = b[index++];
            byte e = b[index++];
            buf[strLen++] = (char)((c & 0xF) << 12 | (d & 0x3F) << 6 | e & 0x3F);
        }
        return new String(buf, 0, strLen);
    }

    private byte[] putUTF8(String s) {
        int charLength = s.length();
        int byteLength = 0;
        for (int i = 0; i < charLength; ++i) {
            char c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++byteLength;
                continue;
            }
            if (c > '\u07ff') {
                byteLength += 3;
                continue;
            }
            byteLength += 2;
        }
        byte[] data = new byte[byteLength];
        int i = 0;
        while (i < charLength) {
            char c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                data[i++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                data[i++] = (byte)(0xE0 | c >> 12 & 0xF);
                data[i++] = (byte)(0x80 | c >> 6 & 0x3F);
                data[i++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            data[i++] = (byte)(0xC0 | c >> 6 & 0x1F);
            data[i++] = (byte)(0x80 | c & 0x3F);
        }
        return data;
    }

    public String toString() {
        return this.debugExtension;
    }
}

