/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.PlatformUnmarshaller;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatformException;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class DOMUnmarshaller
implements PlatformUnmarshaller {
    private XMLParser parser = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLParser();
    private XMLUnmarshaller xmlUnmarshaller;
    private boolean isResultAlwaysXMLRoot;

    public DOMUnmarshaller(XMLUnmarshaller xmlUnmarshaller) {
        this.parser.setNamespaceAware(true);
        this.parser.setValidationMode(0);
        this.xmlUnmarshaller = xmlUnmarshaller;
    }

    public EntityResolver getEntityResolver() {
        return this.parser.getEntityResolver();
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.parser.setEntityResolver(entityResolver);
    }

    public ErrorHandler getErrorHandler() {
        return this.parser.getErrorHandler();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.parser.setErrorHandler(errorHandler);
    }

    public int getValidationMode() {
        return this.parser.getValidationMode();
    }

    public void setValidationMode(int validationMode) {
        this.parser.setValidationMode(validationMode);
    }

    public void setWhitespacePreserving(boolean isWhitespacePreserving) {
        this.parser.setWhitespacePreserving(isWhitespacePreserving);
    }

    public void setSchemas(Object[] schemas) {
        try {
            this.parser.setXMLSchemas(schemas);
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.errorSettingSchemas(e, schemas);
        }
    }

    public Object unmarshal(File file) {
        try {
            Document document = null;
            document = this.parser.parse(file);
            return this.xmlToObject(new DOMRecord(document));
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
    }

    public Object unmarshal(File file, Class clazz) {
        try {
            Document document = null;
            document = this.parser.parse(file);
            return this.xmlToObject(new DOMRecord(document), clazz);
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
    }

    public Object unmarshal(InputStream inputStream) {
        try {
            Document document = null;
            document = this.parser.parse(inputStream);
            return this.xmlToObject(new DOMRecord(document));
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
    }

    public Object unmarshal(InputStream inputStream, Class clazz) {
        try {
            Document document = null;
            document = this.parser.parse(inputStream);
            return this.xmlToObject(new DOMRecord(document), clazz);
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
    }

    public Object unmarshal(InputSource inputSource) {
        try {
            Document document = null;
            document = this.parser.parse(inputSource);
            return this.xmlToObject(new DOMRecord(document));
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
    }

    public Object unmarshal(InputSource inputSource, Class clazz) {
        try {
            Document document = null;
            document = this.parser.parse(inputSource);
            return this.xmlToObject(new DOMRecord(document), clazz);
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
    }

    public Object unmarshal(Node node) {
        Element element = null;
        switch (node.getNodeType()) {
            case 9: {
                element = ((Document)node).getDocumentElement();
                break;
            }
            case 1: {
                element = (Element)node;
                break;
            }
            default: {
                throw XMLMarshalException.unmarshalException();
            }
        }
        return this.xmlToObject(new DOMRecord(element));
    }

    public Object unmarshal(Node node, Class clazz) {
        Element element = null;
        switch (node.getNodeType()) {
            case 9: {
                element = ((Document)node).getDocumentElement();
                break;
            }
            case 1: {
                element = (Element)node;
                break;
            }
            default: {
                throw XMLMarshalException.unmarshalException();
            }
        }
        return this.xmlToObject(new DOMRecord(element), clazz);
    }

    public Object unmarshal(Reader reader) {
        try {
            Document document = null;
            document = this.parser.parse(reader);
            return this.xmlToObject(new DOMRecord(document));
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
    }

    public Object unmarshal(Reader reader, Class clazz) {
        try {
            Document document = null;
            document = this.parser.parse(reader);
            return this.xmlToObject(new DOMRecord(document), clazz);
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
    }

    public Object unmarshal(Source source) {
        try {
            Document document = null;
            document = this.parser.parse(source);
            return this.xmlToObject(new DOMRecord(document));
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
    }

    public Object unmarshal(Source source, Class clazz) {
        try {
            Document document = null;
            document = this.parser.parse(source);
            return this.xmlToObject(new DOMRecord(document), clazz);
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
    }

    public Object unmarshal(URL url) {
        try {
            Document document = null;
            document = this.parser.parse(url);
            return this.xmlToObject(new DOMRecord(document));
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
    }

    public Object unmarshal(URL url, Class clazz) {
        try {
            Document document = null;
            document = this.parser.parse(url);
            return this.xmlToObject(new DOMRecord(document), clazz);
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
    }

    protected XMLDescriptor getDescriptor(DOMRecord xmlRecord) throws XMLMarshalException {
        QName rootQName;
        XMLContext xmlContext = this.xmlUnmarshaller.getXMLContext();
        XMLDescriptor xmlDescriptor = xmlContext.getDescriptor(rootQName = new QName(xmlRecord.getNamespaceURI(), xmlRecord.getLocalName()));
        if (null == xmlDescriptor) {
            String type = ((Element)xmlRecord.getDOM()).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (null != type) {
                XPathFragment typeFragment = new XPathFragment(type);
                String namespaceURI = xmlRecord.resolveNamespacePrefix(typeFragment.getPrefix());
                typeFragment.setNamespaceURI(namespaceURI);
                xmlDescriptor = xmlContext.getDescriptorByGlobalType(typeFragment);
            }
            if (null == xmlDescriptor) {
                throw XMLMarshalException.noDescriptorWithMatchingRootElement(rootQName.toString());
            }
        }
        return xmlDescriptor;
    }

    public Object xmlToObject(DOMRecord xmlRecord) throws XMLMarshalException {
        XMLDescriptor xmlDescriptor = this.getDescriptor(xmlRecord);
        return this.xmlToObject(xmlRecord, xmlDescriptor.getJavaClass());
    }

    public Object xmlToObject(DOMRecord xmlRow, Class referenceClass) throws XMLMarshalException {
        String xmlEncoding = "UTF-8";
        String xmlVersion = "1.0";
        try {
            Method getEncoding = PrivilegedAccessHelper.getMethod(xmlRow.getDocument().getClass(), "getXmlEncoding", new Class[0], true);
            Method getVersion = PrivilegedAccessHelper.getMethod(xmlRow.getDocument().getClass(), "getXmlVersion", new Class[0], true);
            xmlEncoding = (String)PrivilegedAccessHelper.invokeMethod(getEncoding, xmlRow.getDocument(), new Object[0]);
            xmlVersion = (String)PrivilegedAccessHelper.invokeMethod(getVersion, xmlRow.getDocument(), new Object[0]);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (XMLConversionManager.getDefaultJavaTypes().get(referenceClass) != null) {
            String nodeVal;
            try {
                Text rootTxt = (Text)xmlRow.getDOM().getFirstChild();
                nodeVal = rootTxt.getNodeValue();
            }
            catch (Exception ex) {
                nodeVal = null;
            }
            Object obj = XMLConversionManager.getDefaultXMLManager().convertObject(nodeVal, referenceClass);
            XMLRoot xmlRoot = new XMLRoot();
            xmlRoot.setObject(obj);
            String lName = xmlRow.getDOM().getLocalName();
            if (lName == null) {
                lName = xmlRow.getDOM().getNodeName();
            }
            xmlRoot.setLocalName(lName);
            xmlRoot.setNamespaceURI(xmlRow.getDOM().getNamespaceURI());
            xmlRoot.setEncoding(xmlEncoding);
            xmlRoot.setVersion(xmlVersion);
            return xmlRoot;
        }
        XMLContext xmlContext = this.xmlUnmarshaller.getXMLContext();
        AbstractSession session = xmlContext.getReadSession(referenceClass);
        ReadObjectQuery query = new ReadObjectQuery();
        query.setReferenceClass(referenceClass);
        query.setSession(session);
        XMLDescriptor descriptor = (XMLDescriptor)session.getDescriptor(referenceClass);
        if (descriptor == null) {
            throw XMLMarshalException.descriptorNotFoundInProject(referenceClass.getName());
        }
        xmlRow.setUnmarshaller(this.xmlUnmarshaller);
        xmlRow.setDocPresPolicy(xmlContext.getDocumentPreservationPolicy(session));
        XMLObjectBuilder objectBuilder = (XMLObjectBuilder)descriptor.getObjectBuilder();
        Object object = objectBuilder.buildObject(query, xmlRow, null);
        this.xmlUnmarshaller.resolveReferences(session);
        String elementNamespaceUri = xmlRow.getDOM().getNamespaceURI();
        String elementLocalName = xmlRow.getDOM().getLocalName();
        if (elementLocalName == null) {
            elementLocalName = xmlRow.getDOM().getNodeName();
        }
        String elementPrefix = xmlRow.getDOM().getPrefix();
        return descriptor.wrapObjectInXMLRoot(object, elementNamespaceUri, elementLocalName, elementPrefix, xmlEncoding, xmlVersion, this.isResultAlwaysXMLRoot);
    }

    public boolean isResultAlwaysXMLRoot() {
        return this.isResultAlwaysXMLRoot;
    }

    public void setResultAlwaysXMLRoot(boolean alwaysReturnRoot) {
        this.isResultAlwaysXMLRoot = alwaysReturnRoot;
    }
}

