/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.ClassExtractor;
import org.eclipse.persistence.descriptors.MethodClassExtractor;
import org.eclipse.persistence.descriptors.PessimisticLockingPolicy;
import org.eclipse.persistence.descriptors.ReturningPolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.queries.ExpressionQueryMechanism;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.TypedAssociation;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.remote.DistributedSession;

public class InheritancePolicy
implements Serializable,
Cloneable {
    protected Class parentClass;
    protected String parentClassName;
    protected ClassDescriptor parentDescriptor;
    protected Vector childDescriptors;
    protected transient DatabaseField classIndicatorField;
    protected transient Map classIndicatorMapping = new HashMap(10);
    protected transient Map classNameIndicatorMapping = new HashMap(10);
    protected transient boolean shouldUseClassNameAsIndicator = false;
    protected transient Boolean shouldReadSubclasses;
    protected transient boolean hasMultipleTableChild;
    protected transient DatabaseTable readAllSubclassesView;
    protected transient Vector allChildClassIndicators = NonSynchronizedVector.newInstance();
    protected transient Expression onlyInstancesExpression;
    protected transient Expression withAllSubclassesExpression;
    protected transient Vector allTables;
    protected transient List childrenTables;
    protected transient Map childrenTablesJoinExpressions;
    protected transient Expression childrenJoinExpression;
    protected transient ClassExtractor classExtractor;
    protected ClassDescriptor descriptor;
    protected boolean shouldAlwaysUseOuterJoin = false;
    protected boolean useDescriptorsToValidateInheritedObjects = false;
    protected boolean shouldOuterJoinSubclasses = false;
    protected boolean isJoinedStrategy;

    public InheritancePolicy() {
        this.childDescriptors = NonSynchronizedVector.newInstance(5);
        this.setJoinedStrategy();
    }

    public InheritancePolicy(ClassDescriptor descriptor) {
        this();
        this.descriptor = descriptor;
    }

    public void addChildDescriptor(ClassDescriptor childDescriptor) {
        this.getChildDescriptors().addElement(childDescriptor);
    }

    protected void addChildTableJoinExpression(DatabaseTable table, Expression expression) {
        if (this.childrenTablesJoinExpressions == null) {
            this.childrenTablesJoinExpressions = new HashMap();
            this.childrenTables = new ArrayList();
            this.allTables = new Vector<DatabaseTable>(this.getDescriptor().getTables());
        }
        this.childrenTables.add(table);
        this.allTables.add(table);
        this.childrenTablesJoinExpressions.put(table, expression);
        this.childrenJoinExpression = expression.and(this.childrenJoinExpression);
    }

    public void addChildTableJoinExpressionToAllParents(DatabaseTable table, Expression expression) {
        ClassDescriptor parentDescriptor = this.getParentDescriptor();
        while (parentDescriptor != null) {
            InheritancePolicy parentPolicy = parentDescriptor.getInheritancePolicy();
            parentPolicy.addChildTableJoinExpression(table, expression);
            parentDescriptor = parentPolicy.getParentDescriptor();
        }
    }

    public void addClassIndicator(Class childClass, Object typeValue) {
        this.getClassIndicatorMapping().put(typeValue, childClass);
        this.getClassIndicatorMapping().put(childClass, typeValue);
    }

    public void addClassNameIndicator(String childClassName, Object typeValue) {
        this.getClassNameIndicatorMapping().put(childClassName, typeValue);
    }

    public void addClassIndicatorFieldToInsertRow(AbstractRecord databaseRow) {
        if (this.hasClassExtractor()) {
            return;
        }
        DatabaseField field = this.getClassIndicatorField();
        databaseRow.put(field, (Object)null);
    }

    public void addClassIndicatorFieldToRow(AbstractRecord databaseRow) {
        if (this.hasClassExtractor()) {
            return;
        }
        DatabaseField field = this.getClassIndicatorField();
        Object value = this.getClassIndicatorValue();
        databaseRow.put(field, value);
    }

    protected void addClassIndicatorTypeToParent(Object indicator) {
        ClassDescriptor parentDescriptor = this.getDescriptor().getInheritancePolicy().getParentDescriptor();
        if (parentDescriptor.getInheritancePolicy().isChildDescriptor()) {
            if (parentDescriptor.getInheritancePolicy().shouldReadSubclasses()) {
                parentDescriptor.getInheritancePolicy().getAllChildClassIndicators().addElement(indicator);
            }
            parentDescriptor.getInheritancePolicy().addClassIndicatorTypeToParent(indicator);
        }
    }

    protected void addFieldsToParent(Vector fields) {
        if (this.isChildDescriptor()) {
            if (this.getParentDescriptor().isInvalid()) {
                return;
            }
            ClassDescriptor parentDescriptor = this.getParentDescriptor();
            if (parentDescriptor.getInheritancePolicy().shouldReadSubclasses()) {
                Helper.addAllUniqueToVector(parentDescriptor.getAllFields(), fields);
            }
            parentDescriptor.getInheritancePolicy().addFieldsToParent(fields);
        }
    }

    public SQLSelectStatement buildClassIndicatorSelectStatement(ObjectLevelReadQuery query) {
        SQLSelectStatement selectStatement = new SQLSelectStatement();
        selectStatement.useDistinct();
        selectStatement.addTable(this.classIndicatorField.getTable());
        selectStatement.addField(this.getClassIndicatorField());
        IdentityHashMap clonedExpressions = new IdentityHashMap();
        selectStatement.setWhereClause(((ExpressionQueryMechanism)query.getQueryMechanism()).buildBaseSelectionCriteria(false, clonedExpressions));
        this.appendWithAllSubclassesExpression(selectStatement);
        selectStatement.setTranslationRow(query.getTranslationRow());
        if (query.isReadAllQuery() && ((ReadAllQuery)query).hasHierarchicalExpressions()) {
            ReadAllQuery readAllQuery = (ReadAllQuery)query;
            selectStatement.setHierarchicalQueryExpressions(readAllQuery.getStartWithExpression(), readAllQuery.getConnectByExpression(), readAllQuery.getOrderSiblingsByExpressions());
        }
        selectStatement.setHintString(query.getHintString());
        selectStatement.normalize(query.getSession(), this.getDescriptor(), clonedExpressions);
        return selectStatement;
    }

    public void appendWithAllSubclassesExpression(SQLSelectStatement selectStatement) {
        if (this.getWithAllSubclassesExpression() != null) {
            if (selectStatement.getWhereClause() == null) {
                selectStatement.setWhereClause((Expression)this.getWithAllSubclassesExpression().clone());
            } else {
                selectStatement.setWhereClause(selectStatement.getWhereClause().and(this.getWithAllSubclassesExpression()));
            }
        }
    }

    public SQLSelectStatement buildViewSelectStatement(ObjectLevelReadQuery query) {
        Expression branchIndicator;
        IdentityHashMap clonedExpressions = new IdentityHashMap();
        ExpressionQueryMechanism mechanism = (ExpressionQueryMechanism)query.getQueryMechanism();
        SQLSelectStatement selectStatement = mechanism.buildBaseSelectStatement(false, clonedExpressions);
        selectStatement.setTables(NonSynchronizedVector.newInstance(1));
        selectStatement.addTable(this.getReadAllSubclassesView());
        if (this.getWithAllSubclassesExpression() != null && (branchIndicator = (Expression)this.getWithAllSubclassesExpression().clone()) != null) {
            selectStatement.setWhereClause(branchIndicator.and(selectStatement.getWhereClause()));
        }
        selectStatement.setFields(mechanism.getSelectionFields(selectStatement, true));
        selectStatement.normalizeForView(query.getSession(), this.getDescriptor(), clonedExpressions);
        if (query.hasJoining()) {
            query.getJoinedAttributeManager().computeJoiningMappingIndexes(false, query.getSession(), 0);
        }
        return selectStatement;
    }

    public Class classFromRow(AbstractRecord rowFromDatabase, AbstractSession session) throws DescriptorException {
        Class<?> concreteClass;
        if (this.hasClassExtractor()) {
            return this.getClassExtractor().extractClassFromRow(rowFromDatabase, session);
        }
        Object classFieldValue = session.getDatasourcePlatform().getConversionManager().convertObject(rowFromDatabase.get(this.getClassIndicatorField()), this.getClassIndicatorField().getType());
        if (classFieldValue == null) {
            throw DescriptorException.missingClassIndicatorField(rowFromDatabase, this.getDescriptor());
        }
        if (!this.shouldUseClassNameAsIndicator()) {
            concreteClass = (Class<?>)this.getClassIndicatorMapping().get(classFieldValue);
            if (concreteClass == null) {
                throw DescriptorException.missingClassForIndicatorFieldValue(classFieldValue, this.getDescriptor());
            }
        } else {
            try {
                String className = (String)classFieldValue;
                concreteClass = this.getDescriptor().getJavaClass().getClassLoader().loadClass(className);
                if (concreteClass == null) {
                    throw DescriptorException.missingClassForIndicatorFieldValue(classFieldValue, this.getDescriptor());
                }
            }
            catch (ClassNotFoundException e) {
                throw DescriptorException.missingClassForIndicatorFieldValue(classFieldValue, this.getDescriptor());
            }
            catch (ClassCastException e) {
                throw DescriptorException.missingClassForIndicatorFieldValue(classFieldValue, this.getDescriptor());
            }
        }
        return concreteClass;
    }

    public Object clone() {
        InheritancePolicy clone = null;
        try {
            clone = (InheritancePolicy)super.clone();
            if (this.hasClassIndicator()) {
                clone.setClassIndicatorField((DatabaseField)clone.getClassIndicatorField().clone());
            }
        }
        catch (Exception exception) {
            throw new InternalError("clone failed");
        }
        return clone;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        Class parentClass;
        block13: {
            Iterator keysEnum = this.getClassNameIndicatorMapping().keySet().iterator();
            Iterator valuesEnum = this.getClassNameIndicatorMapping().values().iterator();
            this.classIndicatorMapping = new HashMap();
            while (keysEnum.hasNext()) {
                Class theClass;
                Object value;
                block12: {
                    Object key = keysEnum.next();
                    value = valuesEnum.next();
                    theClass = null;
                    try {
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            try {
                                theClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName((String)key, true, classLoader));
                                break block12;
                            }
                            catch (PrivilegedActionException exception) {
                                throw ValidationException.classNotFoundWhileConvertingClassNames((String)key, (Exception)exception.getCause());
                            }
                        }
                        theClass = PrivilegedAccessHelper.getClassForName((String)key, true, classLoader);
                    }
                    catch (ClassNotFoundException exc) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames((String)key, exc);
                    }
                }
                this.classIndicatorMapping.put(theClass, value);
                this.classIndicatorMapping.put(value, theClass);
            }
            if (this.getParentClassName() == null) {
                return;
            }
            parentClass = null;
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        parentClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getParentClassName(), true, classLoader));
                        break block13;
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.getParentClassName(), exception.getException());
                    }
                }
                parentClass = PrivilegedAccessHelper.getClassForName(this.getParentClassName(), true, classLoader);
            }
            catch (ClassNotFoundException exc) {
                throw ValidationException.classNotFoundWhileConvertingClassNames(this.parentClassName, exc);
            }
        }
        this.setParentClass(parentClass);
    }

    public void dontReadSubclassesOnQueries() {
        this.setShouldReadSubclasses(false);
    }

    public void dontUseClassNameAsIndicator() {
        this.setShouldUseClassNameAsIndicator(false);
    }

    protected Vector getAllChildClassIndicators() {
        return this.allChildClassIndicators;
    }

    public Vector getAllChildDescriptors() {
        Vector allChildDescriptors = new Vector(this.getAllChildClassIndicators().size());
        return this.getAllChildDescriptors(allChildDescriptors);
    }

    protected Vector getAllChildDescriptors(Vector allChildDescriptors) {
        Enumeration enumtr = this.getChildDescriptors().elements();
        while (enumtr.hasMoreElements()) {
            ClassDescriptor childDescriptor = (ClassDescriptor)enumtr.nextElement();
            allChildDescriptors.addElement(childDescriptor);
            childDescriptor.getInheritancePolicyOrNull().getAllChildDescriptors(allChildDescriptors);
        }
        return allChildDescriptors;
    }

    public List getChildrenTables() {
        return this.childrenTables;
    }

    public Map getChildrenTablesJoinExpressions() {
        return this.childrenTablesJoinExpressions;
    }

    public Expression getChildrenJoinExpression() {
        return this.childrenJoinExpression;
    }

    public Vector getAllTables() {
        if (this.allTables == null) {
            return this.getDescriptor().getTables();
        }
        return this.allTables;
    }

    public Vector getChildDescriptors() {
        return this.childDescriptors;
    }

    protected Method getClassExtractionMethod() {
        if (this.classExtractor instanceof MethodClassExtractor) {
            return ((MethodClassExtractor)this.classExtractor).getClassExtractionMethod();
        }
        return null;
    }

    public String getClassExtractionMethodName() {
        if (this.classExtractor instanceof MethodClassExtractor) {
            return ((MethodClassExtractor)this.classExtractor).getClassExtractionMethodName();
        }
        return null;
    }

    public ClassExtractor getClassExtractor() {
        return this.classExtractor;
    }

    public void setClassExtractor(ClassExtractor classExtractor) {
        this.classExtractor = classExtractor;
    }

    public Vector getClassIndicatorAssociations() {
        Vector<TypedAssociation> associations = new Vector<TypedAssociation>(this.getClassNameIndicatorMapping().size() / 2);
        Iterator classesEnum = this.getClassNameIndicatorMapping().keySet().iterator();
        Iterator valuesEnum = this.getClassNameIndicatorMapping().values().iterator();
        while (classesEnum.hasNext()) {
            Object className = classesEnum.next();
            if (className instanceof Class) {
                className = ((Class)className).getName();
            }
            Object value = valuesEnum.next();
            associations.addElement(new TypedAssociation(className, value));
        }
        return associations;
    }

    public DatabaseField getClassIndicatorField() {
        return this.classIndicatorField;
    }

    public String getClassIndicatorFieldName() {
        if (this.getClassIndicatorField() == null) {
            return null;
        }
        return this.getClassIndicatorField().getQualifiedName();
    }

    public Map getClassIndicatorMapping() {
        return this.classIndicatorMapping;
    }

    public Map getClassNameIndicatorMapping() {
        if (this.classNameIndicatorMapping.isEmpty() && !this.classIndicatorMapping.isEmpty()) {
            Iterator keysEnum = this.classIndicatorMapping.keySet().iterator();
            Iterator valuesEnum = this.classIndicatorMapping.values().iterator();
            while (keysEnum.hasNext()) {
                Object key = keysEnum.next();
                Object value = valuesEnum.next();
                if (!(key instanceof Class)) continue;
                String className = ((Class)key).getName();
                this.classNameIndicatorMapping.put(className, value);
            }
        }
        return this.classNameIndicatorMapping;
    }

    protected Object getClassIndicatorValue() {
        return this.getClassIndicatorValue(this.getDescriptor().getJavaClass());
    }

    protected Object getClassIndicatorValue(Class javaClass) {
        if (this.shouldUseClassNameAsIndicator()) {
            return javaClass.getName();
        }
        return this.getClassIndicatorMapping().get(javaClass);
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Expression getOnlyInstancesExpression() {
        return this.onlyInstancesExpression;
    }

    public Class getParentClass() {
        return this.parentClass;
    }

    public String getParentClassName() {
        if (this.parentClassName == null && this.parentClass != null) {
            this.parentClassName = this.parentClass.getName();
        }
        return this.parentClassName;
    }

    public ClassDescriptor getParentDescriptor() {
        return this.parentDescriptor;
    }

    public DatabaseTable getReadAllSubclassesView() {
        return this.readAllSubclassesView;
    }

    public String getReadAllSubclassesViewName() {
        if (this.getReadAllSubclassesView() == null) {
            return null;
        }
        return this.getReadAllSubclassesView().getName();
    }

    public ClassDescriptor getRootParentDescriptor() {
        if (this.isRootParentDescriptor()) {
            return this.getDescriptor();
        }
        return this.getParentDescriptor().getInheritancePolicy().getRootParentDescriptor();
    }

    public ClassDescriptor getSubclassDescriptor(Class theClass) {
        if (this.hasChildren()) {
            for (ClassDescriptor childDescriptor : this.getChildDescriptors()) {
                if (childDescriptor.getJavaClass().equals(theClass)) {
                    return childDescriptor;
                }
                ClassDescriptor descriptor = childDescriptor.getInheritancePolicy().getSubclassDescriptor(theClass);
                if (descriptor == null) continue;
                return descriptor;
            }
        }
        return null;
    }

    public boolean getUseDescriptorsToValidateInheritedObjects() {
        return this.useDescriptorsToValidateInheritedObjects;
    }

    public Expression getWithAllSubclassesExpression() {
        return this.withAllSubclassesExpression;
    }

    public boolean hasChildren() {
        return !this.getChildDescriptors().isEmpty();
    }

    public boolean hasClassExtractor() {
        return this.getClassExtractor() != null;
    }

    public boolean hasClassIndicator() {
        return this.getClassIndicatorField() != null;
    }

    public boolean hasMultipleTableChild() {
        return this.childrenTables != null;
    }

    public boolean hasView() {
        return this.getReadAllSubclassesView() != null;
    }

    public void initialize(AbstractSession session) {
        if (this.shouldReadSubclasses == null || this.shouldReadSubclasses()) {
            this.setShouldReadSubclasses(!this.getChildDescriptors().isEmpty());
        }
        if (this.isChildDescriptor()) {
            CMPPolicy parentCMPPolicy;
            this.getDescriptor().setMappings(Helper.concatenateVectors(this.getParentDescriptor().getMappings(), this.getDescriptor().getMappings()));
            this.getDescriptor().setQueryKeys(Helper.concatenateMaps(this.getParentDescriptor().getQueryKeys(), this.getDescriptor().getQueryKeys()));
            this.addFieldsToParent(this.getDescriptor().getFields());
            Vector parentsFields = (Vector)this.getParentDescriptor().getFields().clone();
            Helper.addAllUniqueToVector(parentsFields, this.getDescriptor().getFields());
            this.getDescriptor().setFields(parentsFields);
            if (this.getClassIndicatorValue() != null) {
                if (this.shouldReadSubclasses()) {
                    this.getAllChildClassIndicators().addElement(this.getClassIndicatorValue());
                }
                this.addClassIndicatorTypeToParent(this.getClassIndicatorValue());
            }
            if (!this.getDescriptor().usesOptimisticLocking() && this.getParentDescriptor().usesOptimisticLocking()) {
                this.getDescriptor().setOptimisticLockingPolicy((OptimisticLockingPolicy)this.getParentDescriptor().getOptimisticLockingPolicy().clone());
                this.getDescriptor().getOptimisticLockingPolicy().setDescriptor(this.getDescriptor());
            }
            if (!this.getDescriptor().hasReturningPolicy() && this.getParentDescriptor().hasReturningPolicy()) {
                this.getDescriptor().setReturningPolicy(new ReturningPolicy());
            }
            if ((parentCMPPolicy = this.getDescriptor().getInheritancePolicy().getParentDescriptor().getCMPPolicy()) != null) {
                CMPPolicy cmpPolicy = this.getDescriptor().getCMPPolicy();
                if (cmpPolicy == null) {
                    cmpPolicy = new CMPPolicy();
                    this.getDescriptor().setCMPPolicy(cmpPolicy);
                }
                if (parentCMPPolicy.hasPessimisticLockingPolicy() && !cmpPolicy.hasPessimisticLockingPolicy()) {
                    cmpPolicy.setPessimisticLockingPolicy((PessimisticLockingPolicy)parentCMPPolicy.getPessimisticLockingPolicy().clone());
                }
                if (cmpPolicy.internalGetForceUpdate() == null) {
                    cmpPolicy.internalSetForceUpdate(parentCMPPolicy.internalGetForceUpdate());
                }
                if (cmpPolicy.internalGetUpdateAllFields() == null) {
                    cmpPolicy.internalSetUpdateAllFields(parentCMPPolicy.internalGetUpdateAllFields());
                }
            }
        }
        this.initializeOnlyInstancesExpression();
        this.initializeWithAllSubclassesExpression();
        if (this.hasView() && session.getDatasourcePlatform().getTableQualifier().length() != 0 && this.getReadAllSubclassesView().getTableQualifier().length() == 0) {
            this.getReadAllSubclassesView().setTableQualifier(session.getDatasourcePlatform().getTableQualifier());
        }
    }

    protected void initializeClassExtractor(AbstractSession session) throws DescriptorException {
        if (this.getClassExtractor() == null) {
            if (this.isChildDescriptor()) {
                this.setClassExtractor(this.getParentDescriptor().getInheritancePolicy().getClassExtractor());
            }
        } else {
            this.getClassExtractor().initialize(this.getDescriptor(), session);
        }
    }

    protected void initializeOnlyInstancesExpression() throws DescriptorException {
        if (this.getOnlyInstancesExpression() == null) {
            if (this.hasClassExtractor()) {
                return;
            }
            Object typeValue = this.getClassIndicatorValue();
            if (typeValue == null) {
                if (this.shouldReadSubclasses()) {
                    return;
                }
                throw DescriptorException.valueNotFoundInClassIndicatorMapping(this.getParentDescriptor(), this.getDescriptor());
            }
            DatabaseField typeField = this.getClassIndicatorField();
            if (typeField == null) {
                throw DescriptorException.classIndicatorFieldNotFound(this.getParentDescriptor(), this.getDescriptor());
            }
            if (this.shouldAlwaysUseOuterJoin()) {
                this.setOnlyInstancesExpression(new ExpressionBuilder().getField(typeField).equalOuterJoin(typeValue));
            } else {
                this.setOnlyInstancesExpression(new ExpressionBuilder().getField(typeField).equal(typeValue));
            }
        }
        if (!this.shouldReadSubclasses()) {
            this.getDescriptor().getQueryManager().setAdditionalJoinExpression(this.getOnlyInstancesExpression().and(this.getDescriptor().getQueryManager().getAdditionalJoinExpression()));
        }
    }

    protected void initializeWithAllSubclassesExpression() throws DescriptorException {
        if (this.getWithAllSubclassesExpression() == null) {
            if (this.hasClassExtractor()) {
                return;
            }
            if (this.isChildDescriptor() && this.shouldReadSubclasses()) {
                this.setWithAllSubclassesExpression(new ExpressionBuilder().getField(this.getClassIndicatorField()).in(this.getAllChildClassIndicators()));
            }
        }
    }

    public boolean isChildDescriptor() {
        return this.getParentClassName() != null;
    }

    public boolean isJoinedStrategy() {
        return this.isJoinedStrategy;
    }

    public boolean isRootParentDescriptor() {
        return this.getParentDescriptor() == null;
    }

    public void postInitialize(AbstractSession session) {
    }

    public void preInitialize(AbstractSession session) throws DescriptorException {
        if (this.isChildDescriptor()) {
            Vector<DatabaseTable> childTables = this.getDescriptor().getTables();
            Vector<DatabaseTable> parentTables = this.getParentDescriptor().getTables();
            Vector uniqueTables = Helper.concatenateUniqueVectors(parentTables, childTables);
            this.getDescriptor().setTables(uniqueTables);
            if (childTables.isEmpty()) {
                this.getDescriptor().setInternalDefaultTable();
            } else {
                this.getDescriptor().setInternalDefaultTable((DatabaseTable)uniqueTables.get(uniqueTables.indexOf(childTables.get(0))));
            }
            this.setClassIndicatorMapping(this.getParentDescriptor().getInheritancePolicy().getClassIndicatorMapping());
            this.setShouldUseClassNameAsIndicator(this.getParentDescriptor().getInheritancePolicy().shouldUseClassNameAsIndicator());
            this.getDescriptor().setPrimaryKeyFields(this.getParentDescriptor().getPrimaryKeyFields());
            this.getDescriptor().setAdditionalTablePrimaryKeyFields(Helper.concatenateMaps(this.getParentDescriptor().getAdditionalTablePrimaryKeyFields(), this.getDescriptor().getAdditionalTablePrimaryKeyFields()));
            Expression localExpression = this.getDescriptor().getQueryManager().getMultipleTableJoinExpression();
            Expression parentExpression = this.getParentDescriptor().getQueryManager().getMultipleTableJoinExpression();
            if (localExpression != null) {
                this.getDescriptor().getQueryManager().setInternalMultipleTableJoinExpression(localExpression.and(parentExpression));
            } else if (parentExpression != null) {
                this.getDescriptor().getQueryManager().setInternalMultipleTableJoinExpression(parentExpression);
            }
            Expression localAdditionalExpression = this.getDescriptor().getQueryManager().getAdditionalJoinExpression();
            Expression parentAdditionalExpression = this.getParentDescriptor().getQueryManager().getAdditionalJoinExpression();
            if (localAdditionalExpression != null) {
                this.getDescriptor().getQueryManager().setAdditionalJoinExpression(localAdditionalExpression.and(parentAdditionalExpression));
            } else if (parentAdditionalExpression != null) {
                this.getDescriptor().getQueryManager().setAdditionalJoinExpression(parentAdditionalExpression);
            }
            this.setClassIndicatorField(this.getParentDescriptor().getInheritancePolicy().getClassIndicatorField());
            if (!this.getDescriptor().usesSequenceNumbers()) {
                this.getDescriptor().setSequenceNumberField(this.getParentDescriptor().getSequenceNumberField());
                this.getDescriptor().setSequenceNumberName(this.getParentDescriptor().getSequenceNumberName());
            }
        } else {
            this.getDescriptor().setInternalDefaultTable();
        }
        this.initializeClassExtractor(session);
        if (!this.isChildDescriptor()) {
            if (this.getClassIndicatorField() == null && !this.hasClassExtractor()) {
                session.getIntegrityChecker().handleError(DescriptorException.classIndicatorFieldNotFound(this.getDescriptor(), this.getDescriptor()));
            }
            if (this.getClassIndicatorField() != null) {
                this.setClassIndicatorField(this.getDescriptor().buildField(this.getClassIndicatorField()));
                if (this.shouldUseClassNameAsIndicator()) {
                    this.getClassIndicatorField().setType(ClassConstants.STRING);
                } else if (!this.getClassIndicatorMapping().isEmpty()) {
                    Class<?> type = null;
                    Iterator fieldValuesEnum = this.getClassIndicatorMapping().values().iterator();
                    while (fieldValuesEnum.hasNext() && type == null) {
                        Object value = fieldValuesEnum.next();
                        if (value.getClass() == this.getClass().getClass()) continue;
                        type = value.getClass();
                    }
                    this.getClassIndicatorField().setType(type);
                }
                this.getDescriptor().getFields().addElement(this.getClassIndicatorField());
            }
        }
    }

    public void readSubclassesOnQueries() {
        this.setShouldReadSubclasses(true);
    }

    public void remoteInitialization(DistributedSession session) {
        if (this.isChildDescriptor()) {
            if (session.hasCorrespondingDescriptor(this.getParentDescriptor())) {
                this.setParentDescriptor(session.getDescriptor(this.getParentClass()));
            } else {
                session.privilegedAddDescriptor(this.getParentDescriptor());
                this.getParentDescriptor().remoteInitialization(session);
            }
        }
        Vector<ClassDescriptor> tempChildren = new Vector<ClassDescriptor>(this.getChildDescriptors().size());
        Enumeration childEnum = this.getChildDescriptors().elements();
        while (childEnum.hasMoreElements()) {
            ClassDescriptor childDescriptor = (ClassDescriptor)childEnum.nextElement();
            if (session.hasCorrespondingDescriptor(childDescriptor)) {
                tempChildren.addElement(session.getDescriptor(childDescriptor.getJavaClass()));
                continue;
            }
            session.privilegedAddDescriptor(childDescriptor);
            childDescriptor.remoteInitialization(session);
            tempChildren.addElement(childDescriptor);
        }
        this.setChildDescriptors(tempChildren);
    }

    public boolean requiresMultipleTableSubclassRead() {
        return this.hasMultipleTableChild() && this.shouldReadSubclasses();
    }

    protected Vector selectAllRowUsingCustomMultipleTableSubclassRead(ReadAllQuery query) throws DatabaseException {
        Vector rows = new Vector();
        if (this.getOnlyInstancesExpression() != null || !this.shouldReadSubclasses()) {
            ReadAllQuery concreteQuery = (ReadAllQuery)query.clone();
            concreteQuery.setReferenceClass(this.getDescriptor().getJavaClass());
            concreteQuery.setDescriptor(this.getDescriptor());
            Vector concreteRows = ((ExpressionQueryMechanism)concreteQuery.getQueryMechanism()).selectAllRowsFromConcreteTable();
            rows = Helper.concatenateVectors(rows, concreteRows);
        }
        Enumeration childrenEnum = this.getChildDescriptors().elements();
        while (childrenEnum.hasMoreElements()) {
            ClassDescriptor concreteDescriptor = (ClassDescriptor)childrenEnum.nextElement();
            Vector concreteRows = concreteDescriptor.getInheritancePolicy().selectAllRowUsingCustomMultipleTableSubclassRead(query);
            rows = Helper.concatenateVectors(rows, concreteRows);
        }
        return rows;
    }

    protected Vector selectAllRowUsingDefaultMultipleTableSubclassRead(ReadAllQuery query) throws DatabaseException, QueryException {
        Vector classIndicators = ((ExpressionQueryMechanism)query.getQueryMechanism()).selectAllRowsFromTable();
        Vector<Class> classes = new Vector<Class>();
        Enumeration rowsEnum = classIndicators.elements();
        while (rowsEnum.hasMoreElements()) {
            AbstractRecord row = (AbstractRecord)rowsEnum.nextElement();
            Class concreteClass = this.classFromRow(row, query.getSession());
            if (classes.contains(concreteClass)) continue;
            classes.addElement(concreteClass);
        }
        Vector rows = new Vector();
        HashMap<DatabaseMapping, HashMap<Class, Object>> joinedMappingIndexes = null;
        if (query.hasJoining()) {
            joinedMappingIndexes = new HashMap<DatabaseMapping, HashMap<Class, Object>>();
        }
        Enumeration classesEnum = classes.elements();
        while (classesEnum.hasMoreElements()) {
            Class concreteClass = (Class)classesEnum.nextElement();
            ClassDescriptor concreteDescriptor = query.getSession().getDescriptor(concreteClass);
            if (concreteDescriptor == null) {
                throw QueryException.noDescriptorForClassFromInheritancePolicy(query, concreteClass);
            }
            ReadAllQuery concreteQuery = (ReadAllQuery)query.clone();
            concreteQuery.setReferenceClass(concreteClass);
            concreteQuery.setDescriptor(concreteDescriptor);
            Vector concreteRows = ((ExpressionQueryMechanism)concreteQuery.getQueryMechanism()).selectAllRowsFromConcreteTable();
            rows = Helper.concatenateVectors(rows, concreteRows);
            if (joinedMappingIndexes == null) continue;
            for (Map.Entry<DatabaseMapping, Object> entry : concreteQuery.getJoinedAttributeManager().getJoinedMappingIndexes_().entrySet()) {
                HashMap<Class, Object> map = (HashMap<Class, Object>)joinedMappingIndexes.get(entry.getKey());
                if (map == null) {
                    map = new HashMap<Class, Object>(classes.size());
                    joinedMappingIndexes.put(entry.getKey(), map);
                }
                map.put(concreteClass, entry.getValue());
            }
        }
        if (joinedMappingIndexes != null) {
            query.getJoinedAttributeManager().setJoinedMappingIndexes_(joinedMappingIndexes);
        }
        return rows;
    }

    public Vector selectAllRowUsingMultipleTableSubclassRead(ReadAllQuery query) throws DatabaseException {
        if (this.hasClassExtractor()) {
            return this.selectAllRowUsingCustomMultipleTableSubclassRead(query);
        }
        return this.selectAllRowUsingDefaultMultipleTableSubclassRead(query);
    }

    protected AbstractRecord selectOneRowUsingCustomMultipleTableSubclassRead(ReadObjectQuery query) throws DatabaseException {
        if (this.getOnlyInstancesExpression() != null || !this.shouldReadSubclasses()) {
            ReadObjectQuery concreteQuery = (ReadObjectQuery)query.clone();
            concreteQuery.setReferenceClass(this.getDescriptor().getJavaClass());
            concreteQuery.setDescriptor(this.getDescriptor());
            AbstractRecord row = ((ExpressionQueryMechanism)concreteQuery.getQueryMechanism()).selectOneRowFromConcreteTable();
            if (row != null) {
                return row;
            }
        }
        Enumeration childrenEnum = this.getChildDescriptors().elements();
        while (childrenEnum.hasMoreElements()) {
            ClassDescriptor concreteDescriptor = (ClassDescriptor)childrenEnum.nextElement();
            AbstractRecord row = concreteDescriptor.getInheritancePolicy().selectOneRowUsingCustomMultipleTableSubclassRead(query);
            if (row == null) continue;
            return row;
        }
        return null;
    }

    protected AbstractRecord selectOneRowUsingDefaultMultipleTableSubclassRead(ReadObjectQuery query) throws DatabaseException, QueryException {
        AbstractRecord typeRow = ((ExpressionQueryMechanism)query.getQueryMechanism()).selectOneRowFromTable();
        if (typeRow == null) {
            return null;
        }
        Class concreteClass = this.classFromRow(typeRow, query.getSession());
        ClassDescriptor concreteDescriptor = query.getSession().getDescriptor(concreteClass);
        if (concreteDescriptor == null) {
            throw QueryException.noDescriptorForClassFromInheritancePolicy(query, concreteClass);
        }
        ReadObjectQuery concreteQuery = (ReadObjectQuery)query.clone();
        concreteQuery.setReferenceClass(concreteClass);
        concreteQuery.setDescriptor(concreteDescriptor);
        AbstractRecord resultRow = ((ExpressionQueryMechanism)concreteQuery.getQueryMechanism()).selectOneRowFromConcreteTable();
        return resultRow;
    }

    public AbstractRecord selectOneRowUsingMultipleTableSubclassRead(ReadObjectQuery query) throws DatabaseException, QueryException {
        if (this.hasClassExtractor()) {
            return this.selectOneRowUsingCustomMultipleTableSubclassRead(query);
        }
        return this.selectOneRowUsingDefaultMultipleTableSubclassRead(query);
    }

    protected void setAllChildClassIndicators(Vector allChildClassIndicators) {
        this.allChildClassIndicators = allChildClassIndicators;
    }

    public void setChildDescriptors(Vector theChildDescriptors) {
        this.childDescriptors = theChildDescriptors;
    }

    public void setClassExtractionMethodName(String staticClassClassExtractionMethod) {
        if (staticClassClassExtractionMethod == null || staticClassClassExtractionMethod.length() == 0) {
            return;
        }
        if (!(this.getClassExtractor() instanceof MethodClassExtractor)) {
            this.setClassExtractor(new MethodClassExtractor());
        }
        ((MethodClassExtractor)this.getClassExtractor()).setClassExtractionMethodName(staticClassClassExtractionMethod);
    }

    public void setClassIndicatorAssociations(Vector classIndicatorAssociations) {
        this.setClassNameIndicatorMapping(new HashMap(classIndicatorAssociations.size() + 1));
        this.setClassIndicatorMapping(new HashMap(classIndicatorAssociations.size() * 2 + 1));
        for (Association association : classIndicatorAssociations) {
            Object key = association.getKey();
            if (key instanceof String) {
                key = ConversionManager.getDefaultManager().convertClassNameToClass((String)key);
            }
            this.addClassIndicator((Class)key, association.getValue());
        }
    }

    public void setClassIndicatorField(DatabaseField classIndicatorField) {
        this.classIndicatorField = classIndicatorField;
    }

    public void setClassIndicatorFieldName(String fieldName) {
        if (fieldName == null) {
            this.setClassIndicatorField(null);
        } else {
            this.setClassIndicatorField(new DatabaseField(fieldName));
        }
    }

    public void setClassIndicatorMapping(Map classIndicatorMapping) {
        this.classIndicatorMapping = classIndicatorMapping;
    }

    public void setClassNameIndicatorMapping(Map classNameIndicatorMapping) {
        this.classNameIndicatorMapping = classNameIndicatorMapping;
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void setJoinedStrategy() {
        this.isJoinedStrategy = true;
    }

    public void setOnlyInstancesExpression(Expression onlyInstancesExpression) {
        this.onlyInstancesExpression = onlyInstancesExpression;
    }

    public void setParentClass(Class parentClass) {
        this.parentClass = parentClass;
        if (parentClass != null) {
            this.setParentClassName(parentClass.getName());
        }
    }

    public void setParentClassName(String parentClassName) {
        this.parentClassName = parentClassName;
    }

    public void setParentDescriptor(ClassDescriptor parentDescriptor) {
        this.parentDescriptor = parentDescriptor;
    }

    protected void setReadAllSubclassesView(DatabaseTable readAllSubclassesView) {
        this.readAllSubclassesView = readAllSubclassesView;
    }

    public void setReadAllSubclassesViewName(String readAllSubclassesViewName) {
        if (readAllSubclassesViewName == null) {
            this.setReadAllSubclassesView(null);
        } else {
            this.setReadAllSubclassesView(new DatabaseTable(readAllSubclassesViewName));
        }
    }

    public void setShouldReadSubclasses(Boolean shouldReadSubclasses) {
        this.shouldReadSubclasses = shouldReadSubclasses;
    }

    public void setShouldReadSubclasses(boolean shouldReadSubclasses) {
        this.shouldReadSubclasses = shouldReadSubclasses;
    }

    public void setShouldUseClassNameAsIndicator(boolean shouldUseClassNameAsIndicator) {
        this.shouldUseClassNameAsIndicator = shouldUseClassNameAsIndicator;
    }

    public void setAlwaysUseOuterJoinForClassType(boolean choice) {
        this.shouldAlwaysUseOuterJoin = choice;
    }

    public void setSingleTableStrategy() {
        this.isJoinedStrategy = false;
    }

    public void setUseDescriptorsToValidateInheritedObjects(boolean useDescriptorsToValidateInheritedObjects) {
        this.useDescriptorsToValidateInheritedObjects = useDescriptorsToValidateInheritedObjects;
    }

    public void setWithAllSubclassesExpression(Expression withAllSubclassesExpression) {
        this.withAllSubclassesExpression = withAllSubclassesExpression;
    }

    public boolean shouldReadSubclasses() {
        if (this.shouldReadSubclasses == null) {
            return true;
        }
        return this.shouldReadSubclasses;
    }

    public Boolean shouldReadSubclassesValue() {
        return this.shouldReadSubclasses;
    }

    public boolean shouldAlwaysUseOuterJoin() {
        return this.shouldAlwaysUseOuterJoin;
    }

    public boolean shouldOuterJoinSubclasses() {
        return this.shouldOuterJoinSubclasses;
    }

    public void setShouldOuterJoinSubclasses(boolean shouldOuterJoinSubclasses) {
        this.shouldOuterJoinSubclasses = shouldOuterJoinSubclasses;
    }

    public boolean shouldUseClassNameAsIndicator() {
        return this.shouldUseClassNameAsIndicator;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getDescriptor() + ")";
    }

    public void useClassNameAsIndicator() {
        this.setShouldUseClassNameAsIndicator(true);
    }
}

