/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.indirection.ProxyIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.UnitOfWorkQueryValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.ObjectReferenceChangeRecord;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryByExamplePolicy;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.ObjectCopyingPolicy;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.remote.RemoteSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectReferenceMapping
extends ForeignReferenceMapping {
    protected boolean isForeignKeyRelationship;
    protected Vector<DatabaseField> foreignKeyFields;

    protected ObjectReferenceMapping() {
    }

    @Override
    public Object buildBackupCloneForPartObject(Object attributeValue, Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        return attributeValue;
    }

    @Override
    public Object buildCloneForPartObject(Object attributeValue, Object original, Object clone, UnitOfWorkImpl unitOfWork, boolean isExisting) {
        if (isExisting) {
            return unitOfWork.registerExistingObject(attributeValue);
        }
        return unitOfWork.registerObject(attributeValue);
    }

    @Override
    public void buildCopy(Object copy, Object original, ObjectCopyingPolicy policy) {
        Object copyValue;
        Object attributeValue = this.getRealAttributeValueFromObject(original, policy.getSession());
        if (attributeValue != null && (policy.shouldCascadeAllParts() || policy.shouldCascadePrivateParts() && this.isPrivateOwned())) {
            attributeValue = policy.getSession().copyObject(attributeValue, policy);
        } else if (attributeValue != null && (copyValue = policy.getCopies().get(attributeValue)) != null) {
            attributeValue = copyValue;
        }
        this.setRealAttributeValueInObject(copy, attributeValue);
    }

    @Override
    public Expression buildExpression(Object queryObject, QueryByExamplePolicy policy, Expression expressionBuilder, Map processedObjects, AbstractSession session) {
        String attributeName = this.getAttributeName();
        Object attributeValue = this.getRealAttributeValueFromObject(queryObject, session);
        if (!policy.shouldIncludeInQuery(queryObject.getClass(), attributeName, attributeValue)) {
            return null;
        }
        if (attributeValue == null) {
            Expression expression = expressionBuilder.get(attributeName);
            return policy.completeExpressionForNull(expression);
        }
        ObjectBuilder objectBuilder = this.getReferenceDescriptor().getObjectBuilder();
        return objectBuilder.buildExpressionFromExample(attributeValue, policy, expressionBuilder.get(attributeName), processedObjects, session);
    }

    @Override
    public ChangeRecord compareForChange(Object clone, Object backUp, ObjectChangeSet owner, AbstractSession session) {
        Object cloneAttribute = null;
        Object backUpAttribute = null;
        cloneAttribute = this.getAttributeValueFromObject(clone);
        if (!owner.isNew() && (backUpAttribute = this.getAttributeValueFromObject(backUp)) == null && cloneAttribute == null) {
            return null;
        }
        if (cloneAttribute != null && !this.getIndirectionPolicy().objectIsInstantiated(cloneAttribute)) {
            return null;
        }
        Object cloneAttributeValue = null;
        Object backUpAttributeValue = null;
        if (cloneAttribute != null) {
            cloneAttributeValue = this.getRealAttributeValueFromObject(clone, session);
        }
        if (backUpAttribute != null) {
            backUpAttributeValue = this.getRealAttributeValueFromObject(backUp, session);
        }
        if (cloneAttributeValue == backUpAttributeValue && !owner.isNew()) {
            return null;
        }
        ObjectReferenceChangeRecord record = this.internalBuildChangeRecord(cloneAttributeValue, owner, session);
        if (!owner.isNew()) {
            record.setOldValue(backUpAttributeValue);
        }
        return record;
    }

    public ObjectReferenceChangeRecord internalBuildChangeRecord(Object newValue, ObjectChangeSet owner, AbstractSession session) {
        ObjectReferenceChangeRecord changeRecord = new ObjectReferenceChangeRecord(owner);
        changeRecord.setAttribute(this.getAttributeName());
        changeRecord.setMapping(this);
        this.setNewValueInChangeRecord(newValue, changeRecord, owner, session);
        return changeRecord;
    }

    public void setNewValueInChangeRecord(Object newValue, ObjectReferenceChangeRecord changeRecord, ObjectChangeSet owner, AbstractSession session) {
        if (newValue != null) {
            ObjectChangeSet newSet = this.getDescriptorForTarget(newValue, session).getObjectBuilder().createObjectChangeSet(newValue, (UnitOfWorkChangeSet)owner.getUOWChangeSet(), session);
            changeRecord.setNewValue(newSet);
        } else {
            changeRecord.setNewValue(null);
        }
    }

    @Override
    protected boolean compareObjectsWithoutPrivateOwned(Object firstObject, Object secondObject, AbstractSession session) {
        Object firstReferencedObject = this.getRealAttributeValueFromObject(firstObject, session);
        Object secondReferencedObject = this.getRealAttributeValueFromObject(secondObject, session);
        if (firstReferencedObject == null && secondReferencedObject == null) {
            return true;
        }
        if (firstReferencedObject == null || secondReferencedObject == null) {
            return false;
        }
        Vector firstKey = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(firstReferencedObject, session);
        Vector secondKey = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(secondReferencedObject, session);
        for (int index = 0; index < firstKey.size(); ++index) {
            Object firstValue = firstKey.elementAt(index);
            Object secondValue = secondKey.elementAt(index);
            if (firstValue == null && secondValue == null) continue;
            if (firstValue == null || secondValue == null) {
                return false;
            }
            if (firstValue.equals(secondValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean compareObjectsWithPrivateOwned(Object firstObject, Object secondObject, AbstractSession session) {
        Object firstPrivateObject = this.getRealAttributeValueFromObject(firstObject, session);
        Object secondPrivateObject = this.getRealAttributeValueFromObject(secondObject, session);
        return session.compareObjects(firstPrivateObject, secondPrivateObject);
    }

    @Override
    public void fixRealObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, RemoteSession session) {
        Object attributeValue = this.getRealAttributeValueFromObject(object, session);
        attributeValue = this.getReferenceDescriptor().getObjectBuilder().unwrapObject(attributeValue, session);
        ObjectLevelReadQuery tempQuery = query;
        if (!tempQuery.shouldMaintainCache() && (!tempQuery.shouldCascadeParts() || tempQuery.shouldCascadePrivateParts() && !this.isPrivateOwned())) {
            tempQuery = null;
        }
        Object remoteAttributeValue = session.getObjectCorrespondingTo(attributeValue, objectDescriptors, processedObjects, tempQuery);
        remoteAttributeValue = this.getReferenceDescriptor().getObjectBuilder().wrapObject(remoteAttributeValue, session);
        this.setRealAttributeValueInObject(object, remoteAttributeValue);
    }

    public ClassDescriptor getDescriptorForTarget(Object object, AbstractSession session) {
        return session.getDescriptor(object);
    }

    @Override
    public Object getRealAttributeValueFromObject(Object object, AbstractSession session) {
        Object value = super.getRealAttributeValueFromObject(object, session);
        value = this.getReferenceDescriptor().getObjectBuilder().unwrapObject(value, session);
        return value;
    }

    @Override
    public boolean isObjectReferenceMapping() {
        return true;
    }

    @Override
    public void iterateOnRealAttributeValue(DescriptorIterator iterator, Object realAttributeValue) {
        Object unwrappedAttributeValue = this.getReferenceDescriptor().getObjectBuilder().unwrapObject(realAttributeValue, iterator.getSession());
        iterator.iterateReferenceObjectForMapping(unwrappedAttributeValue, this);
    }

    @Override
    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager) {
        ObjectChangeSet set;
        Object targetValueOfSource = null;
        if (this.shouldMergeCascadeParts(mergeManager) && (set = (ObjectChangeSet)((ObjectReferenceChangeRecord)changeRecord).getNewValue()) != null) {
            if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                targetValueOfSource = set.getTargetVersionOfSourceObject(mergeManager.getSession(), false);
                if (targetValueOfSource == null && (set.isNew() || set.isAggregate()) && set.containsChangesFromSynchronization()) {
                    if (!mergeManager.getObjectsAlreadyMerged().containsKey(set)) {
                        Class objectClass = set.getClassType(mergeManager.getSession());
                        targetValueOfSource = mergeManager.getSession().getDescriptor(objectClass).getObjectBuilder().buildNewInstance();
                        mergeManager.getObjectsAlreadyMerged().put(set, targetValueOfSource);
                    } else {
                        targetValueOfSource = mergeManager.getObjectsAlreadyMerged().get(set);
                    }
                } else {
                    targetValueOfSource = set.getTargetVersionOfSourceObject(mergeManager.getSession(), true);
                }
                if (set.containsChangesFromSynchronization()) {
                    mergeManager.mergeChanges(targetValueOfSource, set);
                }
                if (targetValueOfSource == null) {
                    mergeManager.getSession().getIdentityMapAccessorInstance().invalidateObject(target);
                    return;
                }
            } else {
                mergeManager.mergeChanges(set.getUnitOfWorkClone(), set);
            }
        }
        if (targetValueOfSource == null && ((ObjectReferenceChangeRecord)changeRecord).getNewValue() != null) {
            targetValueOfSource = ((ObjectChangeSet)((ObjectReferenceChangeRecord)changeRecord).getNewValue()).getTargetVersionOfSourceObject(mergeManager.getSession());
        }
        if (this.isPrivateOwned() && source != null) {
            mergeManager.registerRemovedNewObjectIfRequired(this.getRealAttributeValueFromObject(source, mergeManager.getSession()));
        }
        targetValueOfSource = this.getReferenceDescriptor().getObjectBuilder().wrapObject(targetValueOfSource, mergeManager.getSession());
        this.setRealAttributeValueInObject(target, targetValueOfSource);
    }

    @Override
    public void mergeIntoObject(Object target, boolean isTargetUnInitialized, Object source, MergeManager mergeManager) {
        Object valueOfTarget;
        if (isTargetUnInitialized && mergeManager.shouldMergeWorkingCopyIntoOriginal() && !this.isAttributeValueInstantiated(source)) {
            this.setAttributeValueInObject(target, this.getIndirectionPolicy().getOriginalIndirectionObject(this.getAttributeValueFromObject(source), mergeManager.getSession()));
            return;
        }
        if (!this.shouldMergeCascadeReference(mergeManager)) {
            return;
        }
        if (mergeManager.shouldRefreshRemoteObject() && this.usesIndirection()) {
            this.mergeRemoteValueHolder(target, source, mergeManager);
            return;
        }
        if (mergeManager.shouldMergeOriginalIntoWorkingCopy() ? !this.isAttributeValueInstantiated(target) : !this.isAttributeValueInstantiated(source)) {
            return;
        }
        Object valueOfSource = this.getRealAttributeValueFromObject(source, mergeManager.getSession());
        Object targetValueOfSource = null;
        if (this.shouldMergeCascadeParts(mergeManager) && valueOfSource != null) {
            if (mergeManager.getSession().isUnitOfWork() && ((UnitOfWorkImpl)mergeManager.getSession()).getUnitOfWorkChangeSet() != null) {
                mergeManager.mergeChanges(mergeManager.getObjectToMerge(valueOfSource), (ObjectChangeSet)((UnitOfWorkChangeSet)((UnitOfWorkImpl)mergeManager.getSession()).getUnitOfWorkChangeSet()).getObjectChangeSetForClone(valueOfSource));
            } else {
                mergeManager.mergeChanges(mergeManager.getObjectToMerge(valueOfSource), null);
            }
        }
        if (valueOfSource != null) {
            targetValueOfSource = mergeManager.getTargetVersionOfSourceObject(valueOfSource);
        }
        if (this.getDescriptor().getObjectChangePolicy().isObjectChangeTrackingPolicy() && (valueOfTarget = this.getRealAttributeValueFromObject(target, mergeManager.getSession())) != targetValueOfSource) {
            this.getDescriptor().getObjectChangePolicy().raiseInternalPropertyChangeEvent(target, this.getAttributeName(), valueOfTarget, targetValueOfSource);
        }
        targetValueOfSource = this.getReferenceDescriptor().getObjectBuilder().wrapObject(targetValueOfSource, mergeManager.getSession());
        this.setRealAttributeValueInObject(target, targetValueOfSource);
    }

    @Override
    protected Vector<DatabaseField> collectFields() {
        return this.getForeignKeyFields();
    }

    public Vector<DatabaseField> getForeignKeyFields() {
        return this.foreignKeyFields;
    }

    protected void setForeignKeyFields(Vector<DatabaseField> foreignKeyFields) {
        this.foreignKeyFields = foreignKeyFields;
        if (!foreignKeyFields.isEmpty()) {
            this.setIsForeignKeyRelationship(true);
        }
    }

    public boolean isForeignKeyRelationship() {
        return this.isForeignKeyRelationship;
    }

    public void setIsForeignKeyRelationship(boolean isForeignKeyRelationship) {
        this.isForeignKeyRelationship = isForeignKeyRelationship;
    }

    @Override
    public void preInsert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (this.isForeignKeyRelationship()) {
            this.insert(query);
        }
    }

    protected Object readPrivateOwnedForObject(ObjectLevelModifyQuery modifyQuery) throws DatabaseException {
        if (modifyQuery.getSession().isUnitOfWork()) {
            if (modifyQuery.getObjectChangeSet() != null) {
                ObjectReferenceChangeRecord record = (ObjectReferenceChangeRecord)modifyQuery.getObjectChangeSet().getChangesForAttributeNamed(this.getAttributeName());
                if (record != null) {
                    return record.getOldValue();
                }
            } else {
                return this.getRealAttributeValueFromObject(modifyQuery.getBackupClone(), modifyQuery.getSession());
            }
        }
        return null;
    }

    @Override
    public void preUpdate(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        Object objectInDatabase;
        if (!this.isAttributeValueInstantiated(query.getObject())) {
            return;
        }
        if (this.isPrivateOwned() && (objectInDatabase = this.readPrivateOwnedForObject(query)) != null) {
            query.setProperty(this, objectInDatabase);
        }
        if (!this.isForeignKeyRelationship()) {
            return;
        }
        this.update(query);
    }

    @Override
    public void postDelete(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        Object object = query.getProperty(this);
        if (this.isForeignKeyRelationship() && object != null) {
            query.removeProperty(this);
            if (query.isCascadeOfAggregateDelete()) {
                query.getSession().getCommitManager().addObjectToDelete(object);
            } else {
                DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
                deleteQuery.setIsExecutionClone(true);
                deleteQuery.setObject(object);
                deleteQuery.setCascadePolicy(query.getCascadePolicy());
                query.getSession().executeQuery(deleteQuery);
            }
        }
    }

    @Override
    public void postInsert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.isForeignKeyRelationship()) {
            this.insert(query);
        }
    }

    @Override
    public void postUpdate(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        Object objectInDatabase;
        if (!this.isAttributeValueInstantiated(query.getObject())) {
            return;
        }
        if (!this.isForeignKeyRelationship()) {
            this.update(query);
        }
        if ((objectInDatabase = query.getProperty(this)) == null) {
            return;
        }
        query.removeProperty(this);
        if (query.getObjectChangeSet() == null) {
            Object objectInMemory = this.getRealAttributeValueFromObject(query.getObject(), query.getSession());
            if (objectInDatabase != objectInMemory) {
                CacheKey cacheKeyForObjectInDatabase = null;
                CacheKey cacheKeyForObjectInMemory = new CacheKey(new Vector());
                cacheKeyForObjectInDatabase = new CacheKey(this.getPrimaryKeyForObject(objectInDatabase, query.getSession()));
                if (objectInMemory != null) {
                    cacheKeyForObjectInMemory = new CacheKey(this.getPrimaryKeyForObject(objectInMemory, query.getSession()));
                }
                if (this.cacheKeysAreEqual(cacheKeyForObjectInDatabase, cacheKeyForObjectInMemory)) {
                    return;
                }
            } else {
                return;
            }
        }
        if (query.shouldCascadeOnlyDependentParts()) {
            query.getSession().getCommitManager().addObjectToDelete(objectInDatabase);
        } else {
            query.getSession().deleteObject(objectInDatabase);
        }
    }

    @Override
    public void preDelete(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        Object objectInMemory = this.getRealAttributeValueFromObject(query.getObject(), query.getSession());
        Object objectFromDatabase = null;
        objectFromDatabase = this.readPrivateOwnedForObject(query);
        if (objectFromDatabase != null && objectFromDatabase != objectInMemory) {
            CacheKey cacheKeyForObjectInDatabase = null;
            CacheKey cacheKeyForObjectInMemory = new CacheKey(new Vector());
            cacheKeyForObjectInDatabase = new CacheKey(this.getPrimaryKeyForObject(objectFromDatabase, query.getSession()));
            if (objectInMemory != null) {
                cacheKeyForObjectInMemory = new CacheKey(this.getPrimaryKeyForObject(objectInMemory, query.getSession()));
            }
            if (!this.cacheKeysAreEqual(cacheKeyForObjectInMemory, cacheKeyForObjectInDatabase) && objectFromDatabase != null) {
                DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
                deleteQuery.setIsExecutionClone(true);
                deleteQuery.setObject(objectFromDatabase);
                deleteQuery.setCascadePolicy(query.getCascadePolicy());
                query.getSession().executeQuery(deleteQuery);
            }
        }
        if (!this.isForeignKeyRelationship()) {
            if (objectInMemory != null) {
                DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
                deleteQuery.setIsExecutionClone(true);
                deleteQuery.setObject(objectInMemory);
                deleteQuery.setCascadePolicy(query.getCascadePolicy());
                query.getSession().executeQuery(deleteQuery);
            }
        } else if (objectInMemory != null) {
            query.setProperty(this, objectInMemory);
        }
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        Object reference;
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (attributeValue != null && this.isCascadeRemove() && (reference = this.getIndirectionPolicy().getRealAttributeValueFromObject(object, attributeValue)) != null && !visitedObjects.containsKey(reference)) {
            visitedObjects.put(reference, reference);
            uow.performRemove(reference, visitedObjects);
        }
    }

    @Override
    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map newObjects, Map unregisteredExistingObjects, Map visitedObjects, UnitOfWorkImpl uow) {
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (attributeValue != null && this.getIndirectionPolicy().objectIsInstantiated(attributeValue)) {
            Object reference = this.getIndirectionPolicy().getRealAttributeValueFromObject(object, attributeValue);
            uow.discoverAndPersistUnregisteredNewObjects(reference, this.isCascadePersist(), newObjects, unregisteredExistingObjects, visitedObjects);
        }
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (attributeValue != null && this.isCascadePersist() && this.getIndirectionPolicy().objectIsInstantiated(attributeValue)) {
            Object reference = this.getIndirectionPolicy().getRealAttributeValueFromObject(object, attributeValue);
            uow.registerNewObjectForPersist(reference, visitedObjects);
        }
    }

    protected boolean cacheKeysAreEqual(CacheKey cacheKey1, CacheKey cacheKey2) {
        return cacheKey1.equals(cacheKey2);
    }

    protected Vector getPrimaryKeyForObject(Object object, AbstractSession session) {
        return this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object, session);
    }

    @Override
    public boolean hasConstraintDependency() {
        return this.isForeignKeyRelationship();
    }

    @Override
    public UnitOfWorkValueHolder createUnitOfWorkValueHolder(ValueHolderInterface attributeValue, Object original, Object clone, AbstractRecord row, UnitOfWorkImpl unitOfWork, boolean buildDirectlyFromRow) {
        UnitOfWorkQueryValueHolder valueHolder = null;
        if (row == null && this.isPrimaryKeyMapping()) {
            AbstractRecord rowFromTargetObject = this.extractPrimaryKeyRowForSourceObject(original, unitOfWork);
            valueHolder = new UnitOfWorkQueryValueHolder(attributeValue, clone, this, rowFromTargetObject, unitOfWork);
        } else {
            valueHolder = new UnitOfWorkQueryValueHolder(attributeValue, clone, this, row, unitOfWork);
        }
        if (buildDirectlyFromRow && attributeValue.isInstantiated()) {
            Object cloneAttributeValue = attributeValue.getValue();
            valueHolder.privilegedSetValue(cloneAttributeValue);
            valueHolder.setInstantiated();
        }
        return valueHolder;
    }

    public AbstractRecord extractPrimaryKeyRowForSourceObject(Object domainObject, AbstractSession session) {
        AbstractRecord databaseRow = this.getDescriptor().getObjectBuilder().createRecord();
        this.writeFromObjectIntoRow(domainObject, databaseRow, session);
        return databaseRow;
    }

    public Vector extractPrimaryKeysForReferenceObject(Object domainObject, AbstractSession session) {
        return this.getIndirectionPolicy().extractPrimaryKeyForReferenceObject(this.getAttributeValueFromObject(domainObject), session);
    }

    public Vector extractPrimaryKeysForReferenceObjectFromRow(AbstractRecord row) {
        return new Vector(1);
    }

    public Vector extractPrimaryKeysFromRealReferenceObject(Object object, AbstractSession session) {
        if (object == null) {
            return new Vector(1);
        }
        Object implementation = this.getReferenceDescriptor().getObjectBuilder().unwrapObject(object, session);
        return this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(implementation, session);
    }

    @Override
    public void preInitialize(AbstractSession session) throws DescriptorException {
        super.preInitialize(session);
        if (this.getIndirectionPolicy() instanceof ProxyIndirectionPolicy && !((ProxyIndirectionPolicy)this.getIndirectionPolicy()).hasTargetInterfaces()) {
            this.useProxyIndirection();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void insert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        Object object = this.getRealAttributeValueFromObject(query.getObject(), query.getSession());
        if (object == null) {
            return;
        }
        ObjectChangeSet changeSet = query.getObjectChangeSet();
        if (changeSet != null) {
            ObjectReferenceChangeRecord changeRecord = (ObjectReferenceChangeRecord)query.getObjectChangeSet().getChangesForAttributeNamed(this.getAttributeName());
            if (changeRecord == null) return;
            changeSet = (ObjectChangeSet)changeRecord.getNewValue();
        } else {
            UnitOfWorkChangeSet uowChangeSet = null;
            if (query.getSession().isUnitOfWork() && ((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet() != null) {
                uowChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet();
                changeSet = (ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(object);
            }
        }
        WriteObjectQuery writeQuery = null;
        writeQuery = this.isPrivateOwned() && (changeSet == null || changeSet.isNew()) ? new InsertObjectQuery() : new WriteObjectQuery();
        writeQuery.setIsExecutionClone(true);
        writeQuery.setObject(object);
        writeQuery.setObjectChangeSet(changeSet);
        writeQuery.setCascadePolicy(query.getCascadePolicy());
        query.getSession().executeQuery(writeQuery);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void update(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        if (!this.isAttributeValueInstantiated(query.getObject())) {
            return;
        }
        Object object = this.getRealAttributeValueFromObject(query.getObject(), query.getSession());
        if (object == null) return;
        ObjectChangeSet changeSet = query.getObjectChangeSet();
        if (changeSet != null) {
            ObjectReferenceChangeRecord changeRecord = (ObjectReferenceChangeRecord)query.getObjectChangeSet().getChangesForAttributeNamed(this.getAttributeName());
            if (changeRecord == null) return;
            changeSet = (ObjectChangeSet)changeRecord.getNewValue();
        } else {
            UnitOfWorkChangeSet uowChangeSet = null;
            if (query.getSession().isUnitOfWork() && ((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet() != null) {
                uowChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet();
                changeSet = (ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(object);
            }
        }
        if (query.shouldCascadeOnlyDependentParts() && changeSet != null && !changeSet.isNew()) return;
        WriteObjectQuery writeQuery = new WriteObjectQuery();
        writeQuery.setIsExecutionClone(true);
        writeQuery.setObject(object);
        writeQuery.setObjectChangeSet(changeSet);
        writeQuery.setCascadePolicy(query.getCascadePolicy());
        query.getSession().executeQuery(writeQuery);
    }

    public void useProxyIndirection() {
        Class[] targetInterfaces = this.getReferenceClass().getInterfaces();
        if (!this.getReferenceClass().isInterface() && this.getReferenceClass().getSuperclass() == null) {
            this.setIndirectionPolicy(new ProxyIndirectionPolicy(targetInterfaces));
        } else {
            HashSet<Class> targetInterfacesCol = new HashSet<Class>();
            if (this.getReferenceClass().getSuperclass() != null) {
                this.buildTargetInterfaces(this.getReferenceClass(), targetInterfacesCol);
            }
            if (this.getReferenceClass().isInterface()) {
                targetInterfacesCol.add(this.getReferenceClass());
            }
            targetInterfaces = targetInterfacesCol.toArray(targetInterfaces);
            this.setIndirectionPolicy(new ProxyIndirectionPolicy(targetInterfaces));
        }
    }

    public Collection buildTargetInterfaces(Class aClass, Collection targetInterfacesCol) {
        Class<?>[] targetInterfaces = aClass.getInterfaces();
        for (int index = 0; index < targetInterfaces.length; ++index) {
            targetInterfacesCol.add(targetInterfaces[index]);
        }
        if (aClass.getSuperclass() == null) {
            return targetInterfacesCol;
        }
        return this.buildTargetInterfaces(aClass.getSuperclass(), targetInterfacesCol);
    }

    public void useProxyIndirection(Class[] targetInterfaces) {
        this.setIndirectionPolicy(new ProxyIndirectionPolicy(targetInterfaces));
    }

    public void useProxyIndirection(Class targetInterface) {
        Class[] targetInterfaces = new Class[]{targetInterface};
        this.setIndirectionPolicy(new ProxyIndirectionPolicy(targetInterfaces));
    }

    @Override
    public boolean verifyDelete(Object object, AbstractSession session) throws DatabaseException {
        Object attributeValue;
        if (this.isPrivateOwned() && (attributeValue = this.getRealAttributeValueFromObject(object, session)) != null) {
            return session.verifyDelete(attributeValue);
        }
        return true;
    }

    @Override
    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery query, AbstractRecord databaseRow) {
        Object object = query.getObject();
        AbstractSession session = query.getSession();
        if (!this.isAttributeValueInstantiated(object)) {
            return;
        }
        if (session.isUnitOfWork() && this.compareObjectsWithoutPrivateOwned(query.getBackupClone(), object, session)) {
            return;
        }
        this.writeFromObjectIntoRow(object, databaseRow, session);
    }

    @Override
    public void writeFromObjectIntoRowForWhereClause(ObjectLevelModifyQuery query, AbstractRecord databaseRow) {
        if (this.isReadOnly()) {
            return;
        }
        if (query.isDeleteObjectQuery()) {
            this.writeFromObjectIntoRow(query.getObject(), databaseRow, query.getSession());
        } else if (this.isAttributeValueInstantiated(query.getObject())) {
            this.writeFromObjectIntoRow(query.getBackupClone(), databaseRow, query.getSession());
        } else {
            this.writeFromObjectIntoRow(query.getObject(), databaseRow, query.getSession());
        }
    }

    @Override
    public boolean isChangeTrackingSupported(Project project) {
        return true;
    }

    @Override
    public void updateChangeRecord(Object clone, Object newValue, Object oldValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) {
        ObjectReferenceChangeRecord changeRecord;
        Object unwrappedNewValue = newValue;
        Object unwrappedOldValue = oldValue;
        if (newValue != null) {
            unwrappedNewValue = this.getReferenceDescriptor().getObjectBuilder().unwrapObject(newValue, uow);
        }
        if (oldValue != null) {
            unwrappedOldValue = this.getReferenceDescriptor().getObjectBuilder().unwrapObject(oldValue, uow);
        }
        if ((changeRecord = (ObjectReferenceChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName())) == null) {
            changeRecord = this.internalBuildChangeRecord(unwrappedNewValue, objectChangeSet, uow);
            changeRecord.setOldValue(unwrappedOldValue);
            objectChangeSet.addChange(changeRecord);
        } else {
            this.setNewValueInChangeRecord(unwrappedNewValue, changeRecord, objectChangeSet, uow);
        }
    }

    @Override
    public ChangeRecord buildChangeRecord(Object clone, ObjectChangeSet owner, AbstractSession session) {
        return this.internalBuildChangeRecord(this.getRealAttributeValueFromObject(clone, session), owner, session);
    }
}

