/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import org.eclipse.persistence.internal.oxm.StrBuffer;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLRootRecord
extends UnmarshalRecord {
    private Class targetClass;
    private String rootElementName;
    private String rootElementNamespaceUri;
    private StrBuffer characters;
    private boolean shouldReadChars;
    private int elementCount;

    public XMLRootRecord(Class cls) {
        super(null);
        this.targetClass = cls;
        this.shouldReadChars = true;
        this.elementCount = 0;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.characters == null) {
            this.characters = new StrBuffer();
        }
        if (this.shouldReadChars) {
            this.characters.append(ch, start, length);
        }
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.shouldReadChars = false;
    }

    public Object getCurrentObject() {
        String val = null;
        if (this.characters != null) {
            val = this.characters.toString();
        }
        XMLRoot xmlRoot = new XMLRoot();
        xmlRoot.setObject(XMLConversionManager.getDefaultXMLManager().convertObject(val, this.targetClass));
        xmlRoot.setLocalName(this.getRootElementName());
        xmlRoot.setNamespaceURI(this.getRootElementNamespaceUri());
        return xmlRoot;
    }

    public String getRootElementName() {
        return this.rootElementName;
    }

    public String getRootElementNamespaceUri() {
        return this.rootElementNamespaceUri;
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.rootElementName == null) {
            this.rootElementName = qName;
            this.rootElementNamespaceUri = namespaceURI;
        }
        ++this.elementCount;
        if (this.elementCount > 1) {
            this.shouldReadChars = false;
        }
    }
}

