/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.util;

import java.util.HashMap;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.CodeAdapter;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.eclipse.persistence.internal.libraries.asm.Type;

public class CheckCodeAdapter
extends CodeAdapter {
    private boolean end;
    private HashMap labels = new HashMap();
    private static final int[] TYPE = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 7, -1, -1, 2, 2, 2, 2, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 2, 9, 10, 0, 0, 0, 0, 0, 0, 4, 4, 4, 4, 5, 5, 5, 5, -1, 3, 1, 3, 0, 0, 3, 3, 0, 0, -1, 11, 6, 6, -1, -1};

    public CheckCodeAdapter(CodeVisitor cv) {
        super(cv);
    }

    public void visitInsn(int opcode) {
        this.checkEnd();
        CheckCodeAdapter.checkOpcode(opcode, 0);
        this.cv.visitInsn(opcode);
    }

    public void visitIntInsn(int opcode, int operand) {
        this.checkEnd();
        CheckCodeAdapter.checkOpcode(opcode, 1);
        switch (opcode) {
            case 16: {
                CheckCodeAdapter.checkSignedByte(operand, "Invalid operand");
                break;
            }
            case 17: {
                CheckCodeAdapter.checkSignedShort(operand, "Invalid operand");
                break;
            }
            default: {
                if (operand >= 4 && operand <= 11) break;
                throw new IllegalArgumentException("Invalid operand (must be an array type code T_...): " + operand);
            }
        }
        this.cv.visitIntInsn(opcode, operand);
    }

    public void visitVarInsn(int opcode, int var) {
        this.checkEnd();
        CheckCodeAdapter.checkOpcode(opcode, 2);
        CheckCodeAdapter.checkUnsignedShort(var, "Invalid variable index");
        this.cv.visitVarInsn(opcode, var);
    }

    public void visitTypeInsn(int opcode, String desc) {
        this.checkEnd();
        CheckCodeAdapter.checkOpcode(opcode, 3);
        if (desc != null && desc.length() > 0 && desc.charAt(0) == '[') {
            CheckCodeAdapter.checkDesc(desc, false);
        } else {
            CheckCodeAdapter.checkInternalName(desc, "type");
        }
        if (opcode == 187 && desc.charAt(0) == '[') {
            throw new IllegalArgumentException("NEW cannot be used to create arrays: " + desc);
        }
        this.cv.visitTypeInsn(opcode, desc);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.checkEnd();
        CheckCodeAdapter.checkOpcode(opcode, 4);
        CheckCodeAdapter.checkInternalName(owner, "owner");
        CheckCodeAdapter.checkIdentifier(name, "name");
        CheckCodeAdapter.checkDesc(desc, false);
        this.cv.visitFieldInsn(opcode, owner, name, desc);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.checkEnd();
        CheckCodeAdapter.checkOpcode(opcode, 5);
        CheckCodeAdapter.checkInternalName(owner, "owner");
        CheckCodeAdapter.checkMethodIdentifier(name, "name");
        CheckCodeAdapter.checkMethodDesc(desc);
        this.cv.visitMethodInsn(opcode, owner, name, desc);
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.checkEnd();
        CheckCodeAdapter.checkOpcode(opcode, 6);
        this.checkLabel(label, false, "label");
        this.cv.visitJumpInsn(opcode, label);
    }

    public void visitLabel(Label label) {
        this.checkEnd();
        this.checkLabel(label, false, "label");
        if (this.labels.get(label) != null) {
            throw new IllegalArgumentException("Already visited label");
        }
        this.labels.put(label, new Integer(this.labels.size()));
        this.cv.visitLabel(label);
    }

    public void visitLdcInsn(Object cst) {
        this.checkEnd();
        if (!(cst instanceof Type)) {
            CheckCodeAdapter.checkConstant(cst);
        }
        this.cv.visitLdcInsn(cst);
    }

    public void visitIincInsn(int var, int increment) {
        this.checkEnd();
        CheckCodeAdapter.checkUnsignedShort(var, "Invalid variable index");
        CheckCodeAdapter.checkSignedShort(increment, "Invalid increment");
        this.cv.visitIincInsn(var, increment);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.checkEnd();
        if (max < min) {
            throw new IllegalArgumentException("Max = " + max + " must be greater than or equal to min = " + min);
        }
        this.checkLabel(dflt, false, "default label");
        if (labels == null || labels.length != max - min + 1) {
            throw new IllegalArgumentException("There must be max - min + 1 labels");
        }
        for (int i = 0; i < labels.length; ++i) {
            this.checkLabel(labels[i], false, "label at index " + i);
        }
        this.cv.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.checkEnd();
        this.checkLabel(dflt, false, "default label");
        if (keys == null || labels == null || keys.length != labels.length) {
            throw new IllegalArgumentException("There must be the same number of keys and labels");
        }
        for (int i = 0; i < labels.length; ++i) {
            this.checkLabel(labels[i], false, "label at index " + i);
        }
        this.cv.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.checkEnd();
        CheckCodeAdapter.checkDesc(desc, false);
        if (desc.charAt(0) != '[') {
            throw new IllegalArgumentException("Invalid descriptor (must be an array type descriptor): " + desc);
        }
        if (dims < 1) {
            throw new IllegalArgumentException("Invalid dimensions (must be greater than 0): " + dims);
        }
        if (dims > desc.lastIndexOf(91) + 1) {
            throw new IllegalArgumentException("Invalid dimensions (must not be greater than dims(desc)): " + dims);
        }
        this.cv.visitMultiANewArrayInsn(desc, dims);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.checkLabel(start, true, "start label");
        this.checkLabel(end, true, "end label");
        this.checkLabel(handler, true, "handler label");
        if (type != null) {
            CheckCodeAdapter.checkInternalName(type, "type");
        }
        int s = (Integer)this.labels.get(start);
        int e = (Integer)this.labels.get(end);
        if (e <= s) {
            throw new IllegalArgumentException("Invalid start and end labels (end must be greater than start)");
        }
        this.cv.visitTryCatchBlock(start, end, handler, type);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.checkEnd();
        this.end = true;
        CheckCodeAdapter.checkUnsignedShort(maxStack, "Invalid max stack");
        CheckCodeAdapter.checkUnsignedShort(maxLocals, "Invalid max locals");
        this.cv.visitMaxs(maxStack, maxLocals);
    }

    public void visitLocalVariable(String name, String desc, Label start, Label end, int index) {
        CheckCodeAdapter.checkIdentifier(name, "name");
        CheckCodeAdapter.checkDesc(desc, false);
        this.checkLabel(start, true, "start label");
        this.checkLabel(end, true, "end label");
        CheckCodeAdapter.checkUnsignedShort(index, "Invalid variable index");
        int s = (Integer)this.labels.get(start);
        int e = (Integer)this.labels.get(end);
        if (e <= s) {
            throw new IllegalArgumentException("Invalid start and end labels (end must be greater than start)");
        }
        this.cv.visitLocalVariable(name, desc, start, end, index);
    }

    public void visitLineNumber(int line, Label start) {
        CheckCodeAdapter.checkUnsignedShort(line, "Invalid line number");
        this.checkLabel(start, true, "start label");
        this.cv.visitLineNumber(line, start);
    }

    public void visitAttribute(Attribute attr) {
        if (attr == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
    }

    void checkEnd() {
        if (this.end) {
            throw new IllegalStateException("Cannot visit instructions after visitMaxs has been called.");
        }
    }

    static void checkOpcode(int opcode, int type) {
        if (opcode < 0 || opcode > 199 || TYPE[opcode] != type) {
            throw new IllegalArgumentException("Invalid opcode: " + opcode);
        }
    }

    static void checkSignedByte(int value, String msg) {
        if (value < -128 || value > 127) {
            throw new IllegalArgumentException(msg + " (must be a signed byte): " + value);
        }
    }

    static void checkSignedShort(int value, String msg) {
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new IllegalArgumentException(msg + " (must be a signed short): " + value);
        }
    }

    static void checkUnsignedShort(int value, String msg) {
        if (value < 0 || value > 65535) {
            throw new IllegalArgumentException(msg + " (must be an unsigned short): " + value);
        }
    }

    static void checkConstant(Object cst) {
        if (!(cst instanceof Integer || cst instanceof Float || cst instanceof Long || cst instanceof Double || cst instanceof String)) {
            throw new IllegalArgumentException("Invalid constant: " + cst);
        }
    }

    static void checkIdentifier(String name, String msg) {
        CheckCodeAdapter.checkIdentifier(name, 0, -1, msg);
    }

    static void checkIdentifier(String name, int start, int end, String msg) {
        if (name == null || (end == -1 ? name.length() <= start : end <= start)) {
            throw new IllegalArgumentException("Invalid " + msg + " (must not be null or empty)");
        }
        if (!Character.isJavaIdentifierStart(name.charAt(start))) {
            throw new IllegalArgumentException("Invalid " + msg + " (must be a valid Java identifier): " + name);
        }
        int max = end == -1 ? name.length() : end;
        for (int i = start + 1; i < max; ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            throw new IllegalArgumentException("Invalid " + msg + " (must be a valid Java identifier): " + name);
        }
    }

    static void checkMethodIdentifier(String name, String msg) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Invalid " + msg + " (must not be null or empty)");
        }
        if (name.equals("<init>") || name.equals("<clinit>")) {
            return;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            throw new IllegalArgumentException("Invalid " + msg + " (must be a '<init>', '<clinit>' or a valid Java identifier): " + name);
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            throw new IllegalArgumentException("Invalid " + msg + " (must be '<init>' or '<clinit>' or a valid Java identifier): " + name);
        }
    }

    static void checkInternalName(String name, String msg) {
        CheckCodeAdapter.checkInternalName(name, 0, -1, msg);
    }

    static void checkInternalName(String name, int start, int end, String msg) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Invalid " + msg + " (must not be null or empty)");
        }
        int max = end == -1 ? name.length() : end;
        try {
            int slash;
            int begin = start;
            do {
                if ((slash = name.indexOf(47, begin + 1)) == -1 || slash > max) {
                    slash = max;
                }
                CheckCodeAdapter.checkIdentifier(name, begin, slash, null);
                begin = slash + 1;
            } while (slash != max);
        }
        catch (IllegalArgumentException _) {
            throw new IllegalArgumentException("Invalid " + msg + " (must be a fully qualified class name in internal form): " + name);
        }
    }

    static void checkDesc(String desc, boolean canBeVoid) {
        int end = CheckCodeAdapter.checkDesc(desc, 0, canBeVoid);
        if (end != desc.length()) {
            throw new IllegalArgumentException("Invalid descriptor: " + desc);
        }
    }

    static int checkDesc(String desc, int start, boolean canBeVoid) {
        if (desc == null || start >= desc.length()) {
            throw new IllegalArgumentException("Invalid type descriptor (must not be null or empty)");
        }
        switch (desc.charAt(start)) {
            case 'V': {
                if (canBeVoid) {
                    return start + 1;
                }
                throw new IllegalArgumentException("Invalid descriptor: " + desc);
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return start + 1;
            }
            case '[': {
                int index;
                for (index = start + 1; index < desc.length() && desc.charAt(index) == '['; ++index) {
                }
                if (index < desc.length()) {
                    return CheckCodeAdapter.checkDesc(desc, index, false);
                }
                throw new IllegalArgumentException("Invalid descriptor: " + desc);
            }
            case 'L': {
                int index = desc.indexOf(59, start);
                if (index == -1 || index - start < 2) {
                    throw new IllegalArgumentException("Invalid descriptor: " + desc);
                }
                try {
                    CheckCodeAdapter.checkInternalName(desc, start + 1, index, null);
                }
                catch (IllegalArgumentException _) {
                    throw new IllegalArgumentException("Invalid descriptor: " + desc);
                }
                return index + 1;
            }
        }
        throw new IllegalArgumentException("Invalid descriptor: " + desc);
    }

    static void checkMethodDesc(String desc) {
        if (desc == null || desc.length() == 0) {
            throw new IllegalArgumentException("Invalid method descriptor (must not be null or empty)");
        }
        if (desc.charAt(0) != '(' || desc.length() < 3) {
            throw new IllegalArgumentException("Invalid descriptor: " + desc);
        }
        int start = 1;
        if (desc.charAt(start) != ')') {
            do {
                if (desc.charAt(start) != 'V') continue;
                throw new IllegalArgumentException("Invalid descriptor: " + desc);
            } while ((start = CheckCodeAdapter.checkDesc(desc, start, false)) < desc.length() && desc.charAt(start) != ')');
        }
        if ((start = CheckCodeAdapter.checkDesc(desc, start + 1, true)) != desc.length()) {
            throw new IllegalArgumentException("Invalid descriptor: " + desc);
        }
    }

    void checkLabel(Label label, boolean checkVisited, String msg) {
        if (label == null) {
            throw new IllegalArgumentException("Invalid " + msg + " (must not be null)");
        }
        if (checkVisited && this.labels.get(label) == null) {
            throw new IllegalArgumentException("Invalid " + msg + " (must be visited first)");
        }
    }
}

