/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.internal.helper.linkedlist.ExposedNodeLinkedList;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class WriteLockManager {
    protected ExposedNodeLinkedList prevailingQueue = new ExposedNodeLinkedList();
    public static int MAXTRIES = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map acquireLocksForClone(Object objectForClone, ClassDescriptor descriptor, CacheKey cacheKey, AbstractSession session, UnitOfWorkImpl unitOfWork) {
        boolean successful = false;
        IdentityHashMap lockedObjects = new IdentityHashMap();
        try {
            CacheKey toWaitOn = this.acquireLockAndRelatedLocks(objectForClone, lockedObjects, cacheKey, descriptor, session, unitOfWork);
            int tries = 0;
            while (toWaitOn != null) {
                Object lockedList = lockedObjects.values().iterator();
                while (lockedList.hasNext()) {
                    ((CacheKey)lockedList.next()).releaseReadLock();
                    lockedList.remove();
                }
                lockedList = toWaitOn.getMutex();
                synchronized (lockedList) {
                    try {
                        if (toWaitOn.isAcquired()) {
                            toWaitOn.getMutex().wait();
                        }
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
                Object waitObject = toWaitOn.getObject();
                if (waitObject != null) {
                    unitOfWork.checkInvalidObject(toWaitOn.getObject(), toWaitOn, session.getDescriptor(waitObject));
                }
                if ((toWaitOn = this.acquireLockAndRelatedLocks(objectForClone, lockedObjects, cacheKey, descriptor, session, unitOfWork)) == null || ++tries <= MAXTRIES) continue;
                throw ConcurrencyException.maxTriesLockOnCloneExceded(objectForClone);
            }
            successful = true;
        }
        finally {
            if (!successful) {
                Iterator lockedList = lockedObjects.values().iterator();
                while (lockedList.hasNext()) {
                    ((CacheKey)lockedList.next()).releaseReadLock();
                    lockedList.remove();
                }
            }
        }
        return lockedObjects;
    }

    public CacheKey acquireLockAndRelatedLocks(Object objectForClone, Map lockedObjects, CacheKey cacheKey, ClassDescriptor descriptor, AbstractSession session, UnitOfWorkImpl unitOfWork) {
        if (this.checkInvalidObject(objectForClone, cacheKey, descriptor, unitOfWork)) {
            return cacheKey;
        }
        if (cacheKey.acquireReadLockNoWait()) {
            if (cacheKey.getObject() == null) {
                lockedObjects.put(objectForClone, cacheKey);
            } else {
                objectForClone = cacheKey.getObject();
                if (lockedObjects.containsKey(objectForClone)) {
                    cacheKey.releaseReadLock();
                    return null;
                }
                lockedObjects.put(objectForClone, cacheKey);
            }
            return this.traverseRelatedLocks(objectForClone, lockedObjects, descriptor, session, unitOfWork);
        }
        return cacheKey;
    }

    public boolean checkInvalidObject(Object object, CacheKey cacheKey, ClassDescriptor descriptor, UnitOfWorkImpl unitOfWork) {
        if (!unitOfWork.isNestedUnitOfWork() && cacheKey.getObject() != null) {
            CacheInvalidationPolicy cachePolicy = descriptor.getCacheInvalidationPolicy();
            return cachePolicy.shouldRefreshInvalidObjectsInUnitOfWork() && cachePolicy.isInvalidated(cacheKey);
        }
        return false;
    }

    public CacheKey traverseRelatedLocks(Object objectForClone, Map lockedObjects, ClassDescriptor descriptor, AbstractSession session, UnitOfWorkImpl unitOfWork) {
        if (descriptor.shouldAcquireCascadedLocks()) {
            FetchGroupManager fetchGroupManager = descriptor.getFetchGroupManager();
            boolean isPartialObject = fetchGroupManager != null && fetchGroupManager.isPartialObject(objectForClone);
            for (DatabaseMapping mapping : descriptor.getLockableMappings()) {
                CacheKey toWaitOn;
                if (isPartialObject && !fetchGroupManager.isAttributeFetched(objectForClone, mapping.getAttributeName())) continue;
                Object objectToLock = mapping.getAttributeValueFromObject(objectForClone);
                if (mapping.isCollectionMapping()) {
                    if (objectToLock == null) continue;
                    ContainerPolicy cp = mapping.getContainerPolicy();
                    Object iterator = cp.iteratorFor(objectToLock);
                    while (cp.hasNext(iterator)) {
                        CacheKey toWaitOn2;
                        Object object = cp.next(iterator, session);
                        if (mapping.getReferenceDescriptor().hasWrapperPolicy()) {
                            object = mapping.getReferenceDescriptor().getWrapperPolicy().unwrapObject(object, session);
                        }
                        if ((toWaitOn2 = this.checkAndLockObject(object, lockedObjects, mapping, session, unitOfWork)) == null) continue;
                        return toWaitOn2;
                    }
                    continue;
                }
                if (mapping.getReferenceDescriptor().hasWrapperPolicy()) {
                    objectToLock = mapping.getReferenceDescriptor().getWrapperPolicy().unwrapObject(objectToLock, session);
                }
                if ((toWaitOn = this.checkAndLockObject(objectToLock, lockedObjects, mapping, session, unitOfWork)) == null) continue;
                return toWaitOn;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireRequiredLocks(MergeManager mergeManager, UnitOfWorkChangeSet changeSet) {
        if (!MergeManager.LOCK_ON_MERGE) {
            return;
        }
        boolean locksToAcquire = true;
        boolean isForDistributedMerge = false;
        try {
            AbstractSession session = mergeManager.getSession();
            if (session.isUnitOfWork()) {
                session = ((UnitOfWorkImpl)session).getParent();
            } else {
                isForDistributedMerge = true;
            }
            block10: while (locksToAcquire) {
                locksToAcquire = false;
                for (String objectClassName : changeSet.getObjectChanges().keySet()) {
                    Hashtable changeSetTable = (Hashtable)changeSet.getObjectChanges().get(objectClassName);
                    Iterator changeSetIterator = changeSetTable.keySet().iterator();
                    Class objectClass = null;
                    while (changeSetIterator.hasNext()) {
                        ClassDescriptor descriptor;
                        ObjectChangeSet objectChangeSet = (ObjectChangeSet)changeSetIterator.next();
                        if (objectChangeSet.getCacheKey() == null) continue;
                        if (objectClass == null) {
                            objectClass = objectChangeSet.getClassType(session);
                        }
                        if ((descriptor = session.getDescriptor(objectClass)).shouldIsolateObjectsInUnitOfWork()) break;
                        CacheKey activeCacheKey = this.attemptToAcquireLock(objectClass, objectChangeSet.getCacheKey(), session);
                        if (activeCacheKey == null) {
                            block23: {
                                Object[] params;
                                if (this.prevailingQueue.getFirst() == mergeManager) {
                                    activeCacheKey = this.waitOnObjectLock(objectClass, objectChangeSet.getCacheKey(), session);
                                    mergeManager.getAcquiredLocks().add(activeCacheKey);
                                    continue;
                                }
                                this.releaseAllAcquiredLocks(mergeManager);
                                activeCacheKey = session.getIdentityMapAccessorInstance().getCacheKeyForObject(objectChangeSet.getCacheKey().getKey(), objectClass, descriptor);
                                if (session.shouldLog(2, "cache")) {
                                    params = new Object[]{objectClass, objectChangeSet.getCacheKey() != null ? objectChangeSet.getCacheKey().getKey() : new Vector(), Thread.currentThread().getName()};
                                    session.log(2, "cache", "dead_lock_encountered_on_write_no_cachekey", params, null, true);
                                }
                                if (mergeManager.getWriteLockQueued() == null) {
                                    mergeManager.setQueueNode(this.prevailingQueue.addLast(mergeManager));
                                }
                                mergeManager.setWriteLockQueued(objectChangeSet.getCacheKey());
                                try {
                                    if (activeCacheKey == null) break block23;
                                    params = activeCacheKey.getMutex();
                                    synchronized (params) {
                                        if (activeCacheKey.getMutex().isAcquired() && activeCacheKey.getMutex().getActiveThread() != Thread.currentThread()) {
                                            activeCacheKey.getMutex().wait();
                                        }
                                    }
                                }
                                catch (InterruptedException exception) {
                                    throw ConcurrencyException.waitWasInterrupted(exception.getMessage());
                                }
                            }
                            locksToAcquire = true;
                            break;
                        }
                        objectChangeSet.setActiveCacheKey(activeCacheKey);
                        mergeManager.getAcquiredLocks().add(activeCacheKey);
                    }
                    if (!locksToAcquire) continue;
                    continue block10;
                }
            }
        }
        catch (RuntimeException exception) {
            this.releaseAllAcquiredLocks(mergeManager);
            throw exception;
        }
        finally {
            if (mergeManager.getWriteLockQueued() != null) {
                this.prevailingQueue.remove(mergeManager.getQueueNode());
                mergeManager.setWriteLockQueued(null);
            }
        }
    }

    public Object appendLock(Vector primaryKeys, Object objectToLock, ClassDescriptor descriptor, MergeManager mergeManager, AbstractSession session) {
        for (int tries = 0; tries < 1000; ++tries) {
            CacheKey lockedCacheKey = session.getIdentityMapAccessorInstance().acquireLockNoWait(primaryKeys, descriptor.getJavaClass(), true, descriptor);
            if (lockedCacheKey == null) {
                lockedCacheKey = session.getIdentityMapAccessorInstance().acquireReadLockOnCacheKey(primaryKeys, descriptor.getJavaClass(), descriptor);
                Object cachedObject = lockedCacheKey.getObject();
                lockedCacheKey.releaseReadLock();
                if (cachedObject != null) {
                    return cachedObject;
                }
            } else {
                if (lockedCacheKey.getObject() == null) {
                    lockedCacheKey.setObject(objectToLock);
                }
                mergeManager.getAcquiredLocks().add(lockedCacheKey);
                return objectToLock;
            }
            session.getSessionLog().log(1, "cache", "Found null object in identity map on appendLock, retrying");
        }
        throw ConcurrencyException.maxTriesLockOnMergeExceded(objectToLock);
    }

    protected CacheKey attemptToAcquireLock(Class objectClass, CacheKey cacheKey, AbstractSession session) {
        return session.getIdentityMapAccessorInstance().acquireLockNoWait(cacheKey.getKey(), objectClass, true, session.getDescriptor(objectClass));
    }

    protected CacheKey checkAndLockObject(Object objectToLock, Map lockedObjects, DatabaseMapping mapping, AbstractSession session, UnitOfWorkImpl unitOfWork) {
        if (objectToLock != null && !lockedObjects.containsKey(objectToLock)) {
            Vector primaryKeysToLock = null;
            ClassDescriptor referenceDescriptor = null;
            referenceDescriptor = mapping.getReferenceDescriptor().hasInheritance() ? session.getDescriptor(objectToLock) : mapping.getReferenceDescriptor();
            if (referenceDescriptor.isAggregateDescriptor() || referenceDescriptor.isAggregateCollectionDescriptor()) {
                this.traverseRelatedLocks(objectToLock, lockedObjects, referenceDescriptor, session, unitOfWork);
            } else {
                CacheKey toWaitOn;
                primaryKeysToLock = referenceDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(objectToLock, session);
                CacheKey cacheKey = session.getIdentityMapAccessorInstance().getCacheKeyForObject(primaryKeysToLock, objectToLock.getClass(), referenceDescriptor);
                if (cacheKey == null) {
                    cacheKey = new CacheKey(primaryKeysToLock);
                    cacheKey.setReadTime(System.currentTimeMillis());
                }
                if ((toWaitOn = this.acquireLockAndRelatedLocks(objectToLock, lockedObjects, cacheKey, referenceDescriptor, session, unitOfWork)) != null) {
                    return toWaitOn;
                }
            }
        }
        return null;
    }

    public void releaseAllAcquiredLocks(MergeManager mergeManager) {
        if (!MergeManager.LOCK_ON_MERGE) {
            return;
        }
        Iterator locks = mergeManager.getAcquiredLocks().iterator();
        while (locks.hasNext()) {
            CacheKey cacheKeyToRemove = (CacheKey)locks.next();
            if (cacheKeyToRemove.getObject() == null && cacheKeyToRemove.getOwningMap() != null) {
                cacheKeyToRemove.getOwningMap().remove(cacheKeyToRemove);
            }
            cacheKeyToRemove.release();
            locks.remove();
        }
    }

    protected CacheKey waitOnObjectLock(Class objectClass, CacheKey cacheKey, AbstractSession session) {
        return session.getIdentityMapAccessorInstance().acquireLock(cacheKey.getKey(), objectClass, true, session.getDescriptor(objectClass));
    }
}

