/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.remote;

import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.InvalidObject;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CommitManager;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.Transporter;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.sessions.server.ServerSession;

public class RemoteUnitOfWork
extends UnitOfWorkImpl {
    protected Vector newObjectsCache;
    protected Vector unregisteredNewObjectsCache;
    protected boolean isOnClient = true;
    protected transient RemoteSessionController parentSessionController;

    public RemoteUnitOfWork(RemoteUnitOfWork parent) {
        super(parent);
    }

    public RemoteUnitOfWork(RemoteSession parent) {
        super(parent);
    }

    public UnitOfWorkImpl acquireUnitOfWork() {
        this.log(2, "transaction", "acquire_unit_of_work");
        this.setNumberOfActiveUnitsOfWork(this.getNumberOfActiveUnitsOfWork() + 1);
        RemoteUnitOfWork ruow = new RemoteUnitOfWork(this);
        ruow.discoverAllUnregisteredNewObjectsInParent();
        return ruow;
    }

    protected Vector collectNewObjects() {
        return Helper.buildVectorFromHashtableElements(this.getNewObjectsCloneToOriginal());
    }

    protected Vector collectUnregisteredNewObjects() {
        this.discoverAllUnregisteredNewObjects();
        return Helper.buildVectorFromHashtableElements(this.getUnregisteredNewObjects());
    }

    protected void commitIntoRemoteUnitOfWork() {
        ((UnitOfWorkImpl)this.getParent()).setWasTransactionBegunPrematurely(this.wasTransactionBegunPrematurely());
        MergeManager manager = new MergeManager(this);
        manager.mergeWorkingCopyIntoRemote();
        Iterator clones = new IdentityHashMap(this.getCloneMapping()).keySet().iterator();
        while (clones.hasNext()) {
            manager.mergeChanges(clones.next(), null);
        }
    }

    public void commitRootUnitOfWork() {
        RemoteUnitOfWork remoteUnitOfWork;
        if (!this.isOnClient()) {
            if (this.isSynchronized()) {
                if (this.getParent().wasJTSTransactionInternallyStarted()) {
                    this.commitInternallyStartedExternalTransaction();
                }
                return;
            }
            this.getEventManager().preCommitUnitOfWork();
            super.commitRootUnitOfWork();
            this.getEventManager().postCommitUnitOfWork();
            return;
        }
        this.setNewObjectsCache(this.collectNewObjects());
        this.setUnregisteredNewObjectsCache(this.collectUnregisteredNewObjects());
        try {
            remoteUnitOfWork = ((RemoteSession)this.getParent()).getRemoteConnection().commitRootUnitOfWork(this);
        }
        catch (RuntimeException exception) {
            if (this.wasTransactionBegunPrematurely()) {
                this.getParent().getTransactionMutex().release();
            }
            this.setWasTransactionBegunPrematurely(false);
            throw exception;
        }
        if (this.wasTransactionBegunPrematurely()) {
            this.getParent().getTransactionMutex().release();
        }
        remoteUnitOfWork.setParent(this);
        remoteUnitOfWork.setProject(this.getProject());
        remoteUnitOfWork.prepareForMergeIntoRemoteUnitOfWork();
        remoteUnitOfWork.commitIntoRemoteUnitOfWork();
        this.commitRootUnitOfWorkOnClient();
    }

    protected void commitRootUnitOfWorkOnClient() {
        Map allObjects = this.collectAndPrepareObjectsForNestedMerge();
        this.setAllClonesCollection(allObjects);
        UnitOfWorkChangeSet uowChangeSet = (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet();
        if (uowChangeSet == null) {
            this.setUnitOfWorkChangeSet(new UnitOfWorkChangeSet());
            uowChangeSet = (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet();
            this.calculateChanges(this.getAllClones(), (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet(), false);
        }
        Enumeration classes = uowChangeSet.getNewObjectChangeSets().elements();
        while (classes.hasMoreElements()) {
            Map newList = (Map)classes.nextElement();
            Iterator newChangeSets = new IdentityHashMap(newList).keySet().iterator();
            while (newChangeSets.hasNext()) {
                uowChangeSet.putNewObjectInChangesList((ObjectChangeSet)newChangeSets.next(), this);
            }
        }
        Iterator iterator = this.getObjectsDeletedDuringCommit().keySet().iterator();
        while (iterator.hasNext()) {
            ((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet()).addDeletedObject(iterator.next(), this);
        }
        this.mergeChangesIntoParent();
    }

    public Object executeQuery(String queryName) throws DatabaseException {
        return this.executeQuery(queryName, new Vector(1));
    }

    public Object executeQuery(String queryName, Class domainClass) throws DatabaseException {
        return this.executeQuery(queryName, domainClass, new Vector(1));
    }

    public Object executeQuery(String queryName, Class domainClass, Vector argumentValues) throws DatabaseException {
        RemoteSession remoteSession = null;
        if (this.getParent().isRemoteSession()) {
            remoteSession = (RemoteSession)this.getParent();
        } else {
            RemoteUnitOfWork uow = (RemoteUnitOfWork)this.getParent();
            while (uow.getParent().isRemoteUnitOfWork()) {
                uow = (RemoteUnitOfWork)uow.getParent();
            }
            remoteSession = (RemoteSession)uow.getParent();
        }
        Transporter transporter = remoteSession.getRemoteConnection().remoteExecuteNamedQuery(queryName, domainClass, argumentValues);
        transporter.getQuery().setSession(this);
        return transporter.getQuery().extractRemoteResult(transporter);
    }

    public Object executeQuery(String queryName, Vector argumentValues) throws DatabaseException {
        if (this.containsQuery(queryName)) {
            return super.executeQuery(queryName, argumentValues);
        }
        return this.executeQuery(queryName, null, argumentValues);
    }

    public ClassDescriptor getDescriptor(Class domainClass) {
        return this.getParent().getDescriptor(domainClass);
    }

    public Vector getNewObjectsCache() {
        return this.newObjectsCache;
    }

    public RemoteSessionController getParentSessionController() {
        return this.parentSessionController;
    }

    public DatabasePlatform getPlatform() {
        return this.getParent().getPlatform();
    }

    public Platform getDatasourcePlatform() {
        return this.getParent().getDatasourcePlatform();
    }

    public Vector getUnregisteredNewObjectsCache() {
        return this.unregisteredNewObjectsCache;
    }

    public Object internalExecuteQuery(DatabaseQuery query, AbstractRecord Record2) throws DatabaseException, QueryException {
        if (!this.isActive()) {
            throw QueryException.querySentToInactiveUnitOfWork(query);
        }
        if (this.isOnClient()) {
            boolean objectLevelRead;
            boolean bl = objectLevelRead = query.isObjectLevelReadQuery() && !query.isReportQuery() && query.shouldMaintainCache();
            if (objectLevelRead) {
                ObjectLevelReadQuery readQuery = (ObjectLevelReadQuery)query;
                if (this.isAfterWriteChangesButBeforeCommit()) {
                    throw ValidationException.illegalOperationForUnitOfWorkLifecycle(this.getLifecycle(), "executeQuery(ObjectLevelReadQuery)");
                }
                Object result = readQuery.checkEarlyReturn(this, Record2);
                if (result != null) {
                    if (result == InvalidObject.instance) {
                        return null;
                    }
                    return result;
                }
                if (readQuery.isLockQuery(this) && !this.wasTransactionBegunPrematurely()) {
                    this.beginEarlyTransaction();
                }
            } else if (query.isObjectLevelModifyQuery()) {
                return query.executeInUnitOfWork(this, Record2);
            }
            if (!this.getCommitManager().isActive() && query.isDataModifyQuery() && !this.wasTransactionBegunPrematurely()) {
                this.beginEarlyTransaction();
            }
            Object result = this.getParent().executeQuery(query, Record2);
            if (objectLevelRead) {
                result = ((ObjectLevelReadQuery)query).registerResultInUnitOfWork(result, this, Record2, false);
            }
            return result;
        }
        return query.executeInUnitOfWork(this, Record2);
    }

    protected boolean isOnClient() {
        return this.isOnClient;
    }

    public boolean isRemoteUnitOfWork() {
        return true;
    }

    protected void prepareForMergeIntoRemoteUnitOfWork() {
        IdentityHashMap originalToClone = new IdentityHashMap();
        IdentityHashMap cloneToOriginal = new IdentityHashMap();
        Enumeration returnedNewObjects = this.getNewObjectsCache().elements();
        Enumeration newObjects = ((RemoteUnitOfWork)this.getParent()).getNewObjectsCache().elements();
        while (returnedNewObjects.hasMoreElements()) {
            Object cloneFromParent = ((RemoteUnitOfWork)this.getParent()).getNewObjectsOriginalToClone().get(newObjects.nextElement());
            Object cloneFromSelf = this.getNewObjectsOriginalToClone().get(returnedNewObjects.nextElement());
            if (cloneFromSelf == null) continue;
            originalToClone.put(cloneFromParent, cloneFromSelf);
            cloneToOriginal.put(cloneFromSelf, cloneFromParent);
        }
        Enumeration returnedUnregisteredNewObjects = this.getUnregisteredNewObjectsCache().elements();
        Enumeration unregisteredNewObjects = ((RemoteUnitOfWork)this.getParent()).getUnregisteredNewObjectsCache().elements();
        while (returnedUnregisteredNewObjects.hasMoreElements()) {
            Object cloneFromParent = ((RemoteUnitOfWork)this.getParent()).getUnregisteredNewObjects().get(unregisteredNewObjects.nextElement());
            Object cloneFromSelf = this.getUnregisteredNewObjects().get(returnedUnregisteredNewObjects.nextElement());
            originalToClone.put(cloneFromParent, cloneFromSelf);
            cloneToOriginal.put(cloneFromSelf, cloneFromParent);
        }
        this.setNewObjectsOriginalToClone(originalToClone);
        this.setNewObjectsCloneToOriginal(cloneToOriginal);
        IdentityHashMap<Object, Vector> objectsDeletedDuringCommit = new IdentityHashMap<Object, Vector>();
        for (Object deletedObject : this.getObjectsDeletedDuringCommit().keySet()) {
            Vector primaryKey = this.keyFromObject(deletedObject);
            Object cloneFromParent = this.getParent().getIdentityMapAccessor().getFromIdentityMap(primaryKey, deletedObject.getClass());
            if (cloneFromParent == null && (cloneFromParent = cloneToOriginal.get(deletedObject)) == null) {
                cloneFromParent = deletedObject;
            }
            objectsDeletedDuringCommit.put(cloneFromParent, this.keyFromObject(cloneFromParent));
            ((UnitOfWorkImpl)this.getParent()).getIdentityMapAccessor().removeFromIdentityMap(cloneFromParent);
        }
        ((UnitOfWorkImpl)this.getParent()).setObjectsDeletedDuringCommit(objectsDeletedDuringCommit);
    }

    public void reinitializeForSession(AbstractSession session, RemoteSessionController parentSessionController) {
        if (session.isServerSession()) {
            session = ((ServerSession)session).acquireClientSession();
        }
        this.setIsOnClient(false);
        this.setParentSessionController(parentSessionController);
        this.setParent(session);
        this.setProject(session.getProject());
        this.setProfiler(this.getProfiler());
        this.setEventManager(session.getEventManager().clone(this));
        this.setSessionLog(session.getSessionLog());
        this.setLog(session.getLog());
        this.setCommitManager(new CommitManager(this));
        this.setTransactionMutex(new ConcurrencyManager());
        this.getCommitManager().setCommitOrder(session.getCommitManager().getCommitOrder());
        if (this.getParent().hasExternalTransactionController()) {
            this.getParent().getExternalTransactionController().registerSynchronizationListener(this, this.getParent());
        }
    }

    protected void setIsOnClient(boolean isOnClient) {
        this.isOnClient = isOnClient;
    }

    protected void setNewObjectsCache(Vector newObjectsCache) {
        this.newObjectsCache = newObjectsCache;
    }

    public void setParentSessionController(RemoteSessionController parentSessionController) {
        this.parentSessionController = parentSessionController;
    }

    protected void setUnregisteredNewObjectsCache(Vector unregisteredNewObjectsCache) {
        this.unregisteredNewObjectsCache = unregisteredNewObjectsCache;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "()";
    }

    public boolean verifyDelete(Object domainObject) {
        return this.getParent().verifyDelete(domainObject);
    }
}

